/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DynamicKey;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.PrimaryDynamicKey;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

public class CompositeDynamicKey
implements DynamicKey {
    private final Object[] pks;

    public CompositeDynamicKey(Object cks) {
        this.pks = (Object[])cks;
    }

    public DataValueDescriptor[] getEvaluatedIndexKey(Activation activation) throws StandardException {
        DataValueDescriptor[] iks = this.getEvaluatedKey(activation);
        return iks;
    }

    private DataValueDescriptor[] getEvaluatedKey(Activation activation) throws StandardException {
        int len = this.pks.length;
        DataValueDescriptor[] copyPks = new DataValueDescriptor[len];
        for (int i = 0; i < len; ++i) {
            Object temp = this.pks[i];
            DataValueDescriptor key = null;
            if (temp instanceof DynamicKey) {
                assert (temp instanceof PrimaryDynamicKey);
                PrimaryDynamicKey pdk = (PrimaryDynamicKey)temp;
                key = pdk.getEvaluatedAsDataValueDescriptor(activation);
            } else {
                key = (DataValueDescriptor)temp;
            }
            copyPks[i] = key;
        }
        return copyPks;
    }

    @Override
    public RegionKey getEvaluatedPrimaryKey(Activation activation, GemFireContainer container, boolean doClone) throws StandardException {
        DataValueDescriptor[] copyPks = this.getEvaluatedKey(activation);
        return GemFireXDUtils.convertIntoGemfireRegionKey(copyPks, container, doClone);
    }
}

