/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.EmptyRegionFunctionException;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.NoMemberFoundException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.ProxyBucketRegion;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import com.gemstone.gemfire.internal.cache.execute.InternalResultSender;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TObjectObjectProcedure;
import com.gemstone.gnu.trove.TObjectProcedure;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDistributionAdvisor;
import com.pivotal.gemfirexd.internal.engine.distributed.message.BitSetSet;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdFunctionMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class RegionExecutorMessage<T>
extends GfxdFunctionMessage<T>
implements InternalRegionFunctionContext {
    protected BitSetSet bucketBitSet;
    protected transient LocalRegion region;
    protected transient THashSet colocatedRegions;
    protected transient Set<Object> routingObjects;
    protected transient ArrayList<LocalDataSet> colocatedDataSets;
    protected transient HashMapOrSet membersToBucketIds;
    private THashMap ncjMetaData = null;
    private int numRecipients;
    private byte sendToAllReplicates;
    private static final byte SEND_ALL_REPLICATES_INCLUDE_ADMIN = 1;
    private static final byte SEND_ALL_REPLICATES_EXCLUDE_ADMIN = 2;
    protected static final short HAS_BUCKET_BITSET = 64;
    protected static final short UNRESERVED_FLAGS_START = 128;
    public static final RegionAdvisor.BucketVisitor<HashMapOrSet> collectPrimaries = new CollectPrimaries();
    static final RegionAdvisor.BucketVisitor<RegionExecutorMessage<?>> collectPreferredNodes = new CollectPreferredNodes();
    static final RegionAdvisor.BucketVisitor<RegionExecutorMessage<?>> collectPrimaryAndSecondaryNodes = new CollectPrimaryAndSecondaryNodes();
    protected String nameForLogging;
    protected transient Set<PartitionedRegion> otherPartitionRegions = null;
    protected transient boolean hasSetOperatorNode = false;

    protected THashMap getNcjMetaData() {
        return this.ncjMetaData;
    }

    protected void setNcjMetaData(THashMap ncjMetaInfo) {
        this.ncjMetaData = ncjMetaInfo;
    }

    protected RegionExecutorMessage(boolean ignored) {
        super(true);
    }

    protected RegionExecutorMessage(ResultCollector<Object, T> collector, LocalRegion region, Set<Object> routingObjects, TXStateInterface tx, boolean timeStatsEnabled, boolean abortOnLowMemory) {
        super(collector, tx, timeStatsEnabled, abortOnLowMemory);
        this.region = region;
        this.routingObjects = routingObjects;
    }

    protected RegionExecutorMessage(RegionExecutorMessage<T> other) {
        super(other);
        this.region = other.region;
        this.routingObjects = other.routingObjects;
        this.numRecipients = other.numRecipients;
        this.hasSetOperatorNode = other.hasSetOperatorNode;
        this.ncjMetaData = other.ncjMetaData;
        assert (this.getTXState() == null || this.getTXState() == TXManagerImpl.getCurrentTXState()) : "unexpected mismatch of current TX " + TXManagerImpl.getCurrentTXState() + ", and TX passed to message " + this.getTXState();
    }

    public LocalRegion getRegion() {
        return this.region;
    }

    public final String logName() {
        String logName = this.nameForLogging;
        if (logName != null) {
            return logName;
        }
        this.nameForLogging = this.getClass().getSimpleName();
        return this.nameForLogging;
    }

    @Override
    public final void setSendToAllReplicates(boolean includeAdmin) {
        this.sendToAllReplicates = (byte)(includeAdmin ? 1 : 2);
    }

    protected void setMembersToBucketIds(PartitionedRegion.RetryTimeKeeper retryTime) throws StandardException {
        PartitionedRegion pregion = (PartitionedRegion)this.region;
        final boolean optimizeForWrite = this.optimizeForWrite() || pregion.isHDFSReadWriteRegion();
        this.membersToBucketIds = new HashMapOrSet((LocalRegion)pregion);
        Set<PartitionedRegion> otherPRs = this.otherPartitionRegions;
        if (this.routingObjects == null || this.routingObjects.size() == 0) {
            RegionAdvisor advisor = pregion.getRegionAdvisor();
            if (optimizeForWrite) {
                advisor.accept(collectPrimaries, (Object)this.membersToBucketIds);
            } else if (this.withSecondaries()) {
                advisor.accept(collectPrimaryAndSecondaryNodes, (Object)this);
            } else {
                advisor.accept(collectPreferredNodes, (Object)this);
            }
            if (this.membersToBucketIds.isEmpty()) {
                GemFireXDUtils.checkForInsufficientDataStore((LocalRegion)pregion);
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.logName() + ": execute on all " + (optimizeForWrite ? "primary" : "preferred") + " buckets with pruned map: " + (Object)((Object)this.membersToBucketIds)));
            }
            if (this.hasSetOperatorNode && otherPRs != null) {
                BitSetSet nullBucketSet = new BitSetSet(0);
                HashMapOrSet otherMembersToBucketIds = new HashMapOrSet();
                Iterator<PartitionedRegion> partitionIter = otherPRs.iterator();
                PartitionedRegion otherPartition = null;
                RegionAdvisor otherAdvisor = null;
                InternalDistributedMember dataMember2 = null;
                while (partitionIter.hasNext()) {
                    otherPartition = partitionIter.next();
                    if (otherPartition == null) continue;
                    otherAdvisor = otherPartition.getRegionAdvisor();
                    otherMembersToBucketIds.setIsPersistent(GemFireXDUtils.isPersistent((LocalRegion)otherPartition));
                    otherAdvisor.accept(collectPrimaries, (Object)otherMembersToBucketIds);
                    if (otherMembersToBucketIds.isEmpty()) continue;
                    Set otherMembers = otherMembersToBucketIds.keySet();
                    for (InternalDistributedMember dataMember2 : otherMembers) {
                        if (this.membersToBucketIds.containsKey(dataMember2)) continue;
                        this.membersToBucketIds.put(dataMember2, nullBucketSet);
                    }
                    otherMembersToBucketIds.clear();
                }
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.logName() + ": Revised Pruned bucket map for Union, Intersect Or Except " + "operators query consideration: " + (Object)((Object)this.membersToBucketIds)));
                }
            } else if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.logName() + ": No changes to Pruned bucket map for Union, Intersect " + "Or Except operators query consideration"));
            }
        } else {
            BitSetSet allBucketIds = new BitSetSet(pregion.getPartitionAttributes().getTotalNumBuckets());
            for (Object routingObject : this.routingObjects) {
                int bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)pregion, (Object)routingObject);
                if (!allBucketIds.addInt(bucketId)) continue;
                InternalDistributedMember member = optimizeForWrite ? pregion.getOrCreateNodeForBucketWrite(bucketId, retryTime) : pregion.getOrCreateNodeForInitializedBucketRead(bucketId, this.possibleDuplicate);
                RegionExecutorMessage.addBucketIdForMember(this.membersToBucketIds, (DistributedMember)member, bucketId, pregion);
            }
            if (this.membersToBucketIds.isEmpty()) {
                GemFireXDUtils.checkForInsufficientDataStore((LocalRegion)pregion);
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.logName() + ": execute on buckets with routing objects {" + this.routingObjects + "} and pruned map: " + (Object)((Object)this.membersToBucketIds)));
            }
        }
        if (otherPRs != null && !this.hasSetOperatorNode) {
            for (final PartitionedRegion pr : otherPRs) {
                this.membersToBucketIds.forEachValue(new TObjectProcedure(){

                    public boolean execute(Object o) {
                        BitSetSet bucketIds = (BitSetSet)o;
                        RegionAdvisor advisor = pr.getRegionAdvisor();
                        int bucketId = bucketIds.nextSetBit(0, 0);
                        while (bucketId >= 0) {
                            if (advisor.getBucketRedundancy(bucketId) < 0) {
                                if (optimizeForWrite) {
                                    pr.getOrCreateNodeForBucketWrite(bucketId, null);
                                } else {
                                    pr.getOrCreateNodeForInitializedBucketRead(bucketId, RegionExecutorMessage.this.possibleDuplicate);
                                }
                            }
                            bucketId = bucketIds.nextSetBit(bucketId + 1);
                        }
                        return true;
                    }
                });
            }
        }
    }

    @Override
    protected void executeFunction(final boolean enableStreaming) throws StandardException, SQLException {
        DataPolicy policy = this.region.getAttributes().getDataPolicy();
        GemFireCacheImpl cache = this.region.getCache();
        final InternalDistributedSystem sys = cache.getSystem();
        final DM dm = sys.getDistributionManager();
        InternalDistributedMember myId = cache.getMyId();
        final Set<DistributedMember> messageAwareMembers = this.gfxdCollector != null ? this.gfxdCollector.getResultMembers() : null;
        this.membersToBucketIds = null;
        if (policy.withPartitioning()) {
            ArrayList<RegionExecutorMessage> msgsSent;
            long beginMapTime;
            PartitionedRegion pregion = (PartitionedRegion)this.region;
            PartitionedRegion.RetryTimeKeeper retryTime = null;
            TXStateInterface tx = this.getTXState();
            long l = beginMapTime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(-1L) : 0L;
            if (this.hasSetOperatorNode) assert (this.routingObjects == null);
            while (true) {
                this.setMembersToBucketIds(retryTime);
                if (this.failedNodes == null) break;
                boolean hasFailedNode = false;
                for (DistributedMember member : this.failedNodes) {
                    if (!this.membersToBucketIds.containsKey(member)) continue;
                    if (retryTime == null) {
                        retryTime = new PartitionedRegion.RetryTimeKeeper(pregion.getRetryTimeout());
                    }
                    if (retryTime.overMaximum()) {
                        throw new InternalFunctionInvocationTargetException(LocalizedStrings.PRHARedundancyProvider_TIMED_OUT_ATTEMPTING_TO_0_IN_THE_PARTITIONED_REGION__1_WAITED_FOR_2_MS.toLocalizedString(new Object[]{"doing GemFireXD function execution", PRHARedundancyProvider.regionStatus((PartitionedRegion)pregion, null, null, (boolean)true), (long)pregion.getRetryTimeout()}) + PRHARedundancyProvider.TIMEOUT_MSG);
                    }
                    retryTime.waitToRetryNode();
                    hasFailedNode = true;
                    break;
                }
                if (!hasFailedNode) {
                    this.failedNodes = null;
                    break;
                }
                this.membersToBucketIds.clear();
                this.mapping_retry_count = (short)(this.mapping_retry_count + 1);
            }
            final int numMembers = this.membersToBucketIds.size();
            this.setNumRecipients(numMembers);
            if (numMembers == 0) {
                this.userCollector.endResults();
                throw new EmptyRegionFunctionException(LocalizedStrings.PartitionedRegion_FUNCTION_NOT_EXECUTED_AS_REGION_IS_EMPTY.toLocalizedString());
            }
            if (beginMapTime != 0L) {
                this.member_mapping_time = XPLAINUtil.recordTiming(beginMapTime);
                this.begin_scatter_time = XPLAINUtil.currentTimeStamp();
                ArrayList<RegionExecutorMessage> mmsgs = this.membersMsgsSent;
                if (mmsgs == null) {
                    this.membersMsgsSent = mmsgs = new ArrayList<RegionExecutorMessage>(numMembers);
                }
                msgsSent = mmsgs;
            } else {
                msgsSent = null;
            }
            Set destMembers = this.membersToBucketIds.keySet();
            GfxdFunctionMessage.GfxdFunctionReplyMessageProcessor processor = numMembers > 1 ? this.createReplyProcessor(dm, destMembers) : this.createReplyProcessor(dm, (InternalDistributedMember)this.membersToBucketIds.firstKey());
            this.setProcessor(processor);
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("RegionExecutorMessage:: set the processor in " + this.gfxdCollector + " to " + (this.gfxdCollector != null ? this.gfxdCollector.getProcessor() : null)));
            }
            if (SanityManager.isFinerEnabled) {
                SanityManager.DEBUG_PRINT((String)"finer:TRACE", (String)(this.logName() + ": executing region message " + this.toString() + " on nodes " + destMembers));
            }
            if (tx != null) {
                this.doTXFlushBeforeExecution(destMembers, null, (DistributedMember)myId, tx);
            }
            BitSetSet selfBucketIds = (BitSetSet)this.membersToBucketIds.remove(myId);
            try {
                if (this.membersToBucketIds.size() > 0) {
                    processor.registerProcessor();
                    this.membersToBucketIds.forEachEntry(new TObjectObjectProcedure(){
                        private int numMbrs;
                        {
                            this.numMbrs = numMembers;
                        }

                        public final boolean execute(Object key, Object value) {
                            GfxdFunctionMessage msg;
                            long beginTime = beginMapTime != 0L ? XPLAINUtil.recordTiming(-1L) : 0L;
                            InternalDistributedMember member = (InternalDistributedMember)key;
                            if (--this.numMbrs > 0) {
                                msg = RegionExecutorMessage.this.clone();
                                ((RegionExecutorMessage)msg).setIgnoreReplicateIfSetOperators(true);
                            } else {
                                msg = RegionExecutorMessage.this;
                                ((RegionExecutorMessage)msg).setIgnoreReplicateIfSetOperators(false);
                            }
                            ((RegionExecutorMessage)msg).setArgsForMember((DistributedMember)member, messageAwareMembers);
                            ((RegionExecutorMessage)msg).bucketBitSet = (BitSetSet)value;
                            try {
                                msg.executeOnMember(sys, dm, member, false, enableStreaming);
                            }
                            catch (StandardException se) {
                                throw new FunctionExecutionException(se);
                            }
                            catch (SQLException sqle) {
                                throw new FunctionExecutionException(sqle);
                            }
                            if (beginTime != 0L) {
                                if (msg != RegionExecutorMessage.this) {
                                    ((RegionExecutorMessage)msg).process_time = XPLAINUtil.recordTiming(beginTime);
                                } else {
                                    ((RegionExecutorMessage)msg).root_msg_send_time += XPLAINUtil.recordTiming(beginTime);
                                }
                                msgsSent.add(msg);
                            }
                            return true;
                        }
                    });
                }
            }
            catch (FunctionExecutionException fee) {
                if (fee.getCause() instanceof StandardException) {
                    throw (StandardException)fee.getCause();
                }
                if (fee.getCause() instanceof SQLException) {
                    throw (SQLException)fee.getCause();
                }
                throw fee;
            }
            if (selfBucketIds != null) {
                long beginTime = beginMapTime != 0L ? XPLAINUtil.recordTiming(-1L) : 0L;
                this.setArgsForMember((DistributedMember)myId, messageAwareMembers);
                this.bucketBitSet = selfBucketIds;
                this.colocatedDataSets = null;
                this.executeOnMember(sys, dm, myId, true, enableStreaming);
                if (beginTime != 0L) {
                    this.root_msg_send_time += XPLAINUtil.recordTiming(beginTime);
                    msgsSent.add(this);
                }
            }
        } else {
            TXStateInterface tx;
            InternalDistributedMember member;
            long beginMapTime;
            DistributedRegion dreg = (DistributedRegion)this.region;
            Set replicates = null;
            this.bucketBitSet = null;
            this.colocatedDataSets = null;
            long l = beginMapTime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(-1L) : 0L;
            if (this.sendToAllReplicates != 0) {
                replicates = dreg.getCacheDistributionAdvisor().adviseInitializedReplicates();
                if (policy.withReplication() || policy.withPreloaded()) {
                    if (replicates.size() == 0) {
                        replicates = new THashSet(2);
                    }
                    replicates.add(myId);
                }
                if (this.sendToAllReplicates == 2) {
                    ArrayList<InternalDistributedMember> adminVMs = null;
                    GfxdDistributionAdvisor advisor = GemFireXDUtils.getGfxdAdvisor();
                    for (InternalDistributedMember m : replicates) {
                        GfxdDistributionAdvisor.GfxdProfile p = advisor.getProfile(m);
                        if (p == null || p.getVMKind().isAccessorOrStore()) continue;
                        if (adminVMs == null) {
                            adminVMs = new ArrayList<InternalDistributedMember>(5);
                        }
                        adminVMs.add(m);
                    }
                    if (adminVMs != null) {
                        for (InternalDistributedMember m : adminVMs) {
                            replicates.remove(m);
                        }
                    }
                }
                member = null;
            } else if (policy.withReplication() || policy.withPreloaded()) {
                member = myId;
            } else if (!policy.withStorage()) {
                if (this.failedNodes == null) {
                    member = dreg.getRandomReplicate();
                } else {
                    Set allMembers = dreg.getCacheDistributionAdvisor().adviseInitializedReplicates();
                    member = null;
                    allMembers.removeAll(this.failedNodes);
                    if (allMembers.size() > 0) {
                        int pos = PartitionedRegion.rand.nextInt(allMembers.size());
                        Iterator iter = allMembers.iterator();
                        while (pos-- >= 0 && iter.hasNext()) {
                            member = (InternalDistributedMember)iter.next();
                        }
                    }
                }
            } else {
                throw new GemFireXDRuntimeException(this.logName() + "#execute: cannot handle policy " + policy + " for region: " + this.region);
            }
            if (member != null) {
                this.setArgsForMember((DistributedMember)member, messageAwareMembers);
            } else if (replicates == null || replicates.size() == 0) {
                throw new NoMemberFoundException(LocalizedStrings.DistributedRegion_NO_REPLICATED_REGION_FOUND_FOR_EXECUTING_FUNCTION_0.toLocalizedString(new Object[]{this.getClass().getName()}));
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.logName() + ": executing region message " + this.toString() + " on node " + member));
            }
            long beginTime = 0L;
            ArrayList<RegionExecutorMessage> msgsSent = null;
            if (beginMapTime != 0L) {
                this.member_mapping_time = XPLAINUtil.recordTiming(beginMapTime);
                msgsSent = this.membersMsgsSent;
                if (msgsSent == null) {
                    this.membersMsgsSent = msgsSent = new ArrayList<RegionExecutorMessage>(1);
                }
                this.begin_scatter_time = XPLAINUtil.currentTimeStamp();
                beginTime = XPLAINUtil.recordTiming(-1L);
            }
            if ((tx = this.getTXState()) != null) {
                this.doTXFlushBeforeExecution(null, (DistributedMember)member, (DistributedMember)myId, tx);
            }
            if (this.sendToAllReplicates == 0) {
                this.setNumRecipients(1);
                this.executeOnMember(sys, dm, member, member == myId, enableStreaming);
            } else {
                this.setNumRecipients(replicates.size());
                Set targets = replicates;
                this.executeOnMembers(sys, dm, targets, enableStreaming);
            }
            if (beginTime != 0L) {
                this.root_msg_send_time += XPLAINUtil.recordTiming(beginTime);
                msgsSent.add(this);
            }
        }
    }

    protected HashMapOrSet getMembersToBucketIds() {
        return this.membersToBucketIds;
    }

    @Override
    protected final GemFireCacheImpl getGemFireCache() {
        return this.region.getGemFireCache();
    }

    @Override
    public final void checkAllBucketsHosted() throws BucketMovedException {
        if (this.bucketBitSet != null && this.region != null) {
            PartitionedRegion pr = (PartitionedRegion)this.region;
            int movedBucketId = this.areAllBucketsHosted(pr);
            if (movedBucketId >= 0) {
                throw new BucketMovedException(LocalizedStrings.FunctionService_BUCKET_MIGRATED_TO_ANOTHER_NODE.toLocalizedString(), movedBucketId, pr.getFullPath());
            }
            if (this.colocatedRegions != null) {
                this.colocatedRegions.forEach(new TObjectProcedure(){

                    public boolean execute(Object r) {
                        PartitionedRegion pr = (PartitionedRegion)r;
                        int movedBucketId = RegionExecutorMessage.this.areAllBucketsHosted(pr);
                        if (movedBucketId >= 0) {
                            throw new BucketMovedException(LocalizedStrings.FunctionService_BUCKET_MIGRATED_TO_ANOTHER_NODE.toLocalizedString(), movedBucketId, pr.getFullPath());
                        }
                        return true;
                    }
                });
            }
        }
    }

    protected final void setNumRecipients(int n) {
        this.numRecipients = n;
        if (this.gfxdCollector != null) {
            this.gfxdCollector.setNumRecipients(n);
        }
    }

    protected final int areAllBucketsHosted(PartitionedRegion pr) {
        boolean optimizeForWrite = this.optimizeForWrite();
        RegionAdvisor advisor = pr.getRegionAdvisor();
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            if (optimizeForWrite) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("checking for primary bucketIds " + this.bucketBitSet));
            } else {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("checking for hosted bucketIds " + this.bucketBitSet));
            }
        }
        int bucketId = this.bucketBitSet.nextSetBit(0, 0);
        while (bucketId >= 0) {
            if (optimizeForWrite ? !advisor.getBucketAdvisor(bucketId).isPrimary() : !advisor.getBucketAdvisor(bucketId).isHosting()) {
                return bucketId;
            }
            bucketId = this.bucketBitSet.nextSetBit(bucketId + 1);
        }
        return -1;
    }

    protected abstract void setArgsForMember(DistributedMember var1, Set<DistributedMember> var2);

    protected void doTXFlushBeforeExecution(Set<DistributedMember> members, DistributedMember member, DistributedMember self, TXStateInterface tx) {
    }

    public final <K, V> Region<K, V> getDataSet() {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    public final Set<?> getFilter() {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <K, V> Region<K, V> getLocalDataSet(Region<K, V> region) {
        if (region.getAttributes().getPartitionAttributes() != null) {
            RegionExecutorMessage regionExecutorMessage = this;
            synchronized (regionExecutorMessage) {
                LocalDataSet lds2;
                if (this.colocatedDataSets == null) {
                    this.colocatedDataSets = new ArrayList(4);
                } else {
                    for (LocalDataSet lds2 : this.colocatedDataSets) {
                        if (lds2.getProxy() != region) continue;
                        return lds2;
                    }
                }
                PartitionedRegion pr = (PartitionedRegion)region;
                lds2 = new LocalDataSet(pr, this.getPRBucketSet(pr), this.getTXState((LocalRegion)pr));
                this.colocatedDataSets.add(lds2);
                return lds2;
            }
        }
        return null;
    }

    public final <K, V> Set<Integer> getLocalBucketSet(Region<K, V> region) {
        if (region.getAttributes().getPartitionAttributes() != null) {
            return this.getPRBucketSet((PartitionedRegion)region);
        }
        return null;
    }

    private Set<Integer> getPRBucketSet(PartitionedRegion pr) {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("RegionExecutorMessage.getPRBucketSet. Region=" + (this.region == null ? "null" : this.region.getDisplayName()) + " pr=" + (pr == null ? "null" : pr.getDisplayName())));
        }
        boolean firstCall = false;
        if (this.region == null) {
            this.region = pr;
            firstCall = true;
        } else if (this.region != pr) {
            if (this.hasSetOperatorNodeOnRemote()) {
                return pr.getDataStore().getAllLocalPrimaryBucketIds();
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ && this.region instanceof PartitionedRegion && ColocationHelper.getLeaderRegion((PartitionedRegion)pr) != ColocationHelper.getLeaderRegion((PartitionedRegion)((PartitionedRegion)this.region))) {
                throw new FunctionException("RegionExecutorMessage#getPRBucketSet: unexpected invocation for region " + pr.getFullPath() + " with target region " + this.region.getFullPath());
            }
            if (this.colocatedRegions == null) {
                this.colocatedRegions = new THashSet(5);
            }
            firstCall = this.colocatedRegions.add((Object)pr);
        }
        if (this.bucketBitSet != null) {
            int movedBucketId;
            if (firstCall && (movedBucketId = this.areAllBucketsHosted(pr)) >= 0) {
                throw new BucketMovedException(LocalizedStrings.FunctionService_BUCKET_MIGRATED_TO_ANOTHER_NODE.toLocalizedString(), movedBucketId, pr.getFullPath());
            }
            return this.bucketBitSet;
        }
        if (this.hasSetOperatorNodeOnRemote()) {
            return new BitSetSet(0);
        }
        return null;
    }

    public final InternalResultSender getResultSender() {
        return this;
    }

    public final String getFunctionId() {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    public final Object getArguments() {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    public final Map<String, LocalDataSet> getColocatedLocalDataSets() {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    @Override
    public final int getNumRecipients() {
        return this.numRecipients;
    }

    @Override
    public abstract boolean optimizeForWrite();

    public abstract boolean withSecondaries();

    @Override
    protected abstract RegionExecutorMessage<T> clone();

    @Override
    protected short computeCompressedShort(short flags) {
        flags = super.computeCompressedShort(flags);
        if (this.bucketBitSet != null) {
            flags = (short)(flags | 0x40);
        }
        return flags;
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        InternalDataSerializer.writeArrayLength((int)this.numRecipients, (DataOutput)out);
        if (this.bucketBitSet != null) {
            this.bucketBitSet.toData(out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.numRecipients = InternalDataSerializer.readArrayLength((DataInput)in);
        if ((this.flags & 0x40) != 0) {
            this.bucketBitSet = BitSetSet.fromData(in);
        }
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        if (this.region != null) {
            sb.append(";region=").append(this.region.getFullPath());
        }
        sb.append(";bucketIds=").append(this.bucketBitSet);
        Set<Object> routingObjects = this.routingObjects;
        if (routingObjects != null && routingObjects.size() > 0) {
            sb.append(";routingObjects=").append(routingObjects);
        }
        sb.append(";ncjMetaData=").append(this.ncjMetaData);
    }

    static void addBucketIdForMember(HashMapOrSet membersToBucketIds, DistributedMember member, int bucketId, PartitionedRegion region) {
        if (member != null) {
            if (membersToBucketIds.hasValues) {
                BitSetSet bucketSet = (BitSetSet)membersToBucketIds.get(member);
                if (bucketSet == null) {
                    bucketSet = new BitSetSet(region.getPartitionAttributes().getTotalNumBuckets());
                    membersToBucketIds.put(member, bucketSet);
                }
                bucketSet.addInt(bucketId);
            } else {
                membersToBucketIds.put(member, null);
            }
        }
    }

    public void setAllTablesAreReplicatedOnRemote(boolean allTablesReplicated) {
        SanityManager.ASSERT((boolean)true, (String)(this.getClass().getSimpleName() + ": should only be called on an instance of " + "sub-class StatementExecutorMessage"));
    }

    public boolean allTablesAreReplicatedOnRemote() {
        return false;
    }

    public final void setPartitionRegions(Set<PartitionedRegion> regionSet) {
        this.otherPartitionRegions = regionSet;
    }

    public void setNCJoinOnQN(THashMap ncjMetaData, LanguageConnectionContext lcc) {
        SanityManager.THROWASSERT((String)(this.getClass().getSimpleName() + ": should only be called on an instance of sub-class " + " StatementExecutorMessage or PrepStatementExecutorMessage but not " + this.getClass().getSimpleName()));
    }

    public THashMap getNCJMetaDataOnRemote() {
        return this.getNcjMetaData();
    }

    public void setHasSetOperatorNode(boolean hasSetOp, boolean needKeysFromRemote) {
        SanityManager.THROWASSERT((String)(this.getClass().getSimpleName() + ": should only be called on an instance of sub-class " + "StatementExecutorMessage"));
    }

    public boolean hasSetOperatorNodeOnRemote() {
        SanityManager.THROWASSERT((String)(this.getClass().getSimpleName() + ": should only be called on an instance of sub-class " + "StatementExecutorMessage"));
        return false;
    }

    public boolean needKeysForSetOperatorOnRemote() {
        SanityManager.THROWASSERT((String)(this.getClass().getSimpleName() + ": should only be called on an instance of sub-class " + "StatementExecutorMessage"));
        return false;
    }

    public boolean doIgnoreReplicatesIfSetOperatorsOnRemote() {
        SanityManager.THROWASSERT((String)(this.getClass().getSimpleName() + ": should only be called on an instance of sub-class " + "StatementExecutorMessage"));
        return false;
    }

    protected void setIgnoreReplicateIfSetOperators(boolean ignoreReplicate) {
        SanityManager.THROWASSERT((String)(this.getClass().getSimpleName() + ": should only be called on an instance of sub-class " + "StatementExecutorMessage"));
    }

    static final class CollectPrimaryAndSecondaryNodes
    implements RegionAdvisor.BucketVisitor<RegionExecutorMessage<?>> {
        CollectPrimaryAndSecondaryNodes() {
        }

        public final boolean visit(RegionAdvisor advisor, ProxyBucketRegion pbr, RegionExecutorMessage<?> msg) {
            PartitionedRegion pr = pbr.getPartitionedRegion();
            if (pbr.getBucketRedundancy() >= 0 || msg.membersToBucketIds.isPersistent() || pbr.getPartitionedRegion().isHDFSReadWriteRegion()) {
                pr.getOrCreateNodeForBucketWrite(pbr.getBucketId(), null);
                for (InternalDistributedMember bowners : pbr.getBucketOwners()) {
                    RegionExecutorMessage.addBucketIdForMember(msg.membersToBucketIds, (DistributedMember)bowners, pbr.getBucketId(), pr);
                }
            }
            return true;
        }
    }

    static final class CollectPreferredNodes
    implements RegionAdvisor.BucketVisitor<RegionExecutorMessage<?>> {
        CollectPreferredNodes() {
        }

        public final boolean visit(RegionAdvisor advisor, ProxyBucketRegion pbr, RegionExecutorMessage<?> msg) {
            PartitionedRegion pr = pbr.getPartitionedRegion();
            if (pbr.getBucketRedundancy() >= 0 || msg.membersToBucketIds.isPersistent() || pbr.getPartitionedRegion().isHDFSReadWriteRegion()) {
                InternalDistributedMember member = pr.getOrCreateNodeForInitializedBucketRead(pbr.getBucketId(), ((RegionExecutorMessage)msg).possibleDuplicate);
                RegionExecutorMessage.addBucketIdForMember(msg.membersToBucketIds, (DistributedMember)member, pbr.getBucketId(), pr);
            }
            return true;
        }
    }

    static final class CollectPrimaries
    implements RegionAdvisor.BucketVisitor<HashMapOrSet> {
        CollectPrimaries() {
        }

        public boolean visit(RegionAdvisor advisor, ProxyBucketRegion pbr, HashMapOrSet membersToBucketIds) {
            PartitionedRegion pr = pbr.getPartitionedRegion();
            if (pbr.getBucketRedundancy() >= 0 || membersToBucketIds.isPersistent() || pbr.getPartitionedRegion().isHDFSReadWriteRegion()) {
                InternalDistributedMember member = pr.getOrCreateNodeForBucketWrite(pbr.getBucketId(), null);
                RegionExecutorMessage.addBucketIdForMember(membersToBucketIds, (DistributedMember)member, pbr.getBucketId(), pr);
            }
            return true;
        }
    }

    public static final class HashMapOrSet
    extends THashMap {
        private static final long serialVersionUID = 2189213582854257462L;
        private final boolean hasValues;
        private boolean isPersistent;

        public HashMapOrSet() {
            this.hasValues = true;
        }

        public HashMapOrSet(LocalRegion r) {
            this(true, r);
        }

        public HashMapOrSet(boolean hasValues, LocalRegion r) {
            this.hasValues = hasValues;
            this.isPersistent = GemFireXDUtils.isPersistent(r);
        }

        public HashMapOrSet(int initialCapacity, float loadFactor, boolean hasValues, LocalRegion r) {
            super(initialCapacity, loadFactor);
            this.hasValues = hasValues;
            this.isPersistent = GemFireXDUtils.isPersistent(r);
        }

        public final boolean hasValues() {
            return this.hasValues;
        }

        public final boolean isPersistent() {
            return this.isPersistent;
        }

        public final void setIsPersistent(boolean persistent) {
            this.isPersistent = persistent;
        }
    }
}

