/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.IllegalTransactionStateException;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.TransactionStateReadOnlyException;
import com.gemstone.gemfire.cache.execute.EmptyRegionFunctionException;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.NoMemberFoundException;
import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.InsufficientDiskSpaceException;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.NoDataStoreAvailableException;
import com.gemstone.gemfire.internal.cache.PRHARedundancyProvider;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.execute.BucketMovedException;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.snappy.CallbackFactoryProvider;
import com.gemstone.gemfire.internal.snappy.StoreCallbacks;
import com.gemstone.gemfire.internal.util.DebuggerSupport;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.DerbySQLException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.tools.planexporter.CreateXML;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.Condition;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Misc {
    public static volatile boolean reservoirRegionCreated = false;
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    private Misc() {
    }

    public static void waitForDebugger() {
        DebuggerSupport.waitForJavaDebugger((LogWriterI18n)new LocalLogWriter(Integer.MIN_VALUE));
    }

    public static LogWriter getCacheLogWriter() {
        return Misc.getDistributedSystem().getLogWriter();
    }

    public static LogWriter getCacheLogWriterNoThrow() {
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache != null) {
            return cache.getLogger();
        }
        return null;
    }

    public static LogWriterI18n getI18NLogWriter() {
        return Misc.getDistributedSystem().getLogWriterI18n();
    }

    public static final GemFireStore getMemStore() {
        GemFireStore memStore = GemFireStore.getBootedInstance();
        if (memStore != null) {
            return memStore;
        }
        throw new CacheClosedException("Misc#getMemStore: no store found. GemFireXD not booted or closed down.");
    }

    public static final GemFireStore getMemStoreBooting() {
        GemFireStore memStore = GemFireStore.getBootingInstance();
        if (memStore != null) {
            return memStore;
        }
        throw new CacheClosedException("Misc#getMemStoreBooting: no store found. GemFireXD not booted or closed down.");
    }

    public static final GemFireStore getMemStoreBootingNoThrow() {
        return GemFireStore.getBootingInstance();
    }

    public static boolean initialDDLReplayInProgress() {
        GemFireStore memStore = GemFireStore.getBootingInstance();
        return memStore == null || memStore.initialDDLReplayInProgress();
    }

    public static boolean initialDDLReplayDone() {
        GemFireStore memStore = GemFireStore.getBootingInstance();
        return memStore != null && memStore.initialDDLReplayDone();
    }

    public static GemFireCacheImpl getGemFireCache() {
        return GemFireCacheImpl.getExisting();
    }

    public static GemFireCacheImpl getGemFireCacheNoThrow() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && !cache.isClosed()) {
            return cache;
        }
        return null;
    }

    public static InternalDistributedSystem getDistributedSystem() {
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache != null) {
            return cache.getDistributedSystem();
        }
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys == null || !sys.isConnected()) {
            sys = InternalDistributedSystem.getConnectedInstance();
        }
        if (sys == null) {
            throw InternalDistributedSystem.newDisconnectedException(null);
        }
        return sys;
    }

    public static InternalDistributedMember getMyId() {
        InternalDistributedMember self = GemFireStore.getMyId();
        if (self != null) {
            return self;
        }
        return Misc.getDistributedSystem().getDistributedMember();
    }

    public static void checkIfCacheClosing(Throwable t) throws CacheClosedException {
        GemFireStore memStore = GemFireStore.getBootingInstance();
        if (memStore != null) {
            memStore.getAdvisee().getCancelCriterion().checkCancelInProgress(t);
            if (t instanceof InterruptedException) {
                Thread.interrupted();
            }
        } else {
            InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
            if (sys != null) {
                sys.getCancelCriterion().checkCancelInProgress(t);
                if (t instanceof InterruptedException) {
                    Thread.interrupted();
                }
            } else {
                throw new CacheClosedException("Misc#getMemStoreBooting: no store found. GemFireXD not booted or closed down.");
            }
        }
    }

    public static void awaitForCondition(Condition cond) {
        while (true) {
            try {
                cond.await();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                Misc.checkIfCacheClosing(ie);
                continue;
            }
            break;
        }
    }

    public static void throwIfCacheNotClosed(RuntimeException e) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null || cache.isClosed()) {
            return;
        }
        String isCancelling = cache.getCancelCriterion().cancelInProgress();
        if (isCancelling == null) {
            throw e;
        }
    }

    public static <K, V> PartitionResolver createPartitionResolverForSampleTable(String reservoirRegionName) {
        return new PartitionResolver(){

            public String getName() {
                return "PartitionResolverForSampleTable";
            }

            public Serializable getRoutingObject(EntryOperation opDetails) {
                Object k = opDetails.getKey();
                StoreCallbacks callback = CallbackFactoryProvider.getStoreCallbacks();
                int v = callback.getLastIndexOfRow(k);
                if (v != -1) {
                    return Integer.valueOf(v);
                }
                return (Serializable)k;
            }

            public void close() {
            }
        };
    }

    public static <K, V> String getReservoirRegionNameForSampleTable(String schema, String resolvedBaseName) {
        Region<K, V> regionBase = Misc.getRegionForTable(resolvedBaseName, false);
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        return schema + "_SAMPLE_INTERNAL_" + regionBase.getName();
    }

    public static <K, V> PartitionedRegion createReservoirRegionForSampleTable(String reservoirRegionName, String resolvedBaseName) {
        Region<K, V> regionBase = Misc.getRegionForTable(resolvedBaseName, false);
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        Region childRegion = cache.getRegion(reservoirRegionName);
        if (childRegion == null) {
            RegionAttributes attributesBase = regionBase.getAttributes();
            PartitionAttributes partitionAttributesBase = attributesBase.getPartitionAttributes();
            RegionAttributesCreation af = new RegionAttributesCreation();
            af.setDataPolicy(DataPolicy.PARTITION);
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            paf.setTotalNumBuckets(partitionAttributesBase.getTotalNumBuckets());
            paf.setRedundantCopies(partitionAttributesBase.getRedundantCopies());
            paf.setLocalMaxMemory(partitionAttributesBase.getLocalMaxMemory());
            PartitionResolver partResolver = Misc.createPartitionResolverForSampleTable(reservoirRegionName);
            paf.setPartitionResolver(partResolver);
            paf.setColocatedWith(regionBase.getFullPath());
            af.setPartitionAttributes(paf.create());
            childRegion = cache.createRegion(reservoirRegionName, (RegionAttributes)af);
        }
        reservoirRegionCreated = true;
        return (PartitionedRegion)childRegion;
    }

    public static <K, V> PartitionedRegion getReservoirRegionForSampleTable(String reservoirRegionName) {
        GemFireCacheImpl cache;
        Region childRegion;
        if (reservoirRegionName != null && (childRegion = (cache = GemFireCacheImpl.getInstance()).getRegion(reservoirRegionName)) != null) {
            return (PartitionedRegion)childRegion;
        }
        return null;
    }

    public static <K, V> void dropReservoirRegionForSampleTable(PartitionedRegion reservoirRegion) {
        if (reservoirRegion != null) {
            reservoirRegion.destroyRegion(null);
        }
    }

    public static PartitionedRegion.PRLocalScanIterator getLocalBucketsIteratorForSampleTable(PartitionedRegion reservoirRegion, int segi, int segn) {
        if (reservoirRegion != null) {
            Set localPrimaryBucketSet = reservoirRegion.getDataStore().getAllLocalPrimaryBucketIds();
            HashSet<Integer> bucketSet = new HashSet<Integer>();
            for (Integer i : localPrimaryBucketSet) {
                if (i % segn != segi) continue;
                bucketSet.add(i);
            }
            return Misc.getLocalBucketsIteratorForSampleTable(reservoirRegion, bucketSet, false);
        }
        return null;
    }

    public static PartitionedRegion.PRLocalScanIterator getLocalBucketsIteratorForSampleTable(PartitionedRegion reservoirRegion, Set<Integer> bucketSet, Boolean fetchFromRemote) {
        if (reservoirRegion != null && bucketSet != null && bucketSet.size() > 0) {
            return reservoirRegion.getAppropriateLocalEntriesIterator(bucketSet, true, false, true, null, fetchFromRemote.booleanValue());
        }
        return null;
    }

    public static <K, V> Region<K, V> getRegionForTable(String tableName, boolean throwIfNotFound) {
        return Misc.getRegion(Misc.getRegionPath(tableName), throwIfNotFound, false);
    }

    public static String getRegionPath(String qualifiedTableName) {
        StringBuilder sb = new StringBuilder(qualifiedTableName);
        if (sb.charAt(0) != '/') {
            sb.insert(0, '/');
        }
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            char ch = sb.charAt(i);
            if (ch != '.') continue;
            sb.setCharAt(i, '/');
        }
        return sb.toString();
    }

    public static <K, V> Region<K, V> getRegion(String regionPath, boolean throwIfNotFound, boolean returnUnInitialized) throws RegionDestroyedException {
        if (throwIfNotFound) {
            Region region;
            Region region2 = region = returnUnInitialized ? Misc.getGemFireCache().getRegionThoughUnInitialized(regionPath) : Misc.getGemFireCache().getRegion(regionPath);
            if (region != null) {
                return region;
            }
            throw new RegionDestroyedException(LocalizedStrings.Region_CLOSED_OR_DESTROYED.toLocalizedString(new Object[]{regionPath}), regionPath);
        }
        return returnUnInitialized ? Misc.getGemFireCache().getRegionThoughUnInitialized(regionPath) : Misc.getGemFireCache().getRegion(regionPath);
    }

    public static LocalRegion getRegionByPath(String regionPath) {
        LocalRegion region = Misc.getGemFireCache().getRegionByPath(regionPath, false);
        if (region != null) {
            return region;
        }
        throw new RegionDestroyedException(LocalizedStrings.Region_CLOSED_OR_DESTROYED.toLocalizedString(new Object[]{regionPath}), regionPath);
    }

    public static <K, V> Region<K, V> getRegionByPath(String regionPath, boolean throwIfNotFound) {
        if (throwIfNotFound) {
            return Misc.getRegionByPath(regionPath);
        }
        return Misc.getGemFireCache().getRegionByPath(regionPath, false);
    }

    public static <K, V> Region<K, V> getRegion(TableDescriptor td, LanguageConnectionContext lcc, boolean throwIfNotFound, boolean returnUnInitialized) {
        return Misc.getRegion(Misc.getRegionPath(td, lcc), throwIfNotFound, returnUnInitialized);
    }

    public static <K, V> Region<K, V> getRegionByPath(TableDescriptor td, LanguageConnectionContext lcc, boolean throwIfNotFound) {
        return Misc.getRegionByPath(Misc.getRegionPath(td, lcc), throwIfNotFound);
    }

    public static <K, V> Region<K, V> getRegionForTableByPath(String tableName, boolean throwIfNotFound) {
        return Misc.getRegionByPath(Misc.getRegionPath(tableName), throwIfNotFound);
    }

    public static LanguageConnectionContext getLanguageConnectionContext() {
        return (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
    }

    public static String getSchemaName(String schemaName, LanguageConnectionContext lcc) {
        return schemaName != null && schemaName.length() > 0 ? schemaName : Misc.getDefaultSchemaName(lcc);
    }

    public static String getDefaultSchemaName(LanguageConnectionContext lcc) {
        if (lcc == null) {
            lcc = Misc.getLanguageConnectionContext();
        }
        if (lcc == null) {
            throw GemFireXDRuntimeException.newRuntimeException("No current connection (LCC null).", Util.noCurrentConnection());
        }
        return lcc.getDefaultSchema().getSchemaName();
    }

    public static String getRegionPath(String schemaName, String tableName, LanguageConnectionContext lcc) {
        return '/' + Misc.getSchemaName(schemaName, lcc) + '/' + tableName;
    }

    public static String getRegionPath(TableDescriptor td, LanguageConnectionContext lcc) {
        return Misc.getRegionPath(td.getSchemaName(), td.getName(), lcc);
    }

    public static String getFullTableNameFromRegionPath(String regionPath) {
        if (regionPath != null && regionPath.length() > 0) {
            int start = regionPath.charAt(0) == '/' ? 1 : 0;
            int end = regionPath.indexOf(47, start + 1);
            return end != -1 ? regionPath.substring(start, end) + '.' + regionPath.substring(end + 1) : regionPath.substring(start);
        }
        return "";
    }

    public static String getFullTableName(String schemaName, String tableName, LanguageConnectionContext lcc) {
        return Misc.generateFullTableName(new StringBuilder(), schemaName, tableName, lcc).toString();
    }

    public static StringBuilder generateFullTableName(StringBuilder sb, String schemaName, String tableName, LanguageConnectionContext lcc) {
        return sb.append(Misc.getSchemaName(schemaName, lcc)).append('.').append(tableName);
    }

    public static String getFullTableName(TableDescriptor td, LanguageConnectionContext lcc) {
        return Misc.getFullTableName(td.getSchemaName(), td.getName(), lcc);
    }

    public static Element resultSetToXMLElement(java.sql.ResultSet rs, boolean addTypeInfo, boolean ignoreTypeInfo) throws SQLException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element resultSetElement = doc.createElement("resultSet");
        doc.appendChild(resultSetElement);
        if (rs != null) {
            ResultSetMetaData rsMD = rs.getMetaData();
            int numCols = rsMD.getColumnCount();
            while (rs.next()) {
                Element resultElement = doc.createElement("row");
                resultSetElement.appendChild(resultElement);
                for (int index = 1; index <= numCols; ++index) {
                    String valStr;
                    Object result;
                    String colName = rsMD.getColumnName(index);
                    Element fieldElement = doc.createElement("field");
                    fieldElement.setAttribute("name", colName);
                    if (addTypeInfo && !ignoreTypeInfo && (result = rs.getObject(index)) != null) {
                        fieldElement.setAttribute("type", result.getClass().getName());
                    }
                    if ((valStr = rs.getString(index)) == null) {
                        valStr = "NULL";
                    }
                    if (valStr.length() > 0) {
                        fieldElement.appendChild(doc.createTextNode(valStr));
                    }
                    resultElement.appendChild(fieldElement);
                }
            }
            rs.close();
        }
        return resultSetElement;
    }

    public static String serializeXML(Element el) throws TransformerException {
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(el);
        trans.transform(source, result);
        return sw.toString();
    }

    public static String serializeXMLAsString(Element el, String xsltFileName) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StringWriter sw = new StringWriter();
            DOMSource source = new DOMSource(el);
            ClassLoader cl = InternalDistributedSystem.class.getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            InputStream is = cl.getResourceAsStream("com/pivotal/gemfirexd/internal/impl/tools/planexporter/resources/" + xsltFileName);
            Transformer transformer = tFactory.newTransformer(new StreamSource(is));
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (TransformerException te) {
            throw GemFireXDRuntimeException.newRuntimeException("serializeXMLAsString: unexpected exception", te);
        }
    }

    public static char[] serializeXMLAsCharArr(List<Element> el, String xsltFileName) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            CharArrayWriter cw = new CharArrayWriter();
            ClassLoader cl = InternalDistributedSystem.class.getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            String style = CreateXML.class.getPackage().getName().replaceAll("\\.", "/") + "/resources/" + xsltFileName;
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("using stylesheet : " + style));
            }
            InputStream is = cl.getResourceAsStream(style);
            Transformer transformer = tFactory.newTransformer(new StreamSource(is));
            for (Element e : el) {
                DOMSource source = new DOMSource(e);
                StreamResult result = new StreamResult(cw);
                if (GemFireXDUtils.TracePlanGeneration) {
                    SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("about to transform " + e));
                }
                transformer.transform(source, result);
            }
            return cw.toCharArray();
        }
        catch (TransformerException te) {
            throw GemFireXDRuntimeException.newRuntimeException("serializeXMLAsCharArr: unexpected exception", te);
        }
    }

    public static int getHashCodeFromDVD(DataValueDescriptor dvd) {
        int hash = 0;
        if (dvd != null) {
            hash = dvd.hashCode();
        }
        return hash;
    }

    public static int getUnifiedHashCodeFromDVD(DataValueDescriptor dvd, int numPartitions) {
        StoreCallbacks callback = CallbackFactoryProvider.getStoreCallbacks();
        if (dvd != null) {
            return callback.getHashCodeSnappy((Object)dvd, numPartitions);
        }
        return 0;
    }

    public static int getUnifiedHashCodeFromDVD(DataValueDescriptor[] dvds, int numPartitions) {
        StoreCallbacks callback = CallbackFactoryProvider.getStoreCallbacks();
        if (dvds != null) {
            return callback.getHashCodeSnappy((Object[])dvds, numPartitions);
        }
        return 0;
    }

    public static StandardException processFunctionException(String op, Throwable thr, DistributedMember member, Region<?, ?> region) {
        return Misc.processFunctionException(op, thr, member, region, true);
    }

    public static StandardException processFunctionException(String op, Throwable thr, DistributedMember member, Region<?, ?> region, boolean throwUnknownException) {
        Throwable t = thr;
        StandardException stdEx = null;
        GemFireException gfeex = null;
        for (Throwable expEx = thr; expEx != null; expEx = expEx.getCause()) {
            if (expEx instanceof SQLException) {
                stdEx = Misc.wrapRemoteSQLException((SQLException)expEx, thr, member);
            } else if (expEx instanceof StandardException) {
                stdEx = (StandardException)expEx;
                member = StandardException.fixUpRemoteException(t, member);
                stdEx = StandardException.newException(stdEx.getMessageId(), thr, stdEx.getArguments());
            } else if (gfeex == null && expEx instanceof GemFireException) {
                gfeex = (GemFireException)expEx;
            }
            if (stdEx != null) break;
            while (t != null && (t instanceof FunctionExecutionException || t instanceof GemFireXDRuntimeException || t.getClass().equals(FunctionException.class) && t.getMessage().equals(String.valueOf(t.getCause())))) {
                t = t.getCause();
            }
        }
        if (stdEx == null && gfeex != null) {
            member = StandardException.fixUpRemoteException(t, member);
            stdEx = Misc.processGemFireException(gfeex, thr, "execution on remote node " + member, false);
        }
        if (stdEx == null && throwUnknownException) {
            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(thr);
            member = StandardException.fixUpRemoteException(t, member);
            stdEx = StandardException.newException("38000", thr, (Object)thr.toString());
        }
        if (GemFireXDUtils.TraceFunctionException) {
            SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)(op + " encountered exception during execution" + (region != null ? " on region " + region.getFullPath() : "")), (Throwable)(thr instanceof FunctionExecutionException ? thr.getCause() : thr));
        }
        return stdEx;
    }

    public static StandardException processKnownGemFireException(GemFireException gfeex, Throwable cause, String op, boolean getForUnknown) {
        StandardException se;
        Throwable innerCause;
        if ((gfeex instanceof FunctionInvocationTargetException || gfeex instanceof FunctionExecutionException || ((Object)((Object)gfeex)).getClass().equals(FunctionException.class)) && gfeex.getCause() instanceof GemFireException) {
            gfeex = (GemFireException)gfeex.getCause();
        }
        if (getForUnknown) {
            StandardException.fixUpRemoteException(gfeex, null);
        }
        if (gfeex instanceof ConflictException) {
            return StandardException.newException("X0Z02.T", cause, (Object)gfeex.getMessage());
        }
        if (gfeex instanceof IllegalTransactionStateException) {
            return StandardException.newException("X0Z16.T", cause, (Object)cause.getLocalizedMessage());
        }
        if (gfeex instanceof TransactionStateReadOnlyException) {
            return StandardException.newException("X0Z03.T", cause, (Object)cause.getLocalizedMessage());
        }
        if (gfeex instanceof TransactionDataNodeHasDepartedException) {
            return StandardException.newException("40XD0", cause, (Object)StandardException.getSenderFromExceptionOrSelf(cause), (Object)"");
        }
        if (gfeex instanceof TransactionDataRebalancedException) {
            TransactionDataRebalancedException tdre = (TransactionDataRebalancedException)gfeex;
            return StandardException.newException("40XD2", cause, (Object)Misc.getFullTableNameFromRegionPath(tdre.getRegionPath()));
        }
        if (gfeex instanceof TransactionInDoubtException) {
            return StandardException.newException("X0Z06.T", cause);
        }
        if (gfeex instanceof BucketMovedException) {
            if (TXManagerImpl.getCurrentTXState() != null) {
                return StandardException.newException("40XD0", cause, (Object)StandardException.getSenderFromExceptionOrSelf(cause), (Object)"");
            }
            BucketMovedException bme = (BucketMovedException)((Object)gfeex);
            return StandardException.newException("X0Z18.S", cause, (Object)bme.getBucketId(), (Object)Misc.getFullTableNameFromRegionPath(bme.getRegionName()));
        }
        if (gfeex instanceof PartitionedRegionStorageException) {
            String expected = LocalizedStrings.PRHARRedundancyProvider_UNABLE_TO_FIND_ANY_MEMBERS_TO_HOST_A_BUCKET_IN_THE_PARTITIONED_REGION_0.toLocalizedString();
            expected = expected.substring(0, expected.indexOf(46));
            String msgThis = gfeex.getLocalizedMessage();
            if (msgThis.indexOf(expected) != -1 || msgThis.contains(LocalizedStrings.PRHARRedundancyProvider_ALLOCATE_ENOUGH_MEMBERS_TO_HOST_BUCKET.toLocalizedString()) || msgThis.contains(PRHARedundancyProvider.INSUFFICIENT_STORES_MSG.toLocalizedString())) {
                String target = op;
                int prStart = msgThis.indexOf("Partitioned Region name = ");
                if (prStart >= 0) {
                    int index;
                    int len = msgThis.length();
                    for (index = prStart += "Partitioned Region name = ".length(); index < len && !Character.isWhitespace(msgThis.charAt(index)); ++index) {
                    }
                    if (index > prStart) {
                        target = Misc.getFullTableNameFromRegionPath(msgThis.substring(prStart, index));
                    }
                }
                return StandardException.newException("X0Z08.S", cause, (Object)target);
            }
        } else {
            if (gfeex instanceof NoMemberFoundException) {
                return StandardException.newException("X0Z08.S", cause, (Object)op);
            }
            if (gfeex instanceof EmptyRegionFunctionException) {
                return StandardException.newException("X0Z08.S", cause, (Object)op);
            }
            if (gfeex instanceof NoDataStoreAvailableException) {
                String[] messageParts = gfeex.getMessage().split(": ");
                return StandardException.newException("X0Z08.S", cause, (Object)(messageParts.length > 1 ? messageParts[1] : op));
            }
            if (gfeex instanceof PartitionOfflineException) {
                return StandardException.newException("X0Z09.S", cause);
            }
            if (gfeex instanceof PutAllPartialResultException) {
                Exception partialExceptionCause = ((PutAllPartialResultException)gfeex).getFailure();
                if (partialExceptionCause instanceof PartitionedRegionStorageException) {
                    String expected = LocalizedStrings.PRHARRedundancyProvider_UNABLE_TO_FIND_ANY_MEMBERS_TO_HOST_A_BUCKET_IN_THE_PARTITIONED_REGION_0.toLocalizedString();
                    expected = expected.substring(0, expected.indexOf(46));
                    String msgThis = partialExceptionCause.getLocalizedMessage();
                    if (msgThis.indexOf(expected) != -1 || partialExceptionCause.getLocalizedMessage().contains(LocalizedStrings.PRHARRedundancyProvider_ALLOCATE_ENOUGH_MEMBERS_TO_HOST_BUCKET.toLocalizedString()) || partialExceptionCause.getLocalizedMessage().contains(LocalizedStrings.PRHARRedundancyProvider_UNABLE_TO_FIND_ANY_MEMBERS_TO_HOST_A_BUCKET_IN_THE_PARTITIONED_REGION_0.toLocalizedString())) {
                        return StandardException.newException("X0Z09.S", cause, (Object)op);
                    }
                }
            } else {
                if (gfeex instanceof LowMemoryException) {
                    return Misc.generateLowMemoryException(op);
                }
                if (gfeex instanceof RegionDestroyedException) {
                    RegionDestroyedException rde = (RegionDestroyedException)((Object)gfeex);
                    return StandardException.newException("42X05", cause, (Object)Misc.getFullTableNameFromRegionPath(rde.getRegionFullPath()));
                }
                if (gfeex instanceof HDFSIOException) {
                    return StandardException.newException("X0Z30.S", (Throwable)gfeex, (Object)op);
                }
                if (gfeex instanceof InsufficientDiskSpaceException) {
                    return StandardException.newException("X0Z33.T", (Throwable)gfeex, (Object)gfeex.getMessage());
                }
                if (gfeex instanceof DiskAccessException) {
                    return StandardException.newException("XSDA4.S", gfeex);
                }
            }
        }
        if ((innerCause = gfeex.getCause()) != null && innerCause instanceof GemFireException && (se = Misc.processKnownGemFireException((GemFireException)innerCause, innerCause, op, false)) != null) {
            return se;
        }
        if (getForUnknown && (se = Misc.processFunctionException(op, gfeex, null, null)) != null) {
            return se;
        }
        return null;
    }

    public static StandardException processGemFireException(GemFireException gfeex, Throwable cause, String op, boolean getForUnknown) {
        StandardException se = Misc.processKnownGemFireException(gfeex, cause, op, getForUnknown);
        if (se != null) {
            return se;
        }
        if (gfeex instanceof TransactionException) {
            return StandardException.newException("X0Z16.T", cause, (Object)cause.getLocalizedMessage());
        }
        if (gfeex instanceof CacheException) {
            throw gfeex;
        }
        if (gfeex instanceof CancelException) {
            if (gfeex.getCause() instanceof ForcedDisconnectException) {
                return StandardException.newException("X0Z32.S", gfeex);
            }
            throw gfeex;
        }
        Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)gfeex);
        return StandardException.newException("38000", (Throwable)gfeex, (Object)gfeex.toString());
    }

    public static StandardException processRuntimeException(Throwable e, String op, Region<?, ?> region) {
        Throwable t = e;
        do {
            if (t instanceof StandardException) {
                return (StandardException)t;
            }
            if (!(t instanceof SQLException)) continue;
            return Misc.wrapRemoteSQLException((SQLException)t, e, null);
        } while ((t = t.getCause()) != null);
        return Misc.processFunctionException(op, e, null, region);
    }

    public static StandardException wrapRemoteSQLException(SQLException sqle, Throwable remoteEx, DistributedMember member) {
        member = StandardException.fixUpRemoteException(sqle, member);
        return Misc.wrapSQLException(sqle, remoteEx);
    }

    public static StandardException wrapSQLException(SQLException sqle, Throwable root) {
        if (sqle instanceof DerbySQLException) {
            DerbySQLException dsqle = (DerbySQLException)((Object)sqle);
            if (dsqle.isSimpleWrapper() && sqle.getCause() instanceof StandardException) {
                StandardException stde = (StandardException)sqle.getCause();
                return StandardException.newException(stde.getMessageId(), root, stde.getArguments());
            }
            if (dsqle.getArguments() != null) {
                StandardException stde = StandardException.newException(dsqle.getMessageId(), root, dsqle.getArguments());
                stde.setSeverity(sqle.getErrorCode());
                return stde;
            }
        }
        StandardException stde = StandardException.newPreLocalizedException(sqle.getSQLState(), root, sqle.getLocalizedMessage());
        stde.setSeverity(sqle.getErrorCode());
        return stde;
    }

    public static final long estimateMemoryUsage(LanguageConnectionContext lcc, ResultSet resultSet, String stmtText) throws StandardException {
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.estimatingMemoryUsage(stmtText, resultSet);
        }
        long memory = lcc.getLanguageConnectionFactory().getExecutionFactory().getResultSetStatisticsFactory().getResultSetMemoryUsage(resultSet);
        if (GemFireXDUtils.TraceHeapThresh) {
            SanityManager.DEBUG_PRINT((String)"TraceHeapThreshold", (String)("Misc: Estimated working memory for " + stmtText + " (" + resultSet.getActivation().getPreparedStatement() + ") is " + memory));
        }
        if (observer != null) {
            memory = observer.estimatedMemoryUsage(stmtText, memory);
        }
        return memory;
    }

    public static final StandardException generateLowMemoryException(String query) {
        LogWriter logger = Misc.getCacheLogWriterNoThrow();
        if (logger != null && logger.warningEnabled()) {
            logger.warning("TraceHeapThreshold cancelling statement [" + query + "] due to low memory");
        }
        StandardException se = StandardException.newException("XCL54.T", (Object)query, (Object)GemFireStore.getMyId());
        se.setReport(1);
        return se;
    }

    public static final void checkMemoryRuntime(GfxdHeapThresholdListener thresholdListener, String query, long required) {
        StandardException se = Misc.generateLowMemoryException(thresholdListener, query, required);
        if (se == null) {
            return;
        }
        throw GemFireXDRuntimeException.newRuntimeException("Aborting  due to low memory", se);
    }

    public static final void checkMemory(GfxdHeapThresholdListener thresholdListener, String query, long required) throws StandardException {
        StandardException se = Misc.generateLowMemoryException(thresholdListener, query, required);
        if (se == null) {
            return;
        }
        throw se;
    }

    private static final StandardException generateLowMemoryException(GfxdHeapThresholdListener thresholdListener, String query, long required) {
        if (thresholdListener == null || !thresholdListener.isCritical()) {
            return null;
        }
        Runtime jvm = Runtime.getRuntime();
        long currentFreeMemory = jvm.freeMemory();
        long currentTotalMemory = jvm.totalMemory();
        if (required == -1L || required > currentTotalMemory - currentFreeMemory) {
            return Misc.generateLowMemoryException(query);
        }
        return null;
    }

    public static int getLength(int v) {
        if (v == Integer.MIN_VALUE) {
            return "-2147483648".length();
        }
        int x = v < 0 ? -v : v;
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return v < 0 ? i + 2 : i + 1;
    }

    public static int getLength(long v) {
        if (v == Long.MIN_VALUE) {
            return "-9223372036854775808".length();
        }
        long x = v < 0L ? -v + 1L : v;
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return v < 0L ? i + 1 : i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static boolean parseBoolean(String s) {
        if (s != null) {
            if (s.length() == 1) {
                return Integer.parseInt(s) != 0;
            }
            return Boolean.parseBoolean(s);
        }
        return false;
    }

    public static TreeSet<Map.Entry<Integer, Long>> sortByValue(Map<Integer, Long> distribution) {
        TreeSet<Map.Entry<Integer, Long>> entriesByVal = new TreeSet<Map.Entry<Integer, Long>>(new Comparator<Map.Entry<Integer, Long>>(){

            @Override
            public int compare(Map.Entry<Integer, Long> o1, Map.Entry<Integer, Long> o2) {
                int i = o2.getValue().compareTo(o1.getValue());
                return i != 0 ? i : o2.getKey().compareTo(o1.getKey());
            }
        });
        for (Map.Entry<Integer, Long> e : distribution.entrySet()) {
            entriesByVal.add(new GemFireXDUtils.Pair<Integer, Long>(e.getKey(), e.getValue()));
        }
        return entriesByVal;
    }

    public static TreeMap<Long, Double[]> createHistogram(Map<Integer, Long> distribution, TreeSet<Map.Entry<Integer, Long>> sortedByValue) {
        Map.Entry nextHist;
        if (sortedByValue == null) {
            SanityManager.ASSERT((distribution != null ? 1 : 0) != 0);
            sortedByValue = Misc.sortByValue(distribution);
        }
        int numDataPoints = sortedByValue.size();
        int numIntervals = (int)Math.ceil(Math.sqrt(numDataPoints));
        Long min = sortedByValue.last().getValue();
        Long max = sortedByValue.first().getValue();
        long width = (max - min) / (long)numIntervals;
        long stepValue = width > 10L ? (long)Math.pow(10.0, Math.ceil(Math.log10(width))) : (numIntervals < 10 ? 1L : 10L);
        long start = min - stepValue / 2L;
        long end = max + stepValue;
        TreeMap<Long, Double[]> histogram = new TreeMap<Long, Double[]>();
        for (long i = start; i <= end; i += stepValue) {
            histogram.put(i, new Double[]{0.0, 0.0});
        }
        Iterator<Map.Entry<Integer, Long>> i = sortedByValue.descendingIterator();
        Iterator h = histogram.entrySet().iterator();
        Map.Entry currentHist = h.hasNext() ? h.next() : null;
        Map.Entry entry = nextHist = h.hasNext() ? h.next() : null;
        while (i.hasNext() && currentHist != null) {
            Double d;
            Double d2;
            Double[] doubleArray;
            long v = i.next().getValue();
            if (nextHist == null || v <= (Long)nextHist.getKey()) {
                doubleArray = (Double[])currentHist.getValue();
                d2 = doubleArray[0];
                d = doubleArray[0] = Double.valueOf(doubleArray[0] + 1.0);
                continue;
            }
            do {
                currentHist = nextHist;
                Map.Entry entry2 = nextHist = h.hasNext() ? h.next() : null;
            } while (nextHist != null && v > (Long)currentHist.getKey());
            assert (v <= (Long)currentHist.getKey());
            doubleArray = (Double[])currentHist.getValue();
            d2 = doubleArray[0];
            d = doubleArray[0] = Double.valueOf(doubleArray[0] + 1.0);
        }
        SanityManager.ASSERT((!i.hasNext() ? 1 : 0) != 0);
        for (Map.Entry e : histogram.entrySet()) {
            double percent = ((Double[])e.getValue())[0] / (double)numDataPoints * 100.0;
            ((Double[])e.getValue())[1] = percent;
        }
        return histogram;
    }

    public static StringBuilder histogramToString(TreeMap<Long, Double[]> histogram, StringBuilder str) {
        str.append("histogram:").append(SanityManager.lineSeparator);
        int maxKeyLength = 0;
        int maxValLength = 0;
        int maxPercentLength = 0;
        int len = 0;
        for (Map.Entry<Long, Double[]> e : histogram.entrySet()) {
            len = Misc.getLength(e.getKey());
            maxKeyLength = len > maxKeyLength ? len : maxKeyLength;
            len = Misc.getLength(e.getValue()[0].intValue());
            maxValLength = len > maxValLength ? len : maxValLength;
            len = Misc.getLength(e.getValue()[1].intValue());
            maxPercentLength = len > maxPercentLength ? len : maxPercentLength;
        }
        Iterator<Map.Entry<Long, Double[]>> hI = histogram.entrySet().iterator();
        Map.Entry<Long, Double[]> currV = hI.hasNext() ? hI.next() : null;
        Map.Entry<Long, Double[]> nextV = null;
        Long key = null;
        Double val = null;
        while (hI.hasNext()) {
            int l;
            nextV = hI.next();
            key = currV.getKey();
            for (l = Misc.getLength(key); l < maxKeyLength; ++l) {
                str.append(' ');
            }
            str.append(key).append('-');
            key = nextV.getKey();
            for (l = Misc.getLength(key - 1L); l < maxKeyLength; ++l) {
                str.append(' ');
            }
            str.append(key).append(' ');
            val = currV.getValue()[0];
            for (l = Misc.getLength(val.intValue() - 1); l < maxValLength; ++l) {
                str.append(' ');
            }
            str.append(val.intValue()).append(' ');
            val = currV.getValue()[1];
            for (l = Misc.getLength(val.intValue() - 1); l < maxPercentLength; ++l) {
                str.append(' ');
            }
            str.append(PlanUtils.format.format(val)).append("%").append(SanityManager.lineSeparator);
            currV = nextV;
        }
        return str;
    }
}

