/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TemporaryRowHolder;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderResultSet;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;

abstract class ScanResultSet
extends NoPutResultSetImpl {
    protected final boolean tableLocked;
    private final boolean unspecifiedIsolationLevel;
    private final int suppliedLockMode;
    private boolean isolationLevelNeedsUpdate;
    int lockMode;
    int isolationLevel;
    ExecRow candidate;
    protected final FormatableBitSet accessedCols;

    ScanResultSet(Activation activation, int resultSetNumber, GeneratedMethod resultRowAllocator, int lockMode, boolean tableLocked, int isolationLevel, int colRefItem, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        this(activation, resultSetNumber, (ExecRow)resultRowAllocator.invoke(activation), lockMode, tableLocked, isolationLevel, colRefItem != -1 ? (FormatableBitSet)activation.getSavedObject(colRefItem) : null, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.printResultSetHierarchy();
    }

    ScanResultSet(Activation activation, int resultSetNumber, ExecRow candidate, int lockMode, boolean tableLocked, int isolationLevel, FormatableBitSet accessedCols, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.tableLocked = tableLocked;
        this.suppliedLockMode = lockMode;
        if (isolationLevel == 0) {
            this.unspecifiedIsolationLevel = true;
            isolationLevel = this.getLanguageConnectionContext().getCurrentIsolationLevel();
        } else {
            this.unspecifiedIsolationLevel = false;
        }
        this.lockMode = this.getLockMode(isolationLevel);
        this.isolationLevel = this.translateLanguageIsolationLevel(isolationLevel);
        this.candidate = candidate;
        this.accessedCols = accessedCols;
        this.printResultSetHierarchy();
    }

    protected TemporaryRowHolder getFutureForUpdateRows() {
        return null;
    }

    protected TemporaryRowHolderResultSet getFutureRowResultSet() {
        return null;
    }

    protected void setFutureRowResultSet(TemporaryRowHolderResultSet futureRowResultSet) {
        throw new AssertionError((Object)("setFutureRowResultSet: unexpected call for " + this.getClass().getName()));
    }

    protected boolean sourceDrained() {
        throw new AssertionError((Object)("sourceDrained: unexpected call for " + this.getClass().getName()));
    }

    void initIsolationLevel() {
        if (this.isolationLevelNeedsUpdate) {
            int languageLevel = this.getLanguageConnectionContext().getCurrentIsolationLevel();
            this.lockMode = this.getLockMode(languageLevel);
            this.isolationLevel = this.translateLanguageIsolationLevel(languageLevel);
            this.isolationLevelNeedsUpdate = false;
        }
    }

    private int getLockMode(int languageLevel) {
        if (this.tableLocked || languageLevel == 4) {
            return this.suppliedLockMode;
        }
        return 6;
    }

    private int translateLanguageIsolationLevel(int languageLevel) {
        switch (languageLevel) {
            case 1: {
                return 1;
            }
            case 2: {
                if (!this.canGetInstantaneousLocks()) {
                    return 2;
                }
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 0;
    }

    abstract boolean canGetInstantaneousLocks();

    @Override
    public int getScanIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        this.isolationLevelNeedsUpdate = this.unspecifiedIsolationLevel;
        this.candidate.resetRowArray();
        super.close(cleanupOnError);
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber));
        }
    }
}

