/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

public class RowUtil {
    public static ExecRow getEmptyValueRow(int columnCount, LanguageConnectionContext lcc) {
        return lcc.getLanguageConnectionFactory().getExecutionFactory().getValueRow(columnCount);
    }

    public static ExecIndexRow getEmptyIndexRow(int columnCount, LanguageConnectionContext lcc) {
        return lcc.getLanguageConnectionFactory().getExecutionFactory().getIndexableRow(columnCount);
    }

    public static void copyCloneColumns(ExecRow to, ExecRow from, int count) {
        for (int ix = 1; ix <= count; ++ix) {
            to.setColumn(ix, from.cloneColumn(ix));
        }
    }

    public static void copyRefColumns(ExecRow to, ExecRow from) {
        DataValueDescriptor[] src = from.getRowArray();
        DataValueDescriptor[] dst = to.getRowArray();
        System.arraycopy(src, 0, dst, 0, src.length);
    }

    public static void copyRefColumns(ExecRow to, ExecRow from, int count) throws StandardException {
        RowUtil.copyRefColumns(to, 0, from, 0, count);
    }

    public static void copyRefColumns(ExecRow to, ExecRow from, int start, int count) throws StandardException {
        RowUtil.copyRefColumns(to, 0, from, start, count);
    }

    public static void copyRefColumns(ExecRow to, int toStart, ExecRow from, int fromStart, int count) throws StandardException {
        for (int i = 1; i <= count; ++i) {
            to.setColumn(i + toStart, from.getColumn(i + fromStart));
        }
    }

    public static void copyRefColumns(ExecRow to, ExecRow from, int[] positions) throws StandardException {
        if (positions == null) {
            return;
        }
        int count = positions.length;
        for (int ix = 0; ix < count; ++ix) {
            to.setColumn(ix + 1, from.getColumn(positions[ix]));
        }
    }

    public static void copyRefColumns(ExecRow to, ExecRow from, FormatableBitSet positions) throws StandardException {
        if (positions == null) {
            return;
        }
        int max = to.getRowArray().length;
        int fromCount = 1;
        for (int toCount = 1; toCount <= max; ++toCount) {
            if (!positions.get(toCount)) continue;
            to.setColumn(toCount, from.getColumn(fromCount));
            ++fromCount;
        }
    }

    public static void copyRefColumns(ExecRow setMe) throws StandardException {
        for (int ix = 1; ix <= setMe.nColumns(); ++ix) {
            setMe.setColumn(ix, null);
        }
    }

    public static String toString(ExecRow row) {
        return row == null ? "null" : RowUtil.toString(row.getRowArray());
    }

    public static String toString(Object[] objs) {
        StringBuilder strbuf = new StringBuilder();
        if (objs == null) {
            return "null";
        }
        strbuf.append("(");
        for (int i = 0; i < objs.length; ++i) {
            if (i > 0) {
                strbuf.append(",");
            }
            strbuf.append(objs[i]);
        }
        strbuf.append(")");
        return strbuf.toString();
    }

    public static String toString(ExecRow row, int startPoint, int endPoint) {
        return RowUtil.toString(row.getRowArray(), startPoint, endPoint);
    }

    public static String toString(Object[] objs, int startPoint, int endPoint) {
        StringBuilder strbuf = new StringBuilder();
        if (endPoint >= objs.length) {
            SanityManager.THROWASSERT((String)("endPoint " + endPoint + " is too high," + " array only has " + objs.length + " elements"));
        }
        strbuf.append("(");
        for (int i = startPoint; i <= endPoint; ++i) {
            if (i > 0) {
                strbuf.append(",");
            }
            strbuf.append(objs[i]);
        }
        strbuf.append(")");
        return strbuf.toString();
    }

    public static String toString(ExecRow row, int[] positions) {
        return RowUtil.toString(row.getRowArray(), positions);
    }

    public static String toString(Object[] objs, int[] positions) {
        if (positions == null) {
            return null;
        }
        StringBuilder strbuf = new StringBuilder();
        strbuf.append("(");
        for (int i = 0; i < positions.length; ++i) {
            if (i > 0) {
                strbuf.append(",");
            }
            strbuf.append(objs[positions[i] - 1]);
        }
        strbuf.append(")");
        return strbuf.toString();
    }

    public static String intArrayToString(int[] colMap) {
        StringBuilder strbuf = new StringBuilder();
        strbuf.append("(");
        for (int i = 0; i < colMap.length; ++i) {
            if (i > 0) {
                strbuf.append(",");
            }
            strbuf.append(colMap[i]);
        }
        strbuf.append(")");
        return strbuf.toString();
    }

    public static boolean inAscendingOrder(int[] colMap) {
        if (colMap != null) {
            int lastCol = -1;
            for (int i = 0; i < colMap.length; ++i) {
                if (lastCol > colMap[i]) {
                    return false;
                }
                lastCol = colMap[i];
            }
        }
        return true;
    }

    public static FormatableBitSet shift(FormatableBitSet bitSet, int n) {
        FormatableBitSet out = null;
        if (bitSet != null) {
            int size = bitSet.getLength();
            out = new FormatableBitSet(size);
            for (int i = n; i < size; ++i) {
                if (!bitSet.get(i)) continue;
                out.set(i - n);
            }
        }
        return out;
    }
}

