/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ResultSetStatisticsFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.sql.SQLWarning;
import java.sql.Timestamp;

public abstract class NoRowsResultSetImpl
implements ResultSet {
    protected final Activation activation;
    private UUID executionPlanID;
    private boolean dumpedStats;
    NoPutResultSet[] subqueryTrackingArray;
    protected boolean statisticsTimingOn;
    protected boolean runtimeStatisticsOn;
    protected boolean explainConnection;
    protected boolean statsEnabled;
    private boolean isOpen;
    final LanguageConnectionContext lcc;
    protected long beginTime;
    protected long endTime;
    public long beginExecutionTime;
    public long endExecutionTime;

    NoRowsResultSetImpl(Activation activation) throws StandardException {
        this.activation = activation;
        if (activation == null) {
            SanityManager.THROWASSERT((String)("activation is null in result set " + this.getClass()));
        }
        this.lcc = activation.getLanguageConnectionContext();
        this.statisticsTimingOn = this.lcc.getStatisticsTiming();
        this.runtimeStatisticsOn = this.lcc.getRunTimeStatisticsMode();
        this.explainConnection = this.lcc.explainConnection();
        this.statsEnabled = this.lcc.statsEnabled();
        if (this.statisticsTimingOn) {
            this.beginTime = XPLAINUtil.nanoTime();
            this.beginExecutionTime = XPLAINUtil.currentTimeMillis();
        }
        StatementContext sc = this.lcc.getStatementContext();
        sc.setTopResultSet(this, null);
        this.subqueryTrackingArray = sc.getSubqueryTrackingArray();
    }

    protected void setup() throws StandardException {
        this.statisticsTimingOn = this.lcc.getStatisticsTiming();
        if (this.statisticsTimingOn && this.beginExecutionTime == 0L) {
            this.beginTime = XPLAINUtil.nanoTime();
            this.beginExecutionTime = XPLAINUtil.currentTimeMillis();
        }
        this.runtimeStatisticsOn = this.lcc.getRunTimeStatisticsMode();
        this.explainConnection = this.lcc.explainConnection();
        this.statsEnabled = this.lcc.statsEnabled();
        this.isOpen = true;
    }

    @Override
    public final boolean returnsRows() {
        return false;
    }

    @Override
    public int modifiedRowCount() {
        return 0;
    }

    @Override
    public final Activation getActivation() {
        return this.activation;
    }

    @Override
    public final ExecRow getAbsoluteRow(int row) throws StandardException {
        throw StandardException.newException("XCL01.S", "absolute");
    }

    @Override
    public final ExecRow getRelativeRow(int row) throws StandardException {
        throw StandardException.newException("XCL01.S", "relative");
    }

    @Override
    public final ExecRow setBeforeFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "beforeFirst");
    }

    @Override
    public final ExecRow getFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "first");
    }

    @Override
    public final ExecRow getNextRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "next");
    }

    @Override
    public final ExecRow getPreviousRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "previous");
    }

    @Override
    public final ExecRow getLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "last");
    }

    @Override
    public final ExecRow setAfterLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "afterLast");
    }

    @Override
    public final void clearCurrentRow() {
    }

    @Override
    public final boolean checkRowPosition(int isType) {
        return false;
    }

    @Override
    public final int getRowNumber() {
        return 0;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        if (!this.isOpen) {
            return;
        }
        GemFireTransaction gft = (GemFireTransaction)this.lcc.getTransactionExecute();
        if (gft != null) {
            gft.release();
        }
        if (!this.dumpedStats) {
            if (this.runtimeStatisticsOn && !this.doesCommit() && !this.lcc.isConnectionForRemote()) {
                HeaderPrintWriter istream;
                this.endExecutionTime = this.statisticsTimingOn ? XPLAINUtil.currentTimeMillis() : 0L;
                ExecutionFactory ef = this.lcc.getLanguageConnectionFactory().getExecutionFactory();
                ResultSetStatisticsFactory rssf = ef.getResultSetStatisticsFactory();
                boolean logPlan = this.lcc.getLogQueryPlan();
                if (logPlan || this.lcc.getRunTimeStatisticsModeExplicit()) {
                    this.lcc.setRunTimeStatisticsObject(rssf.getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray));
                    istream = logPlan ? Monitor.getStream() : null;
                } else {
                    istream = null;
                }
                if (istream != null) {
                    istream.printlnWithHeader("(XID = " + this.lcc.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + this.lcc.getInstanceNumber() + "), " + this.lcc.getRunTimeStatisticsObject().getStatementText() + " ******* " + this.lcc.getRunTimeStatisticsObject().getStatementExecutionPlanText());
                }
                if (!cleanupOnError) {
                    ResultSetStatisticsVisitor visitor = ef.getXPLAINFactory().getXPLAINVisitor(this.lcc, this.statsEnabled, this.explainConnection);
                    visitor.doXPLAIN(this, this.activation, true, this.statisticsTimingOn, false);
                    this.executionPlanID = visitor.getStatementUUID();
                }
            }
            this.dumpedStats = true;
        }
        int staLength = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
        for (int index = 0; index < staLength; ++index) {
            if (this.subqueryTrackingArray[index] == null || this.subqueryTrackingArray[index].isClosed()) continue;
            this.subqueryTrackingArray[index].close(cleanupOnError);
        }
        if (!this.lcc.isConnectionForRemote()) {
            this.resetStatistics();
        }
        this.isOpen = false;
        if (this.activation.isSingleExecution()) {
            this.activation.close();
        }
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public void finish() throws StandardException {
    }

    @Override
    public long getExecuteTime() {
        return this.endTime - this.beginTime;
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        if (this.beginExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.beginExecutionTime);
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    public String getQueryPlanText(int depth) {
        return MessageService.getTextMessage("42Z47.U", this.getClass().getName());
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        if (GemFireXDUtils.TracePlanGeneration) {
            throw new AssertionError((Object)"should be overridden by subclasses ");
        }
        return 0L;
    }

    @Override
    public final NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[numSubqueries];
        }
        return this.subqueryTrackingArray;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    @Override
    public String getCursorName() {
        return null;
    }

    @Override
    public boolean hasAutoGeneratedKeysResultSet() {
        return false;
    }

    @Override
    public void flushBatch() throws StandardException {
    }

    @Override
    public void closeBatch() throws StandardException {
    }

    public static void evaluateACheckConstraint(GeneratedMethod checkGM, String checkName, long heapConglom, Activation activation) throws StandardException {
        DataValueDescriptor checkBoolean;
        if (checkGM != null && (checkBoolean = (DataValueDescriptor)checkGM.invoke(activation)) != null && !checkBoolean.isNull() && !checkBoolean.getBoolean()) {
            DataDictionary dd = activation.getLanguageConnectionContext().getDataDictionary();
            ConglomerateDescriptor cd = dd.getConglomerateDescriptor(heapConglom);
            TableDescriptor td = dd.getTableDescriptor(cd.getTableID());
            StandardException se = StandardException.newException("23513", (Object)td.getQualifiedName(), (Object)checkName);
            throw se;
        }
    }

    public static void evaluateCheckConstraints(GeneratedMethod checkGM, Activation activation) throws StandardException {
        if (checkGM != null) {
            checkGM.invoke(activation);
        }
    }

    public boolean doesCommit() {
        return false;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public UUID getExecutionPlanID() {
        return this.executionPlanID;
    }

    @Override
    public void markLocallyExecuted() {
    }

    @Override
    public void resetStatistics() {
        this.beginExecutionTime = 0L;
        this.endExecutionTime = 0L;
    }

    @Override
    public boolean isDistributedResultSet() {
        return false;
    }

    @Override
    public boolean addLockReference(GemFireTransaction tran) {
        return false;
    }

    @Override
    public boolean releaseLocks(GemFireTransaction tran) {
        return false;
    }

    @Override
    public final void checkCancellationFlag() throws StandardException {
        if (this.activation.isQueryCancelled()) {
            this.activation.checkCancellationFlag();
        }
    }
}

