/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.AliasInfo;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;
import com.pivotal.gemfirexd.internal.catalog.types.SynonymAliasInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import java.util.List;

public final class CreateAliasConstantAction
extends DDLConstantAction {
    private final String aliasName;
    private final String schemaName;
    private final String javaClassName;
    private final char aliasType;
    private final char nameSpace;
    private final AliasInfo aliasInfo;

    CreateAliasConstantAction(String aliasName, String schemaName, String javaClassName, AliasInfo aliasInfo, char aliasType) {
        this.aliasName = aliasName;
        this.schemaName = schemaName;
        this.javaClassName = javaClassName;
        this.aliasInfo = aliasInfo;
        this.aliasType = aliasType;
        switch (aliasType) {
            case 'P': {
                this.nameSpace = (char)80;
                break;
            }
            case 'F': {
                this.nameSpace = (char)70;
                break;
            }
            case 'S': {
                this.nameSpace = (char)83;
                break;
            }
            case 'A': {
                this.nameSpace = (char)65;
                break;
            }
            case 'R': {
                this.nameSpace = (char)82;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Unexpected value for aliasType (" + aliasType + ")"));
                this.nameSpace = '\u0000';
            }
        }
    }

    public String toString() {
        String type = null;
        switch (this.aliasType) {
            case 'P': {
                type = "CREATE PROCEDURE ";
                break;
            }
            case 'F': {
                type = "CREATE FUNCTION ";
                break;
            }
            case 'S': {
                type = "CREATE SYNONYM ";
                break;
            }
            case 'A': {
                type = "CREATE TYPE ";
                break;
            }
            case 'R': {
                type = "CREATE PROCEDURE RESULT PROCESSOR";
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Unexpected value for aliasType (" + this.aliasType + ")"));
            }
        }
        return type + this.aliasName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        SchemaDescriptor sd = this.getSchemaDescriptorForCreate(dd, activation, this.schemaName);
        GemFireXDUtils.lockObject(null, sd.getSchemaName() + '.' + this.aliasName, true, tc);
        UUID aliasID = dd.getUUIDFactory().createUUID();
        AliasDescriptor ads = new AliasDescriptor(dd, aliasID, this.aliasName, sd.getUUID(), this.javaClassName, this.aliasType, this.nameSpace, false, this.aliasInfo, null);
        switch (this.aliasType) {
            case 'A': {
                AliasDescriptor duplicateUDT = dd.getAliasDescriptor(sd.getUUID().toString(), this.aliasName, this.nameSpace);
                if (duplicateUDT == null) break;
                throw StandardException.newException("X0Y68.S", (Object)ads.getDescriptorType(), (Object)this.aliasName);
            }
            case 'F': 
            case 'P': {
                List list = dd.getRoutineList(sd.getUUID().toString(), this.aliasName, this.aliasType);
                for (int i = list.size() - 1; i >= 0; --i) {
                    AliasDescriptor proc = (AliasDescriptor)list.get(i);
                    RoutineAliasInfo procedureInfo = (RoutineAliasInfo)proc.getAliasInfo();
                    int parameterCount = procedureInfo.getParameterCount();
                    if (parameterCount != ((RoutineAliasInfo)this.aliasInfo).getParameterCount()) continue;
                    throw StandardException.newException("X0Y68.S", (Object)ads.getDescriptorType(), (Object)this.aliasName);
                }
                break;
            }
            case 'R': {
                List list = dd.getRoutineList(sd.getUUID().toString(), this.aliasName, this.aliasType);
                for (int i = list.size() - 1; i >= 0; --i) {
                    AliasDescriptor proc = (AliasDescriptor)list.get(i);
                    if (!proc.getObjectName().equals(this.aliasName)) continue;
                    throw StandardException.newException("X0Y68.S", (Object)ads.getDescriptorType(), (Object)this.aliasName);
                }
                ClassInspector ci = lcc.getLanguageConnectionFactory().getClassFactory().getClassInspector();
                if (ci.assignableTo(ads.getJavaClassName(), "com.pivotal.gemfirexd.procedure.ProcedureResultProcessor")) break;
                throw StandardException.newException("X0Z17.S", (Object)ads.getJavaClassName(), (Object)"com.pivotal.gemfirexd.procedure.ProcedureResultProcessor");
            }
            case 'S': {
                AliasDescriptor nextAD;
                SchemaDescriptor nextSD;
                TableDescriptor targetTD = dd.getTableDescriptor(this.aliasName, sd, tc);
                if (targetTD != null) {
                    throw StandardException.newException("X0Y68.S", (Object)targetTD.getDescriptorType(), (Object)targetTD.getDescriptorName());
                }
                String nextSynTable = ((SynonymAliasInfo)this.aliasInfo).getSynonymTable();
                String nextSynSchema = ((SynonymAliasInfo)this.aliasInfo).getSynonymSchema();
                while ((nextSD = dd.getSchemaDescriptor(nextSynSchema, tc, false)) != null && (nextAD = dd.getAliasDescriptor(nextSD.getUUID().toString(), nextSynTable, this.nameSpace)) != null) {
                    SynonymAliasInfo info = (SynonymAliasInfo)nextAD.getAliasInfo();
                    nextSynTable = info.getSynonymTable();
                    nextSynSchema = info.getSynonymSchema();
                    if (!this.aliasName.equals(nextSynTable) || !this.schemaName.equals(nextSynSchema)) continue;
                    throw StandardException.newException("42916", (Object)this.aliasName, (Object)((SynonymAliasInfo)this.aliasInfo).getSynonymTable());
                }
                if (nextSD != null) {
                    targetTD = dd.getTableDescriptor(nextSynTable, nextSD, tc);
                }
                if (nextSD == null || targetTD == null) {
                    activation.addWarning(StandardException.newWarning("01522", this.aliasName, nextSynSchema + "." + nextSynTable));
                }
                DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
                TableDescriptor td = ddg.newTableDescriptor(this.aliasName, sd, 4, 'R');
                dd.addDescriptor(td, sd, 1, false, tc);
                break;
            }
        }
        dd.addDescriptor(ads, null, 7, false, tc);
        this.adjustUDTDependencies(lcc, dd, ads, true);
    }

    @Override
    public final String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public final String getObjectName() {
        return this.aliasName;
    }
}

