/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SingleChildResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;

public final class RowCountNode
extends SingleChildResultSetNode {
    private ValueNode offset;
    private ValueNode fetchFirst;

    @Override
    public void init(Object childResult, Object rcl, Object offset, Object fetchFirst) throws StandardException {
        this.init(childResult, null);
        this.resultColumns = (ResultColumnList)rcl;
        this.offset = (ValueNode)offset;
        this.fetchFirst = (ValueNode)fetchFirst;
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.assignResultSetNumber();
        this.costEstimate = this.childResult.getFinalCostEstimate();
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        acb.pushThisAsActivation(mb);
        mb.push(this.resultSetNumber);
        boolean dynamicOffset = false;
        boolean dynamicFetchFirst = false;
        if (this.offset != null) {
            this.generateExprFun(acb, mb, this.offset);
        } else {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        }
        if (this.fetchFirst != null) {
            this.generateExprFun(acb, mb, this.fetchFirst);
        } else {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        }
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getRowCountResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 7);
    }

    private void generateExprFun(ExpressionClassBuilder ecb, MethodBuilder mb, ValueNode vn) throws StandardException {
        MethodBuilder exprFun = ecb.newExprFun();
        vn.generateExpression(ecb, exprFun);
        exprFun.methodReturn();
        exprFun.complete();
        ecb.pushMethodReference(mb, exprFun);
    }

    @Override
    public String toString() {
        return "offset: " + this.offset + "\n" + "fetchFirst:" + this.fetchFirst + "\n" + super.toString();
    }

    public ValueNode getRowCountOffSet() throws StandardException {
        return this.offset;
    }

    public ValueNode getRowCountFetchFirst() throws StandardException {
        return this.fetchFirst;
    }
}

