/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.cache.Region;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryRelationalOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JoinNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RelationalOperator;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.List;

public class HalfOuterJoinNode
extends JoinNode {
    private boolean rightOuterJoin;
    private boolean transformed = false;
    private HalfOuterJoinNode leftHalfOuterJoinNode;
    private HalfOuterJoinNode rightHalfOuterJoinNode;
    private String logicalLeftTableName;
    private String logicalRightTableName;

    @Override
    public void init(Object leftResult, Object rightResult, Object onClause, Object usingClause, Object rightOuterJoin, Object tableProperties) throws StandardException {
        super.init(leftResult, rightResult, onClause, usingClause, null, tableProperties, null);
        this.rightOuterJoin = (Boolean)rightOuterJoin;
        TableName lltname = null;
        TableName lrtname = null;
        if (this.rightOuterJoin) {
            if (leftResult instanceof FromBaseTable) {
                lrtname = ((FromBaseTable)leftResult).getActualTableName();
            } else if (leftResult instanceof HalfOuterJoinNode) {
                this.rightHalfOuterJoinNode = (HalfOuterJoinNode)leftResult;
            }
            if (rightResult instanceof FromBaseTable) {
                lltname = ((FromBaseTable)rightResult).getActualTableName();
            } else if (rightResult instanceof HalfOuterJoinNode) {
                this.leftHalfOuterJoinNode = (HalfOuterJoinNode)rightResult;
            }
        } else {
            if (rightResult instanceof FromBaseTable) {
                lrtname = ((FromBaseTable)rightResult).getActualTableName();
            } else if (rightResult instanceof HalfOuterJoinNode) {
                this.rightHalfOuterJoinNode = (HalfOuterJoinNode)rightResult;
            }
            if (leftResult instanceof FromBaseTable) {
                lltname = ((FromBaseTable)leftResult).getActualTableName();
            } else if (leftResult instanceof HalfOuterJoinNode) {
                this.leftHalfOuterJoinNode = (HalfOuterJoinNode)leftResult;
            }
        }
        if (lltname != null) {
            this.logicalLeftTableName = lltname.getFullTableName();
        }
        if (lrtname != null) {
            this.logicalRightTableName = lrtname.getFullTableName();
        }
        this.flattenableJoin = false;
    }

    public String getLogicalLeftTableName() {
        return this.logicalLeftTableName;
    }

    public String getLogicalRightTableName() {
        return this.logicalRightTableName;
    }

    public HalfOuterJoinNode getLeftHalfOuterJoinNode() {
        return this.leftHalfOuterJoinNode;
    }

    public HalfOuterJoinNode getRightHalfOuterJoinNode() {
        return this.rightHalfOuterJoinNode;
    }

    public void addAllLogicalLeftTableNamesToList(final List<Region> logicalLeftTableList) throws StandardException {
        HalfOuterJoinNode rightHalfNode;
        String logicalLeftTableName = this.getLogicalLeftTableName();
        if (logicalLeftTableName != null) {
            Region lregion = Misc.getRegionForTableByPath(logicalLeftTableName, false);
            if (lregion == null) {
                ResultSetNode rsNode = this.getLogicalLeftResultSet();
                VisitorAdaptor searchTables = new VisitorAdaptor(){

                    @Override
                    public Visitable visit(Visitable node) throws StandardException {
                        Region r;
                        TableName tableName;
                        if (node instanceof FromBaseTable && (tableName = ((FromBaseTable)node).getActualTableName()) != null && (r = Misc.getRegionByPath(tableName.getFullTableNameAsRegionPath(), false)) != null) {
                            if (GemFireXDUtils.TraceOuterJoin) {
                                SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("DMLQueryInfo::handleJoinNode table name being added at node: " + node + " is " + r + " to list: " + logicalLeftTableList));
                            }
                            logicalLeftTableList.add(r);
                        }
                        return node;
                    }

                    @Override
                    public boolean skipChildren(Visitable node) throws StandardException {
                        return node instanceof ValueNode && !(node instanceof SubqueryNode) || node instanceof ResultColumnList || node instanceof ResultColumn || node instanceof PredicateList;
                    }
                };
                rsNode.accept(searchTables);
            } else {
                Region rregion;
                if (GemFireXDUtils.TraceOuterJoin) {
                    SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("DMLQueryInfo::handleJoinNodeltable name being added at node: " + this + " is" + lregion + " to list: " + logicalLeftTableList));
                }
                logicalLeftTableList.add(lregion);
                if (this.getRightHalfOuterJoinNode() != null) {
                    this.getRightHalfOuterJoinNode().addAllLogicalLeftTableNamesToList(logicalLeftTableList);
                }
                String logicalRightTableName = null;
                logicalRightTableName = this.getLogicalRightTableName();
                if (logicalRightTableName != null && (rregion = Misc.getRegionForTableByPath(logicalRightTableName, false)) != null) {
                    if (GemFireXDUtils.TraceOuterJoin) {
                        SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("DMLQueryInfo::handleJoinNodertable name being added to list of logical left tables is: " + logicalRightTableName));
                    }
                    logicalLeftTableList.add(rregion);
                }
            }
            return;
        }
        HalfOuterJoinNode leftHalfNode = this.getLeftHalfOuterJoinNode();
        if (leftHalfNode != null) {
            leftHalfNode.addAllLogicalLeftTableNamesToList(logicalLeftTableList);
        }
        if ((rightHalfNode = this.getRightHalfOuterJoinNode()) != null) {
            rightHalfNode.addAllLogicalLeftTableNamesToList(logicalLeftTableList);
        }
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        FromTable leftFromTable = (FromTable)this.leftResultSet;
        if (leftFromTable.getReferencedTableMap().contains(optimizablePredicate.getReferencedMap())) {
            return leftFromTable.pushOptPredicate(optimizablePredicate);
        }
        return false;
    }

    @Override
    public String toString() {
        return "rightOuterJoin: " + this.rightOuterJoin + "\n" + "transformed: " + this.transformed + "\n" + super.toString();
    }

    @Override
    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        if (this.rightOuterJoin) {
            SanityManager.ASSERT((!this.transformed ? 1 : 0) != 0, (String)"Attempting to transform a right outer join multiple times");
            ResultSetNode tmp = this.leftResultSet;
            this.leftResultSet = this.rightResultSet;
            this.rightResultSet = tmp;
            this.transformed = true;
        }
        ResultSetNode newTreeTop = super.preprocess(numTables, gbl, fromList);
        return newTreeTop;
    }

    @Override
    public void pushExpressions(PredicateList outerPredicateList) throws StandardException {
        FromTable leftFromTable = (FromTable)this.leftResultSet;
        FromTable rightFromTable = (FromTable)this.rightResultSet;
        this.pushExpressionsToLeft(outerPredicateList);
        for (int index = this.joinPredicates.size() - 1; index >= 0; --index) {
            Predicate predicate = (Predicate)this.joinPredicates.elementAt(index);
            if (!predicate.getPushable()) continue;
            this.getRightPredicateList().addPredicate(predicate);
            this.joinPredicates.removeElementAt(index);
        }
        PredicateList noPredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        leftFromTable.pushExpressions(this.getLeftPredicateList());
        rightFromTable.pushExpressions(noPredicates);
    }

    @Override
    public boolean LOJ_reorderable(int numTables) throws StandardException {
        ValueNode rightCol;
        ValueNode leftCol;
        BinaryRelationalOperatorNode equals;
        ValueNode left;
        AndNode and;
        ResultSetNode logicalRightResultSet;
        ResultSetNode logicalLeftResultSet;
        boolean anyChange = false;
        if (this.rightOuterJoin) {
            logicalLeftResultSet = this.rightResultSet;
            logicalRightResultSet = this.leftResultSet;
        } else {
            logicalLeftResultSet = this.leftResultSet;
            logicalRightResultSet = this.rightResultSet;
        }
        super.normExpressions();
        if (logicalLeftResultSet instanceof FromBaseTable && logicalRightResultSet instanceof FromBaseTable) {
            return anyChange;
        }
        if (logicalLeftResultSet instanceof HalfOuterJoinNode) {
            anyChange = ((HalfOuterJoinNode)logicalLeftResultSet).LOJ_reorderable(numTables) || anyChange;
        } else if (!(logicalLeftResultSet instanceof FromBaseTable)) {
            return anyChange;
        }
        if (logicalRightResultSet instanceof HalfOuterJoinNode) {
            anyChange = ((HalfOuterJoinNode)logicalRightResultSet).LOJ_reorderable(numTables) || anyChange;
        } else if (!(logicalRightResultSet instanceof FromBaseTable)) {
            return anyChange;
        }
        if (this.rightOuterJoin || logicalRightResultSet instanceof HalfOuterJoinNode && ((HalfOuterJoinNode)logicalRightResultSet).rightOuterJoin) {
            return this.LOJ_bindResultColumns(anyChange);
        }
        JBitSet RPReferencedTableMap = logicalLeftResultSet.LOJgetReferencedTables(numTables);
        JBitSet NPReferencedTableMap = logicalRightResultSet.LOJgetReferencedTables(numTables);
        if ((RPReferencedTableMap == null || NPReferencedTableMap == null) && anyChange) {
            return this.LOJ_bindResultColumns(anyChange);
        }
        ValueNode vn = this.joinClause;
        while (vn instanceof AndNode) {
            and = (AndNode)vn;
            left = and.getLeftOperand();
            if (left instanceof RelationalOperator && left.isBinaryEqualsOperatorNode()) {
                equals = (BinaryRelationalOperatorNode)left;
                leftCol = equals.getLeftOperand();
                rightCol = equals.getRightOperand();
                if (!(leftCol instanceof ColumnReference) || !(rightCol instanceof ColumnReference)) {
                    return this.LOJ_bindResultColumns(anyChange);
                }
                boolean refCheck = false;
                boolean leftOperandCheck = false;
                if (RPReferencedTableMap.get(((ColumnReference)leftCol).getTableNumber())) {
                    refCheck = true;
                    leftOperandCheck = true;
                } else if (NPReferencedTableMap.get(((ColumnReference)leftCol).getTableNumber())) {
                    refCheck = true;
                }
                if (!refCheck) {
                    return this.LOJ_bindResultColumns(anyChange);
                }
                refCheck = false;
                if (!leftOperandCheck && RPReferencedTableMap.get(((ColumnReference)rightCol).getTableNumber())) {
                    refCheck = true;
                } else if (leftOperandCheck && NPReferencedTableMap.get(((ColumnReference)rightCol).getTableNumber())) {
                    refCheck = true;
                }
                if (!refCheck) {
                    return this.LOJ_bindResultColumns(anyChange);
                }
            } else {
                return this.LOJ_bindResultColumns(anyChange);
            }
            vn = and.getRightOperand();
        }
        boolean push = false;
        if (logicalRightResultSet instanceof HalfOuterJoinNode) {
            JBitSet logicalNPRefTableMap = ((HalfOuterJoinNode)logicalRightResultSet).LOJgetNPReferencedTables(numTables);
            vn = this.joinClause;
            push = true;
            while (vn instanceof AndNode) {
                and = (AndNode)vn;
                left = and.getLeftOperand();
                equals = (BinaryRelationalOperatorNode)left;
                leftCol = equals.getLeftOperand();
                rightCol = equals.getRightOperand();
                if (logicalNPRefTableMap.get(((ColumnReference)leftCol).getTableNumber()) || logicalNPRefTableMap.get(((ColumnReference)rightCol).getTableNumber())) {
                    push = false;
                    break;
                }
                vn = and.getRightOperand();
            }
        }
        if (push) {
            if (this.subqueryList.size() != 0 || ((JoinNode)logicalRightResultSet).subqueryList.size() != 0 || this.joinPredicates.size() != 0 || ((JoinNode)logicalRightResultSet).joinPredicates.size() != 0 || this.usingClause != null || ((JoinNode)logicalRightResultSet).usingClause != null) {
                return this.LOJ_bindResultColumns(anyChange);
            }
            anyChange = true;
            ResultSetNode tmp = logicalLeftResultSet;
            ResultSetNode LChild = ((HalfOuterJoinNode)logicalRightResultSet).leftResultSet;
            ResultSetNode RChild = ((HalfOuterJoinNode)logicalRightResultSet).rightResultSet;
            ((HalfOuterJoinNode)logicalRightResultSet).rightResultSet = LChild;
            ((HalfOuterJoinNode)logicalRightResultSet).leftResultSet = tmp;
            vn = this.joinClause;
            this.joinClause = ((HalfOuterJoinNode)logicalRightResultSet).joinClause;
            ((HalfOuterJoinNode)logicalRightResultSet).joinClause = vn;
            FromList localFromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.leftResultSet = logicalRightResultSet;
            this.rightResultSet = RChild;
            ((HalfOuterJoinNode)this.leftResultSet).resultColumns = null;
            ((JoinNode)this.leftResultSet).bindResultColumns(localFromList);
            boolean localChange = ((HalfOuterJoinNode)this.leftResultSet).LOJ_reorderable(numTables);
            return this.LOJ_bindResultColumns(anyChange);
        }
        return this.LOJ_bindResultColumns(anyChange);
    }

    public boolean LOJ_bindResultColumns(boolean anyChange) throws StandardException {
        if (anyChange) {
            this.resultColumns = null;
            FromList localFromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.bindResultColumns(localFromList);
        }
        return anyChange;
    }

    @Override
    public FromTable transformOuterJoins(ValueNode predicateTree, int numTables) throws StandardException {
        ResultSetNode innerRS;
        if (predicateTree == null) {
            this.leftResultSet.notFlattenableJoin();
            this.rightResultSet.notFlattenableJoin();
            return this;
        }
        super.transformOuterJoins(predicateTree, numTables);
        JBitSet innerMap = new JBitSet(numTables);
        if (this.rightOuterJoin) {
            SanityManager.ASSERT((!this.transformed ? 1 : 0) != 0, (String)"right OJ not expected to be transformed into left OJ yet");
            innerRS = this.leftResultSet;
        } else {
            innerRS = this.rightResultSet;
        }
        innerRS.fillInReferencedTableMap(innerMap);
        ValueNode vn = predicateTree;
        while (vn instanceof AndNode) {
            AndNode and = (AndNode)vn;
            ValueNode left = and.getLeftOperand();
            if (left.isInstanceOf(25)) {
                vn = and.getRightOperand();
                continue;
            }
            if (left instanceof RelationalOperator) {
                JBitSet refMap = new JBitSet(numTables);
                if (!left.categorize(refMap, true)) {
                    vn = and.getRightOperand();
                    continue;
                }
                for (int bit = 0; bit < numTables; ++bit) {
                    if (!refMap.get(bit) || !innerMap.get(bit)) continue;
                    JoinNode ij = (JoinNode)this.getNodeFactory().getNode(139, this.leftResultSet, this.rightResultSet, this.joinClause, null, this.resultColumns, null, null, this.getContextManager());
                    ij.setTableNumber(this.tableNumber);
                    ij.setSubqueryList(this.subqueryList);
                    ij.setAggregateVector(this.aggregateVector);
                    return ij;
                }
            }
            vn = and.getRightOperand();
        }
        this.leftResultSet.notFlattenableJoin();
        this.rightResultSet.notFlattenableJoin();
        return this;
    }

    @Override
    protected void adjustNumberOfRowsReturned(CostEstimate costEstimate) {
        CostEstimate outerCost = this.getLeftResultSet().getCostEstimate();
        if (costEstimate.rowCount() < outerCost.rowCount()) {
            costEstimate.setCost(costEstimate.getEstimatedCost(), outerCost.rowCount(), outerCost.rowCount());
        }
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((this.rightOuterJoin == this.transformed ? 1 : 0) != 0, (String)("rightOuterJoin (" + this.rightOuterJoin + ") is expected to equal transformed (" + this.transformed + ")"));
        super.generateCore(acb, mb, 3);
    }

    @Override
    protected int addOuterJoinArguments(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.rightResultSet.getResultColumns().generateNulls(acb, mb);
        mb.push(this.rightOuterJoin);
        return 2;
    }

    @Override
    protected int getNumJoinArguments() {
        return super.getNumJoinArguments() + 2;
    }

    @Override
    protected void oneRowRightSide(ActivationClassBuilder acb, MethodBuilder mb) {
        mb.push(false);
        mb.push(false);
    }

    @Override
    public ResultSetNode getLogicalLeftResultSet() {
        if (this.rightOuterJoin) {
            return this.rightResultSet;
        }
        return this.leftResultSet;
    }

    @Override
    ResultSetNode getLogicalRightResultSet() {
        if (this.rightOuterJoin) {
            return this.leftResultSet;
        }
        return this.rightResultSet;
    }

    public boolean isRightOuterJoin() {
        return this.rightOuterJoin;
    }

    public JBitSet LOJgetNPReferencedTables(int numTables) throws StandardException {
        if (this.rightOuterJoin && !this.transformed) {
            return this.leftResultSet.LOJgetReferencedTables(numTables);
        }
        return this.rightResultSet.LOJgetReferencedTables(numTables);
    }
}

