/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnDefinitionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementList;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ColumnInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ConstraintConstantAction;

public class AlterTableNode
extends DDLStatementNode {
    public TableElementList tableElementList = null;
    public char lockGranularity;
    public boolean compressTable = false;
    public boolean sequential = false;
    public int behavior;
    public TableDescriptor baseTable;
    protected int numConstraints;
    private int changeType = 0;
    private boolean truncateTable = false;
    protected SchemaDescriptor schemaDescriptor = null;
    protected ColumnInfo[] colInfos = null;
    protected ConstraintConstantAction[] conActions = null;
    private boolean isSet;

    @Override
    public void init(Object objectName) throws StandardException {
        this.initAndCheck(objectName);
        this.truncateTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    @Override
    public void init(Object objectName, Object sequential) throws StandardException {
        this.initAndCheck(objectName);
        this.sequential = (Boolean)sequential;
        this.compressTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    @Override
    public void init(Object objectName, Object tableElementList, Object lockGranularity, Object changeType, Object isSet, Object behavior, Object sequential) throws StandardException {
        this.initAndCheck(objectName);
        this.tableElementList = (TableElementList)tableElementList;
        this.lockGranularity = ((Character)lockGranularity).charValue();
        int[] ct = (int[])changeType;
        int[] bh = (int[])behavior;
        this.changeType = ct[0];
        this.behavior = bh[0];
        boolean[] seq = (boolean[])sequential;
        this.sequential = seq[0];
        this.isSet = ((boolean[])isSet)[0];
        switch (this.changeType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw StandardException.newException("0A000.S");
            }
        }
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    @Override
    public String toString() {
        return super.toString() + "objectName: " + "\n" + this.getObjectName() + "\n" + "tableElementList: " + "\n" + this.tableElementList + "\n" + "lockGranularity: " + "\n" + this.lockGranularity + "\n" + "compressTable: " + "\n" + this.compressTable + "\n" + "sequential: " + "\n" + this.sequential + "\n" + "truncateTable: " + "\n" + this.truncateTable + "\n";
    }

    @Override
    public String statementToString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE";
        }
        return "ALTER TABLE";
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public int getChangeType() {
        return this.changeType;
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        int numCheckConstraints = 0;
        int numBackingIndexes = 0;
        this.baseTable = this.getTableDescriptor();
        if (this.baseTable.getTableType() == 3) {
            throw StandardException.newException("42995");
        }
        this.getCompilerContext().createDependency(this.baseTable);
        if (this.changeType == 1 && this.tableElementList != null) {
            for (int i = 0; i < this.tableElementList.size(); ++i) {
                ColumnDefinitionNode cdn;
                if (!(this.tableElementList.elementAt(i) instanceof ColumnDefinitionNode) || !(cdn = (ColumnDefinitionNode)this.tableElementList.elementAt(i)).getType().getTypeId().isStringTypeId()) continue;
                cdn.setCollationType(this.schemaDescriptor.getCollationType());
            }
        }
        if (this.tableElementList != null) {
            this.tableElementList.validate(this, dd, this.baseTable);
            if (this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns() > 1012) {
                throw StandardException.newException("54011", (Object)String.valueOf(this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns()), (Object)this.getRelativeName(), (Object)String.valueOf(1012));
            }
            numBackingIndexes = this.tableElementList.countConstraints(2) + this.tableElementList.countConstraints(6) + this.tableElementList.countConstraints(3);
            numCheckConstraints = this.tableElementList.countConstraints(4);
        }
        if (numBackingIndexes + this.baseTable.getTotalNumberOfIndexes() > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", (Object)String.valueOf(numBackingIndexes + this.baseTable.getTotalNumberOfIndexes()), (Object)this.getRelativeName(), (Object)String.valueOf(Short.MAX_VALUE));
        }
        if (numCheckConstraints > 0) {
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            FromBaseTable table = (FromBaseTable)this.getNodeFactory().getNode(135, this.getObjectName(), null, null, null, this.getContextManager());
            fromList.addFromTable(table);
            fromList.bindTables(dd, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
            this.tableElementList.appendNewColumnsToRCL(table);
            this.tableElementList.bindAndValidateCheckConstraints(fromList);
        }
        if (this.isPrivilegeCollectionRequired()) {
            CompilerContext cc = this.getCompilerContext();
            cc.pushCurrentPrivType(7);
            this.getCompilerContext().addRequiredTablePriv(this.baseTable);
            cc.popCurrentPrivType();
        }
        this.getCompilerContext().createDependency(this.baseTable);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.baseTable.getSchemaName());
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        this.prepConstantAction();
        return this.getGenericConstantActionFactory().getAlterTableConstantAction(this.schemaDescriptor, this.getRelativeName(), this.baseTable.getUUID(), this.baseTable.getHeapConglomerateId(), 0, this.colInfos, this.conActions, this.lockGranularity, this.compressTable, this.isSet, this.behavior, this.sequential, this.truncateTable);
    }

    private void prepConstantAction() throws StandardException {
        if (this.tableElementList != null) {
            this.genColumnInfo();
        }
        if (this.numConstraints > 0) {
            this.conActions = new ConstraintConstantAction[this.numConstraints];
            this.tableElementList.genConstraintActions(false, this.conActions, this.getRelativeName(), this.schemaDescriptor, this.getDataDictionary());
        }
    }

    public void genColumnInfo() {
        this.colInfos = new ColumnInfo[this.tableElementList.countNumberOfColumns()];
        this.numConstraints = this.tableElementList.genColumnInfos(this.colInfos);
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.tableElementList != null) {
            this.tableElementList.accept(v);
        }
    }
}

