/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;

public class IndexInfoImpl {
    private IndexRowGenerator irg;
    private long conglomerateNumber;
    private final CatalogRowFactory crf;
    private final int indexNumber;

    IndexInfoImpl(int indexNumber, CatalogRowFactory crf) {
        this.crf = crf;
        this.indexNumber = indexNumber;
        this.conglomerateNumber = -1L;
    }

    long getConglomerateNumber() {
        return this.conglomerateNumber;
    }

    void setConglomerateNumber(long conglomerateNumber) {
        this.conglomerateNumber = conglomerateNumber;
    }

    String getIndexName() {
        return this.crf.getIndexName(this.indexNumber);
    }

    int getColumnCount() {
        return this.crf.getIndexColumnCount(this.indexNumber);
    }

    public IndexRowGenerator getIndexRowGenerator() {
        return this.irg;
    }

    void setIndexRowGenerator(IndexRowGenerator irg) {
        this.irg = irg;
    }

    int getBaseColumnPosition(int colNumber) {
        return this.crf.getIndexColumnPositions(this.indexNumber)[colNumber];
    }

    boolean isIndexUnique() {
        return this.crf.isIndexUnique(this.indexNumber);
    }
}

