/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayUtil;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.Statement;
import com.pivotal.gemfirexd.internal.iapi.sql.StorablePreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.sql.CursorInfo;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class GenericStorablePreparedStatement
extends GenericPreparedStatement
implements Formatable,
StorablePreparedStatement {
    private ByteArray byteCode;
    private String className;

    public GenericStorablePreparedStatement() {
    }

    GenericStorablePreparedStatement(Statement stmt) {
        super(stmt);
    }

    @Override
    ByteArray getByteCodeSaver() {
        if (this.byteCode == null) {
            this.byteCode = new ByteArray();
        }
        return this.byteCode;
    }

    @Override
    public GeneratedClass getActivationClass() throws StandardException {
        if (this.activationClass == null) {
            this.loadGeneratedClass();
        }
        return this.activationClass;
    }

    @Override
    void setActivationClass(GeneratedClass ac) {
        super.setActivationClass(ac);
        if (ac != null) {
            this.className = ac.getName();
            if (this.byteCode != null && this.byteCode.getArray() == null) {
                this.byteCode = null;
            }
        }
    }

    @Override
    public void loadGeneratedClass() throws StandardException {
        LanguageConnectionContext lcc = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        ClassFactory classFactory = lcc.getLanguageConnectionFactory().getClassFactory();
        GeneratedClass gc = classFactory.loadGeneratedClass(this.className, this.byteCode);
        this.setActivationClass(gc);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getCursorInfo());
        out.writeBoolean(this.needsSavepoint());
        out.writeBoolean(this.isAtomic);
        out.writeObject(this.executionConstants);
        out.writeObject(this.resultDesc);
        if (this.savedObjects == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            ArrayUtil.writeArrayLength(out, this.savedObjects);
            ArrayUtil.writeArrayItems(out, this.savedObjects);
        }
        out.writeObject(this.className);
        out.writeBoolean(this.byteCode != null);
        if (this.byteCode != null) {
            this.byteCode.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setCursorInfo((CursorInfo)in.readObject());
        this.setNeedsSavepoint(in.readBoolean());
        this.isAtomic = in.readBoolean();
        this.executionConstants = (ConstantAction)in.readObject();
        this.resultDesc = (ResultDescription)in.readObject();
        if (in.readBoolean()) {
            this.savedObjects = new Object[ArrayUtil.readArrayLength(in)];
            ArrayUtil.readArrayItems(in, this.savedObjects);
        }
        this.className = (String)in.readObject();
        if (in.readBoolean()) {
            this.byteCode = new ByteArray();
            this.byteCode.readExternal(in);
        } else {
            this.byteCode = null;
        }
    }

    @Override
    public int getTypeFormatId() {
        return 225;
    }

    @Override
    public boolean isStorable() {
        return true;
    }

    @Override
    public String toString() {
        String acn = this.activationClass == null ? "null" : this.activationClass.getName();
        return "GSPS " + System.identityHashCode(this) + " activationClassName=" + acn + " className=" + this.className;
    }
}

