/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.monitor;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.ErrorStringBuilder;
import com.pivotal.gemfirexd.internal.iapi.error.ShutdownException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.Context;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.BundleFinder;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.info.JVMInfo;
import com.pivotal.gemfirexd.internal.iapi.services.io.AccessibleByteArrayOutputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatIdUtil;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableInstanceGetter;
import com.pivotal.gemfirexd.internal.iapi.services.io.RegisteredFormatIds;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInfo;
import com.pivotal.gemfirexd.internal.iapi.services.loader.InstanceGetter;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleFactory;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleSupportable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.PersistentService;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.InfoStreams;
import com.pivotal.gemfirexd.internal.iapi.services.stream.PrintWriterGetHeader;
import com.pivotal.gemfirexd.internal.iapi.services.timer.TimerFactory;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.services.monitor.AntiGC;
import com.pivotal.gemfirexd.internal.impl.services.monitor.ProtocolKey;
import com.pivotal.gemfirexd.internal.impl.services.monitor.ServiceBootContext;
import com.pivotal.gemfirexd.internal.impl.services.monitor.StorageFactoryService;
import com.pivotal.gemfirexd.internal.impl.services.monitor.TopService;
import com.pivotal.gemfirexd.internal.impl.services.monitor.UpdateServiceProperties;
import com.pivotal.gemfirexd.internal.io.StorageFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

abstract class BaseMonitor
implements ModuleFactory,
BundleFinder {
    private HashMap<String, PersistentService> serviceProviders = new HashMap();
    Vector[] implementationSets;
    private Vector services;
    Properties bootProperties;
    Properties applicationProperties;
    volatile boolean inShutdown;
    private InfoStreams systemStreams;
    private ContextService contextService;
    private UUIDFactory uuidFactory;
    private TimerFactory timerFactory;
    boolean reportOn = Monitor.reportOn;
    private PrintStream logging;
    ThreadGroup daemonGroup;
    AntiGC dontGC;
    private InstanceGetter[] rc2;
    private Boolean exceptionTrace;
    private static final String SERVICE = "gemfirexd.service.";
    private static final HashMap storageFactories = new HashMap();
    private PrintWriter tmpWriter;
    private AccessibleByteArrayOutputStream tmpArray;
    private boolean dumpedTempWriter;

    BaseMonitor() {
        this.services = new Vector(0, 1);
        this.services.addElement(new TopService(this));
    }

    @Override
    public InfoStreams getSystemStreams() {
        if (this.systemStreams == null) {
            this.bootDefaultStream();
        }
        return this.systemStreams;
    }

    private synchronized void bootDefaultStream() {
        try {
            this.systemStreams = (InfoStreams)Class.forName("com.pivotal.gemfirexd.internal.impl.services.stream.SingleStream").newInstance();
            ((ModuleControl)((Object)this.systemStreams)).boot(true, null);
        }
        catch (StandardException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean inShutdown() {
        return this.inShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void shutdown() {
        Object object = this;
        // MONITORENTER : object
        if (this.inShutdown) {
            // MONITOREXIT : object
            return;
        }
        this.inShutdown = true;
        // MONITOREXIT : object
        if (this.reportOn) {
            this.report("Shutdown request");
        }
        this.contextService.notifyAllActiveThreads(null);
        while (true) {
            BaseMonitor baseMonitor = this;
            // MONITORENTER : baseMonitor
            int position = this.services.size() - 1;
            if (position == 0) {
                // MONITOREXIT : baseMonitor
                ((TopService)this.services.elementAt(0)).shutdown();
                object = this.dontGC;
                // MONITORENTER : object
                this.dontGC.goAway = true;
                this.dontGC.notifyAll();
                // MONITOREXIT : object
                ContextService.stop();
                Monitor.clearMonitor();
                return;
            }
            TopService ts = (TopService)this.services.elementAt(position);
            // MONITOREXIT : baseMonitor
            ContextManager cm = this.contextService.newContextManager();
            try {
                cm.popContext();
                this.contextService.setCurrentContextManager(cm);
                this.shutdown(ts.getService());
                continue;
            }
            finally {
                this.contextService.resetCurrentContextManager(cm);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(Object serviceModule) {
        if (serviceModule == null) {
            return;
        }
        TopService ts = this.findTopService(serviceModule);
        if (ts == null) {
            return;
        }
        boolean removeService = true;
        try {
            removeService = ts.shutdown();
        }
        finally {
            BaseMonitor baseMonitor = this;
            synchronized (baseMonitor) {
                if (removeService) {
                    boolean found = this.services.removeElement(ts);
                    SanityManager.ASSERT((boolean)found, (String)("service was not found " + serviceModule));
                }
            }
        }
    }

    protected final void runWithState(Properties properties, PrintStream log) {
        this.bootProperties = properties;
        this.logging = log;
        if (!this.initialize(false)) {
            return;
        }
        if (!Monitor.setMonitor(this)) {
            return;
        }
        Object msgService = MessageService.setFinder(this);
        Object[] keepItems = new Object[]{this, new Monitor(), msgService};
        this.dontGC = new AntiGC(keepItems);
        final Thread dontGCthread = this.getDaemonThread(this.dontGC, "antiGC", true);
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    dontGCthread.setContextClassLoader(null);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        dontGCthread.start();
        this.applicationProperties = this.readApplicationProperties();
        Properties systemProperties = null;
        try {
            systemProperties = System.getProperties();
            Enumeration<?> e = systemProperties.propertyNames();
            boolean changedProps = false;
            while (e.hasMoreElements()) {
                String prop = (String)e.nextElement();
                if (!prop.startsWith("gemfirexd.user.") && !prop.startsWith("sqlfire.user.")) continue;
                try {
                    String userID = IdUtil.getDBUserId(prop, true);
                    if (prop.equals(userID)) continue;
                    System.setProperty(userID, systemProperties.getProperty(prop));
                    System.clearProperty(prop);
                    changedProps = true;
                }
                catch (StandardException userID) {}
            }
            if (changedProps) {
                systemProperties = System.getProperties();
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        Vector bootImplementations = this.getImplementations(this.bootProperties, false);
        Vector systemImplementations = null;
        Vector applicationImplementations = null;
        systemImplementations = this.getImplementations(systemProperties, false);
        applicationImplementations = this.getImplementations(this.applicationProperties, false);
        Vector defaultImplementations = this.getDefaultImplementations();
        int implementationCount = 0;
        if (bootImplementations != null) {
            ++implementationCount;
        }
        if (systemImplementations != null) {
            ++implementationCount;
        }
        if (applicationImplementations != null) {
            ++implementationCount;
        }
        if (defaultImplementations != null) {
            ++implementationCount;
        }
        this.implementationSets = new Vector[implementationCount];
        implementationCount = 0;
        if (bootImplementations != null) {
            this.implementationSets[implementationCount++] = bootImplementations;
        }
        if (systemImplementations != null) {
            this.implementationSets[implementationCount++] = systemImplementations;
        }
        if (applicationImplementations != null) {
            this.implementationSets[implementationCount++] = applicationImplementations;
        }
        if (defaultImplementations != null) {
            this.implementationSets[implementationCount++] = defaultImplementations;
        }
        if (this.applicationProperties != null) {
            this.addDebugFlags(this.applicationProperties.getProperty("gemfirexd.debug.false"), false);
            this.addDebugFlags(this.applicationProperties.getProperty("gemfirexd.debug.true"), true);
        }
        this.addDebugFlags(PropertyUtil.getSystemProperty("gemfirexd.debug.false"), false);
        this.addDebugFlags(PropertyUtil.getSystemProperty("gemfirexd.debug.true"), true);
        try {
            this.systemStreams = (InfoStreams)Monitor.startSystemModule("com.pivotal.gemfirexd.internal.iapi.services.stream.InfoStreams");
            SanityManager.SET_DEBUG_STREAM((PrintWriter)this.systemStreams.stream().getPrintWriter());
            this.dumpTempWriter(false, false);
        }
        catch (StandardException se) {
            this.reportException(se);
            this.dumpTempWriter(true, true);
            return;
        }
        try {
            this.contextService = new ContextService();
            this.uuidFactory = (UUIDFactory)Monitor.startSystemModule("com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory");
            this.timerFactory = (TimerFactory)Monitor.startSystemModule("com.pivotal.gemfirexd.internal.iapi.services.timer.TimerFactory");
            Monitor.startSystemModule("com.pivotal.gemfirexd.internal.iapi.services.jmx.ManagementService");
        }
        catch (StandardException se) {
            this.reportException(se);
            this.dumpTempWriter(true, true);
            return;
        }
        this.clearTempWriter();
        if (this.reportOn) {
            this.dumpProperties("Boot Properties", this.bootProperties);
            this.dumpProperties("System Properties", systemProperties);
            this.dumpProperties("Application Properties", this.applicationProperties);
        }
        this.determineSupportedServiceProviders();
        boolean bootAll = Boolean.valueOf(PropertyUtil.getSystemProperty("gemfirexd.system.bootAll"));
        this.startServices(this.bootProperties, bootAll);
        this.startServices(systemProperties, bootAll);
        this.startServices(this.applicationProperties, bootAll);
        if (bootAll) {
            this.bootPersistentServices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object findService(String factoryInterface, String serviceName) {
        ProtocolKey key;
        if (serviceName == null) {
            return null;
        }
        try {
            key = ProtocolKey.create(factoryInterface, serviceName);
        }
        catch (StandardException se) {
            return null;
        }
        TopService myts = null;
        BaseMonitor baseMonitor = this;
        synchronized (baseMonitor) {
            for (int i = 1; i < this.services.size(); ++i) {
                TopService ts = (TopService)this.services.elementAt(i);
                if (!ts.isPotentialService(key)) continue;
                myts = ts;
                break;
            }
        }
        if (myts != null && myts.isActiveService(key)) {
            return myts.getService();
        }
        return null;
    }

    @Override
    public Locale getLocale(Object serviceModule) {
        TopService ts = this.findTopService(serviceModule);
        if (ts == null) {
            return null;
        }
        return ts.serviceLocale;
    }

    @Override
    public Locale getLocaleFromString(String localeDescription) throws StandardException {
        return BaseMonitor.staticGetLocaleFromString(localeDescription);
    }

    @Override
    public String getServiceName(Object serviceModule) {
        TopService ts = this.findTopService(serviceModule);
        if (ts == null) {
            return null;
        }
        return ts.getServiceType().getUserServiceName(ts.getKey().getIdentifier());
    }

    @Override
    public Locale setLocale(Object serviceModule, String userDefinedLocale) throws StandardException {
        TopService ts = this.findTopService(serviceModule);
        if (ts == null) {
            return null;
        }
        PersistentService provider = ts.getServiceType();
        if (provider == null) {
            return null;
        }
        String serviceName = ts.getKey().getIdentifier();
        Properties properties = provider.getServiceProperties(serviceName, null);
        properties = new UpdateServiceProperties(provider, serviceName, properties, true);
        return this.setLocale(properties, userDefinedLocale);
    }

    @Override
    public Locale setLocale(Properties serviceProperties, String userDefinedLocale) throws StandardException {
        Locale locale = BaseMonitor.staticGetLocaleFromString(userDefinedLocale);
        serviceProperties.put("gemfirexd.serviceLocale", locale.toString());
        return locale;
    }

    @Override
    public PersistentService getServiceType(Object serviceModule) {
        TopService ts = this.findTopService(serviceModule);
        if (ts == null) {
            return null;
        }
        return ts.getServiceType();
    }

    @Override
    public Object startModule(boolean create, Object serviceModule, String factoryInterface, String identifier, Properties properties) throws StandardException {
        ProtocolKey key = ProtocolKey.create(factoryInterface, identifier);
        TopService ts = this.findTopService(serviceModule);
        Object instance = ts.bootModule(create, serviceModule, key, properties);
        if (instance == null) {
            throw Monitor.missingImplementation(factoryInterface);
        }
        return instance;
    }

    private synchronized TopService findTopService(Object serviceModule) {
        if (serviceModule == null) {
            return (TopService)this.services.elementAt(0);
        }
        for (int i = 1; i < this.services.size(); ++i) {
            TopService ts = (TopService)this.services.elementAt(i);
            if (!ts.inService(serviceModule)) continue;
            return ts;
        }
        return null;
    }

    @Override
    public Object findModule(Object serviceModule, String factoryInterface, String identifier) {
        ProtocolKey key;
        try {
            key = ProtocolKey.create(factoryInterface, identifier);
        }
        catch (StandardException se) {
            return null;
        }
        TopService ts = this.findTopService(serviceModule);
        if (ts == null) {
            return null;
        }
        return ts.findModule(key, true, null);
    }

    @Override
    public InstanceGetter classFromIdentifier(int fmtId) throws StandardException {
        String className;
        InstanceGetter[] iga;
        int off;
        try {
            InstanceGetter ig;
            off = fmtId - 0;
            iga = this.rc2;
            if (iga == null) {
                iga = this.rc2 = new InstanceGetter[RegisteredFormatIds.TwoByte.length];
            }
            if ((ig = iga[off]) != null) {
                return ig;
            }
            className = RegisteredFormatIds.TwoByte[off];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            className = null;
            iga = null;
            off = 0;
        }
        if (className != null) {
            Throwable t;
            try {
                Class<?> clazz = Class.forName(className);
                if (FormatableInstanceGetter.class.isAssignableFrom(clazz)) {
                    FormatableInstanceGetter tfig = (FormatableInstanceGetter)clazz.newInstance();
                    tfig.setFormatId(fmtId);
                    iga[off] = tfig;
                    return iga[off];
                }
                iga[off] = new ClassInfo(clazz);
                return iga[off];
            }
            catch (ClassNotFoundException cnfe) {
                t = cnfe;
            }
            catch (IllegalAccessException iae) {
                t = iae;
            }
            catch (InstantiationException ie) {
                t = ie;
            }
            catch (LinkageError le) {
                t = le;
            }
            throw StandardException.newException("XBM0V.S", t, (Object)FormatIdUtil.formatIdToString(fmtId), (Object)className);
        }
        throw StandardException.newException("XBM0U.S", FormatIdUtil.formatIdToString(fmtId));
    }

    @Override
    public Object newInstanceFromIdentifier(int identifier) throws StandardException {
        Throwable t;
        InstanceGetter ci = this.classFromIdentifier(identifier);
        try {
            Object result = ci.getNewInstance();
            return result;
        }
        catch (InstantiationException ie) {
            t = ie;
        }
        catch (IllegalAccessException iae) {
            t = iae;
        }
        catch (InvocationTargetException ite) {
            t = ite;
        }
        catch (LinkageError le) {
            t = le;
        }
        throw StandardException.newException("XBM0W.S", t, (Object)new Integer(identifier), (Object)"XX");
    }

    protected Object loadInstance(Class factoryInterface, Properties properties, String identifier) {
        Object instance = null;
        Vector localImplementations = this.getImplementations(properties, false);
        if (localImplementations != null) {
            instance = this.loadInstance(localImplementations, factoryInterface, properties, identifier);
        }
        for (int i = 0; i < this.implementationSets.length && (instance = this.loadInstance(this.implementationSets[i], factoryInterface, properties, identifier)) == null; ++i) {
        }
        return instance;
    }

    private Object loadInstance(Vector implementations, Class factoryInterface, Properties properties, String identifier) {
        int index = 0;
        while ((index = BaseMonitor.findImplementation(implementations, index, factoryInterface)) >= 0) {
            Object instance = this.newInstance((Class)implementations.elementAt(index));
            if (BaseMonitor.canSupport(identifier, instance, properties)) {
                return instance;
            }
            ++index;
        }
        return null;
    }

    private static int findImplementation(Vector implementations, int startIndex, Class factoryInterface) {
        for (int i = startIndex; i < implementations.size(); ++i) {
            Class factoryClass = (Class)implementations.elementAt(i);
            if (!factoryInterface.isAssignableFrom(factoryClass)) continue;
            return i;
        }
        return -1;
    }

    private Object newInstance(String className) {
        try {
            Class<?> factoryClass = Class.forName(className);
            return factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.report(className + " " + e.toString());
        }
        catch (InstantiationException e) {
            this.report(className + " " + e.toString());
        }
        catch (IllegalAccessException e) {
            this.report(className + " " + e.toString());
        }
        catch (LinkageError le) {
            this.report(className + " " + le.toString());
            this.reportException(le);
        }
        return null;
    }

    private Object newInstance(Class classObject) {
        try {
            return classObject.newInstance();
        }
        catch (InstantiationException e) {
            this.report(classObject.getName() + " " + e.toString());
        }
        catch (IllegalAccessException e) {
            this.report(classObject.getName() + " " + e.toString());
        }
        catch (LinkageError le) {
            this.report(classObject.getName() + " " + le.toString());
            this.reportException(le);
        }
        return null;
    }

    @Override
    public Properties getApplicationProperties() {
        return this.applicationProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getServiceList(String protocol) {
        BaseMonitor baseMonitor = this;
        synchronized (baseMonitor) {
            TopService ts;
            int count = 0;
            for (int i = 1; i < this.services.size(); ++i) {
                ts = (TopService)this.services.elementAt(i);
                if (!ts.isActiveService() || !ts.getKey().getFactoryInterface().getName().equals(protocol)) continue;
                ++count;
            }
            String[] list = new String[count];
            if (count != 0) {
                int j = 0;
                for (int i = 1; i < this.services.size(); ++i) {
                    ts = (TopService)this.services.elementAt(i);
                    if (!ts.isActiveService() || !ts.getKey().getFactoryInterface().getName().equals(protocol)) continue;
                    list[j++] = ts.getServiceType().getUserServiceName(ts.getKey().getIdentifier());
                    if (j == count) break;
                }
            }
            return list;
        }
    }

    public void dumpProperties(String title, Properties props) {
        PrintWriter writer = this.getTempWriter();
        if (writer == null && this.systemStreams != null) {
            writer = this.systemStreams.stream().getPrintWriter();
        }
        GemFireXDUtils.dumpProperties(props, title, "MONITOR", this.reportOn, writer);
    }

    public void report(String message) {
        PrintWriter tpw = this.getTempWriter();
        if (tpw != null) {
            tpw.println(message);
        }
        if (this.systemStreams != null) {
            this.systemStreams.stream().printlnWithHeader(message);
        }
    }

    protected void reportException(Throwable t) {
        PrintWriterGetHeader pwgh = null;
        if (this.systemStreams != null) {
            pwgh = this.systemStreams.stream().getHeader();
        }
        ErrorStringBuilder esb = new ErrorStringBuilder(pwgh);
        esb.appendln(t.getMessage());
        esb.stackTrace(t);
        this.report(esb.get().toString());
    }

    private void addDebugFlags(String flags, boolean set) {
        SanityManager.addDebugFlags((String)flags, (boolean)set);
    }

    @Override
    public void startServices(Properties properties, boolean bootAll) {
        if (properties == null) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(SERVICE)) continue;
            String name = key.substring(SERVICE.length());
            String protocolOrType = properties.getProperty(key);
            try {
                if (protocolOrType.equals("serviceDirectory")) {
                    if (!bootAll) continue;
                    this.findProviderAndStartService(name, properties, true);
                    continue;
                }
                this.bootService(null, protocolOrType, name, properties, false);
            }
            catch (StandardException se) {
                if (protocolOrType.equals("serviceDirectory")) continue;
                this.reportException(se);
            }
        }
    }

    @Override
    public final boolean startPersistentService(String name, Properties properties) throws StandardException {
        return this.findProviderAndStartService(name, properties, false);
    }

    @Override
    public Object createPersistentService(String factoryInterface, String name, Properties properties) throws StandardException {
        PersistentService provider = this.findProviderForCreate(name);
        if (provider == null) {
            throw StandardException.newException("XBM0K.D", name);
        }
        return this.bootService(provider, factoryInterface, name, properties, true);
    }

    @Override
    public void removePersistentService(String name) throws StandardException {
        String serviceName;
        PersistentService provider = null;
        provider = this.findProviderForCreate(name);
        boolean removed = provider.removeServiceRoot(serviceName = provider.getCanonicalServiceName(name));
        if (!removed) {
            throw StandardException.newException("XBM0I.D", serviceName);
        }
    }

    @Override
    public Object startNonPersistentService(String factoryInterface, String serviceName, Properties properties) throws StandardException {
        return this.bootService(null, factoryInterface, serviceName, properties, false);
    }

    private Vector getImplementations(Properties moduleList, boolean actualModuleList) {
        if (moduleList == null) {
            return null;
        }
        Vector implementations = actualModuleList ? new Vector(moduleList.size()) : new Vector(0, 1);
        int theJDKId = JVMInfo.JDK_ID;
        int[] envModuleCount = new int[theJDKId + 1];
        Enumeration<?> e = moduleList.propertyNames();
        block12: while (e.hasMoreElements()) {
            String tag;
            String key = (String)e.nextElement();
            if (key.startsWith("gemfirexd.module.")) {
                tag = key.substring("gemfirexd.module.".length());
            } else {
                if (!key.startsWith("gemfirexd.subSubProtocol.")) continue;
                tag = key.substring("gemfirexd.module.".length());
            }
            String envKey = "gemfirexd.env.jdk.".concat(tag);
            String envJDK = moduleList.getProperty(envKey);
            int envJDKId = 0;
            if (envJDK != null && (envJDKId = Integer.parseInt(envJDK.trim())) > theJDKId) continue;
            envKey = "gemfirexd.env.classes.".concat(tag);
            String envClasses = moduleList.getProperty(envKey);
            if (envClasses != null) {
                StringTokenizer st = new StringTokenizer(envClasses, ",");
                while (st.hasMoreTokens()) {
                    try {
                        Class.forName(st.nextToken().trim());
                    }
                    catch (ClassNotFoundException cnfe) {
                        continue block12;
                    }
                    catch (LinkageError le) {
                        continue block12;
                    }
                }
            }
            String className = moduleList.getProperty(key);
            if (this.reportOn) {
                this.report("Accessing module " + className + " to run initializers at boot time");
            }
            try {
                Class<?> possibleModule = Class.forName(className);
                if (this.getPersistentServiceImplementation(possibleModule)) continue;
                if (StorageFactory.class.isAssignableFrom(possibleModule)) {
                    storageFactories.put(tag, className);
                    continue;
                }
                if (envJDKId != 0) {
                    int offset = 0;
                    for (int eji = theJDKId; eji > envJDKId; --eji) {
                        offset += envModuleCount[eji];
                    }
                    implementations.insertElementAt(possibleModule, offset);
                    int n = envJDKId;
                    envModuleCount[n] = envModuleCount[n] + 1;
                } else {
                    implementations.addElement(possibleModule);
                }
                Class[] csParams = new Class[]{new Properties().getClass()};
                try {
                    possibleModule.getMethod("canSupport", csParams);
                    if (!ModuleSupportable.class.isAssignableFrom(possibleModule)) {
                        SanityManager.THROWASSERT((String)("Module does not implement ModuleSupportable but has canSupport() - " + className));
                    }
                }
                catch (NoSuchMethodException eji) {
                    // empty catch block
                }
                boolean eitherMethod = false;
                Class[] bootParams = new Class[]{Boolean.TYPE, new Properties().getClass()};
                try {
                    possibleModule.getMethod("boot", bootParams);
                    eitherMethod = true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                Class[] stopParams = new Class[]{};
                try {
                    possibleModule.getMethod("stop", stopParams);
                    eitherMethod = true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (!eitherMethod || ModuleControl.class.isAssignableFrom(possibleModule)) continue;
                SanityManager.THROWASSERT((String)("Module does not implement ModuleControl but has its methods - " + className));
            }
            catch (ClassNotFoundException cnfe) {
                this.report("Class " + className + " " + cnfe.toString() + ", module ignored.");
            }
            catch (LinkageError le) {
                this.report("Class " + className + " " + le.toString() + ", module ignored.");
            }
        }
        if (implementations.isEmpty()) {
            return null;
        }
        implementations.trimToSize();
        return implementations;
    }

    private boolean getPersistentServiceImplementation(Class possibleModule) {
        if (!PersistentService.class.isAssignableFrom(possibleModule)) {
            return false;
        }
        PersistentService ps = (PersistentService)this.newInstance(possibleModule);
        if (ps == null) {
            this.report("Class " + possibleModule.getName() + " cannot create instance, module ignored.");
        } else {
            this.serviceProviders.put(ps.getType(), ps);
        }
        return true;
    }

    private Vector getDefaultImplementations() {
        Properties moduleList = this.getDefaultModuleProperties();
        return this.getImplementations(moduleList, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getDefaultModuleProperties() {
        Properties moduleList = new Properties();
        boolean firstList = true;
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            Enumeration<URL> e;
            Enumeration<URL> enumeration = e = cl == null ? ClassLoader.getSystemResources("com/pivotal/gemfirexd/internal/modules.properties") : cl.getResources("com/pivotal/gemfirexd/internal/modules.properties");
            while (e.hasMoreElements()) {
                URL modulesPropertiesURL = e.nextElement();
                InputStream is = null;
                try {
                    is = modulesPropertiesURL.openStream();
                    if (firstList) {
                        moduleList.load(is);
                        firstList = false;
                        continue;
                    }
                    Properties otherList = new Properties();
                    otherList.load(is);
                    Enumeration<Object> newKeys = otherList.keys();
                    while (newKeys.hasMoreElements()) {
                        String key = (String)newKeys.nextElement();
                        if (moduleList.contains(key)) {
                            this.report("Ignored duplicate property " + key + " in " + modulesPropertiesURL.toString());
                            continue;
                        }
                        moduleList.setProperty(key, otherList.getProperty(key));
                    }
                }
                catch (IOException ioe) {
                    this.report("Can't load implementation list " + modulesPropertiesURL.toString() + ": " + ioe.toString());
                }
                finally {
                    try {
                        if (is == null) continue;
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException ioe) {
            this.report("Can't load implementation list: " + ioe.toString());
        }
        if (firstList) {
            this.report("Default implementation list not found");
        }
        return moduleList;
    }

    protected static Properties removeRuntimeProperties(Properties properties) {
        Properties subset = new Properties();
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("gemfirexd.__rt.")) continue;
            subset.put(key, properties.get(key));
        }
        return subset;
    }

    abstract InputStream applicationPropertiesStream() throws IOException;

    protected Properties readApplicationProperties() {
        Properties properties;
        InputStream is = null;
        try {
            is = this.applicationPropertiesStream();
            if (is == null) {
                Properties properties2 = null;
                return properties2;
            }
            Properties properties3 = new Properties();
            com.pivotal.gemfirexd.internal.iapi.util.PropertyUtil.loadWithTrimmedValues(new BufferedInputStream(is), properties3);
            properties = properties3;
        }
        catch (SecurityException se) {
            Properties properties4 = null;
            return properties4;
        }
        catch (IOException ioe) {
            this.report(ioe.toString() + " (" + "gemfirexd.properties" + ")");
            this.reportException(ioe);
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    private void determineSupportedServiceProviders() {
        Iterator<PersistentService> i = this.serviceProviders.values().iterator();
        while (i.hasNext()) {
            PersistentService provider = i.next();
            String identifier = null;
            if (provider != null && provider instanceof PersistentService) {
                identifier = provider.getServiceName();
            }
            if (BaseMonitor.canSupport(identifier, provider, null)) continue;
            i.remove();
        }
    }

    private void bootPersistentServices() {
        ProviderEnumeration e = new ProviderEnumeration(this.applicationProperties);
        while (e.hasMoreElements()) {
            PersistentService provider = (PersistentService)e.nextElement();
            this.bootProviderServices(provider);
        }
    }

    protected void bootProviderServices(PersistentService provider) {
        if (this.reportOn) {
            this.report("Booting persistent services for provider: " + provider.getType());
        }
        Enumeration e = provider.getBootTimeServices();
        while (e != null && e.hasMoreElements()) {
            Properties serviceProperties;
            String serviceName = (String)e.nextElement();
            try {
                serviceProperties = provider.getServiceProperties(serviceName, null);
            }
            catch (StandardException mse) {
                this.report("Failed to load service properties, name: " + serviceName + ", type = " + provider.getType());
                this.reportException(mse);
                continue;
            }
            if (Boolean.valueOf(serviceProperties.getProperty("gemfirexd.distributedsystem.noAutoBoot")).booleanValue()) continue;
            try {
                this.startProviderService(provider, serviceName, serviceProperties);
            }
            catch (StandardException mse) {
                this.report("Service failed to boot, name: " + serviceName + ", type = " + provider.getType());
                this.reportException(mse);
            }
        }
    }

    private boolean findProviderAndStartService(String name, Properties properties, boolean bootTime) throws StandardException {
        PersistentService actualProvider = null;
        Properties serviceProperties = null;
        String serviceName = null;
        int colon = name.indexOf(58);
        if (colon != -1 && (actualProvider = this.findProviderFromName(name, colon)) != null) {
            serviceName = actualProvider.getCanonicalServiceName(name);
            if (serviceName == null) {
                return true;
            }
            serviceProperties = actualProvider.getServiceProperties(serviceName, properties);
            if (serviceProperties == null) {
                return true;
            }
            if (bootTime && Boolean.valueOf(serviceProperties.getProperty("gemfirexd.distributedsystem.noAutoBoot")).booleanValue()) {
                return true;
            }
            this.startProviderService(actualProvider, serviceName, serviceProperties);
            return true;
        }
        StandardException savedMse = null;
        ProviderEnumeration e = new ProviderEnumeration(properties);
        while (e.hasMoreElements()) {
            PersistentService provider = (PersistentService)e.nextElement();
            String sn = provider.getCanonicalServiceName(name);
            if (sn == null) continue;
            Properties p = null;
            try {
                p = provider.getServiceProperties(sn, properties);
                if (p == null) {
                    continue;
                }
            }
            catch (StandardException mse) {
                savedMse = mse;
            }
            if (actualProvider == null) {
                actualProvider = provider;
                serviceName = sn;
                serviceProperties = p;
                continue;
            }
            throw StandardException.newException("XBM0T.D", name);
        }
        if (actualProvider == null) {
            return colon == -1;
        }
        if (savedMse != null) {
            throw savedMse;
        }
        if (bootTime && Boolean.valueOf(serviceProperties.getProperty("gemfirexd.distributedsystem.noAutoBoot")).booleanValue()) {
            return true;
        }
        this.startProviderService(actualProvider, serviceName, serviceProperties);
        return true;
    }

    protected PersistentService findProviderForCreate(String name) throws StandardException {
        return this.findProviderFromName(name, name.indexOf(58));
    }

    private PersistentService findProviderFromName(String name, int colon) throws StandardException {
        if (colon == 0) {
            return null;
        }
        String serviceType = colon < 2 ? "directory" : name.substring(0, colon);
        return this.getServiceProvider(serviceType);
    }

    @Override
    public PersistentService getServiceProvider(String subSubProtocol) throws StandardException {
        PersistentService ps;
        if (subSubProtocol == null) {
            return null;
        }
        if (this.serviceProviders != null && (ps = this.serviceProviders.get(subSubProtocol)) != null) {
            return ps;
        }
        return this.getPersistentService(subSubProtocol);
    }

    private PersistentService getPersistentService(String subSubProtocol) throws StandardException {
        String className = this.getStorageFactoryClassName(subSubProtocol);
        return this.getPersistentService(className, subSubProtocol);
    }

    private PersistentService getPersistentService(String className, String subSubProtocol) throws StandardException {
        if (className == null) {
            return null;
        }
        Class<?> storageFactoryClass = null;
        try {
            storageFactoryClass = Class.forName(className);
        }
        catch (Throwable e) {
            throw StandardException.newException("XBM08.D", e, (Object)subSubProtocol, (Object)className);
        }
        return new StorageFactoryService(subSubProtocol, storageFactoryClass);
    }

    private String getStorageFactoryClassName(String subSubProtocol) {
        String propertyName = "gemfirexd.subSubProtocol." + subSubProtocol;
        String className = PropertyUtil.getSystemProperty(propertyName);
        if (className != null) {
            return className;
        }
        return (String)storageFactories.get(subSubProtocol);
    }

    protected void startProviderService(PersistentService provider, String serviceName, Properties serviceProperties) throws StandardException {
        String protocol = serviceProperties.getProperty("gemfirexd.serviceProtocol");
        if (protocol == null) {
            throw StandardException.newException("XCY03.S", "gemfirexd.serviceProtocol");
        }
        this.bootService(provider, protocol, serviceName, serviceProperties, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Object bootService(PersistentService provider, String factoryInterface, String serviceName, Properties properties, boolean create) throws StandardException {
        Object instance;
        ContextManager previousCM;
        if (provider != null) {
            serviceName = provider.getCanonicalServiceName(serviceName);
        }
        ProtocolKey serviceKey = ProtocolKey.create(factoryInterface, serviceName);
        if (this.reportOn) {
            this.report("Booting service " + serviceKey + " create = " + create);
        }
        ContextManager cm = previousCM = this.contextService.getCurrentContextManager();
        TopService ts = null;
        Context sb = null;
        try {
            Properties serviceProperties;
            UpdateServiceProperties usProperties;
            boolean inRestore;
            String serverLocaleDescription;
            BaseMonitor baseMonitor = this;
            // MONITORENTER : baseMonitor
            if (this.inShutdown) {
                throw StandardException.newException("XJ015.M");
            }
            for (int i = 1; i < this.services.size(); ++i) {
                TopService ts2 = (TopService)this.services.elementAt(i);
                if (!ts2.isPotentialService(serviceKey)) continue;
                Object var15_21 = null;
                // MONITOREXIT : baseMonitor
                return var15_21;
            }
            Locale serviceLocale = null;
            if (create) {
                properties = new Properties(properties);
                serviceLocale = BaseMonitor.setLocale(properties);
                properties.put("gemfirexd.serviceProtocol", factoryInterface);
                serviceName = provider.createServiceRoot(serviceName, Boolean.valueOf(properties.getProperty("gemfirexd.__deleteOnCreate")));
                serviceKey = ProtocolKey.create(factoryInterface, serviceName);
            } else if (properties != null && (serverLocaleDescription = properties.getProperty("gemfirexd.serviceLocale")) != null) {
                serviceLocale = BaseMonitor.staticGetLocaleFromString(serverLocaleDescription);
            }
            ts = new TopService(this, serviceKey, provider, serviceLocale);
            this.services.addElement(ts);
            // MONITOREXIT : baseMonitor
            if (provider != null) {
                SanityManager.ASSERT((boolean)provider.getCanonicalServiceName(serviceName).equals(serviceName), (String)("mismatched canonical names " + provider.getCanonicalServiceName(serviceName) + " != " + serviceName));
                SanityManager.ASSERT((boolean)serviceName.equals(serviceKey.getIdentifier()), (String)("mismatched names " + serviceName + " != " + serviceKey.getIdentifier()));
            }
            if (properties != null && provider != null) {
                properties.put("gemfirexd.__rt.serviceDirectory", serviceName);
                properties.put("gemfirexd.__rt.serviceType", provider.getType());
            }
            if (this.reportOn) {
                this.dumpProperties("Service Properties: " + serviceKey.toString(), properties);
            }
            if (previousCM == null) {
                cm = this.contextService.newContextManager();
                this.contextService.setCurrentContextManager(cm);
            }
            sb = new ServiceBootContext(cm);
            boolean bl = properties != null ? properties.getProperty("gemfirexd.__rt.inRestore") != null : (inRestore = false);
            if (provider != null && properties != null) {
                usProperties = new UpdateServiceProperties(provider, serviceName, properties, !create && !inRestore);
                serviceProperties = usProperties;
            } else {
                usProperties = null;
                serviceProperties = properties;
            }
            instance = ts.bootModule(create, null, serviceKey, serviceProperties);
            if (create || inRestore) {
                provider.saveServiceProperties(serviceName, usProperties.getStorageFactory(), BaseMonitor.removeRuntimeProperties(properties), false);
                usProperties.setServiceBooted();
            }
            if (cm != previousCM) {
                cm.cleanupOnError(StandardException.closeException());
            }
        }
        catch (Throwable t) {
            Throwable nested;
            StandardException se = t instanceof StandardException && ((StandardException)t).getSeverity() == 45000 ? (StandardException)t : Monitor.exceptionStartingModule(t);
            if (cm != previousCM) {
                cm.cleanupOnError(se);
            }
            if (ts != null) {
                boolean deleteOnError;
                try {
                    ts.shutdown();
                }
                catch (Exception inRestore) {
                    // empty catch block
                }
                BaseMonitor inRestore = this;
                // MONITORENTER : inRestore
                this.services.removeElement(ts);
                // MONITOREXIT : inRestore
                boolean bl = properties != null ? properties.getProperty("gemfirexd.__rt.deleteRootOnError") != null : (deleteOnError = false);
                if (create || deleteOnError) {
                    provider.removeServiceRoot(serviceName);
                }
            }
            if (!((nested = se.getCause()) instanceof ThreadDeath)) throw se;
            throw (ThreadDeath)nested;
        }
        finally {
            if (previousCM == cm && sb != null) {
                sb.popMe();
            }
            if (previousCM == null) {
                this.contextService.resetCurrentContextManager(cm);
            }
        }
        ts.setTopModule(instance);
        Thread.yield();
        return instance;
    }

    @Override
    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    @Override
    public TimerFactory getTimerFactory() {
        return this.timerFactory;
    }

    protected PrintWriter getTempWriter() {
        if (this.tmpWriter == null && !this.dumpedTempWriter) {
            this.tmpArray = new AccessibleByteArrayOutputStream();
            this.tmpWriter = new PrintWriter(this.tmpArray);
        }
        return this.tmpWriter;
    }

    private void dumpTempWriter(boolean bothPlaces, boolean clear) {
        BaseMonitor monitor = (BaseMonitor)Monitor.getCachedMonitorLite(true);
        if (monitor != null && monitor != this) {
            monitor.systemStreams = this.systemStreams;
            monitor.dumpTempWriter(bothPlaces, clear);
        }
        if (this.tmpWriter == null) {
            return;
        }
        this.tmpWriter.flush();
        BufferedReader lnr = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.tmpArray.getInternalByteArray())));
        try {
            String s;
            while ((s = lnr.readLine()) != null) {
                if (s.length() <= 0) continue;
                if (this.systemStreams != null) {
                    this.systemStreams.stream().printlnWithHeader(s);
                }
                if (this.systemStreams != null && !bothPlaces) continue;
                this.logging.println(s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.systemStreams == null || bothPlaces) {
            this.logging.flush();
        }
        if (!clear) {
            return;
        }
        this.tmpWriter = null;
        this.tmpArray = null;
        this.dumpedTempWriter = true;
        this.logging = null;
    }

    private void clearTempWriter() {
        this.tmpWriter = null;
        this.tmpArray = null;
        this.dumpedTempWriter = true;
        this.logging = null;
    }

    static boolean canSupport(String identifier, Object instance, Properties properties) {
        return !(instance instanceof ModuleSupportable) || ((ModuleSupportable)instance).canSupport(identifier, properties);
    }

    static void boot(Object module, boolean create, Properties properties) throws StandardException {
        if (module instanceof ModuleControl) {
            ((ModuleControl)module).boot(create, properties);
        }
    }

    private static Locale staticGetLocaleFromString(String localeDescription) throws StandardException {
        String country;
        boolean isOk;
        int len = localeDescription.length();
        boolean bl = isOk = len == 2 || len == 5 || len > 6;
        if (isOk && len != 2) {
            boolean bl2 = isOk = localeDescription.charAt(2) == '_';
        }
        if (isOk && len > 5) {
            boolean bl3 = isOk = localeDescription.charAt(5) == '_';
        }
        if (!isOk) {
            throw StandardException.newException("XBM0X.D", localeDescription);
        }
        String language = localeDescription.substring(0, 2);
        String string = country = len == 2 ? "" : localeDescription.substring(3, 5);
        if (len < 6) {
            return new Locale(language, country);
        }
        String variant = len > 6 ? localeDescription.substring(6, len) : null;
        return new Locale(language, country, variant);
    }

    private static Locale setLocale(Properties properties) throws StandardException {
        String userDefinedLocale = properties.getProperty("territory");
        Locale locale = userDefinedLocale == null ? Locale.getDefault() : BaseMonitor.staticGetLocaleFromString(userDefinedLocale);
        properties.put("gemfirexd.serviceLocale", locale.toString());
        return locale;
    }

    @Override
    public ResourceBundle getBundle(String messageId) {
        ContextManager cm;
        try {
            cm = ContextService.getFactory().getCurrentContextManager();
        }
        catch (ShutdownException se) {
            cm = null;
        }
        if (cm != null) {
            return MessageService.getBundleForLocale(cm.getMessageLocale(), messageId);
        }
        return null;
    }

    @Override
    public Thread getDaemonThread(Runnable task, String name, boolean setMinPriority) {
        Thread t = new Thread(this.daemonGroup, task, "gemfirexd.".concat(name));
        t.setDaemon(true);
        if (setMinPriority) {
            t.setPriority(1);
        }
        return t;
    }

    @Override
    public void setThreadPriority(int priority) {
        Thread t = Thread.currentThread();
        if (t.getThreadGroup() == this.daemonGroup) {
            t.setPriority(priority);
        }
    }

    abstract boolean initialize(boolean var1);

    static {
        String dirStorageFactoryClass = !JVMInfo.J2ME && JVMInfo.JDK_ID >= 4 ? "com.pivotal.gemfirexd.internal.impl.io.DirStorageFactory4" : "com.pivotal.gemfirexd.internal.impl.io.DirStorageFactory";
        storageFactories.put("directory", dirStorageFactoryClass);
        storageFactories.put("classpath", "com.pivotal.gemfirexd.internal.impl.io.CPStorageFactory");
        storageFactories.put("jar", "com.pivotal.gemfirexd.internal.impl.io.JarStorageFactory");
        storageFactories.put("http", "com.pivotal.gemfirexd.internal.impl.io.URLStorageFactory");
        storageFactories.put("https", "com.pivotal.gemfirexd.internal.impl.io.URLStorageFactory");
    }

    class ProviderEnumeration
    implements Enumeration {
        private Enumeration serviceProvidersKeys;
        private Properties startParams;
        private Enumeration paramEnumeration;
        private boolean enumeratedDirectoryProvider;
        private PersistentService storageFactoryPersistentService;

        ProviderEnumeration(Properties startParams) {
            this.serviceProvidersKeys = BaseMonitor.this.serviceProviders == null ? null : Collections.enumeration(BaseMonitor.this.serviceProviders.keySet());
            this.startParams = startParams;
            if (startParams != null) {
                this.paramEnumeration = startParams.keys();
            }
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.serviceProvidersKeys != null && this.serviceProvidersKeys.hasMoreElements()) {
                return BaseMonitor.this.serviceProviders.get(this.serviceProvidersKeys.nextElement());
            }
            this.getNextStorageFactory();
            PersistentService ret = this.storageFactoryPersistentService;
            this.storageFactoryPersistentService = null;
            return ret;
        }

        private void getNextStorageFactory() {
            if (this.storageFactoryPersistentService != null) {
                return;
            }
            if (this.paramEnumeration != null) {
                while (this.paramEnumeration.hasMoreElements()) {
                    String prop = (String)this.paramEnumeration.nextElement();
                    if (!prop.startsWith("gemfirexd.subSubProtocol.")) continue;
                    try {
                        String storageFactoryClassName = (String)this.startParams.get(prop);
                        if (storageFactoryClassName == null) continue;
                        this.storageFactoryPersistentService = BaseMonitor.this.getPersistentService((String)this.startParams.get(prop), prop.substring("gemfirexd.subSubProtocol.".length()));
                        if (this.storageFactoryPersistentService == null) continue;
                        return;
                    }
                    catch (StandardException standardException) {
                    }
                }
            }
            if (!this.enumeratedDirectoryProvider) {
                try {
                    this.storageFactoryPersistentService = BaseMonitor.this.getPersistentService(BaseMonitor.this.getStorageFactoryClassName("directory"), "directory");
                }
                catch (StandardException se) {
                    this.storageFactoryPersistentService = null;
                }
                this.enumeratedDirectoryProvider = true;
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (this.serviceProvidersKeys != null && this.serviceProvidersKeys.hasMoreElements()) {
                return true;
            }
            this.getNextStorageFactory();
            return this.storageFactoryPersistentService != null;
        }
    }
}

