/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.db;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.db.Database;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.JarReader;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleFactory;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleSupportable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertySetCallback;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.LanguageFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.FileInfoDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.FileResource;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.util.DoubleProperties;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.db.DatabaseContextImpl;
import com.pivotal.gemfirexd.internal.impl.db.StoreClassFactoryContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.JarUtil;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Dictionary;
import java.util.Locale;
import java.util.Properties;

public abstract class BasicDatabase
implements ModuleControl,
ModuleSupportable,
PropertySetCallback,
Database,
JarReader {
    protected boolean active;
    private AuthenticationService authenticationService;
    protected AccessFactory af;
    protected PropertyFactory pf;
    protected ClassFactory cfDB;
    private DataDictionary dd;
    protected LanguageConnectionFactory lcf;
    protected LanguageFactory lf;
    protected Object resourceAdapter;
    private Locale databaseLocale;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private DateFormat timestampFormat;
    private UUID myUUID;
    protected boolean lastToBoot = true;

    @Override
    public boolean canSupport(String identifier, Properties startParams) {
        String repliMode;
        boolean supported = Monitor.isDesiredCreateType(startParams, this.getEngineType());
        if (supported && (repliMode = startParams.getProperty("replication.slave.mode")) != null && !repliMode.equals("slavepremode")) {
            supported = false;
        }
        return supported;
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        ModuleFactory monitor = Monitor.getMonitor();
        if (create) {
            String localeID;
            if (startParams.getProperty("gemfirexd.__rt.storage.createWithNoLog") == null) {
                startParams.put("gemfirexd.__rt.storage.createWithNoLog", "true");
            }
            if ((localeID = startParams.getProperty("territory")) == null) {
                localeID = Locale.getDefault().toString();
            }
            this.databaseLocale = monitor.setLocale(startParams, localeID);
        } else {
            this.databaseLocale = monitor.getLocale(this);
        }
        this.setLocale(this.databaseLocale);
        this.bootValidation(create, startParams);
        DataValueFactory dvf = (DataValueFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory", startParams);
        this.bootStore(create, startParams);
        this.myUUID = this.makeDatabaseID(create, startParams);
        DoubleProperties allParams = new DoubleProperties(this.getAllDatabaseProperties(), startParams);
        if (this.pf != null) {
            this.pf.addPropertySetNotification(this);
        }
        this.bootClassFactory(create, allParams);
        this.dd = (DataDictionary)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary", allParams);
        this.lcf = (LanguageConnectionFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionFactory", allParams);
        this.lf = (LanguageFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.sql.LanguageFactory", allParams);
        this.bootResourceAdapter(create, allParams);
        this.authenticationService = this.bootAuthenticationService(create, allParams);
        SanityManager.ASSERT((this.authenticationService != null ? 1 : 0) != 0, (String)"Failed to set the Authentication service for the database");
        if (create && this.lastToBoot && startParams.getProperty("gemfirexd.__rt.storage.createWithNoLog") != null) {
            this.createFinished();
        }
        this.active = true;
    }

    @Override
    public void stop() {
        this.active = false;
    }

    @Override
    public int getEngineType() {
        return 2;
    }

    @Override
    public boolean isReadOnly() {
        return this.af.isReadOnly();
    }

    @Override
    public LanguageConnectionContext setupConnection(ContextManager cm, String user, String drdaID, String dbname) throws StandardException {
        TransactionController tc = this.getConnectionTransaction(cm);
        cm.setLocaleFinder(this);
        this.pushDbContext(cm);
        LanguageConnectionContext lctx = this.lcf.newLanguageConnectionContext(cm, tc, this.lf, this, user, drdaID, -1L, false, dbname);
        this.pushClassFactoryContext(cm, this.lcf.getClassFactory());
        ExecutionFactory ef = this.lcf.getExecutionFactory();
        ef.newExecutionContext(cm);
        lctx.initialize();
        lctx.internalCommitNoSync(5);
        return lctx;
    }

    @Override
    public final DataDictionary getDataDictionary() {
        return this.dd;
    }

    @Override
    public void pushDbContext(ContextManager cm) {
        DatabaseContextImpl dc = new DatabaseContextImpl(cm, this);
    }

    @Override
    public AuthenticationService getAuthenticationService() throws StandardException {
        SanityManager.ASSERT((this.authenticationService != null ? 1 : 0) != 0, (String)"Unexpected - There is no valid authentication service for the database!");
        return this.authenticationService;
    }

    @Override
    public void startReplicationMaster(String dbmaster, String host, int port, String replicationMode) throws SQLException {
        try {
            this.af.startReplicationMaster(dbmaster, host, port, replicationMode);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void stopReplicationMaster() throws SQLException {
        try {
            this.af.stopReplicationMaster();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void stopReplicationSlave() throws SQLException {
        StandardException se = StandardException.newException("XRE40");
        throw PublicAPI.wrapStandardException(se);
    }

    @Override
    public boolean isInSlaveMode() {
        return false;
    }

    @Override
    public void failover(String dbname) throws StandardException {
        this.af.failover(dbname);
    }

    @Override
    public void freeze() throws SQLException {
        try {
            this.af.freeze();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void unfreeze() throws SQLException {
        try {
            this.af.unfreeze();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void backup(String backupDir, boolean wait) throws SQLException {
        try {
            this.af.backup(backupDir, wait);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void backupAndEnableLogArchiveMode(String backupDir, boolean deleteOnlineArchivedLogFiles, boolean wait) throws SQLException {
        try {
            this.af.backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles, wait);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void disableLogArchiveMode(boolean deleteOnlineArchivedLogFiles) throws SQLException {
        try {
            this.af.disableLogArchiveMode(deleteOnlineArchivedLogFiles);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void checkpoint() throws SQLException {
        try {
            this.af.checkpoint();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public Locale getLocale() {
        return this.databaseLocale;
    }

    @Override
    public final UUID getId() {
        return this.myUUID;
    }

    @Override
    public Locale getCurrentLocale() throws StandardException {
        if (this.databaseLocale != null) {
            return this.databaseLocale;
        }
        throw BasicDatabase.noLocale();
    }

    @Override
    public DateFormat getDateFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance(1, this.databaseLocale);
            }
            return this.dateFormat;
        }
        throw BasicDatabase.noLocale();
    }

    @Override
    public DateFormat getTimeFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.timeFormat == null) {
                this.timeFormat = DateFormat.getTimeInstance(1, this.databaseLocale);
            }
            return this.timeFormat;
        }
        throw BasicDatabase.noLocale();
    }

    @Override
    public DateFormat getTimestampFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.timestampFormat == null) {
                this.timestampFormat = DateFormat.getDateTimeInstance(1, 1, this.databaseLocale);
            }
            return this.timestampFormat;
        }
        throw BasicDatabase.noLocale();
    }

    private static StandardException noLocale() {
        return StandardException.newException("XCXE0.S");
    }

    @Override
    public void setLocale(Locale locale) {
        this.databaseLocale = locale;
        this.dateFormat = null;
        this.timeFormat = null;
        this.timestampFormat = null;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected UUID makeDatabaseID(boolean create, Properties startParams) throws StandardException {
        TransactionController tc = this.af.getTransaction(ContextService.getFactory().getCurrentContextManager());
        String upgradeID = null;
        UUID databaseID = (UUID)tc.getProperty("gemfirexd.distributedsystemID");
        if (databaseID == null) {
            UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
            upgradeID = startParams.getProperty("gemfirexd.distributedsystemID");
            databaseID = upgradeID == null ? uuidFactory.createUUID() : uuidFactory.recreateUUID(upgradeID);
            tc.setProperty("gemfirexd.distributedsystemID", databaseID, true);
        }
        if (upgradeID != null) {
            startParams.remove("gemfirexd.distributedsystemID");
        }
        tc.commit();
        tc.destroy();
        return databaseID;
    }

    @Override
    public Object getResourceAdapter() {
        return this.resourceAdapter;
    }

    @Override
    public void init(boolean dbOnly, Dictionary p) {
    }

    @Override
    public boolean validate(String key, Serializable value, Dictionary p) throws StandardException {
        if (key.equals("gemfirexd.engineType")) {
            throw StandardException.newException("XCY02.S", (Object)key, (Object)value);
        }
        if (!key.equals("gemfirexd.distributedsystem.classpath")) {
            return false;
        }
        String newClasspath = (String)((Object)value);
        String[][] dbcp = null;
        if (newClasspath != null) {
            dbcp = IdUtil.parseDbClassPath(newClasspath);
        }
        if (dbcp != null) {
            for (int ix = 0; ix < dbcp.length; ++ix) {
                SchemaDescriptor sd = this.dd.getSchemaDescriptor(dbcp[ix][0], null, false);
                FileInfoDescriptor fid = null;
                if (sd != null) {
                    fid = this.dd.getFileInfoDescriptor(sd, dbcp[ix][1]);
                }
                if (fid != null) continue;
                throw StandardException.newException("42X96", IdUtil.mkQualifiedName(dbcp[ix]));
            }
        }
        return true;
    }

    @Override
    public Serviceable apply(String key, Serializable value, Dictionary p) throws StandardException {
        if (!key.equals("gemfirexd.distributedsystem.classpath")) {
            return null;
        }
        if (this.cfDB != null) {
            this.getDataDictionary().invalidateAllSPSPlans();
            String newClasspath = (String)((Object)value);
            if (newClasspath == null) {
                newClasspath = "";
            }
            this.cfDB.notifyModifyClasspath(newClasspath);
        }
        return null;
    }

    @Override
    public Serializable map(String key, Serializable value, Dictionary p) {
        return null;
    }

    protected void createFinished() throws StandardException {
        this.af.createFinished();
    }

    protected String getClasspath(Properties startParams) {
        String cp = PropertyUtil.getPropertyFromSet(startParams, "gemfirexd.distributedsystem.classpath");
        if (cp == null) {
            cp = PropertyUtil.getSystemProperty("gemfirexd.distributedsystem.classpath", "");
        }
        return cp;
    }

    protected void bootClassFactory(boolean create, Properties startParams) throws StandardException {
        String classpath = this.getClasspath(startParams);
        IdUtil.parseDbClassPath(classpath);
        startParams.put("gemfirexd.__rt.distributedsystem.classpath", classpath);
        this.cfDB = (ClassFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory", startParams);
    }

    protected TransactionController getConnectionTransaction(ContextManager cm) throws StandardException {
        return this.af.getTransaction(cm);
    }

    protected AuthenticationService bootAuthenticationService(boolean create, Properties props) throws StandardException {
        return (AuthenticationService)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService", props);
    }

    protected void bootValidation(boolean create, Properties startParams) throws StandardException {
        this.pf = (PropertyFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory", startParams);
    }

    protected void bootStore(boolean create, Properties startParams) throws StandardException {
        this.af = (AccessFactory)Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory", startParams);
    }

    protected Properties getAllDatabaseProperties() throws StandardException {
        TransactionController tc = this.af.getTransaction(ContextService.getFactory().getCurrentContextManager());
        Properties dbProps = tc.getProperties();
        tc.commit();
        tc.destroy();
        return dbProps;
    }

    protected void bootResourceAdapter(boolean create, Properties allParams) {
        try {
            this.resourceAdapter = Monitor.bootServiceModule(create, this, "com.pivotal.gemfirexd.internal.iapi.jdbc.ResourceAdapter", allParams);
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    protected void pushClassFactoryContext(ContextManager cm, ClassFactory cf) {
        new StoreClassFactoryContext(cm, cf, this.af, this);
    }

    @Override
    public StorageFile getJarFile(String schemaName, String sqlName) throws StandardException {
        SchemaDescriptor sd = this.dd.getSchemaDescriptor(schemaName, null, true);
        FileInfoDescriptor fid = this.dd.getFileInfoDescriptor(sd, sqlName);
        if (fid == null) {
            throw StandardException.newException("X0X13.S", (Object)sqlName, (Object)schemaName);
        }
        long generationId = fid.getGenerationId();
        ContextManager cm = ContextService.getFactory().getCurrentContextManager();
        FileResource fr = this.af.getTransaction(cm).getFileHandler();
        String externalName = JarUtil.mkExternalName(schemaName, sqlName, fr.getSeparatorChar());
        return fr.getAsFile(externalName, generationId);
    }

    @Override
    public void postCreate(EngineConnection conn, Properties bootProps) throws StandardException {
        throw new AssertionError((Object)"This shouldn't have been called.");
    }

    @Override
    public boolean disableStatementOptimizationToGenericPlan() {
        throw new AssertionError((Object)"This shouldn't have been called.");
    }

    @Override
    public LanguageConnectionContext setupConnection(ContextManager cm, String user, String drdaID, String dbname, long connectionID, boolean isRemote) throws StandardException {
        throw new AssertionError((Object)"This shouldn't have been called.");
    }

    @Override
    public boolean getRuntimeStatistics() {
        throw new AssertionError((Object)"This shouldn't have been called.");
    }
}

