/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;

public abstract class NumberDataType
extends DataType
implements NumberDataValue {
    static DataValueDescriptor ZERO_DECIMAL;
    static Comparable MINLONG_MINUS_ONE;
    static Comparable MAXLONG_PLUS_ONE;

    @Override
    public final NumberDataValue absolute(NumberDataValue result) throws StandardException {
        if (this.isNegative()) {
            return this.minus(result);
        }
        if (result == null) {
            result = (NumberDataType)this.getNewNull();
        }
        result.setValue(this);
        return result;
    }

    @Override
    public NumberDataValue sqrt(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        double doubleValue = this.getDouble();
        if (this.isNegative()) {
            if (new Double(doubleValue).equals(new Double(-0.0))) {
                doubleValue = 0.0;
            } else {
                throw StandardException.newException("22013", this);
            }
        }
        result.setValue(Math.sqrt(doubleValue));
        return result;
    }

    @Override
    public NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        int addend1Int = addend1.getInt();
        int addend2Int = addend2.getInt();
        int resultValue = addend1Int + addend2Int;
        if (addend1Int < 0 == addend2Int < 0 && addend1Int < 0 != resultValue < 0) {
            throw this.outOfRange();
        }
        result.setValue(resultValue);
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        int diff = left.getInt() - right.getInt();
        if (left.getInt() < 0 != right.getInt() < 0 && left.getInt() < 0 != diff < 0) {
            throw this.outOfRange();
        }
        result.setValue(diff);
        return result;
    }

    @Override
    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        int intDivisor = divisor.getInt();
        if (intDivisor == 0) {
            throw StandardException.newException("22012");
        }
        result.setValue(dividend.getInt() / intDivisor);
        return result;
    }

    @Override
    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result, int scale) throws StandardException {
        return this.divide(dividend, divisor, result);
    }

    @Override
    public NumberDataValue mod(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        SanityManager.NOTREACHED();
        return null;
    }

    @Override
    public final int compare(DataValueDescriptor arg) throws StandardException {
        if (this.typePrecedence() < arg.typePrecedence()) {
            return -Integer.signum(arg.compare(this));
        }
        boolean thisNull = this.isNull();
        boolean otherNull = arg.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return -1;
            }
            if (!otherNull) {
                return 1;
            }
            return 0;
        }
        return this.typeCompare(arg);
    }

    protected abstract int typeCompare(DataValueDescriptor var1) throws StandardException;

    @Override
    public final boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    protected abstract boolean isNegative();

    @Override
    public void setValue(short theValue) throws StandardException {
        this.setValue((int)theValue);
    }

    @Override
    public void setValue(byte theValue) throws StandardException {
        this.setValue((int)theValue);
    }

    @Override
    public void setValue(Number theValue) throws StandardException {
        if (this.objectNull(theValue)) {
            return;
        }
        if (!(theValue instanceof Integer)) {
            SanityManager.THROWASSERT((String)("NumberDataType.setValue(Number) passed a " + theValue.getClass()));
        }
        this.setValue(theValue.intValue());
    }

    @Override
    void setObject(Object theValue) throws StandardException {
        this.setValue((Integer)theValue);
    }

    @Override
    public void setBigDecimal(Number bigDecimal) throws StandardException {
        if (this.objectNull(bigDecimal)) {
            return;
        }
        Comparable bdc = (Comparable)((Object)bigDecimal);
        if (bdc.compareTo(MINLONG_MINUS_ONE) != 1 || bdc.compareTo(MAXLONG_PLUS_ONE) != -1) {
            throw StandardException.newException("22003", (Object)this.getTypeName(), (Object)null);
        }
        this.setValue(bigDecimal.longValue());
    }

    @Override
    public int typeToBigDecimal() {
        return -5;
    }

    @Override
    public int getDecimalValuePrecision() {
        return -1;
    }

    @Override
    public int getDecimalValueScale() {
        return -1;
    }

    protected final boolean objectNull(Object o) {
        if (o == null) {
            this.restoreToNull();
            return true;
        }
        return false;
    }

    public static float normalizeREAL(float v) throws StandardException {
        if (Float.isNaN(v) || Float.isInfinite(v) || v < -3.402E38f || v > 3.402E38f || v > 0.0f && v < 1.175E-37f || v < 0.0f && v > -1.175E-37f) {
            throw StandardException.newException("22003", (Object)"REAL", (Object)null);
        }
        if (v == 0.0f) {
            v = 0.0f;
        }
        return v;
    }

    public static float normalizeREAL(double v) throws StandardException {
        if (Double.isNaN(v) || Double.isInfinite(v) || v < (double)-3.402E38f || v > (double)3.402E38f || v > 0.0 && v < (double)1.175E-37f || v < 0.0 && v > (double)-1.175E-37f) {
            throw StandardException.newException("22003", (Object)"REAL", (Object)null);
        }
        if (v == 0.0) {
            v = 0.0;
        }
        return (float)v;
    }

    public static double normalizeDOUBLE(double v) throws StandardException {
        if (Double.isNaN(v) || Double.isInfinite(v) || v < -1.79769E308 || v > 1.79769E308 || v > 0.0 && v < 2.225E-307 || v < 0.0 && v > -2.225E-307) {
            throw StandardException.newException("22003", (Object)"DOUBLE", (Object)null);
        }
        if (v == 0.0) {
            v = 0.0;
        }
        return v;
    }
}

