/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.store.raw;

import com.pivotal.gemfirexd.internal.iapi.services.io.CompressedNumber;
import com.pivotal.gemfirexd.internal.iapi.services.locks.Latch;
import com.pivotal.gemfirexd.internal.iapi.services.locks.Lockable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerLock;
import com.pivotal.gemfirexd.internal.iapi.store.raw.PageKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.util.Matchable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;

public final class ContainerKey
implements Matchable,
Lockable {
    private final long segmentId;
    private final long containerId;
    private static final int KEYCACHE_SIZE = 300;
    private static final ContainerKey[] zeroSegmentCache = new ContainerKey[300];

    public ContainerKey(long segmentId, long containerId) {
        this.segmentId = segmentId;
        this.containerId = containerId;
    }

    public long getContainerId() {
        return this.containerId;
    }

    public long getSegmentId() {
        return this.segmentId;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        CompressedNumber.writeLong(out, this.segmentId);
        CompressedNumber.writeLong(out, this.containerId);
    }

    public static ContainerKey read(ObjectInput in) throws IOException {
        long sid = CompressedNumber.readLong(in);
        long cid = CompressedNumber.readLong(in);
        return new ContainerKey(sid, cid);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ContainerKey) {
            ContainerKey otherKey = (ContainerKey)other;
            return this.containerId == otherKey.containerId && this.segmentId == otherKey.segmentId;
        }
        return false;
    }

    public final int hashCode() {
        return (int)(this.segmentId ^ this.containerId);
    }

    public String toString() {
        return "Container(" + this.segmentId + ", " + this.containerId + ")";
    }

    @Override
    public boolean match(Object key) {
        if (this.equals(key)) {
            return true;
        }
        if (key instanceof PageKey) {
            return this.equals(((PageKey)key).getContainerId());
        }
        if (key instanceof RecordHandle) {
            return this.equals(((RecordHandle)key).getContainerId());
        }
        return false;
    }

    @Override
    public void lockEvent(Latch lockInfo) {
    }

    @Override
    public boolean requestCompatible(Object requestedQualifier, Object grantedQualifier) {
        SanityManager.ASSERT((boolean)(requestedQualifier instanceof ContainerLock));
        SanityManager.ASSERT((boolean)(grantedQualifier instanceof ContainerLock));
        ContainerLock clRequested = (ContainerLock)requestedQualifier;
        ContainerLock clGranted = (ContainerLock)grantedQualifier;
        return clRequested.isCompatible(clGranted);
    }

    @Override
    public boolean lockerAlwaysCompatible() {
        return true;
    }

    @Override
    public void unlockEvent(Latch lockInfo) {
    }

    @Override
    public boolean lockAttributes(int flag, Hashtable attributes) {
        SanityManager.ASSERT((attributes != null ? 1 : 0) != 0, (String)"cannot call lockProperties with null attribute list");
        if ((flag & 2) == 0) {
            return false;
        }
        attributes.put("CONTAINERID", this.getContainerId());
        attributes.put("LOCKNAME", "Tablelock");
        attributes.put("TYPE", "TABLE");
        return true;
    }

    public static ContainerKey valueOf(long segmentId, long containerId) {
        if (segmentId == 0L && containerId >= 0L && containerId < 300L) {
            return zeroSegmentCache[(int)containerId];
        }
        return new ContainerKey(segmentId, containerId);
    }

    static {
        for (int index = 0; index < 300; ++index) {
            ContainerKey.zeroSegmentCache[index] = new ContainerKey(0L, index);
        }
    }
}

