/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.ResultWasNull;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TreeSet;

public final class OffHeapCompactExecRowWithLobs
extends AbstractCompactExecRow {
    private static final long serialVersionUID = 2591346199546303027L;
    private Object source;

    public OffHeapCompactExecRowWithLobs() {
    }

    OffHeapCompactExecRowWithLobs(RowFormatter rf) {
        super(rf);
        this.source = null;
    }

    OffHeapCompactExecRowWithLobs(DataValueDescriptor[] dvds, RowFormatter rf) throws StandardException {
        super(rf);
        this.source = dvds != null ? (Object)rf.generateByteArrays(dvds) : null;
    }

    OffHeapCompactExecRowWithLobs(Object bytes, RowFormatter rf) {
        super(rf);
        this.source = bytes;
        assert (rf.isTableFormatter() || rf.hasLobs()) : "use a OffHeapCompactExecRow instead";
    }

    OffHeapCompactExecRowWithLobs(byte[][] bytes, RowFormatter rf) {
        super(rf);
        this.source = bytes;
        assert (rf.isTableFormatter() || rf.hasLobs()) : "use a OffHeapCompactExecRow instead";
    }

    OffHeapCompactExecRowWithLobs(OffHeapByteSource bytes, RowFormatter rf) {
        super(rf);
        this.source = bytes;
        assert (rf.isTableFormatter() || rf.hasLobs()) : "use a OffHeapCompactExecRow instead";
    }

    OffHeapCompactExecRowWithLobs(byte[][] source, RowFormatter rf, DataValueDescriptor[] row, int rowLen, boolean doClone) {
        super(rf, row, rowLen, doClone);
        this.source = source;
        assert (rf.isTableFormatter() || rf.hasLobs()) : "use a OffHeapCompactExecRow instead";
    }

    OffHeapCompactExecRowWithLobs(OffHeapByteSource bytes, RowFormatter rf, DataValueDescriptor[] row, int rowLen, boolean doClone) {
        super(rf, row, rowLen, doClone);
        this.source = bytes;
        assert (rf.isTableFormatter() || rf.hasLobs()) : "use a OffHeapCompactExecRow instead";
    }

    @Override
    public final byte[][] getRowByteArrays() {
        return this.getRowByteArraysIfPresent();
    }

    @Override
    protected final byte[][] getRowByteArraysIfPresent() {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return ((OffHeapRowWithLobs)((Object)source)).getRowByteArrays();
            }
            if (cls == byte[][].class) {
                return (byte[][])source;
            }
            return this.formatter.createByteArraysWithDefaultLobs(((OffHeapRow)((Object)source)).getRowBytes());
        }
        return null;
    }

    @Override
    public final byte[] getRowBytes(int logicalPosition) {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.getRowBytes(logicalPosition, (OffHeapRowWithLobs)((Object)source));
            }
            if (cls == byte[][].class) {
                return this.getRowBytes(logicalPosition, (byte[][])source);
            }
            return this.getRowBytes(logicalPosition, (OffHeapRow)((Object)source));
        }
        return null;
    }

    @Override
    public final boolean hasByteArrays() {
        return true;
    }

    @Override
    public final Object getRawRowValue(boolean doClone) {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return ((OffHeapRowWithLobs)((Object)source)).getRowByteArrays();
            }
            if (cls == byte[][].class) {
                if (doClone) {
                    byte[][] sourceBytes = (byte[][])source;
                    byte[][] newBytes = new byte[sourceBytes.length][];
                    int i = 0;
                    for (byte[] row : sourceBytes) {
                        newBytes[i] = new byte[row.length];
                        System.arraycopy(row, 0, newBytes[i], 0, row.length);
                    }
                    return newBytes;
                }
                return source;
            }
            return this.formatter.createByteArraysWithDefaultLobs(((OffHeapRow)((Object)source)).getRowBytes());
        }
        return null;
    }

    @Override
    protected String getString(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsString(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsString(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsString(position, (OffHeapRow)((Object)source), wasNull);
        }
        return this.formatter.getAsString(position, (byte[])null, wasNull);
    }

    @Override
    protected Object getObject(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsObject(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsObject(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsObject(position, (OffHeapRow)((Object)source), wasNull);
        }
        return this.formatter.getAsObject(position, (byte[])null, wasNull);
    }

    @Override
    protected boolean getBoolean(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsBoolean(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsBoolean(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsBoolean(position, (OffHeapRow)((Object)source), wasNull);
        }
        return this.formatter.getAsBoolean(position, (byte[])null, wasNull);
    }

    @Override
    protected byte getByte(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsByte(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsByte(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsByte(position, (OffHeapRow)((Object)source), wasNull);
        }
        return this.formatter.getAsByte(position, (byte[])null, wasNull);
    }

    @Override
    protected short getShort(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsShort(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsShort(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsShort(position, (OffHeapRow)((Object)source), wasNull);
        }
        return this.formatter.getAsShort(position, (byte[])null, wasNull);
    }

    @Override
    protected int getInt(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsInt(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsInt(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsInt(position, (OffHeapRow)((Object)source), wasNull);
        }
        return this.formatter.getAsInt(position, (byte[])null, wasNull);
    }

    @Override
    protected long getLong(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsLong(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsLong(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsLong(position, (OffHeapRow)((Object)source), wasNull);
        }
        return this.formatter.getAsLong(position, (byte[])null, wasNull);
    }

    @Override
    protected float getFloat(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsFloat(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsFloat(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsFloat(position, (OffHeapRow)((Object)source), wasNull);
        }
        return this.formatter.getAsFloat(position, (byte[])null, wasNull);
    }

    @Override
    protected double getDouble(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsDouble(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsDouble(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsDouble(position, (OffHeapRow)((Object)source), wasNull);
        }
        return this.formatter.getAsDouble(position, (byte[])null, wasNull);
    }

    @Override
    protected byte[] getBytes(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsBytes(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsBytes(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsBytes(position, (OffHeapRow)((Object)source), wasNull);
        }
        return this.formatter.getAsBytes(position, (byte[])null, wasNull);
    }

    @Override
    protected BigDecimal getBigDecimal(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsBigDecimal(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsBigDecimal(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsBigDecimal(position, (OffHeapRow)((Object)source), wasNull);
        }
        return this.formatter.getAsBigDecimal(position, (byte[])null, wasNull);
    }

    @Override
    protected Date getDate(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsDate(position, (OffHeapRowWithLobs)((Object)source), cal, wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsDate(position, (byte[][])source, cal, wasNull);
            }
            return this.formatter.getAsDate(position, (OffHeapRow)((Object)source), cal, wasNull);
        }
        return this.formatter.getAsDate(position, (byte[])null, cal, wasNull);
    }

    @Override
    protected Time getTime(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsTime(position, (OffHeapRowWithLobs)((Object)source), cal, wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsTime(position, (byte[][])source, cal, wasNull);
            }
            return this.formatter.getAsTime(position, (OffHeapRow)((Object)source), cal, wasNull);
        }
        return this.formatter.getAsTime(position, (byte[])null, cal, wasNull);
    }

    @Override
    protected Timestamp getTimestamp(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsTimestamp(position, (OffHeapRowWithLobs)((Object)source), cal, wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsTimestamp(position, (byte[][])source, cal, wasNull);
            }
            return this.formatter.getAsTimestamp(position, (OffHeapRow)((Object)source), cal, wasNull);
        }
        return this.formatter.getAsTimestamp(position, (byte[])null, cal, wasNull);
    }

    @Override
    public final Blob getAsBlob(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsBlob(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsBlob(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsBlob(position, (OffHeapRow)((Object)source), wasNull);
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    @Override
    public final Clob getAsClob(int position, ResultWasNull wasNull) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getAsClob(position, (OffHeapRowWithLobs)((Object)source), wasNull);
            }
            if (cls == byte[][].class) {
                return this.formatter.getAsClob(position, (byte[][])source, wasNull);
            }
            return this.formatter.getAsClob(position, (OffHeapRow)((Object)source), wasNull);
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    @Override
    protected final DataValueDescriptor basicGetColumn(int position) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getColumn(position, (OffHeapRowWithLobs)((Object)source));
            }
            if (cls == byte[][].class) {
                return this.formatter.getColumn(position, (byte[][])source);
            }
            return this.formatter.getColumn(position, (OffHeapRow)((Object)source));
        }
        return this.formatter.getColumn(position, (byte[])null);
    }

    @Override
    protected final void basicSetColumns(FormatableBitSet columns, DataValueDescriptor[] values) throws StandardException {
        if (values.length > 0) {
            Class<?> cls;
            Object source = this.source;
            this.source = source != null ? ((cls = source.getClass()) == OffHeapRowWithLobs.class ? (Object)this.formatter.setColumns(columns, values, (OffHeapRowWithLobs)((Object)source), null, this.formatter, false) : (cls == byte[][].class ? (Object)this.formatter.setColumns(columns, values, (byte[][])source, null, this.formatter) : (Object)this.formatter.setColumns(columns, values, null, (OffHeapRow)((Object)source), this.formatter, false))) : (Object)this.formatter.setColumns(columns, values, (byte[][])null, null, this.formatter);
        } else assert (this.formatter.getNumColumns() == 0) : "if none of the values are set such a condition can happen when DTD is also nothing";
    }

    @Override
    protected void basicSetColumn(int columnIndex, DataValueDescriptor value) throws StandardException {
        Class<?> cls;
        Object source = this.source;
        this.source = source != null ? ((cls = source.getClass()) == OffHeapRowWithLobs.class ? (Object)this.formatter.setColumn(columnIndex, value, (OffHeapRowWithLobs)((Object)source), null, this.formatter) : (cls == byte[][].class ? (Object)this.formatter.setColumn(columnIndex, value, (byte[][])source, this.formatter) : (Object)this.formatter.setColumn(columnIndex, value, null, (OffHeapRow)((Object)source), this.formatter))) : (Object)this.formatter.setColumn(columnIndex, value, (byte[][])null, this.formatter);
    }

    @Override
    protected final void basicSetCompactColumns(FormatableBitSet columns, DataValueDescriptor[] values) throws StandardException {
        this.source = this.formatter.setByteArrayCompactColumns(columns, values);
    }

    @Override
    protected final void basicSetColumns(int nCols, DataValueDescriptor[] values) throws StandardException {
        if (values.length > 0) {
            Class<?> cls;
            Object source = this.source;
            this.source = source != null ? ((cls = source.getClass()) == OffHeapRowWithLobs.class ? (Object)this.formatter.setColumns(nCols, values, (OffHeapRowWithLobs)((Object)source), null) : (cls == byte[][].class ? (Object)this.formatter.setColumns(nCols, values, (byte[][])source) : (Object)this.formatter.setColumns(nCols, values, null, (OffHeapRow)((Object)source)))) : (Object)this.formatter.setColumns(nCols, values, (byte[][])null);
        } else assert (this.formatter.getNumColumns() == 0) : "if none of the values are set such a condition can happen when DTD is also nothing";
    }

    @Override
    protected final void basicSetColumns(FormatableBitSet columns, AbstractCompactExecRow srcRow, int[] baseColumnMap) throws StandardException {
        Class<?> sclass;
        Object fromSource = srcRow.getBaseByteSource();
        this.source = fromSource != null ? ((sclass = fromSource.getClass()) == OffHeapRowWithLobs.class ? (Object)this.formatter.setColumns(columns, (OffHeapRowWithLobs)((Object)fromSource), null, srcRow.formatter, baseColumnMap) : (sclass == byte[][].class ? (Object)this.formatter.setColumns(columns, (byte[][])fromSource, null, srcRow.formatter, baseColumnMap) : (sclass == OffHeapRow.class ? (Object)this.formatter.setColumns(columns, null, (OffHeapRow)((Object)fromSource), srcRow.formatter, baseColumnMap) : (Object)this.formatter.setColumns(columns, srcRow.getRowByteArraysIfPresent(), srcRow.getRowBytes(), srcRow.formatter, baseColumnMap)))) : (Object)this.formatter.setColumns(columns, (byte[][])null, null, srcRow.formatter, baseColumnMap);
    }

    @Override
    protected final void basicSetColumns(int[] columns, boolean zeroBased, AbstractCompactExecRow srcRow) throws StandardException {
        Class<?> sclass;
        Object fromSource = srcRow.getBaseByteSource();
        this.source = fromSource != null ? ((sclass = fromSource.getClass()) == OffHeapRowWithLobs.class ? (Object)this.formatter.setColumns(columns, zeroBased, (OffHeapRowWithLobs)((Object)fromSource), null, srcRow.formatter) : (sclass == byte[][].class ? (Object)this.formatter.setColumns(columns, zeroBased, (byte[][])fromSource, null, srcRow.formatter) : (sclass == OffHeapRow.class ? (Object)this.formatter.setColumns(columns, zeroBased, null, (OffHeapRow)((Object)fromSource), srcRow.formatter) : (Object)this.formatter.setColumns(columns, zeroBased, srcRow.getRowByteArraysIfPresent(), srcRow.getRowBytes(), srcRow.formatter)))) : (Object)this.formatter.setColumns(columns, zeroBased, (byte[][])null, null, srcRow.formatter);
    }

    @Override
    protected final void basicSetColumns(int nCols, AbstractCompactExecRow srcRow) throws StandardException {
        Class<?> sclass;
        Object fromSource = srcRow.getBaseByteSource();
        this.source = fromSource != null ? ((sclass = fromSource.getClass()) == OffHeapRowWithLobs.class ? (Object)this.formatter.setColumns(nCols, (OffHeapRowWithLobs)((Object)fromSource), null, srcRow.formatter) : (sclass == byte[][].class ? (Object)this.formatter.setColumns(nCols, (byte[][])fromSource, null, srcRow.formatter) : (sclass == OffHeapRow.class ? (Object)this.formatter.setColumns(nCols, null, (OffHeapByteSource)((OffHeapRow)((Object)fromSource)), srcRow.formatter) : (Object)this.formatter.setColumns(nCols, srcRow.getRowByteArraysIfPresent(), srcRow.getRowBytes(), srcRow.formatter)))) : (Object)this.formatter.setColumns(nCols, (byte[][])null, null, srcRow.formatter);
    }

    @Override
    protected final void basicResetRowArray() {
        this.source = null;
    }

    @Override
    protected final DataValueDescriptor[] basicGetRowArray() {
        try {
            Object source = this.source;
            if (source != null) {
                Class<?> cls = source.getClass();
                if (cls == OffHeapRowWithLobs.class) {
                    return this.formatter.getAllColumns((OffHeapRowWithLobs)((Object)source));
                }
                if (cls == byte[][].class) {
                    return this.formatter.getAllColumns((byte[][])source);
                }
                return this.formatter.getAllColumns((OffHeapRow)((Object)source));
            }
            return this.formatter.getAllColumns((byte[][])null);
        }
        catch (StandardException e) {
            throw GemFireXDRuntimeException.newRuntimeException("OffHeapCompactExecRowWithLobs#getRowArray: unexpected exception", e);
        }
    }

    @Override
    protected final void basicSetRowArray(ExecRow otherRow) {
        if (!(otherRow instanceof AbstractCompactExecRow)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.basicSetRowArray((AbstractCompactExecRow)otherRow);
    }

    @Override
    protected final void basicSetRowArray(AbstractCompactExecRow otherRow) {
        RowFormatter otherFormatter = otherRow.formatter;
        if (otherRow.hasByteArrays()) {
            this.source = otherRow.getBaseByteSource();
        } else if (this.formatter.container == otherFormatter.container) {
            Object fromSource = otherRow.getBaseByteSource();
            this.source = fromSource instanceof byte[] ? (Object)otherFormatter.createByteArraysWithDefaultLobs((byte[])fromSource) : fromSource;
        } else {
            throw new UnsupportedOperationException("OffHeapCompactExecRowWithLobs does not support byte[]");
        }
        if (this.formatter != otherFormatter) {
            this.formatter = otherFormatter;
        }
    }

    @Override
    protected void basicSetRowArray(byte[] rowArray, RowFormatter formatter) {
        if (this.formatter.container != formatter.container) {
            throw new UnsupportedOperationException("OffHeapCompactExecRowWithLobs does not support byte[]");
        }
        this.basicSetRowArray(formatter.createByteArraysWithDefaultLobs(rowArray), formatter);
    }

    @Override
    protected final void basicSetRowArray(byte[][] rowArray, RowFormatter formatter) {
        this.source = rowArray;
        if (this.formatter != formatter) {
            this.formatter = formatter;
        }
    }

    @Override
    protected void basicSetDVDValues(DataValueDescriptor[] dvds, int[] srcColumns, boolean zeroBased) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                OffHeapRowWithLobs ohLobRow = (OffHeapRowWithLobs)((Object)source);
                int bytesLen = ohLobRow.getLength();
                long memAddr = ohLobRow.getUnsafeAddress(0, bytesLen);
                super.basicSetDVDValues(dvds, srcColumns, zeroBased, UnsafeMemoryChunk.getUnsafeWrapper(), memAddr, bytesLen, null, ohLobRow);
            } else if (cls == byte[][].class) {
                super.basicSetDVDValues(dvds, srcColumns, zeroBased, (byte[][])source);
            } else {
                OffHeapRow ohRow = (OffHeapRow)((Object)source);
                int bytesLen = ohRow.getLength();
                long memAddr = ohRow.getUnsafeAddress(0, bytesLen);
                super.basicSetDVDValues(dvds, srcColumns, zeroBased, UnsafeMemoryChunk.getUnsafeWrapper(), memAddr, bytesLen, ohRow, null);
            }
        } else {
            for (DataValueDescriptor dvd : dvds) {
                if (dvd == null) continue;
                dvd.restoreToNull();
            }
        }
    }

    @Override
    protected final byte[] getRowBytes() {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return ((OffHeapRowWithLobs)((Object)source)).getRowBytes();
            }
            if (cls == byte[][].class) {
                return ((byte[][])source)[0];
            }
            return ((OffHeapRow)((Object)source)).getRowBytes();
        }
        return null;
    }

    protected final int numLobsFromValue() {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return ((OffHeapRowWithLobs)((Object)source)).readNumLobsColumns(false);
            }
            if (cls == byte[][].class) {
                return ((byte[][])source).length - 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public final void setRowArrayClone(ExecRow otherRow, TreeSet<RegionAndKey> allKeys) {
        if (otherRow instanceof AbstractCompactExecRow) {
            AbstractCompactExecRow otherCRow = (AbstractCompactExecRow)otherRow;
            Object byteSource = otherCRow.getBaseByteSource();
            RowFormatter otherFormatter = otherCRow.formatter;
            if (byteSource != null) {
                Class<?> cls = byteSource.getClass();
                if (cls == OffHeapRowWithLobs.class) {
                    this.basicSetRowArray(((OffHeapRowWithLobs)((Object)byteSource)).getRowByteArrays(), otherFormatter);
                } else if (cls == byte[][].class) {
                    this.source = byteSource;
                    if (this.formatter != otherFormatter) {
                        this.formatter = otherFormatter;
                    }
                } else {
                    this.basicSetRowArray(otherFormatter.createByteArraysWithDefaultLobs(((OffHeapRow)((Object)byteSource)).getRowBytes()), otherFormatter);
                }
            }
        } else {
            this.setRowArray(otherRow.getRowArray());
        }
        this.setOfKeys = allKeys;
    }

    @Override
    public final OffHeapCompactExecRowWithLobs getClone() {
        OffHeapCompactExecRowWithLobs row = new OffHeapCompactExecRowWithLobs(this.source, this.formatter);
        row.setOfKeys = this.setOfKeys;
        return row;
    }

    @Override
    public final OffHeapCompactExecRowWithLobs getShallowClone() {
        return this.getClone();
    }

    @Override
    public final OffHeapCompactExecRowWithLobs getNewNullRow() {
        return new OffHeapCompactExecRowWithLobs(this.formatter);
    }

    @Override
    public final int compare(ExecRow row, int logicalPosition, long thisOffsetWidth, boolean nullsOrderedLow) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                Object v = this.formatter.getColumnAsByteSource((OffHeapRowWithLobs)((Object)source), logicalPosition);
                if (v == source) {
                    return this.compare(row, (OffHeapRowWithLobs)((Object)v), logicalPosition, thisOffsetWidth, nullsOrderedLow);
                }
                if (v instanceof OffHeapRow) {
                    return this.compare(row, (OffHeapRow)((Object)v), logicalPosition, thisOffsetWidth, nullsOrderedLow);
                }
                return this.compare(row, (byte[])v, logicalPosition, thisOffsetWidth, nullsOrderedLow);
            }
            if (cls == byte[][].class) {
                return this.compare(row, this.getRowBytes(logicalPosition, (byte[][])source), logicalPosition, thisOffsetWidth, nullsOrderedLow);
            }
            ColumnDescriptor cd = this.formatter.getColumnDescriptor(logicalPosition - 1);
            if (!cd.isLob) {
                return this.compare(row, (OffHeapRow)((Object)source), logicalPosition, thisOffsetWidth, nullsOrderedLow);
            }
            return this.compare(row, cd.columnDefaultBytes, logicalPosition, thisOffsetWidth, nullsOrderedLow);
        }
        return this.compare(row, (byte[])null, logicalPosition, thisOffsetWidth, nullsOrderedLow);
    }

    @Override
    public int compare(ExecRow row, int logicalPosition, boolean nullsOrderedLow) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                OffHeapRowWithLobs thisRow = (OffHeapRowWithLobs)((Object)source);
                Object v = this.formatter.getColumnAsByteSource(thisRow, logicalPosition);
                if (v == thisRow) {
                    return this.compare(row, thisRow, logicalPosition, this.formatter.getOffsetAndWidth(logicalPosition, thisRow), nullsOrderedLow);
                }
                if (v instanceof OffHeapRow) {
                    OffHeapRow bytes = (OffHeapRow)((Object)v);
                    return this.compare(row, bytes, logicalPosition, this.formatter.getOffsetAndWidth(logicalPosition, bytes), nullsOrderedLow);
                }
                byte[] bytes = (byte[])v;
                return this.compare(row, bytes, logicalPosition, this.formatter.getOffsetAndWidth(logicalPosition, bytes), nullsOrderedLow);
            }
            if (cls == byte[][].class) {
                byte[] bytes = this.getRowBytes(logicalPosition, (byte[][])source);
                return this.compare(row, bytes, logicalPosition, this.formatter.getOffsetAndWidth(logicalPosition, bytes), nullsOrderedLow);
            }
            ColumnDescriptor cd = this.formatter.getColumnDescriptor(logicalPosition - 1);
            if (!cd.isLob) {
                OffHeapRow bytes = (OffHeapRow)((Object)source);
                return this.compare(row, bytes, logicalPosition, this.formatter.getOffsetAndWidth(logicalPosition, bytes), nullsOrderedLow);
            }
            byte[] bytes = cd.columnDefaultBytes;
            return this.compare(row, bytes, logicalPosition, this.formatter.getOffsetAndWidth(logicalPosition, bytes), nullsOrderedLow);
        }
        return this.compare(row, (byte[])null, logicalPosition, -7L, nullsOrderedLow);
    }

    @Override
    public final int computeHashCode(int position, int hash) {
        Object source = this.source;
        RowFormatter rf = this.formatter;
        if (source != null) {
            OffHeapByteSource bs;
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                Object lob;
                OffHeapRowWithLobs byteArrays = (OffHeapRowWithLobs)((Object)source);
                int index = position - 1;
                ColumnDescriptor cd = rf.columns[index];
                if (!cd.isLob) {
                    int bytesLen = byteArrays.getLength();
                    long memAddr = byteArrays.getUnsafeAddress(0, bytesLen);
                    return rf.computeHashCode(position, UnsafeMemoryChunk.getUnsafeWrapper(), memAddr, bytesLen, hash);
                }
                int offsetFromMap = rf.positionMap[index];
                Object object = lob = offsetFromMap != 0 ? (Object)byteArrays.getGfxdByteSource(offsetFromMap) : cd.columnDefaultBytes;
                if (lob == null || lob instanceof byte[]) {
                    return rf.computeHashCode(position, (byte[])lob, hash);
                }
                bs = (OffHeapByteSource)((Object)lob);
            } else {
                if (cls == byte[][].class) {
                    byte[][] byteArrays = (byte[][])source;
                    int index = position - 1;
                    if (!rf.columns[index].isLob) {
                        return rf.computeHashCode(position, byteArrays[0], hash);
                    }
                    return rf.computeHashCode(position, rf.getLob(byteArrays, position), hash);
                }
                bs = (OffHeapByteSource)((Object)source);
            }
            int bytesLen = bs.getLength();
            long memAddr = bs.getUnsafeAddress(0, bytesLen);
            return rf.computeHashCode(position, UnsafeMemoryChunk.getUnsafeWrapper(), memAddr, bytesLen, hash);
        }
        return ResolverUtils.addByteToBucketHash((byte)0, (int)hash, (int)rf.getType(position).getTypeId().getTypeFormatId());
    }

    @Override
    public long isNull(int logicalPosition) throws StandardException {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            RowFormatter rf = this.formatter;
            ColumnDescriptor cd = rf.getColumnDescriptor(logicalPosition - 1);
            if (cls == OffHeapRowWithLobs.class) {
                if (!cd.isLob) {
                    return rf.getOffsetAndWidth(logicalPosition, (OffHeapRowWithLobs)((Object)source));
                }
                int offsetFromMap = rf.positionMap[logicalPosition - 1];
                if (offsetFromMap > 0) {
                    return ((OffHeapRowWithLobs)((Object)source)).getLobDataSizeLength(offsetFromMap);
                }
                return cd.columnDefaultBytes == null ? -7L : -6L;
            }
            if (cls == byte[][].class) {
                return rf.getOffsetAndWidth(logicalPosition, this.getRowBytes(logicalPosition, (byte[][])source));
            }
            if (!cd.isLob) {
                return rf.getOffsetAndWidth(logicalPosition, (OffHeapRow)((Object)source));
            }
            return cd.columnDefaultBytes == null ? -7L : -6L;
        }
        return -7L;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        Object source = this.source;
        if (this.formatter != null) {
            sb.append('(');
            int rowLen = this.formatter.getNumColumns();
            try {
                for (int position = 1; position <= rowLen; ++position) {
                    if (position != 1) {
                        sb.append(',');
                    }
                    ColumnDescriptor cd = this.formatter.getColumnDescriptor(position - 1);
                    if (cd.isLob) {
                        sb.append("columnType=").append(cd.getType()).append(';');
                        byte[] lob = null;
                        if (source != null) {
                            Class<?> cls = source.getClass();
                            if (cls == OffHeapRowWithLobs.class) {
                                lob = this.formatter.getLob((OffHeapRowWithLobs)((Object)source), position);
                            } else if (cls == byte[][].class) {
                                lob = this.formatter.getLob((byte[][])source, position);
                            }
                        }
                        OffHeapCompactExecRowWithLobs.lobToString(lob, sb);
                        continue;
                    }
                    sb.append(this.getColumn(position));
                }
            }
            catch (StandardException e) {
                throw GemFireXDRuntimeException.newRuntimeException("OffHeapCompactExecRowWithLobs#toString: unexpected exception", e);
            }
            sb.append(')');
        } else {
            sb.append("(NULL formatter) rawValue {");
            byte[] rowBytes = this.getRowBytes();
            ArrayUtils.objectStringNonRecursive((Object)rowBytes, (StringBuilder)sb);
            int len = this.numLobsFromValue();
            for (int index = 1; index <= len; ++index) {
                sb.append(',');
                byte[] lob = null;
                if (source != null) {
                    Class<?> cls = source.getClass();
                    if (cls == OffHeapRowWithLobs.class) {
                        lob = ((OffHeapRowWithLobs)((Object)source)).getGfxdBytes(index);
                    } else if (cls == byte[][].class) {
                        lob = ((byte[][])source)[index];
                    }
                }
                OffHeapCompactExecRowWithLobs.lobToString(lob, sb);
            }
            sb.append('}');
        }
        return sb.toString();
    }

    private static void lobToString(byte[] column, StringBuilder sb) {
        if (column != null) {
            sb.append("length=").append(column.length);
            sb.append(";hash=").append(ResolverUtils.addBytesToHash((byte[])column, (int)0));
        } else {
            sb.append("(NULL)");
        }
    }

    @Override
    public byte getGfxdID() {
        throw new UnsupportedOperationException("OffHeapCompactExecRowWithLobs does not support getGfxdID()");
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("OffHeapCompactExecRowWithLobs does not support toData");
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.source = DataSerializer.readArrayOfByteArrays((DataInput)in);
    }

    @Override
    public Object getByteSource() {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return source;
            }
            if (cls == byte[][].class) {
                return ((byte[][])source)[0];
            }
            return source;
        }
        return null;
    }

    @Override
    public Object getByteSource(int logicalPosition) {
        Object source = this.source;
        if (source != null) {
            Class<?> cls = source.getClass();
            if (cls == OffHeapRowWithLobs.class) {
                return this.formatter.getColumnAsByteSource((OffHeapRowWithLobs)((Object)source), logicalPosition);
            }
            if (cls == byte[][].class) {
                return this.formatter.getColumnAsByteSource((byte[][])source, logicalPosition);
            }
            return source;
        }
        return null;
    }

    @Override
    void basicSetByteSource(Object source) {
        this.source = source;
    }

    @Override
    public void releaseByteSource() {
        if (OffHeapHelper.release((Object)this.source)) {
            this.source = null;
        }
    }

    @Override
    public Object getBaseByteSource() {
        return this.source;
    }
}

