/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.NoMemberFoundException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.NoDataStoreAvailableException;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.DistributedRegionFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.InternalExecution;
import com.gemstone.gemfire.internal.cache.execute.MemberFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.MemberMappedArgument;
import com.gemstone.gemfire.internal.cache.execute.MultiRegionFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.PartitionedRegionFunctionExecutor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public final class FunctionUtils {
    private FunctionUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResultCollector<?, ?> executeFunction(GfxdExecution exec, Object args, String functionId, ResultCollector<?, ?> rc, boolean enableStreaming, boolean isPossibleDuplicate) {
        assert (!enableStreaming || rc != null);
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.beforeQueryDistribution(null, enableStreaming);
        }
        boolean execSuccess = false;
        try {
            exec.setWaitOnExceptionFlag(true);
            if (isPossibleDuplicate) {
                exec.setIsReExecute();
            }
            rc = exec.execute(functionId);
            execSuccess = true;
        }
        finally {
            if (!execSuccess) {
                rc.clearResults();
            }
            if (observer != null) {
                observer.afterQueryDistribution(null, enableStreaming);
            }
        }
        return rc;
    }

    public static GfxdExecution onRegion(Region<?, ?> region) {
        if (region == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString(new Object[]{"Region instance "}));
        }
        if (PartitionRegionHelper.isPartitionedRegion(region)) {
            return new GfxdPRFunctionExecutor(region);
        }
        return new GfxdDRFunctionExecutor(region);
    }

    public static GfxdExecution onRegions(Set<Region> regions) {
        if (regions == null) {
            throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"regions set"}));
        }
        if (regions.contains(null)) {
            throw new FunctionException(LocalizedStrings.OnRegionsFunctions_THE_REGION_SET_FOR_ONREGIONS_HAS_NULL.toLocalizedString());
        }
        if (regions.isEmpty()) {
            throw new FunctionException(LocalizedStrings.OnRegionsFunctions_THE_REGION_SET_IS_EMPTY_FOR_ONREGIONS.toLocalizedString());
        }
        return new GfxdMultiRegionFunctionExecutor(regions);
    }

    public static GfxdExecution onMembers(DistributedSystem dsys, GetFunctionMembers fMembers, boolean flushTXPendingOps) {
        if (dsys == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString(new Object[]{"DistributedSystem instance "}));
        }
        return new GetMembersFunctionExecutor(dsys, fMembers, flushTXPendingOps, false);
    }

    public static Object executeFunction(GfxdExecution exec, Object args, String functionId, String logFunction, int retryCnt, ResultCollector<?, ?> collector, boolean enableStreaming, boolean isPossibleDuplicate, boolean isHA, MemberMappedArgument mma, Set<Object> routingObjects, boolean requireRC, AbstractGemFireResultSet rs) throws StandardException {
        if (collector != null) {
            exec.withCollector(collector);
        }
        if (mma != null) {
            exec.withMemberMappedArgument(mma);
        } else if (args != null) {
            exec.withArgs(args);
        }
        if (routingObjects != null) {
            exec.withRoutingObjects(routingObjects);
        }
        try {
            ResultCollector<?, ?> rc = FunctionUtils.executeFunction(exec, args, functionId, collector, enableStreaming, isPossibleDuplicate);
            if (GemFireXDUtils.TraceProcedureExecution) {
                FunctionUtils.logRoutingObjectsAndMembers(routingObjects, exec.getExecutionNodes(), functionId, logFunction);
            }
            if (!enableStreaming) {
                Object rcRes = rc.getResult();
                if (rs != null) {
                    Collection<InternalDistributedMember> recipients = exec.getExecutionNodes();
                    rs.setup(rcRes, recipients != null ? recipients.size() : 0);
                }
                return requireRC ? rc : rcRes;
            }
            return rc;
        }
        catch (RuntimeException e) {
            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)e);
            if (rs != null) {
                rs.checkCancellationFlag();
            }
            int cnt = 0;
            RuntimeException retryEx = e;
            if (isHA && retryCnt > 0 && GemFireXDUtils.retryToBeDone(e, cnt)) {
                while (cnt++ < retryCnt) {
                    GemFireXDUtils.sleepForRetry(cnt);
                    if (GemFireXDUtils.TraceFunctionException) {
                        SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)("executeFunction: retry cnt: " + retryCnt + " retry is true"), (Throwable)retryEx);
                    }
                    if (collector != null) {
                        collector.clearResults();
                    }
                    try {
                        ResultCollector<?, ?> rc = FunctionUtils.executeFunction(exec, args, functionId, collector, enableStreaming, true);
                        if (GemFireXDUtils.TraceProcedureExecution) {
                            FunctionUtils.logRoutingObjectsAndMembers(routingObjects, exec.getExecutionNodes(), functionId, logFunction);
                        }
                        if (!enableStreaming) {
                            Object rcRes = rc.getResult();
                            if (rs != null) {
                                Collection<InternalDistributedMember> recipients = exec.getExecutionNodes();
                                rs.setup(rcRes, recipients != null ? recipients.size() : 0);
                            }
                            return requireRC ? rc : rcRes;
                        }
                        return rc;
                    }
                    catch (RuntimeException ex) {
                        Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)ex);
                        if (rs != null) {
                            rs.checkCancellationFlag();
                        }
                        if (!GemFireXDUtils.retryToBeDone(ex, cnt) || cnt >= retryCnt) {
                            if (GemFireXDUtils.TraceFunctionException) {
                                SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)("executeFunction: retry cnt: " + retryCnt + " retry is false"), (Throwable)ex);
                            }
                            throw ex;
                        }
                        retryEx = ex;
                    }
                }
                SanityManager.DEBUG_PRINT((String)"info:TraceFunctionException", (String)("executeFunction: retry cnt: " + retryCnt + " exhausted and throwing exception"), (Throwable)e);
            }
            throw e;
        }
    }

    private static void logRoutingObjectsAndMembers(Set<Object> routingObjects, Collection<InternalDistributedMember> members, String functionId, String logFunction) {
        StringBuilder sb = new StringBuilder();
        if (routingObjects != null) {
            sb.append("The routing objects are: ");
            for (Object routingObject : routingObjects) {
                sb.append(" ");
                sb.append(routingObject.toString());
            }
        }
        if (members == null) {
            sb.append(" No member is selected to execute the function ").append(functionId);
            if (logFunction != null && !logFunction.equals(functionId)) {
                sb.append('[').append(logFunction).append(']');
            }
        } else {
            sb.append("The members that executed function ").append(functionId);
            if (logFunction != null && !logFunction.equals(functionId)) {
                sb.append('[').append(logFunction).append(']');
            }
            sb.append(" are: ");
            for (InternalDistributedMember member : members) {
                sb.append(' ').append(member.getId());
            }
        }
        SanityManager.DEBUG_PRINT((String)"TraceProcedureExecution", (String)sb.toString());
    }

    public static ResultCollector<?, ?> executeFunction(GfxdExecution exec, Object args, String functionId, String logFunction, ResultCollector<?, ?> rc, boolean enableStreaming, boolean isPossibleDuplicate, boolean isHA, MemberMappedArgument mma, Set<Object> routingObjects) throws StandardException {
        return (ResultCollector)FunctionUtils.executeFunction(exec, args, functionId, logFunction, 10000, rc, enableStreaming, isPossibleDuplicate, isHA, mma, routingObjects, true, null);
    }

    public static Object executeFunctionOnRegionWithArgs(Region<?, ?> rgn, Object args, String functionId, ResultCollector<?, ?> rc, boolean enableStreaming, boolean isPossibleDuplicate, boolean isHA, MemberMappedArgument mma, Set<Object> routingObjects) throws StandardException {
        GfxdExecution exec = FunctionUtils.onRegion(rgn);
        return FunctionUtils.executeFunction(exec, args, functionId, functionId, 10000, rc, enableStreaming, isPossibleDuplicate, isHA, mma, routingObjects, false, null);
    }

    public static Collection<?> executeFunctionOnRegionWithArgs(Region<?, ?> rgn, Object args, String functionId, ResultCollector<?, ?> rc, boolean enableStreaming, boolean isPossibleDuplicate, boolean isHA, MemberMappedArgument mma, Set<Object> routingObjects, AbstractGemFireResultSet rs) throws StandardException {
        GfxdExecution exec = FunctionUtils.onRegion(rgn);
        return (Collection)FunctionUtils.executeFunction(exec, args, functionId, functionId, 10000, rc, enableStreaming, isPossibleDuplicate, isHA, mma, routingObjects, false, rs);
    }

    public static Object executeFunctionOnRegionsWithArgs(Set<Region> regions, Object args, String functionId, ResultCollector<?, ?> rc, boolean enableStreaming, boolean isHA, MemberMappedArgument mma, Set<Object> routingObjects, boolean isPossibleDuplicate) throws StandardException {
        GfxdExecution exec = FunctionUtils.onRegions(regions);
        return FunctionUtils.executeFunction(exec, args, functionId, functionId, 10000, rc, enableStreaming, isPossibleDuplicate, isHA, mma, routingObjects, false, null);
    }

    public static Object executeFunctionOnMembers(DistributedSystem dsys, GetFunctionMembers fMembers, Object args, String functionId, ResultCollector<?, ?> collector, boolean enableStreaming, boolean isPossibleDuplicate, boolean isHA, boolean flushTXPendingOps) throws StandardException {
        GfxdExecution exec = FunctionUtils.onMembers(dsys, fMembers, flushTXPendingOps);
        try {
            return FunctionUtils.executeFunction(exec, args, functionId, functionId, 10000, collector, enableStreaming, isPossibleDuplicate, isHA, null, null, false, null);
        }
        catch (NoMemberFoundException ex) {
            Set<String> serverGroups = fMembers.getServerGroups();
            throw StandardException.newException("X0Z04.S", ex, (Object)(serverGroups == null || serverGroups.size() == 0 ? "the distributed system" : "server groups '" + serverGroups + "'"), (Object)("internal function '" + functionId + "'"));
        }
        catch (NoDataStoreAvailableException ex) {
            Set<String> serverGroups = fMembers.getServerGroups();
            throw StandardException.newException("X0Z08.S", (Throwable)ex, (Object)(" executing function " + functionId + " with args: " + args + " on server groups " + serverGroups));
        }
    }

    public static class GfxdMultiRegionFunctionExecutor
    extends MultiRegionFunctionExecutor
    implements GfxdExecution {
        public GfxdMultiRegionFunctionExecutor(Set<Region> regions) {
            super(regions);
            this.setWaitOnExceptionFlag(true);
        }

        @Override
        public final GfxdMultiRegionFunctionExecutor withArgs(Object arguments) {
            if (arguments == null) {
                throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"args"}));
            }
            this.args = arguments;
            return this;
        }

        public final GfxdMultiRegionFunctionExecutor withCollector(ResultCollector collector) {
            if (collector == null) {
                throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"Result Collector"}));
            }
            this.rc = collector;
            return this;
        }

        @Override
        public GfxdMultiRegionFunctionExecutor withFilter(Set<?> filter) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_CANNOT_SPECIFY_0_FOR_ONREGIONS_FUNCTION.toLocalizedString(new Object[]{"filter"}));
        }

        @Override
        public GfxdMultiRegionFunctionExecutor withRoutingObjects(Set<Object> routingObjects) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_CANNOT_SPECIFY_0_FOR_ONREGIONS_FUNCTION.toLocalizedString(new Object[]{"routing objects"}));
        }

        @Override
        public final GfxdMultiRegionFunctionExecutor withMemberMappedArgument(MemberMappedArgument argument) {
            if (argument == null) {
                throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"MemberMappedArgs"}));
            }
            this.memberMappedArg = argument;
            this.isMemberMappedArgument = true;
            return this;
        }

        @Override
        public final GfxdMultiRegionFunctionExecutor setIsReExecute() {
            this.isReExecute = true;
            return this;
        }
    }

    public static class GetMembersFunctionExecutor
    extends MemberFunctionExecutor
    implements GfxdExecution {
        protected final GetFunctionMembers getMembers;
        protected final boolean flushTXPendingOps;
        protected final boolean onlyLocal;

        public GetMembersFunctionExecutor(DistributedSystem dsys, GetFunctionMembers fMembers, boolean flushTXPendingOps, boolean onlyLocal) {
            super(dsys, (Set)null);
            this.getMembers = fMembers;
            this.flushTXPendingOps = flushTXPendingOps;
            this.setWaitOnExceptionFlag(true);
            this.onlyLocal = onlyLocal;
        }

        protected ResultCollector<?, ?> executeFunction(Function function) {
            Set<Object> members = this.getMembers != null ? this.getMembers.getMembers() : (!this.onlyLocal ? GemFireXDUtils.getGfxdAdvisor().adviseOperationNodes(null) : Collections.singleton(this.ds.getDistributedMember()));
            this.checkMembers(members, function);
            this.members = members;
            ResultCollector resultsCollector = super.executeFunction(function);
            if (this.getMembers != null) {
                this.getMembers.postExecutionCallback();
            }
            return resultsCollector;
        }

        protected void checkMembers(Set<DistributedMember> members, Function function) {
            if (members == null || members.isEmpty()) {
                throw new NoMemberFoundException(LocalizedStrings.MemberFunctionExecutor_NO_MEMBER_FOUND_FOR_EXECUTING_FUNCTION_0.toLocalizedString(new Object[]{function.getId() + " in server groups [" + (this.getMembers != null ? this.getMembers.getServerGroups() : "") + ']'}));
            }
        }

        protected final TXStateInterface flushTXPendingOps(DM dm) {
            TXStateInterface tx = TXManagerImpl.getCurrentTXState();
            if (tx != null && this.flushTXPendingOps) {
                tx.flushPendingOps(dm);
            }
            return tx;
        }

        @Override
        public final GetMembersFunctionExecutor withArgs(Object arguments) {
            if (arguments == null) {
                throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"args"}));
            }
            this.args = arguments;
            return this;
        }

        public final GetMembersFunctionExecutor withCollector(ResultCollector collector) {
            if (collector == null) {
                throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"Result Collector"}));
            }
            this.rc = collector;
            return this;
        }

        public final GetMembersFunctionExecutor withFilter(Set filter) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_CANNOT_SPECIFY_0_FOR_DATA_INDEPENDENT_FUNCTIONS.toLocalizedString(new Object[]{"filter"}));
        }

        @Override
        public final GetMembersFunctionExecutor withRoutingObjects(Set<Object> routingObjects) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_CANNOT_SPECIFY_0_FOR_DATA_INDEPENDENT_FUNCTIONS.toLocalizedString(new Object[]{"routing objects"}));
        }

        @Override
        public final GetMembersFunctionExecutor withMemberMappedArgument(MemberMappedArgument argument) {
            if (argument == null) {
                throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"MemberMappedArgs"}));
            }
            this.memberMappedArg = argument;
            this.isMemberMappedArgument = true;
            return this;
        }

        @Override
        public final GetMembersFunctionExecutor setIsReExecute() {
            this.isReExecute = true;
            return this;
        }
    }

    public static class GfxdDRFunctionExecutor
    extends DistributedRegionFunctionExecutor
    implements GfxdExecution {
        public GfxdDRFunctionExecutor(Region<?, ?> region) {
            super(region);
            this.setWaitOnExceptionFlag(true);
        }

        @Override
        public final GfxdDRFunctionExecutor withArgs(Object arguments) {
            if (arguments == null) {
                throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"args"}));
            }
            this.args = arguments;
            return this;
        }

        public final GfxdDRFunctionExecutor withCollector(ResultCollector collector) {
            if (collector == null) {
                throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"Result Collector"}));
            }
            this.rc = collector;
            return this;
        }

        public final GfxdDRFunctionExecutor withFilter(Set filter) {
            if (filter == null) {
                throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"filter"}));
            }
            this.filter.clear();
            this.filter.addAll(filter);
            return this;
        }

        @Override
        public final GfxdDRFunctionExecutor withRoutingObjects(Set<Object> routingObjects) {
            super.withRoutingObjects(routingObjects);
            return this;
        }

        @Override
        public final GfxdDRFunctionExecutor withMemberMappedArgument(MemberMappedArgument argument) {
            if (argument == null) {
                throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"MemberMappedArgs"}));
            }
            this.memberMappedArg = argument;
            this.isMemberMappedArgument = true;
            return this;
        }

        @Override
        public final GfxdDRFunctionExecutor setIsReExecute() {
            this.isReExecute = true;
            return this;
        }
    }

    public static class GfxdPRFunctionExecutor
    extends PartitionedRegionFunctionExecutor
    implements GfxdExecution {
        public GfxdPRFunctionExecutor(Region<?, ?> region) {
            super(region);
            this.setWaitOnExceptionFlag(true);
        }

        @Override
        public final GfxdPRFunctionExecutor withArgs(Object arguments) {
            if (arguments == null) {
                throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"args"}));
            }
            this.args = arguments;
            return this;
        }

        public final GfxdPRFunctionExecutor withCollector(ResultCollector collector) {
            if (collector == null) {
                throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"Result Collector"}));
            }
            this.rc = collector;
            return this;
        }

        public final GfxdPRFunctionExecutor withFilter(Set filter) {
            if (filter == null) {
                throw new FunctionException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"filter"}));
            }
            this.filter.clear();
            this.filter.addAll(filter);
            return this;
        }

        @Override
        public final GfxdPRFunctionExecutor withRoutingObjects(Set<Object> routingObjects) {
            super.withRoutingObjects(routingObjects);
            return this;
        }

        @Override
        public final GfxdPRFunctionExecutor withMemberMappedArgument(MemberMappedArgument argument) {
            if (argument == null) {
                throw new IllegalArgumentException(LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString(new Object[]{"MemberMappedArgs"}));
            }
            this.memberMappedArg = argument;
            this.isMemberMappedArgument = true;
            return this;
        }

        @Override
        public final GfxdPRFunctionExecutor setIsReExecute() {
            this.isReExecute = true;
            return this;
        }
    }

    public static interface GfxdExecution
    extends InternalExecution {
        public Collection<InternalDistributedMember> getExecutionNodes();

        public void setRequireExecutionNodes(AbstractExecution.ExecutionNodesListener var1);

        public GfxdExecution withMemberMappedArgument(MemberMappedArgument var1);

        public GfxdExecution withRoutingObjects(Set<Object> var1);

        public GfxdExecution setIsReExecute();

        public GfxdExecution withArgs(Object var1);

        public GfxdExecution withCollector(ResultCollector<?, ?> var1);

        public GfxdExecution withFilter(Set<?> var1);
    }

    public static interface GetFunctionMembers {
        public Set<DistributedMember> getMembers();

        public Set<String> getServerGroups();

        public void postExecutionCallback();
    }
}

