/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.conn;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.shared.FinalizeObject;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.conn.ConnectionState;
import com.pivotal.gemfirexd.internal.engine.sql.conn.ConnectionStateKey;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ConnectionSignaller
extends Thread {
    private static volatile ConnectionSignaller instance = new ConnectionSignaller();
    private static final Object instanceLock = new Object();
    private static final int MAX_JOIN_WAIT = 2000;
    private final SortedSet<ConnectionStateKey> connectionList = new TreeSet<ConnectionStateKey>();
    private volatile boolean shouldContinue = true;

    private ConnectionSignaller() {
        super((ThreadGroup)LogWriterImpl.createThreadGroup((String)LocalizedStrings.CONNECTION_DISTRIBUTOR_THREAD.toLocalizedString(), (LogWriterI18n)null), LocalizedStrings.CONNECTION_DISTRIBUTOR_THREAD.toLocalizedString());
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionSignaller getInstance() {
        ConnectionSignaller inst = instance;
        if (inst != null) {
            return inst;
        }
        Object object = instanceLock;
        synchronized (object) {
            if (instance == null) {
                instance = new ConnectionSignaller();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (GemFireXDUtils.TraceConnectionSignaller) {
            SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)"thread starting.");
        }
        ArrayList<ConnectionState> changeList = new ArrayList<ConnectionState>();
        int numProcessNows = 0;
        while (this.shouldContinue) {
            try {
                Object object = instanceLock;
                synchronized (object) {
                    if (this.shouldContinue) {
                        while (this.connectionList.isEmpty() && this.shouldContinue) {
                            if (GemFireXDUtils.TraceConnectionSignaller) {
                                SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)"waiting for a new item in the queue");
                            }
                            instanceLock.wait(2000L);
                        }
                        Iterator<ConnectionStateKey> iter = this.connectionList.iterator();
                        this.fillInConnectionsToProcess(iter, changeList);
                        if (changeList.size() == 0 || numProcessNows >= 2) {
                            iter = this.connectionList.iterator();
                            while (iter.hasNext()) {
                                boolean processNow;
                                ConnectionStateKey conn = iter.next();
                                long waitMillis = conn.endWaitTime() - System.currentTimeMillis();
                                if (waitMillis > 0L) {
                                    if (!this.shouldContinue) break;
                                    if (GemFireXDUtils.TraceConnectionSignaller) {
                                        SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)("waiting for a new item in the queue for " + waitMillis + "ms"));
                                    }
                                    instanceLock.wait(waitMillis);
                                    iter = this.connectionList.iterator();
                                    numProcessNows = 0;
                                    assert (iter.hasNext());
                                    conn = iter.next();
                                    processNow = conn.processNow();
                                } else {
                                    processNow = true;
                                }
                                if (!processNow) continue;
                                iter.remove();
                                changeList.add(conn.connectionState());
                                this.fillInConnectionsToProcess(iter, changeList);
                                if (numProcessNows >= 4) continue;
                                break;
                            }
                            if (numProcessNows > 0 && this.connectionList.size() == 0) {
                                numProcessNows = 0;
                            }
                        }
                    }
                }
                if (changeList.size() > 0) {
                    ++numProcessNows;
                    for (ConnectionState connState : changeList) {
                        if (!this.shouldContinue) break;
                        if (GemFireXDUtils.TraceConnectionSignaller) {
                            SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)("distributing changes for item: " + connState.toString()));
                        }
                        connState.distribute();
                    }
                    changeList.clear();
                }
                FinalizeObject.getServerHolder().invokePendingFinalizers();
            }
            catch (InterruptedException ie) {
                SystemFailure.checkFailure();
                this.shouldContinue = false;
                break;
            }
            catch (CancelException e) {
                this.shouldContinue = false;
                break;
            }
            catch (Throwable t) {
                Error err;
                if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                    SystemFailure.initiateFailure((Error)err);
                    throw err;
                }
                SystemFailure.checkFailure();
                try {
                    LogWriterI18n logger = Misc.getI18NLogWriter();
                    logger.warning(LocalizedStrings.CONNECTION_CHANGE_PROCESS_FAILED, t);
                }
                catch (CancelException ce) {
                    this.shouldContinue = false;
                    break;
                }
            }
        }
        if (GemFireXDUtils.TraceConnectionSignaller) {
            SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)"thread ending.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ConnectionState newState) {
        assert (newState != null);
        if (GemFireXDUtils.TraceConnectionSignaller) {
            SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)("adding new item to queue: " + newState));
        }
        ConnectionStateKey newConnState = null;
        Object object = instanceLock;
        synchronized (object) {
            Iterator iter = this.connectionList.iterator();
            while (iter.hasNext()) {
                ConnectionStateKey connState = (ConnectionStateKey)iter.next();
                if (GemFireXDUtils.TraceConnectionSignaller) {
                    SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)("trying to accumulate [" + newState.toString() + "] into: " + connState.toString()));
                }
                if (!connState.connectionState().accumulate(newState)) continue;
                if (GemFireXDUtils.TraceConnectionSignaller) {
                    SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)("accumulated [" + newState.toString() + "] to obtain: " + connState.toString()));
                }
                iter.remove();
                newConnState = connState;
                break;
            }
            if (newConnState == null) {
                newConnState = new ConnectionStateKey(newState);
            }
            if (GemFireXDUtils.TraceConnectionSignaller) {
                SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)("after accumulation adding new item to queue: " + newConnState.toString()));
            }
            this.connectionList.add(newConnState);
            instanceLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSynchronous(ConnectionState newState) {
        assert (newState != null);
        if (GemFireXDUtils.TraceConnectionSignaller) {
            SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)("[sync] adding new item to queue synchronously: " + newState));
        }
        Object object = instanceLock;
        synchronized (object) {
            Iterator iter = this.connectionList.iterator();
            while (iter.hasNext()) {
                ConnectionStateKey connState = (ConnectionStateKey)iter.next();
                if (GemFireXDUtils.TraceConnectionSignaller) {
                    SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)("[sync] trying to accumulate [" + newState.toString() + "] into: " + connState.toString()));
                }
                if (!connState.connectionState().accumulate(newState)) continue;
                if (GemFireXDUtils.TraceConnectionSignaller) {
                    SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)("[sync] accumulated [" + newState.toString() + "] to obtain: " + connState.toString()));
                }
                iter.remove();
                newState = connState.connectionState();
                break;
            }
        }
        if (GemFireXDUtils.TraceConnectionSignaller) {
            SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)("[sync] distributing changes for item: " + newState.toString()));
        }
        newState.distribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionSignaller signalStop() {
        ConnectionSignaller signaller;
        block12: {
            signaller = instance;
            if (signaller == null) {
                return null;
            }
            try {
                if (!signaller.isAlive()) break block12;
                Object object = instanceLock;
                synchronized (object) {
                    signaller.shouldContinue = false;
                    instanceLock.notify();
                }
                signaller.join(1000L);
                if (signaller.isAlive()) {
                    signaller.interrupt();
                    signaller.join(1000L);
                }
                if (GemFireXDUtils.TraceConnectionSignaller) {
                    SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)((signaller.isAlive() ? "giving up waiting to stop" : "successfully stopped") + " the periodic connection signaller thread"));
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (signaller.isAlive()) {
                    signaller.interrupt();
                }
                instance = null;
            }
        }
        return signaller;
    }

    private void fillInConnectionsToProcess(Iterator<ConnectionStateKey> iter, Collection<ConnectionState> changeList) {
        while (iter.hasNext()) {
            ConnectionStateKey conn = iter.next();
            if (GemFireXDUtils.TraceConnectionSignaller) {
                SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)("peeking new item: " + conn.toString()));
            }
            if (!conn.processNow()) continue;
            if (GemFireXDUtils.TraceConnectionSignaller) {
                SanityManager.DEBUG_PRINT((String)"TraceConnectionSignaller", (String)("adding new item for processing: " + conn.toString()));
            }
            changeList.add(conn.connectionState());
            iter.remove();
        }
    }
}

