/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalRowLocation;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractConditionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColocationCriteria;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ComparisonQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.CompositeDynamicKey;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DynamicKey;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.InQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.JunctionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.OrJunctionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueListQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.ColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.MultiColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class AndJunctionQueryInfo
extends JunctionQueryInfo {
    private final Map<String, AbstractConditionQueryInfo> colOperands = new HashMap<String, AbstractConditionQueryInfo>();
    private final Map<String, Map<String, ComparisonQueryInfo>> equalityConditions = new HashMap<String, Map<String, ComparisonQueryInfo>>(3);
    private QueryInfo runTimePruner = null;

    AndJunctionQueryInfo(AbstractConditionQueryInfo op1, AbstractConditionQueryInfo op2) throws StandardException {
        int pos1 = op1.getActualColumnPostionOfOperand();
        int pos2 = op2.getActualColumnPostionOfOperand();
        if (pos1 < pos2) {
            this.addNonJunctionOperandToTheStructuresInJunction(op1);
            this.addNonJunctionOperandToTheStructuresInJunction(op2);
        } else {
            this.addNonJunctionOperandToTheStructuresInJunction(op2);
            this.addNonJunctionOperandToTheStructuresInJunction(op1);
        }
    }

    AndJunctionQueryInfo(int junctionType, JunctionQueryInfo jqi, AbstractConditionQueryInfo op1) throws StandardException {
        super(jqi);
        if (op1 != null) {
            this.addNonJunctionOperandToTheStructuresInJunction(op1);
        }
    }

    AndJunctionQueryInfo(JunctionQueryInfo jqi1, JunctionQueryInfo jqi2) {
        super(jqi1, jqi2);
    }

    private void addNonJunctionOperandToTheStructuresInJunction(AbstractConditionQueryInfo operand) throws StandardException {
        if (!this.isWhereClauseDynamic()) {
            this.setIsDynamic(operand.isWhereClauseDynamic());
        }
        if (!this.isStaticallyNotGetConvertible()) {
            this.setIsStaticallyNotGetConvertible(operand.isStaticallyNotGetConvertible());
        }
        if (!this.hasINPredicate()) {
            this.setHasINPredicate(operand instanceof InQueryInfo);
        }
        if (operand.getActualColumnPostionOfOperand() != -1) {
            String uname = operand.getUniqueColumnName();
            assert (uname != null);
            boolean isProcessed = false;
            if (operand.getRelationalOperator() == 1 && !operand.isTableVTI()) {
                String regionName = ((ComparisonQueryInfo)operand).getRegionName();
                Map<String, ComparisonQueryInfo> unameToCondition = this.equalityConditions.get(regionName);
                if (unameToCondition == null) {
                    unameToCondition = new LinkedHashMap<String, ComparisonQueryInfo>();
                    unameToCondition.put(uname, (ComparisonQueryInfo)operand);
                    this.equalityConditions.put(regionName, unameToCondition);
                    isProcessed = true;
                    if (!this.isStaticallyNotGetConvertible()) {
                        this.setIsStaticallyNotGetConvertible(this.equalityConditions.size() > 1);
                    }
                } else if (!unameToCondition.containsKey(uname)) {
                    unameToCondition.put(uname, (ComparisonQueryInfo)operand);
                    isProcessed = true;
                }
            }
            if (!isProcessed) {
                this.setIsStaticallyNotGetConvertible(true);
                AbstractConditionQueryInfo oldCondition = this.colOperands.get(uname);
                if (oldCondition == null) {
                    this.colOperands.put(uname, operand);
                } else {
                    AbstractConditionQueryInfo newAcqi = oldCondition.createOrAddToGroup(operand, true, null, false);
                    assert (newAcqi != null);
                    if (newAcqi != oldCondition) {
                        this.colOperands.put(uname, newAcqi);
                    }
                    this.setIsStaticallyNotGetConvertible(true);
                }
            }
        }
        if (operand.isEquiJoinCondition()) {
            int rowCount;
            ComparisonQueryInfo cqi = (ComparisonQueryInfo)operand;
            if (this.colocationCriteria == null && (rowCount = cqi.getColocationMatrixRowCount()) > 0 && cqi.getColocationMatrixPRTableCount() > 1) {
                this.colocationCriteria = new ColocationCriteria(rowCount, cqi.getColocationMatrixTables());
            }
            if (this.colocationCriteria != null) {
                this.colocationCriteria.updateColocationCriteria(cqi);
            }
        }
    }

    @Override
    JunctionQueryInfo mergeNonJunctionOperand(AbstractConditionQueryInfo operand, int operandJunctionType) throws StandardException {
        if (this.getJunctionType() == operandJunctionType) {
            this.addNonJunctionOperandToTheStructuresInJunction(operand);
            return this;
        }
        return new OrJunctionQueryInfo(operandJunctionType, this, operand);
    }

    @Override
    Object isConvertibleToGetOnLocalIndex(int[][] ikColumns, TableQueryInfo tqi) throws StandardException {
        Object retType = null;
        Object[] iks = null;
        if (!this.isStaticallyNotGetConvertible()) {
            assert (this.equalityConditions.size() == 1);
            Map<String, ComparisonQueryInfo> unameToCondition = this.equalityConditions.values().iterator().next();
            int opsLen = unameToCondition.size();
            if (ikColumns.length == opsLen) {
                AbstractConditionQueryInfo[] conditions = new AbstractConditionQueryInfo[opsLen];
                unameToCondition.values().toArray(conditions);
                if (opsLen > 2) {
                    this.sortOperandInIncreasingColumnPosition(conditions);
                }
                iks = this.isWhereClauseDynamic() || this.hasINPredicate() ? new Object[opsLen] : new DataValueDescriptor[opsLen];
                for (int index = 0; index < opsLen; ++index) {
                    AbstractConditionQueryInfo aqi = conditions[index];
                    Object temp = aqi.isConvertibleToGetOnLocalIndex(ikColumns[index][0], tqi);
                    if (temp == null) {
                        iks = null;
                        break;
                    }
                    iks[ikColumns[index][1] - 1] = temp;
                }
            }
        }
        if (iks != null) {
            retType = this.hasINPredicate() ? this.generateCompositeKeysForBulkOp(iks, tqi) : (this.isWhereClauseDynamic() ? new CompositeDynamicKey(iks) : (DataValueDescriptor[])iks);
        }
        return retType;
    }

    @Override
    Object isConvertibleToGet(int[][] fkColumns, TableQueryInfo tqi) throws StandardException {
        Object retType = null;
        Object[] pks = null;
        if (!this.isStaticallyNotGetConvertible()) {
            assert (this.equalityConditions.size() == 1);
            Map<String, ComparisonQueryInfo> unameToCondition = this.equalityConditions.values().iterator().next();
            int opsLen = unameToCondition.size();
            if (fkColumns.length == opsLen) {
                AbstractConditionQueryInfo[] conditions = new AbstractConditionQueryInfo[opsLen];
                unameToCondition.values().toArray(conditions);
                if (opsLen > 2) {
                    this.sortOperandInIncreasingColumnPosition(conditions);
                }
                pks = this.isWhereClauseDynamic() || this.hasINPredicate() ? new Object[opsLen] : new DataValueDescriptor[opsLen];
                for (int index = 0; index < opsLen; ++index) {
                    AbstractConditionQueryInfo aqi = conditions[index];
                    Object temp = aqi.isConvertibleToGet(fkColumns[index][0], tqi);
                    if (temp == null) {
                        pks = null;
                        break;
                    }
                    pks[fkColumns[index][1] - 1] = temp;
                }
            }
        }
        if (pks != null) {
            if (this.hasINPredicate()) {
                retType = this.generateCompositeKeysForBulkOp(pks, tqi);
            } else if (this.isWhereClauseDynamic()) {
                retType = new CompositeDynamicKey(pks);
            } else {
                GemFireContainer container = (GemFireContainer)tqi.getRegion().getUserAttribute();
                if (container.isPrimaryKeyBased()) {
                    retType = GemFireXDUtils.convertIntoGemfireRegionKey((DataValueDescriptor[])pks, container, false);
                }
            }
        }
        return retType;
    }

    private Object[] generateCompositeKeysForBulkOp(Object[] baseKeys, TableQueryInfo tqi) throws StandardException {
        Object[] template = this.isWhereClauseDynamic() ? new Object[baseKeys.length] : new DataValueDescriptor[baseKeys.length];
        ArrayList primaryKeys = new ArrayList();
        this.recursiveGeneration(baseKeys, 0, template, primaryKeys, false, tqi);
        return primaryKeys.toArray();
    }

    private void recursiveGeneration(Object[] baseKeys, int indx, Object[] template, List keysHolder, boolean isTupleDynamic, TableQueryInfo tqi) throws StandardException {
        int baseKeysLen = baseKeys.length;
        if (indx == baseKeysLen) {
            Object[] pks = isTupleDynamic ? new Object[baseKeysLen] : new DataValueDescriptor[baseKeysLen];
            for (int i = 0; i < baseKeysLen; ++i) {
                pks[i] = template[i];
            }
            if (isTupleDynamic) {
                keysHolder.add(new CompositeDynamicKey(pks));
            } else {
                GemFireContainer container = (GemFireContainer)tqi.getRegion().getUserAttribute();
                keysHolder.add(GemFireXDUtils.convertIntoGemfireRegionKey((DataValueDescriptor[])pks, container, false));
            }
            return;
        }
        Object individualKey = baseKeys[indx];
        if (individualKey instanceof Object[]) {
            Object[] multipleValues = (Object[])individualKey;
            for (int j = 0; j < multipleValues.length; ++j) {
                template[indx] = multipleValues[j];
                this.recursiveGeneration(baseKeys, indx + 1, template, keysHolder, isTupleDynamic || multipleValues[j] instanceof DynamicKey, tqi);
            }
        } else {
            template[indx] = individualKey;
            this.recursiveGeneration(baseKeys, indx + 1, template, keysHolder, isTupleDynamic || individualKey instanceof DynamicKey, tqi);
        }
    }

    private void sortOperandInIncreasingColumnPosition(AbstractConditionQueryInfo[] conditions) {
        int len = conditions.length;
        block0: for (int j = 0; j < len; ++j) {
            AbstractConditionQueryInfo toSort = conditions[j];
            int posToSort = toSort.getActualColumnPostionOfOperand();
            for (int i = j - 1; i > -1; --i) {
                AbstractConditionQueryInfo currSorted = conditions[i];
                if (currSorted.getActualColumnPostionOfOperand() < posToSort) {
                    if (i + 1 == j) continue block0;
                    conditions[i + 1] = toSort;
                    continue block0;
                }
                conditions[i + 1] = currSorted;
                if (i != 0) continue;
                conditions[0] = toSort;
            }
        }
    }

    @Override
    List getOperands() {
        ArrayList<AbstractConditionQueryInfo> temp = new ArrayList<AbstractConditionQueryInfo>();
        Iterator<Map<String, ComparisonQueryInfo>> itr = this.equalityConditions.values().iterator();
        while (itr.hasNext()) {
            temp.addAll(itr.next().values());
        }
        temp.addAll(this.colOperands.values());
        return temp;
    }

    @Override
    int getJunctionType() {
        return 1;
    }

    private QueryInfo createRuntimeNodesPruner() {
        final LogWriter logger = Misc.getCacheLogWriter();
        final QueryInfo[] equalityCondnPruners = new QueryInfo[this.equalityConditions.size()];
        final QueryInfo[] nonEqualityCondnPruners = new QueryInfo[this.colOperands.size()];
        int i = 0;
        for (Map.Entry<String, Map<String, ComparisonQueryInfo>> entry : this.equalityConditions.entrySet()) {
            String regionName = entry.getKey();
            Map<String, ComparisonQueryInfo> condnMap = entry.getValue();
            if (condnMap.size() == 1) {
                equalityCondnPruners[i++] = condnMap.values().iterator().next();
                continue;
            }
            equalityCondnPruners[i++] = this.seggregateEqualityConditions(regionName, condnMap);
        }
        Iterator<Map.Entry<String, AbstractConditionQueryInfo>> itr = this.colOperands.entrySet().iterator();
        i = 0;
        while (itr.hasNext()) {
            nonEqualityCondnPruners[i++] = itr.next().getValue();
        }
        AbstractQueryInfo pruner = new AbstractQueryInfo(){

            @Override
            public void computeNodes(Set<Object> routingKeys, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
                if (forSingleHopPreparePhase && nonEqualityCondnPruners != null && nonEqualityCondnPruners.length != 0) {
                    routingKeys.clear();
                    routingKeys.add(ResolverUtils.TOK_ALL_NODES);
                    return;
                }
                HashSet<Object> nodesCollector = new HashSet<Object>();
                nodesCollector.add(ResolverUtils.TOK_ALL_NODES);
                if (logger.fineEnabled()) {
                    logger.fine("AndJunctionQueryInfo::computeNodes: Before prunning nodes are" + routingKeys);
                }
                for (QueryInfo qi : equalityCondnPruners) {
                    qi.computeNodes(nodesCollector, activation, forSingleHopPreparePhase);
                    if (nodesCollector.contains(ResolverUtils.TOK_ALL_NODES)) continue;
                    if (routingKeys.contains(ResolverUtils.TOK_ALL_NODES)) {
                        routingKeys.remove(ResolverUtils.TOK_ALL_NODES);
                        routingKeys.addAll(nodesCollector);
                    } else {
                        routingKeys.retainAll(nodesCollector);
                    }
                    nodesCollector.clear();
                    nodesCollector.add(ResolverUtils.TOK_ALL_NODES);
                }
                if (!forSingleHopPreparePhase) {
                    assert (nodesCollector.size() == 1);
                    assert (nodesCollector.contains(ResolverUtils.TOK_ALL_NODES));
                } else {
                    nodesCollector.clear();
                    nodesCollector.add(ResolverUtils.TOK_ALL_NODES);
                }
                for (QueryInfo qi : nonEqualityCondnPruners) {
                    qi.computeNodes(nodesCollector, activation, forSingleHopPreparePhase);
                    if (nodesCollector.contains(ResolverUtils.TOK_ALL_NODES)) continue;
                    if (routingKeys.contains(ResolverUtils.TOK_ALL_NODES)) {
                        routingKeys.remove(ResolverUtils.TOK_ALL_NODES);
                        routingKeys.addAll(nodesCollector);
                    } else {
                        routingKeys.retainAll(nodesCollector);
                    }
                    nodesCollector.clear();
                    nodesCollector.add(ResolverUtils.TOK_ALL_NODES);
                }
                if (!forSingleHopPreparePhase) {
                    assert (nodesCollector.size() == 1);
                    assert (nodesCollector.contains(ResolverUtils.TOK_ALL_NODES));
                } else {
                    nodesCollector.clear();
                    nodesCollector.add(ResolverUtils.TOK_ALL_NODES);
                }
                if (AndJunctionQueryInfo.this.children != null) {
                    for (int i = 0; i < AndJunctionQueryInfo.this.children.length; ++i) {
                        AndJunctionQueryInfo.this.children[i].computeNodes(nodesCollector, activation, forSingleHopPreparePhase);
                        if (nodesCollector.contains(ResolverUtils.TOK_ALL_NODES)) continue;
                        if (routingKeys.contains(ResolverUtils.TOK_ALL_NODES)) {
                            routingKeys.remove(ResolverUtils.TOK_ALL_NODES);
                            routingKeys.addAll(nodesCollector);
                        } else {
                            routingKeys.retainAll(nodesCollector);
                        }
                        nodesCollector.clear();
                        nodesCollector.add(ResolverUtils.TOK_ALL_NODES);
                    }
                }
                if (logger.fineEnabled()) {
                    logger.fine("AndJunctionQueryInfo::computeNodes: After prunning nodes are" + routingKeys);
                }
            }
        };
        return pruner;
    }

    private QueryInfo seggregateEqualityConditions(String regionName, Map<String, ComparisonQueryInfo> unameToCondnMap) {
        QueryInfo retVal = null;
        Region rgn = Misc.getRegionByPath(regionName, true);
        boolean noPruningPossible = true;
        if (rgn.getAttributes().getDataPolicy().withPartitioning()) {
            PartitionedRegion pr = (PartitionedRegion)rgn;
            GfxdPartitionResolver spr = (GfxdPartitionResolver)pr.getPartitionResolver();
            final LogWriter logger = Misc.getCacheLogWriter();
            if (spr != null) {
                String[] rslvrColNames = spr.getColumnNames();
                if (rslvrColNames.length == 1) {
                    String canonicaliedExpr;
                    String uname = AndJunctionQueryInfo.generateUniqueColumnName(spr.getSchemaName(), spr.getTableName(), spr.getColumnNames()[0]);
                    retVal = unameToCondnMap.get(uname);
                    if (retVal == null && (canonicaliedExpr = spr.getCanonicalizedExpression()) != null) {
                        uname = AndJunctionQueryInfo.generateUniqueColumnName(spr.getSchemaName(), spr.getTableName(), canonicaliedExpr);
                        retVal = unameToCondnMap.get(uname);
                    }
                    noPruningPossible = retVal == null;
                } else if (rslvrColNames.length > 1) {
                    ValueQueryInfo[] partitioningConstants = new ValueQueryInfo[rslvrColNames.length];
                    int i = 0;
                    noPruningPossible = false;
                    boolean foundInPredicate = false;
                    for (String uname : rslvrColNames) {
                        uname = AndJunctionQueryInfo.generateUniqueColumnName(spr.getSchemaName(), spr.getTableName(), uname);
                        AbstractConditionQueryInfo temp = unameToCondnMap.get(uname);
                        if (logger.fineEnabled()) {
                            logger.fine("AndJunctionQueryInfo::Segregartion:computeNodes: uname = " + uname + " Condition = " + temp);
                        }
                        if (temp == null) {
                            noPruningPossible = true;
                            break;
                        }
                        foundInPredicate = foundInPredicate || temp instanceof InQueryInfo;
                        partitioningConstants[i++] = (ValueQueryInfo)((ComparisonQueryInfo)temp).rightOperand;
                    }
                    if (!noPruningPossible) {
                        retVal = foundInPredicate ? this.createHelperForMultiColumnPartitioningWithInCondition(partitioningConstants, spr) : this.createHelperForMultiColumnPartitioningNoInCondition(partitioningConstants, spr);
                    } else {
                        String canonicaliedExpr = spr.getCanonicalizedExpression();
                        if (canonicaliedExpr != null) {
                            String uname = AndJunctionQueryInfo.generateUniqueColumnName(spr.getSchemaName(), spr.getTableName(), canonicaliedExpr);
                            retVal = unameToCondnMap.get(uname);
                        }
                        boolean bl = noPruningPossible = retVal == null;
                    }
                }
            }
            if (noPruningPossible) {
                ComparisonQueryInfo condn = unameToCondnMap.values().iterator().next();
                List<ConglomerateDescriptor> sortedGlobalIndexes = this.sortGlobalIndexesOnBaseColumns(condn.getTableDescriptor());
                long conglomID = -1L;
                ValueQueryInfo[] partitioningConstants = null;
                for (ConglomerateDescriptor cd : sortedGlobalIndexes) {
                    int[] baseColPos;
                    ComparisonQueryInfo[] condnsMatchingGlobalIndex = this.isGlobalIndexApplicable(cd, partitioningConstants = new ValueQueryInfo[(baseColPos = cd.getIndexDescriptor().baseColumnPositions()).length], unameToCondnMap.values().iterator(), baseColPos);
                    if (condnsMatchingGlobalIndex == null) continue;
                    if (condnsMatchingGlobalIndex.length == 1) {
                        retVal = condnsMatchingGlobalIndex[0];
                        noPruningPossible = false;
                        break;
                    }
                    conglomID = cd.getConglomerateNumber();
                    break;
                }
                if (conglomID != -1L) {
                    noPruningPossible = false;
                    final long indexConglomID = conglomID;
                    retVal = new ValueListQueryInfo(partitioningConstants, false){

                        @Override
                        public void computeNodes(Set<Object> routingKeys, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
                            if (forSingleHopPreparePhase) {
                                return;
                            }
                            assert (routingKeys.size() == 1);
                            assert (routingKeys.contains(ResolverUtils.TOK_ALL_NODES));
                            if (logger.fineEnabled()) {
                                logger.fine("AndJunctionQueryInfo::computeNodes: Before prunning nodes are" + routingKeys);
                            }
                            DataValueDescriptor[] indexKey = this.evaluateToGetDataValueDescriptorArray(activation);
                            TransactionController tc = activation.getTransactionController();
                            ScanController scan = tc.openScan(indexConglomID, false, 0, 7, 5, null, indexKey, 1, null, indexKey, 1, null);
                            if (scan.next()) {
                                routingKeys.clear();
                                DataValueDescriptor[] fetchKey = new DataValueDescriptor[indexKey.length + 1];
                                for (int i = 0; i < indexKey.length; ++i) {
                                    fetchKey[i] = indexKey[i];
                                }
                                while (scan.next()) {
                                    GlobalRowLocation grl = new GlobalRowLocation();
                                    fetchKey[indexKey.length] = grl;
                                    scan.fetch(fetchKey);
                                    Serializable routingObject = grl.getRoutingObject();
                                    if (logger.fineEnabled()) {
                                        logger.fine("AndJunctionQueryInfo::computeNodes:pruneUsingGlobalIndex: Scan of Global index found a row = " + grl);
                                        logger.fine("AndJunctionQueryInfo::computeNodes:pruneUsingGlobalIndex: Scan of Global index found routing object = " + routingObject);
                                    }
                                    assert (routingObject != null);
                                    routingKeys.add(routingObject);
                                }
                            } else {
                                if (logger.fineEnabled()) {
                                    logger.fine("AndJunctionQueryInfo::computeNodes:pruneUsingGlobalIndex: Scan of Global index found NO row");
                                }
                                routingKeys.clear();
                            }
                            scan.close();
                        }
                    };
                }
            }
        }
        if (noPruningPossible) {
            retVal = QueryInfoConstants.NON_PRUNABLE;
        }
        return retVal;
    }

    private QueryInfo createHelperForMultiColumnPartitioningWithInCondition(final ValueQueryInfo[] partitioningConstants, final GfxdPartitionResolver spr) {
        final LogWriter logger = Misc.getCacheLogWriter();
        AbstractQueryInfo retVal = new AbstractQueryInfo(){

            @Override
            public void computeNodes(Set<Object> routingKeys, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
                assert (routingKeys.size() == 1);
                assert (routingKeys.contains(ResolverUtils.TOK_ALL_NODES));
                if (logger.fineEnabled()) {
                    logger.fine("AndJunctionQueryInfo::computeNodes: Before prunning nodes are" + routingKeys);
                }
                if (!forSingleHopPreparePhase) {
                    ArrayList<DataValueDescriptor[]> collector = new ArrayList<DataValueDescriptor[]>(5);
                    DataValueDescriptor[] holder = new DataValueDescriptor[partitioningConstants.length];
                    this.expand(partitioningConstants, 0, collector, holder, activation);
                    Iterator partitionValsItr = collector.iterator();
                    while (partitionValsItr.hasNext()) {
                        Object routingObject = spr.getRoutingObjectsForPartitioningColumns((DataValueDescriptor[])partitionValsItr.next());
                        assert (routingObject != null);
                        if (routingKeys.contains(ResolverUtils.TOK_ALL_NODES)) {
                            routingKeys.clear();
                        }
                        routingKeys.add(routingObject);
                    }
                } else {
                    routingKeys.clear();
                    routingKeys.add(ResolverUtils.TOK_ALL_NODES);
                    return;
                }
            }

            private void expand(ValueQueryInfo[] partitionConstants, int col, List<DataValueDescriptor[]> collector, DataValueDescriptor[] holder, Activation activation) throws StandardException {
                ValueQueryInfo vqi = partitionConstants[col];
                if (vqi instanceof ValueListQueryInfo) {
                    ValueListQueryInfo vlqi = (ValueListQueryInfo)vqi;
                    ValueQueryInfo[] vqiArr = vlqi.getOperands();
                    for (int i = 0; i < vqiArr.length; ++i) {
                        holder[col] = vqiArr[i].evaluateToGetDataValueDescriptor(activation);
                        if (col + 1 == partitionConstants.length) {
                            DataValueDescriptor[] values = new DataValueDescriptor[col + 1];
                            int j = 0;
                            for (DataValueDescriptor obj : holder) {
                                values[j++] = obj;
                            }
                            collector.add(values);
                            continue;
                        }
                        this.expand(partitionConstants, col + 1, collector, holder, activation);
                    }
                } else {
                    holder[col] = vqi.evaluateToGetDataValueDescriptor(activation);
                    if (col + 1 == partitionConstants.length) {
                        DataValueDescriptor[] values = new DataValueDescriptor[col + 1];
                        int j = 0;
                        for (DataValueDescriptor obj : holder) {
                            values[j++] = obj;
                        }
                        collector.add(values);
                    } else {
                        this.expand(partitionConstants, col + 1, collector, holder, activation);
                    }
                }
            }
        };
        return retVal;
    }

    private QueryInfo createHelperForMultiColumnPartitioningNoInCondition(ValueQueryInfo[] partitioningConstants, final GfxdPartitionResolver spr) {
        final LogWriter logger = Misc.getCacheLogWriter();
        ValueListQueryInfo retVal = new ValueListQueryInfo(partitioningConstants, false){

            @Override
            public void computeNodes(Set<Object> routingKeys, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
                assert (routingKeys.size() == 1);
                assert (routingKeys.contains(ResolverUtils.TOK_ALL_NODES));
                if (logger.fineEnabled()) {
                    logger.fine("AndJunctionQueryInfo::computeNodes: Before prunning nodes are" + routingKeys);
                }
                if (!forSingleHopPreparePhase) {
                    Object routingObject = spr.getRoutingObjectsForPartitioningColumns(this.evaluateToGetDataValueDescriptorArray(activation));
                    assert (routingObject != null);
                    routingKeys.clear();
                    routingKeys.add(routingObject);
                } else {
                    ColumnRoutingObjectInfo[] crinfo = this.evaluateToGetColumnInfos(activation);
                    MultiColumnRoutingObjectInfo mcroinfo = new MultiColumnRoutingObjectInfo(crinfo);
                    routingKeys.clear();
                    routingKeys.add(mcroinfo);
                }
            }
        };
        return retVal;
    }

    private List<ConglomerateDescriptor> sortGlobalIndexesOnBaseColumns(TableDescriptor td) {
        ConglomerateDescriptorList cdl = td.getConglomerateDescriptorList();
        Iterator itr = cdl.iterator();
        LinkedList<ConglomerateDescriptor> sortedIndexes = new LinkedList<ConglomerateDescriptor>();
        while (itr.hasNext()) {
            ConglomerateDescriptor currSorted;
            IndexRowGenerator id;
            ConglomerateDescriptor cd = (ConglomerateDescriptor)itr.next();
            if (!cd.isIndex() && !cd.isConstraint() || !(id = cd.getIndexDescriptor()).indexType().equals("GLOBALHASH")) continue;
            int[] baseColPos = id.baseColumnPositions();
            ListIterator<ConglomerateDescriptor> li = sortedIndexes.listIterator();
            while (li.hasNext() && baseColPos.length <= (currSorted = (ConglomerateDescriptor)li.next()).getIndexDescriptor().baseColumnPositions().length) {
            }
            li.add(cd);
        }
        return sortedIndexes;
    }

    ComparisonQueryInfo[] isGlobalIndexApplicable(ConglomerateDescriptor cd, ValueQueryInfo[] partitioningConstants, Iterator<ComparisonQueryInfo> condnsToCheck, int[] baseColsPos) {
        ComparisonQueryInfo[] condnsConstitutingGlobalIndex = new ComparisonQueryInfo[baseColsPos.length];
        HashSet<Integer> colPosSatisfied = new HashSet<Integer>(baseColsPos.length);
        while (condnsToCheck.hasNext()) {
            ComparisonQueryInfo condn = condnsToCheck.next();
            int indexPos = condn.isPartOfGlobalIndex(baseColsPos);
            if (indexPos == -1) continue;
            colPosSatisfied.add(indexPos);
            partitioningConstants[indexPos] = (ValueQueryInfo)condn.rightOperand;
            condnsConstitutingGlobalIndex[indexPos] = condn;
        }
        if (colPosSatisfied.size() != baseColsPos.length) {
            condnsConstitutingGlobalIndex = null;
        }
        return condnsConstitutingGlobalIndex;
    }

    @Override
    public String isEquiJoinColocationCriteriaFullfilled(TableQueryInfo ncjTqi) {
        if (this.colocationCriteria != null) {
            return this.colocationCriteria.isEquiJoinColocationCriteriaFullfilled(ncjTqi);
        }
        if (this.colocationFailReason != null) {
            return this.colocationFailReason;
        }
        return "no colocation criteria could be determined";
    }

    Map getEqualityConditionsMap() {
        return Collections.unmodifiableMap(this.equalityConditions);
    }

    Map getInEqualityConditionsMap() {
        return Collections.unmodifiableMap(this.colOperands);
    }

    @Override
    QueryInfo getRuntimeNodesPruner(boolean forSingleHopPreparePhase) {
        if (this.runTimePruner == null) {
            this.runTimePruner = this.createRuntimeNodesPruner();
        }
        return this.runTimePruner;
    }
}

