/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdListResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.OffHeapReleaseUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.message.BitSetSet;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GetExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionMultiKeyExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class GetAllExecutorMessage
extends RegionMultiKeyExecutorMessage {
    private final Map<InternalDistributedMember, Map<Integer, List<Object>>> allMembersAndBucketsAndKeys;
    protected final Object[] inRoutingobjects;
    protected final Object[] inKeys;
    protected List<Integer> keysCountPerBucket = null;
    protected final LanguageConnectionContext lcc;
    protected final boolean isTX;
    private boolean forUpdate;
    private boolean queryHDFS;
    private transient boolean hasLoader;
    private transient boolean canStartTX;
    protected static final short HAS_LOADER = 1024;
    protected static final short CAN_START_TX = 2048;
    protected static final short FOR_UPDATE = 4096;

    public boolean isTX() {
        return this.isTX;
    }

    public boolean hasLoader() {
        return this.hasLoader;
    }

    public GetAllExecutorMessage() {
        super(true);
        this.inKeys = null;
        this.allMembersAndBucketsAndKeys = null;
        this.inRoutingobjects = null;
        this.lcc = null;
        this.isTX = false;
    }

    public GetAllExecutorMessage(LocalRegion region, Object[] keys, Object[] routingObjects, RowFormatter targetFormat, int[] projectionFixedColumns, int[] projectionVarColumns, int[] projectionLobColumns, int[] projectionAllColumns, TXStateInterface tx, LanguageConnectionContext lcc, boolean forUpdate, boolean queryHDFS) {
        super(new GfxdListResultCollector(null, true), region, null, tx, GetAllExecutorMessage.getTimeStatsSettings(lcc), targetFormat, projectionFixedColumns, projectionVarColumns, projectionLobColumns, projectionAllColumns);
        this.inKeys = keys;
        this.hasLoader = ((GemFireContainer)region.getUserAttribute()).getHasLoaderAnywhere();
        if (this.isTransactional() && !region.getScope().isLocal()) {
            this.canStartTX = this.getLockingPolicy().readCanStartTX() || this.hasLoader;
        }
        this.allMembersAndBucketsAndKeys = new THashMap();
        this.inRoutingobjects = routingObjects;
        this.lcc = lcc;
        this.isTX = tx != null;
        this.keysCountPerBucket = new ArrayList<Integer>();
        this.forUpdate = forUpdate;
        this.queryHDFS = queryHDFS;
        SanityManager.ASSERT((this.inKeys != null ? 1 : 0) != 0);
        SanityManager.ASSERT((this.routingObjects == null ? 1 : 0) != 0);
        SanityManager.ASSERT((this.pr != null ? 1 : 0) != 0);
    }

    public GetAllExecutorMessage(GetAllExecutorMessage other) {
        super(other);
        this.inKeys = other.inKeys;
        this.allMembersAndBucketsAndKeys = other.allMembersAndBucketsAndKeys;
        this.inRoutingobjects = other.inRoutingobjects;
        this.hasLoader = other.hasLoader;
        this.canStartTX = other.canStartTX;
        this.lcc = other.lcc;
        this.isTX = other.isTX;
        this.keysCountPerBucket = other.keysCountPerBucket;
        this.forUpdate = other.forUpdate;
        this.queryHDFS = other.queryHDFS;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean withSecondaries() {
        return false;
    }

    @Override
    protected GetAllExecutorMessage clone() {
        return new GetAllExecutorMessage(this);
    }

    @Override
    protected void execute() throws GemFireCheckedException {
        boolean doLog = DistributionManager.VERBOSE | GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ;
        ArrayList<Object> resultList = new ArrayList<Object>();
        LogWriterI18n logger = this.region.getLogWriterI18n();
        int numKeys = this.membersToKeys.size();
        ArrayList<Integer> bucketList = new ArrayList<Integer>();
        TreeSet<Integer> uniqueBucketList = new TreeSet<Integer>();
        int bucketId = this.bucketBitSet.nextSetBit(0, 0);
        while (bucketId >= 0) {
            uniqueBucketList.add(bucketId);
            bucketId = this.bucketBitSet.nextSetBit(bucketId + 1);
        }
        SanityManager.ASSERT((this.keysCountPerBucket.size() == uniqueBucketList.size() ? 1 : 0) != 0);
        Iterator<Integer> countItr = this.keysCountPerBucket.iterator();
        Iterator i$ = uniqueBucketList.iterator();
        while (i$.hasNext()) {
            int bucketId2 = (Integer)i$.next();
            int count = countItr.next();
            for (int i = 0; i < count; ++i) {
                bucketList.add(bucketId2);
            }
        }
        if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.getID() + ".execute: Got keys " + this.membersToKeys + " of size [" + numKeys + "] " + " with bucketList " + bucketList + " of size [" + bucketList.size() + "] " + " for region " + this.region.getFullPath() + " , processorId=" + this.getProcessorId() + " , and callbackArg " + (this.commonCallbackArg != null)));
        }
        SanityManager.ASSERT((numKeys == bucketList.size() ? 1 : 0) != 0);
        boolean isPrimary = true;
        GfxdCallbackArgument.WithInfoFieldsType callbackArg = null;
        if (this.commonCallbackArg != null) {
            callbackArg = ((GfxdCallbackArgument.WithInfoFieldsType)this.commonCallbackArg).cloneObject();
        }
        boolean throwingException = false;
        for (int keyAndBucketIndex = 0; keyAndBucketIndex < numKeys; ++keyAndBucketIndex) {
            Object result;
            int bucketId3;
            Object key;
            block36: {
                key = this.membersToKeys.get(keyAndBucketIndex);
                bucketId3 = (Integer)bucketList.get(keyAndBucketIndex);
                result = null;
                try {
                    if (callbackArg != null) {
                        Integer routingObject = (Integer)GemFireXDUtils.getRoutingObject(bucketId3);
                        callbackArg.setRoutingObject(routingObject);
                    }
                    Assert.assertTrue(((result = GetExecutorMessage.executeOneKey(this, key, callbackArg, bucketId3, this.pr, this.region, this.regionPath, false, this.hasProjection, this.targetFormat, this.projectionFixedColumns, this.projectionVarColumns, this.projectionAllColumns, this.projectionLobColumns, this.targetFormatOffsetBytes, true, this.forUpdate, this.queryHDFS)) != GetExecutorMessage.INVALID_RESULT ? 1 : 0) != 0);
                }
                catch (CacheLoaderException ex) {
                    boolean isItENFE = GemFireResultSet.checkIfENFE(ex);
                    if (isItENFE) {
                        if (logger.fineEnabled()) {
                            logger.fine("Got EntryNotFoundException wrapped in CacheLoaderException");
                        }
                        result = null;
                        break block36;
                    }
                    throwingException = true;
                    throw ex;
                }
                catch (EntryNotFoundException ex) {
                    if (logger.fineEnabled()) {
                        logger.fine("Got EntryNotFoundException exception", (Throwable)ex);
                    }
                    result = null;
                }
                catch (GemFireXDRuntimeException ex) {
                    if (logger.fineEnabled()) {
                        logger.fine("Got GemFireXDRuntimeException exception", (Throwable)ex);
                    }
                    if (ex.getCause() instanceof StandardException) {
                        if (!GemFireResultSet.exceptionCanBeIgnored((StandardException)ex.getCause())) {
                            throwingException = true;
                            throw ex;
                        }
                        break block36;
                    }
                    throwingException = true;
                    throw ex;
                }
                catch (EntryExistsException ex) {
                    boolean isTheRegionReplicate;
                    DataPolicy policy = this.region.getDataPolicy();
                    boolean bl = isTheRegionReplicate = policy.withReplication() || !policy.withStorage();
                    if (isTheRegionReplicate) {
                        result = ex.getOldValue();
                        break block36;
                    }
                    throwingException = true;
                    throw ex;
                }
                catch (RuntimeException re) {
                    throwingException = true;
                    throw re;
                }
                finally {
                    if (throwingException && GemFireXDUtils.isOffHeapEnabled()) {
                        OffHeapReleaseUtil.freeOffHeapReference(resultList);
                    }
                }
            }
            if (doLog) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.getID() + ".execute: Got result for key= " + key.toString() + " , bucketId= " + bucketId3 + " , region " + this.region.getFullPath() + " [" + result == null ? "null" : result + "]" + ", keyIndex=" + keyAndBucketIndex));
            }
            resultList.add(result);
        }
        if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.getID() + ".execute: Sending lastResult of size [" + resultList.size() + "] for region " + this.region.getFullPath() + " , processorId=" + this.getProcessorId()));
        }
        try {
            this.lastResult(resultList, true, true, true);
        }
        catch (RuntimeException re) {
            throw re;
        }
        finally {
            if (GemFireXDUtils.isOffHeapEnabled() && !this.isLocallyExecuted()) {
                OffHeapReleaseUtil.freeOffHeapReference(resultList);
            }
        }
    }

    @Override
    public byte getGfxdID() {
        return 45;
    }

    @Override
    protected final short computeCompressedShort(short flags) {
        flags = super.computeCompressedShort(flags);
        if (this.hasLoader) {
            flags = (short)(flags | 0x400);
        }
        if (this.canStartTX) {
            flags = (short)(flags | 0x800);
        }
        if (this.forUpdate) {
            flags = (short)(flags | 0x1000);
        }
        return flags;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        long beginTime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.ser_deser_time == 0L ? (this.ser_deser_time = -1L) : -2L) : 0L;
        super.toData(out);
        InternalDataSerializer.writeObject(this.keysCountPerBucket, (DataOutput)out);
        out.writeBoolean(this.queryHDFS);
        if (beginTime != 0L) {
            this.ser_deser_time = XPLAINUtil.recordTiming(beginTime);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.ser_deser_time = this.timeStatsEnabled ? (long)(this.ser_deser_time == 0L ? -1 : -2) : 0L;
        super.fromData(in);
        this.hasLoader = (this.flags & 0x400) != 0;
        this.canStartTX = (this.flags & 0x800) != 0;
        this.forUpdate = (this.flags & 0x1000) != 0;
        this.keysCountPerBucket = (List)InternalDataSerializer.readObject((DataInput)in);
        this.queryHDFS = in.readBoolean();
        if (this.timeStatsEnabled && this.ser_deser_time == -1L) {
            this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
        }
    }

    @Override
    public final int getMessageProcessorType() {
        return 78;
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        if (this.hasLoader) {
            sb.append(";hasLoader=").append(this.hasLoader);
        }
        if (this.canStartTX) {
            sb.append(";canStartTX=").append(this.canStartTX);
        }
        if (this.forUpdate) {
            sb.append(";forUpdate=true");
        }
        if (this.queryHDFS) {
            sb.append(";queryHDFS=true");
        }
    }

    @Override
    public final boolean canStartRemoteTransaction() {
        return this.canStartTX;
    }

    @Override
    public boolean useTransactionProxy() {
        return this.canStartTX;
    }

    @Override
    protected boolean requiresTXFlushAfterExecution() {
        return this.canStartTX;
    }

    @Override
    protected void setArgsForMember(DistributedMember member, Set<DistributedMember> messageAwareMembers) {
        this.target = member;
        this.getKeysPerMember(member);
        boolean doLog = DistributionManager.VERBOSE | GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ;
        if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.getID() + ".setArgsForMember: keys [" + this.membersToKeys.toString() + "] with count of keys per bucket [" + this.keysCountPerBucket.toString() + "]" + " being sent to member " + member.getHost() + "/" + member.getId() + " , with processorId - " + member.getProcessId()));
        }
    }

    @Override
    protected void setMembersToBucketIds(PartitionedRegion.RetryTimeKeeper retryTime) throws StandardException {
        boolean doLog = DistributionManager.VERBOSE | GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ;
        this.allMembersAndBucketsAndKeys.clear();
        this.resetKeysPerMember();
        PartitionedRegion pregion = (PartitionedRegion)this.region;
        boolean optimizeForWrite = this.optimizeForWrite() || pregion.isHDFSReadWriteRegion();
        this.membersToBucketIds = new RegionExecutorMessage.HashMapOrSet((LocalRegion)pregion);
        BitSetSet allBucketIds = new BitSetSet(pregion.getPartitionAttributes().getTotalNumBuckets());
        GfxdCallbackArgument callbackArg = null;
        boolean needCallbackArg = false;
        if (this.hasLoader && !this.isTX) {
            needCallbackArg = true;
        }
        if (doLog) {
            StringBuilder debugString = new StringBuilder();
            debugString.append(this.getID());
            debugString.append(".setMembersToBucketIds: keys for ");
            debugString.append(this.regionPath);
            debugString.append(" [");
            for (Object key : this.inKeys) {
                debugString.append(key);
                debugString.append(", ");
            }
            debugString.append("] with callbackArg=");
            debugString.append(needCallbackArg);
            debugString.append(" ,optimizeForWrite=");
            debugString.append(optimizeForWrite);
            debugString.append(" ,hdfs-region=");
            debugString.append(pregion.isHDFSReadWriteRegion());
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)debugString.toString());
        }
        assert (this.inRoutingobjects == null || this.inKeys.length == this.inRoutingobjects.length);
        for (int index = 0; index < this.inKeys.length; ++index) {
            List<Object> keylist;
            Object routingObject = this.inRoutingobjects == null ? null : this.inRoutingobjects[index];
            callbackArg = GemFireXDUtils.wrapCallbackArgs(routingObject, this.lcc, false, true, true, true, this.lcc.isSkipListeners(), false, this.lcc.isSkipConstraintChecks());
            int bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)this.pr, (Operation)Operation.GET, (Object)this.inKeys[index], null, (Object)callbackArg);
            if (!allBucketIds.addInt(bucketId)) {
                // empty if block
            }
            InternalDistributedMember member = optimizeForWrite ? pregion.getOrCreateNodeForBucketWrite(bucketId, retryTime) : pregion.getOrCreateNodeForInitializedBucketRead(bucketId, this.possibleDuplicate);
            GetAllExecutorMessage.addBucketIdForMember(this.membersToBucketIds, (DistributedMember)member, bucketId, pregion);
            Map<Integer, List<Object>> bucketToKeylistMap = this.allMembersAndBucketsAndKeys.get(member);
            if (bucketToKeylistMap == null) {
                bucketToKeylistMap = new TreeMap<Integer, List<Object>>();
                this.allMembersAndBucketsAndKeys.put(member, bucketToKeylistMap);
            }
            if ((keylist = bucketToKeylistMap.get(bucketId)) == null) {
                keylist = new ArrayList<Object>();
                bucketToKeylistMap.put(bucketId, keylist);
            }
            keylist.add(this.inKeys[index]);
        }
        if (needCallbackArg) {
            SanityManager.ASSERT((boolean)(callbackArg instanceof GfxdCallbackArgument.WithInfoFieldsType));
            ((GfxdCallbackArgument.WithInfoFieldsType)callbackArg).setRoutingObject(null);
            this.commonCallbackArg = callbackArg;
        }
        if (this.membersToBucketIds.isEmpty()) {
            GemFireXDUtils.checkForInsufficientDataStore((LocalRegion)pregion);
        }
        if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.getID() + ".setMembersToBucketIds: execute on buckets with pruned map :- " + (Object)((Object)this.membersToBucketIds)));
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.allMembersAndBucketsAndKeys.clear();
        this.resetKeysPerMember();
    }

    @Override
    public List<Object> getKeysPerMember(DistributedMember member) {
        this.resetKeysPerMember();
        assert (this.membersToKeys != null);
        assert (this.keysCountPerBucket != null);
        Map<Integer, List<Object>> bucketToKeylistMap = this.allMembersAndBucketsAndKeys.get(member);
        assert (bucketToKeylistMap != null);
        for (List<Object> keylist : bucketToKeylistMap.values()) {
            this.keysCountPerBucket.add(keylist.size());
            for (Object key : keylist) {
                this.membersToKeys.add(key);
            }
        }
        return this.membersToKeys;
    }

    @Override
    public long estimateMemoryUsage() throws StandardException {
        long memory = 0L;
        try {
            for (Map<Integer, List<Object>> bucketsAndKeys : this.allMembersAndBucketsAndKeys.values()) {
                for (List<Object> allKeys : bucketsAndKeys.values()) {
                    for (Object k : allKeys) {
                        if (k instanceof CompactCompositeKey) {
                            memory += ((CompactCompositeKey)k).estimateMemoryUsage();
                            continue;
                        }
                        if (k instanceof DataValueDescriptor) {
                            memory += (long)((DataValueDescriptor)k).estimateMemoryUsage();
                            continue;
                        }
                        if (!(k instanceof Long)) continue;
                        memory += 64L;
                    }
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return memory;
    }

    @Override
    protected void resetKeysPerMember() {
        super.resetKeysPerMember();
        if (this.keysCountPerBucket != null) {
            this.keysCountPerBucket.clear();
        }
    }
}

