/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.gemstone.gemfire.internal.NanoTimer;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.execute.VTIResultSet;
import com.pivotal.gemfirexd.internal.vti.IFastPath;
import com.pivotal.gemfirexd.internal.vti.IQualifyable;
import com.pivotal.gemfirexd.internal.vti.VTIEnvironment;
import com.pivotal.gemfirexd.tools.sizer.ObjectSizer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MemoryAnalyticsVTI
extends GfxdVTITemplate
implements IQualifyable,
IFastPath,
ObjectSizer.PreQualifier {
    public static boolean TEST_MODE = false;
    private Iterator<GemFireContainer> containerList;
    private final String host;
    private final String member;
    private Iterator<Map.Entry<String, Object[]>> memberResults;
    private Map.Entry<String, Object[]> currentMemoryReport;
    private ArrayList<DataValueDescriptor[]> partialResult;
    private static final String keyDelimiter = "!";
    private final boolean isForInternalUse;
    private final GemFireStore.StoreStatistics stats;
    private Qualifier[][] qualifiers;
    private long beginTime = -1L;
    private ObjectSizer sizer;
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String INDEX_NAME = "INDEX_NAME";
    public static final String INDEX_TYPE = "INDEX_TYPE";
    public static final String QUEUE_NAME = "QUEUE_NAME";
    public static final String QUEUE_TYPE = "QUEUE_TYPE";
    public static final String MEMBERID = "ID";
    public static final String HOST = "HOST";
    public static final String CONSTANT_OVERHEAD = "CONSTANT_OVERHEAD";
    public static final String ENTRY_SIZE = "ENTRY_SIZE";
    public static final String KEY_SIZE = "KEY_SIZE";
    public static final String VALUE_SIZE = "VALUE_SIZE";
    public static final String VALUE_SIZE_OFFHEAP = "VALUE_SIZE_OFFHEAP";
    public static final String NUM_ROWS = "NUM_ROWS";
    public static final String NUM_KEYS_MEMORY = "NUM_KEYS_IN_MEMORY";
    public static final String NUM_VALUES_MEMORY = "NUM_VALUES_IN_MEMORY";
    public static final String NUM_VALUES_OFFHEAP = "NUM_VALUES_IN_OFFHEAP";
    public static final String TOTAL_SIZE = "TOTAL_SIZE";
    public static final String MEMORY_REPORT = "MEMORY";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("TABLE_NAME", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("INDEX_NAME", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("INDEX_TYPE", 12, true, 32), EmbedResultSetMetaData.getResultColumnDescriptor("QUEUE_NAME", 12, true, 256), EmbedResultSetMetaData.getResultColumnDescriptor("QUEUE_TYPE", 12, true, 32), EmbedResultSetMetaData.getResultColumnDescriptor("ID", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("HOST", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("CONSTANT_OVERHEAD", 7, false), EmbedResultSetMetaData.getResultColumnDescriptor("ENTRY_SIZE", 7, false), EmbedResultSetMetaData.getResultColumnDescriptor("KEY_SIZE", 7, false), EmbedResultSetMetaData.getResultColumnDescriptor("VALUE_SIZE", 7, false), EmbedResultSetMetaData.getResultColumnDescriptor("VALUE_SIZE_OFFHEAP", 7, false), EmbedResultSetMetaData.getResultColumnDescriptor("TOTAL_SIZE", 7, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUM_ROWS", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUM_KEYS_IN_MEMORY", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUM_VALUES_IN_MEMORY", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NUM_VALUES_IN_OFFHEAP", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("MEMORY", -1, false)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public MemoryAnalyticsVTI() {
        this(false);
    }

    public MemoryAnalyticsVTI(boolean internalOnly) {
        this.isForInternalUse = internalOnly;
        this.stats = Misc.getMemStore().getStoreStatistics();
        this.host = Misc.getMyId().getHost();
        this.member = Misc.getMyId().getId();
        this.sizer = ObjectSizer.getInstance(this.isForInternalUse);
        if (TEST_MODE) {
            this.partialResult = new ArrayList();
        }
    }

    public void setContainer(GemFireContainer container) {
        ArrayList<GemFireContainer> list = new ArrayList<GemFireContainer>();
        list.add(container);
        this.containerList = list.iterator();
        this.beginTime = -1L;
    }

    @Override
    public boolean next() throws SQLException {
        boolean hasMoreContainers = false;
        try {
            GemFireStore.VMKind vmKind = GemFireXDUtils.getMyVMKind();
            if (!vmKind.isStore()) {
                boolean bl = false;
                return bl;
            }
            if (this.beginTime == -1L) {
                this.beginTime = NanoTimer.getTime();
                this.sizer.initialize(this.isForInternalUse, keyDelimiter);
                this.sizer.setQueryHints(this.compileTimeConstants);
            }
            if (this.containerList == null) {
                ArrayList<GemFireContainer> targetContainers = new ArrayList<GemFireContainer>();
                ObjectSizer.getTargetContainers(targetContainers);
                this.containerList = targetContainers.iterator();
            }
            LinkedHashMap<String, Object[]> retVal = null;
            do {
                hasMoreContainers = this.containerList.hasNext();
                if (this.memberResults != null && this.memberResults.hasNext()) {
                    this.currentMemoryReport = this.memberResults.next();
                    boolean bl = true;
                    return bl;
                }
                if (hasMoreContainers) continue;
                this.containerList = null;
                this.beginTime = -1L;
                boolean bl = false;
                return bl;
            } while ((retVal = this.sizer.size(this.containerList.next(), this)) == null);
            this.sizer.logSizes(retVal);
            LinkedHashMap<String, Object[]> result = new LinkedHashMap<String, Object[]>();
            for (Map.Entry<String, Object[]> e : retVal.entrySet()) {
                result.put(this.member + keyDelimiter + this.host + keyDelimiter + e.getKey(), e.getValue());
            }
            this.memberResults = result.entrySet().iterator();
            if (this.memberResults.hasNext()) {
                this.currentMemoryReport = this.memberResults.next();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            hasMoreContainers = false;
            throw GemFireXDRuntimeException.newRuntimeException("Exception in MemoryAnalyticsVTI#next", e);
        }
        catch (Throwable t) {
            hasMoreContainers = false;
            throw Util.javaException(t);
        }
        finally {
            if (!hasMoreContainers) {
                this.sizer.done();
            }
        }
        this.stats.collectMemoryAnalyticsStats(NanoTimer.getTime() - this.beginTime, this.isForInternalUse);
        return false;
    }

    @Override
    protected Object getObjectForColumn(int columnNumber) throws SQLException {
        Object res;
        ResultColumnDescriptor desc = columnInfo[columnNumber - 1];
        String columnName = desc.getName();
        String[] keyAr = this.currentMemoryReport.getKey().split(keyDelimiter);
        long[] currVal = (long[])this.currentMemoryReport.getValue()[0];
        if (TABLE_NAME.equals(columnName)) {
            res = keyAr[2];
        } else if (INDEX_NAME.equals(columnName)) {
            res = keyAr.length > 3 && keyAr[3].length() > 0 ? keyAr[3] : null;
        } else if (INDEX_TYPE.equals(columnName)) {
            res = keyAr.length > 4 && keyAr[4].length() > 0 ? keyAr[4] : null;
        } else if (QUEUE_NAME.equals(columnName)) {
            res = keyAr.length > 5 ? keyAr[5] : null;
        } else if (QUEUE_TYPE.equals(columnName)) {
            res = keyAr.length > 6 ? keyAr[6] : null;
        } else if (MEMBERID.equals(columnName)) {
            res = keyAr[0];
        } else if (HOST.equals(columnName)) {
            res = keyAr[1];
        } else if (CONSTANT_OVERHEAD.equals(columnName)) {
            res = this.formatSizeValue(currVal[0], new StringBuilder());
        } else if (ENTRY_SIZE.equals(columnName)) {
            res = this.formatSizeValue(currVal[1], new StringBuilder());
        } else if (KEY_SIZE.equals(columnName)) {
            res = this.formatSizeValue(currVal[2], new StringBuilder());
        } else if (VALUE_SIZE.equals(columnName)) {
            res = this.formatSizeValue(currVal[3], new StringBuilder());
        } else if (VALUE_SIZE_OFFHEAP.equals(columnName)) {
            res = this.formatSizeValue(currVal[4], new StringBuilder());
        } else if (TOTAL_SIZE.equals(columnName)) {
            long totalsize = currVal[0] + currVal[1] + currVal[2] + currVal[3] + currVal[4];
            res = this.formatSizeValue(totalsize, new StringBuilder());
        } else if (NUM_ROWS.equals(columnName)) {
            res = currVal.length > 9 && currVal[9] > 0L ? Long.valueOf(currVal[9]) : Long.valueOf(currVal[5]);
        } else if (NUM_KEYS_MEMORY.equals(columnName)) {
            res = currVal[6];
        } else if (NUM_VALUES_MEMORY.equals(columnName)) {
            res = currVal[7];
        } else if (NUM_VALUES_OFFHEAP.equals(columnName)) {
            res = currVal[8];
        } else if (MEMORY_REPORT.equals(columnName)) {
            res = this.currentMemoryReport.getValue().length > 1 ? this.currentMemoryReport.getValue()[1] : "-";
            Misc.getGemFireCache().getLogger().info("Memory Report : " + res);
        } else {
            throw new GemFireXDRuntimeException("unexpected columnName " + columnName);
        }
        return res instanceof StringBuilder ? res.toString() : res;
    }

    public Float formatSizeValue(long value, StringBuilder sb) {
        return Float.valueOf((float)value / 1000.0f);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return metadata;
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vtiEnvironment) throws SQLException {
        ArrayList<GemFireContainer> targetContainers = new ArrayList<GemFireContainer>();
        ObjectSizer.getTargetContainers(targetContainers);
        return targetContainers.size();
    }

    @Override
    public double getEstimatedCostPerInstantiation(VTIEnvironment vtiEnvironment) throws SQLException {
        return 1.0;
    }

    @Override
    public void setQualifiers(VTIEnvironment vtiEnvironment, Qualifier[][] qualifiers) throws SQLException {
        if (qualifiers == null || qualifiers.length == 0) {
            return;
        }
        this.qualifiers = qualifiers;
    }

    public boolean qualifiesRow(DataValueDescriptor[] row, boolean allowPartialRow) throws StandardException {
        if (this.qualifiers != null) {
            return RowUtil.qualifyRow(row, null, this.qualifiers, allowPartialRow);
        }
        return true;
    }

    @Override
    public boolean qualifyPartialRow(String tableName, String indexName, String indexType, String queueName, String queueType, long constantOverhead) throws StandardException {
        if (this.qualifiers == null) {
            return true;
        }
        DataValueDescriptor[] partialRow = new DataValueDescriptor[columnInfo.length];
        int idx = 0;
        partialRow[idx] = columnInfo[idx].getType().getNull();
        partialRow[idx].setValue(tableName);
        partialRow[++idx] = columnInfo[idx].getType().getNull();
        partialRow[++idx].setValue(indexName);
        partialRow[++idx] = columnInfo[idx].getType().getNull();
        partialRow[++idx].setValue(indexType);
        partialRow[++idx] = columnInfo[idx].getType().getNull();
        partialRow[++idx].setValue(queueName);
        partialRow[++idx] = columnInfo[idx].getType().getNull();
        partialRow[++idx].setValue(queueType);
        partialRow[++idx] = columnInfo[idx].getType().getNull();
        partialRow[++idx].setValue(this.member);
        partialRow[++idx] = columnInfo[idx].getType().getNull();
        partialRow[++idx].setValue(this.host);
        partialRow[++idx] = columnInfo[idx].getType().getNull();
        partialRow[++idx].setValue(constantOverhead);
        boolean retVal = this.qualifiesRow(partialRow, true);
        if (TEST_MODE && retVal) {
            this.partialResult.add(partialRow);
        }
        return retVal;
    }

    @Override
    public boolean executeAsFastPath() throws StandardException, SQLException {
        return true;
    }

    @Override
    public int nextRow(ExecRow row, VTIResultSet parentRS) throws StandardException, SQLException {
        do {
            if (!this.next()) {
                return -1;
            }
            parentRS.populateFromResultSet(row);
        } while (!this.qualifiesRow(row.getRowArray(), false));
        return 0;
    }

    @Override
    public void currentRow(ResultSet rs, DataValueDescriptor[] row) throws StandardException, SQLException {
        throw new AssertionError((Object)"UnExpected call ");
    }

    @Override
    public void rowsDone() throws StandardException, SQLException {
        throw new AssertionError((Object)"UnExpected call ");
    }

    public ArrayList<DataValueDescriptor[]> getPartialResult() {
        return this.partialResult;
    }
}

