/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EvictionCriteria;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gemfire.internal.offheap.Releasable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.expression.ExpressionCompiler;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public class GfxdEvictionCriteria
implements EvictionCriteria<Object, Object> {
    private final ExpressionCompiler predicateCompiler;
    private final String predicateString;
    private PreparedStatement queryStatement;
    private Observer evictionObserver;

    public GfxdEvictionCriteria(ValueNode predicate, String sqlText, int beginOffset, int endOffset) {
        this.predicateCompiler = new ExpressionCompiler(predicate, new HashMap<String, Integer>(), "EVICTION BY CRITERIA");
        this.predicateString = sqlText.substring(beginOffset, endOffset);
    }

    public void setObserver(Observer observer) {
        this.evictionObserver = observer;
    }

    public final String getPredicateString() {
        return this.predicateString;
    }

    public void bindExpression(FromList fromList, LanguageConnectionContext lcc) throws StandardException {
        Vector aggregates = new Vector();
        SubqueryList subqueries = (SubqueryList)lcc.getLanguageConnectionFactory().getNodeFactory().getNode(11, lcc.getContextManager());
        String[] exprCols = this.predicateCompiler.bindExpression(fromList, subqueries, aggregates);
        if (exprCols == null || exprCols.length == 0) {
            throw StandardException.newException("42909");
        }
        if (aggregates.size() > 0) {
            throw StandardException.newException("42903");
        }
        if (subqueries.size() > 0) {
            throw StandardException.newException("42904", "EVICTION BY CRITERIA");
        }
        this.predicateCompiler.normalizeExpression(true);
    }

    public void initialize(GemFireContainer container, LanguageConnectionContext lcc) throws StandardException {
        this.queryStatement = lcc.prepareInternalStatement("SELECT * FROM " + container.getQualifiedTableName() + " WHERE " + this.predicateString, (short)0);
        this.predicateCompiler.compileExpression(container.getTableDescriptor(), lcc);
    }

    public Iterator<Map.Entry<Object, Object>> getKeysToBeEvicted(long currentMillis, Region<Object, Object> region) {
        return new Itr(currentMillis, region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doEvict(EntryEvent<Object, Object> event) {
        EntryEventImpl ev = (EntryEventImpl)event;
        RegionEntry re = ev.getRegionEntry();
        LocalRegion region = ev.getRegion();
        CachePerfStats stats = region instanceof BucketRegion ? region.getPartitionedRegion().getCachePerfStats() : region.getCachePerfStats();
        long startTime = stats.startEvaluation();
        try {
            if (region.getLogWriterI18n().fineEnabled()) {
                region.getLogWriterI18n().fine(" The entry is " + re + " and the event is " + event + " re marked for eviction " + re.isMarkedForEviction());
            }
            if (re != null) {
                if (ev.getTXState() == null && re.hasAnyLock()) {
                    boolean bl = false;
                    return bl;
                }
                if (re.isMarkedForEviction()) {
                    boolean bl = true;
                    return bl;
                }
                Observer observer = this.evictionObserver;
                if (observer != null) {
                    observer.onDoEvictCompare(ev);
                }
                RowLocation rl = (RowLocation)re;
                GemFireContainer container = (GemFireContainer)ev.getRegion().getUserAttribute();
                EmbedConnection conn = null;
                boolean contextSet = false;
                LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
                try {
                    DataValueDescriptor res;
                    if (lcc == null) {
                        conn = GemFireXDUtils.getTSSConnection(true, true, false);
                        conn.getTR().setupContextStack();
                        contextSet = true;
                        lcc = conn.getLanguageConnectionContext();
                        if (lcc == null) {
                            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
                        }
                    }
                    if ((res = this.predicateCompiler.evaluateExpression(ev.getKey(), rl, container, lcc)) != null) {
                        assert (res instanceof SQLBoolean) : "unexpected DVD type=" + res.getClass() + ": " + res.toString();
                        boolean bl = ((SQLBoolean)res).getBoolean();
                        return bl;
                    }
                }
                catch (StandardException standardException) {
                }
                finally {
                    if (contextSet) {
                        conn.getTR().restoreContextStack();
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            region.getLogWriterI18n().fine("Getting called finally");
            stats.incEvaluations();
            stats.endEvaluation(startTime, 0L);
        }
    }

    public boolean isEquivalent(EvictionCriteria<Object, Object> other) {
        if (other instanceof GfxdEvictionCriteria) {
            GfxdEvictionCriteria otherCriteria = (GfxdEvictionCriteria)other;
            return this.predicateString.equals(otherCriteria.predicateString);
        }
        return false;
    }

    private final class Itr
    implements Iterator<Map.Entry<Object, Object>>,
    Releasable {
        private final long currentMillis;
        private final GemFireContainer container;
        private final ConcurrentSkipListMap.SimpleReusableEntry entry;
        private final EmbedConnection conn;
        private final boolean contextSet;
        private final LanguageConnectionContext lcc;
        private final boolean popLCCContext;
        private final StatementContext statementContext;
        private final CursorResultSet resultSet;
        private RowLocation currentRowLocation;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Itr(long currentTimeMillis, Region<Object, Object> region) {
            this.currentMillis = currentTimeMillis;
            this.container = (GemFireContainer)region.getUserAttribute();
            this.entry = new ConcurrentSkipListMap.SimpleReusableEntry();
            this.currentRowLocation = null;
            LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
            EmbedConnection conn = null;
            StatementContext statementContext = null;
            boolean contextSet = false;
            boolean popContext = false;
            CursorResultSet resultSet = null;
            Exception t = null;
            try {
                if (lcc == null) {
                    conn = GemFireXDUtils.getTSSConnection(true, true, false);
                    conn.getTR().setupContextStack();
                    contextSet = true;
                    lcc = conn.getLanguageConnectionContext();
                    if (lcc == null) {
                        Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
                    }
                } else {
                    contextSet = false;
                }
                if (lcc != null) {
                    lcc.pushMe();
                    popContext = true;
                    assert (ContextService.getContextOrNull("LanguageConnectionContext") != null);
                    statementContext = lcc.pushStatementContext(false, false, GfxdEvictionCriteria.this.predicateString, null, false, 0L, true);
                    statementContext.setSQLAllowed((short)1, true);
                    resultSet = (CursorResultSet)GfxdEvictionCriteria.this.queryStatement.execute(lcc, false, 0L);
                    if (resultSet.getNextRow() != null) {
                        this.currentRowLocation = resultSet.getRowLocation();
                    }
                }
            }
            catch (Exception e) {
                t = e;
                this.currentRowLocation = null;
                LogWriter logger = Misc.getCacheLogWriterNoThrow();
                if (logger != null) {
                    logger.warning("GfxdEvictionCriteria: Error in Iterator creation", (Throwable)e);
                }
            }
            finally {
                if (this.currentRowLocation == null) {
                    Observer observer;
                    if (statementContext != null) {
                        lcc.popStatementContext(statementContext, t);
                    }
                    if (lcc != null && popContext) {
                        lcc.popMe();
                    }
                    if (contextSet) {
                        conn.getTR().restoreContextStack();
                    }
                    if ((observer = GfxdEvictionCriteria.this.evictionObserver) != null) {
                        observer.onIterationComplete(region);
                    }
                }
            }
            this.conn = conn;
            this.contextSet = contextSet;
            this.lcc = lcc;
            this.popLCCContext = popContext;
            this.statementContext = statementContext;
            this.resultSet = resultSet;
        }

        @Override
        public boolean hasNext() {
            return this.currentRowLocation != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<Object, Object> next() {
            RowLocation rl = this.currentRowLocation;
            if (rl != null) {
                Observer observer;
                Object key = null;
                Integer routingObject = null;
                Exception t = null;
                this.currentRowLocation = null;
                try {
                    key = rl.getKeyCopy();
                    routingObject = rl.getBucketID();
                    if (GemFireXDUtils.isOffHeapEnabled()) {
                        ((NoPutResultSet)((Object)this.resultSet)).releasePreviousByteSource();
                    }
                    if (this.resultSet.getNextRow() != null) {
                        this.currentRowLocation = this.resultSet.getRowLocation();
                    }
                }
                catch (Exception e) {
                    this.currentRowLocation = null;
                    t = e;
                    LogWriter logger = Misc.getCacheLogWriterNoThrow();
                    if (logger != null) {
                        logger.warning("GfxdEvictionCriteria::Itr:next: Error in iterator.next", (Throwable)e);
                    }
                }
                finally {
                    if (this.currentRowLocation == null) {
                        if (this.statementContext != null) {
                            this.lcc.popStatementContext(this.statementContext, t);
                        }
                        if (this.lcc != null && this.popLCCContext) {
                            this.lcc.popMe();
                        }
                        if (this.contextSet) {
                            this.conn.getTR().restoreContextStack();
                        }
                    }
                }
                if ((observer = GfxdEvictionCriteria.this.evictionObserver) != null) {
                    LocalRegion region = this.container.getRegion();
                    observer.keyReturnedForEviction(key, routingObject, this.currentMillis, (Region<Object, Object>)region);
                    if (this.currentRowLocation == null) {
                        observer.onIterationComplete((Region<Object, Object>)region);
                    }
                }
                this.entry.setReusableKey(key);
                this.entry.setReusableValue((Object)routingObject);
                return this.entry;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void release() {
            if (this.lcc != null) {
                ((GemFireTransaction)this.lcc.getTransactionExecute()).release();
            }
        }
    }

    public static interface Observer {
        public void keyReturnedForEviction(Object var1, Object var2, long var3, Region<Object, Object> var5);

        public void onIterationComplete(Region<Object, Object> var1);

        public void onDoEvictCompare(EntryEventImpl var1);
    }
}

