/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;

class SavepointConstantAction
extends DDLConstantAction {
    private final String savepointName;
    private final int savepointStatementType;

    SavepointConstantAction(String savepointName, int savepointStatementType) {
        this.savepointName = savepointName;
        this.savepointStatementType = savepointStatementType;
    }

    public String toString() {
        if (this.savepointStatementType == 1) {
            return this.constructToString("SAVEPOINT ", this.savepointName + " ON ROLLBACK RETAIN CURSORS ON ROLLBACK RETAIN LOCKS");
        }
        if (this.savepointStatementType == 2) {
            return this.constructToString("ROLLBACK WORK TO SAVEPOINT ", this.savepointName);
        }
        return this.constructToString("RELEASE TO SAVEPOINT ", this.savepointName);
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        StatementContext stmtCtxt = lcc.getStatementContext();
        if (stmtCtxt != null && stmtCtxt.inTrigger()) {
            throw StandardException.newException("XJ017.S");
        }
        if (this.savepointStatementType == 1) {
            if (this.savepointName.startsWith("SYS")) {
                throw StandardException.newException("42939", "SYS");
            }
            lcc.languageSetSavePoint(this.savepointName, this.savepointName);
        } else if (this.savepointStatementType == 2) {
            lcc.internalRollbackToSavepoint(this.savepointName, true, this.savepointName);
        } else {
            lcc.releaseSavePoint(this.savepointName, this.savepointName);
        }
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public boolean isReplayable() {
        return false;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

