/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TargetResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.types.BinarySQLHybridType;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicNoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericQualifier;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

public abstract class NoPutResultSetImpl
extends BasicNoPutResultSetImpl {
    public final int resultSetNumber;
    private boolean needsRowLocation;
    protected ExecRow clonedExecRow;
    protected TargetResultSet targetResultSet;
    private int[] checkNullCols;
    private int cncLen;

    public NoPutResultSetImpl(Activation activation, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(activation, optimizerEstimatedRowCount, optimizerEstimatedCost);
        SanityManager.ASSERT((activation != null ? 1 : 0) != 0, (String)"activation expected to be non-null");
        SanityManager.ASSERT((resultSetNumber >= 0 ? 1 : 0) != 0, (String)"resultSetNumber expected to be >= 0");
        this.resultSetNumber = resultSetNumber;
    }

    @Override
    public String getCursorName() {
        String cursorName = this.activation.getCursorName();
        if (cursorName == null && this.isForUpdate()) {
            this.activation.setCursorName(this.activation.getLanguageConnectionContext().getUniqueCursorName());
            cursorName = this.activation.getCursorName();
        }
        return cursorName;
    }

    @Override
    public int resultSetNumber() {
        return this.resultSetNumber;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        if (!this.isOpen) {
            return;
        }
        if (this.isTopResultSet) {
            this.closeTopResultSet(cleanupOnError);
        }
        this.localTXState = null;
        this.localTXStateSet = false;
        this.isOpen = false;
    }

    private final void closeTopResultSet(boolean cleanupOnError) throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        if (this.runtimeStatisticsOn && (!lcc.isConnectionForRemote() || this.isLocallyExecuted)) {
            long l = this.endExecutionTime = this.statisticsTimingOn ? XPLAINUtil.currentTimeMillis() : 0L;
            if (this.statisticsTimingOn) {
                this.closeTime = this.getElapsedNanos(this.beginTime);
            }
            ExecutionFactory ef = lcc.getLanguageConnectionFactory().getExecutionFactory();
            if (lcc.getLogQueryPlan() || lcc.getRunTimeStatisticsModeExplicit()) {
                this.logRuntimeStatistics(lcc.getLogQueryPlan(), ef);
            }
            if (!cleanupOnError) {
                this.invokeQueryPlan(ef);
            } else if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)"Invoking query plan capture.");
            }
        }
        if (this.subqueryTrackingArray != null && this.subqueryTrackingArray.length > 0) {
            this.closeSubqueryTrackingArray(cleanupOnError);
        }
        if (!lcc.isConnectionForRemote()) {
            this.resetStatistics();
        }
    }

    private final void logRuntimeStatistics(boolean logPlan, ExecutionFactory ef) throws StandardException {
        HeaderPrintWriter istream;
        this.lcc.setRunTimeStatisticsObject(ef.getResultSetStatisticsFactory().getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray));
        if (logPlan && (istream = Monitor.getStream()) != null) {
            istream.printlnWithHeader("(XID = " + this.lcc.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + this.lcc.getInstanceNumber() + "), " + this.lcc.getRunTimeStatisticsObject().getStatementText() + " ******* " + this.lcc.getRunTimeStatisticsObject().getStatementExecutionPlanText());
        }
    }

    private final void invokeQueryPlan(ExecutionFactory ef) throws StandardException {
        ResultSetStatisticsVisitor visitor = ef.getXPLAINFactory().getXPLAINVisitor(this.lcc, this.statsEnabled, this.explainConnection);
        visitor.doXPLAIN(this, this.activation, true, this.statisticsTimingOn, this.isLocallyExecuted);
        this.executionPlanID = visitor.getStatementUUID();
        if (this.observer != null) {
            this.observer.afterQueryPlanGeneration();
        }
    }

    private final void closeSubqueryTrackingArray(boolean cleanupOnError) throws StandardException {
        int staLength = this.subqueryTrackingArray.length;
        for (int index = 0; index < staLength; ++index) {
            if (this.subqueryTrackingArray[index] == null || this.subqueryTrackingArray[index].isClosed()) continue;
            this.subqueryTrackingArray[index].close(cleanupOnError);
        }
    }

    @Override
    public void setTargetResultSet(TargetResultSet trs) {
        this.targetResultSet = trs;
    }

    @Override
    public void setNeedsRowLocation(boolean needsRowLocation) {
        this.needsRowLocation = needsRowLocation;
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public ExecRow getNextRowFromRowSource() throws StandardException {
        ExecRow execRow = this.getNextRowCore();
        if (execRow != null) {
            this.clonedExecRow = this.targetResultSet.preprocessSourceRow(execRow);
            return execRow;
        }
        return null;
    }

    @Override
    public boolean needsToClone() {
        return true;
    }

    @Override
    public void closeRowSource() {
    }

    @Override
    public boolean needsRowLocation() {
        return this.needsRowLocation;
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
        this.targetResultSet.changedRow(this.clonedExecRow, rl);
    }

    protected void clearOrderableCache(Qualifier[][] qualifiers) throws StandardException {
        if (qualifiers != null) {
            for (int term = 0; term < qualifiers.length; ++term) {
                for (int index = 0; index < qualifiers[term].length; ++index) {
                    Qualifier qual = qualifiers[term][index];
                    qual.clearOrderableCache();
                    if (((GenericQualifier)qual).variantType == 0) continue;
                    qual.getOrderable();
                }
            }
        }
    }

    @Override
    public final void setCurrentRow(ExecRow row) {
        this.activation.setCurrentRow(row, this.resultSetNumber);
        this.currentRow = row;
    }

    @Override
    public void clearCurrentRow() {
        this.currentRow = null;
        this.activation.clearCurrentRow(this.resultSetNumber);
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }

    protected boolean skipScan(ExecIndexRow startPosition, ExecIndexRow stopPosition) throws StandardException {
        int position;
        int nStartCols = startPosition == null ? 0 : startPosition.nColumns();
        int nStopCols = stopPosition == null ? 0 : stopPosition.nColumns();
        boolean startKeyLonger = false;
        int size = nStopCols;
        if (nStartCols > nStopCols) {
            startKeyLonger = true;
            size = nStartCols;
        }
        if (size == 0) {
            return false;
        }
        if (this.checkNullCols == null || this.checkNullCols.length < size) {
            this.checkNullCols = new int[size];
        }
        this.cncLen = 0;
        boolean returnValue = false;
        for (position = 0; position < nStartCols; ++position) {
            if (startPosition.areNullsOrdered(position)) continue;
            if (startKeyLonger) {
                this.checkNullCols[this.cncLen++] = position + 1;
            }
            if (!startPosition.getColumn(position + 1).isNull()) continue;
            returnValue = true;
            if (!startKeyLonger) break;
        }
        if (startKeyLonger && returnValue) {
            return true;
        }
        for (position = 0; position < nStopCols; ++position) {
            if (stopPosition.areNullsOrdered(position)) continue;
            if (!startKeyLonger) {
                this.checkNullCols[this.cncLen++] = position + 1;
            }
            if (returnValue || !stopPosition.getColumn(position + 1).isNull()) continue;
            returnValue = true;
            if (startKeyLonger) break;
        }
        return returnValue;
    }

    protected final boolean skipRow(ExecRow row) throws StandardException {
        int cncLen = this.cncLen;
        if (cncLen == 0) {
            return false;
        }
        for (int i = 0; i < cncLen; ++i) {
            if (row.isNull(this.checkNullCols[i]) != -7L) continue;
            return true;
        }
        return false;
    }

    public static String printQualifiers(Qualifier[][] qualifiers, boolean addNewLine) {
        String idt = "";
        String output = "";
        if (qualifiers == null) {
            return idt + MessageService.getTextMessage("42Z37.U");
        }
        for (int term = 0; term < qualifiers.length; ++term) {
            for (int i = 0; i < qualifiers[term].length; ++i) {
                Qualifier qual = qualifiers[term][i];
                boolean negateOp = qual.negateCompareResult();
                output = idt + output + MessageService.getTextMessage("42Z48.U", String.valueOf(term), String.valueOf(i)) + ": " + (qual.getColumnName() != null ? qual.getColumnName() : Integer.valueOf(qual.getColumnId())) + (addNewLine ? " \n" : "  ");
                int operator = qual.getOperator();
                String opString = null;
                switch (operator) {
                    case 2: {
                        opString = negateOp ? "<>" : "=";
                        break;
                    }
                    case 3: {
                        opString = negateOp ? ">" : "<=";
                        break;
                    }
                    case 1: {
                        opString = negateOp ? ">=" : "<";
                        break;
                    }
                    default: {
                        SanityManager.THROWASSERT((String)("Unknown operator " + operator));
                        opString = "unknown value (" + operator + ")";
                    }
                }
                try {
                    DataValueDescriptor desc = qual.getOrderable();
                    boolean printValue = false;
                    if (desc != null) {
                        if (desc instanceof BinarySQLHybridType) {
                            desc = ((BinarySQLHybridType)desc).getSQLValue();
                        }
                        if (!BinarySQLHybridType.isStringType(desc.getTypeFormatId()) && !BinarySQLHybridType.isBinaryType(desc.getTypeFormatId())) {
                            printValue = true;
                        } else if (desc instanceof SQLChar) {
                            char firstChar;
                            char[] descChars = ((SQLChar)desc).getCharArray();
                            if (descChars != null && (firstChar = ((SQLChar)desc).getCharArray()[0]) >= ' ' && firstChar < '\uffff') {
                                printValue = true;
                            }
                        } else {
                            printValue = true;
                        }
                    }
                    if (printValue) {
                        opString = opString + " " + desc.getString();
                    }
                }
                catch (StandardException e) {
                    e.printStackTrace();
                }
                output = output + idt + MessageService.getTextMessage("42Z43.U") + ": " + opString + (addNewLine ? "\n" : "  ") + idt + MessageService.getTextMessage("42Z44.U") + ": " + qual.getOrderedNulls() + (addNewLine ? "\n" : "  ") + idt + MessageService.getTextMessage("42Z45.U") + ": " + qual.getUnknownRV() + (addNewLine ? "\n" : "  ");
            }
        }
        return output;
    }

    @Override
    public void updateRow(ExecRow row) throws StandardException {
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
    }

    public abstract void printResultSetHierarchy();
}

