/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.catalog.types.ReferencedColumnsDescriptorImpl;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableArrayHolder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableIntHolder;
import com.pivotal.gemfirexd.internal.iapi.services.io.Storable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.BackingStoreHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.KeyHasher;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

class HashTableResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public long restrictionTime;
    public long projectionTime;
    public int hashtableSize;
    public Properties scanProperties;
    public NoPutResultSet source;
    public GeneratedMethod singleTableRestriction;
    public Qualifier[][] nextQualifiers;
    private GeneratedMethod projection;
    private int[] projectMapping;
    protected boolean runTimeStatsOn;
    private ExecRow mappedResultRow;
    public boolean reuseResult;
    public int[] keyColumns;
    protected boolean removeDuplicates;
    protected long maxInMemoryRowCount;
    protected int initialCapacity;
    protected float loadFactor;
    protected boolean skipNullKeyColumns;
    protected boolean firstNext = true;
    protected int numFetchedOnNext;
    protected int entryVectorSize;
    protected List entryVector;
    private boolean hashTableBuilt;
    private boolean firstIntoHashtable = true;
    protected ExecRow nextCandidate;
    private ExecRow projRow;
    protected BackingStoreHashtable ht;
    private List rakVector;

    HashTableResultSet(NoPutResultSet s, Activation a, GeneratedMethod str, Qualifier[][] nextQualifiers, GeneratedMethod p, int resultSetNumber, int mapRefItem, boolean reuseResult, int keyColItem, boolean removeDuplicates, long maxInMemoryRowCount, int initialCapacity, float loadFactor, boolean skipNullKeyColumns, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = s;
        SanityManager.ASSERT((this.source != null ? 1 : 0) != 0, (String)"HTRS(), source expected to be non-null");
        this.singleTableRestriction = str;
        this.nextQualifiers = nextQualifiers;
        this.projection = p;
        this.projectMapping = ((ReferencedColumnsDescriptorImpl)a.getSavedObject(mapRefItem)).getReferencedColumnPositions();
        FormatableArrayHolder fah = (FormatableArrayHolder)a.getSavedObject(keyColItem);
        FormatableIntHolder[] fihArray = (FormatableIntHolder[])fah.getArray(FormatableIntHolder.class);
        this.keyColumns = new int[fihArray.length];
        for (int index = 0; index < fihArray.length; ++index) {
            this.keyColumns[index] = fihArray[index].getInt();
        }
        this.reuseResult = reuseResult;
        this.removeDuplicates = removeDuplicates;
        this.maxInMemoryRowCount = maxInMemoryRowCount;
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.skipNullKeyColumns = skipNullKeyColumns;
        if (this.projection == null) {
            this.mappedResultRow = this.activation.getExecutionFactory().getValueRow(this.projectMapping.length);
        }
        this.runTimeStatsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.initLocalTXState();
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((this.source != null ? 1 : 0) != 0, (String)"HTRS().openCore(), source expected to be non-null");
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"HashTableResultSet already open");
        this.isOpen = true;
        if (!this.hashTableBuilt) {
            this.source.openCore();
            this.ht = this.getBackingStoreHashtable();
            this.checkCancellationFlag();
            if (this.runTimeStatsOn) {
                this.hashtableSize = this.ht.size();
                if (this.scanProperties == null) {
                    this.scanProperties = new Properties();
                }
                try {
                    if (this.ht != null) {
                        this.ht.getAllRuntimeStats(this.scanProperties);
                    }
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
            }
            this.hashTableBuilt = true;
        }
        this.resetProbeVariables();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"HashTableResultSet already open");
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.resetProbeVariables();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    protected void resetProbeVariables() throws StandardException {
        this.firstNext = true;
        this.numFetchedOnNext = 0;
        this.entryVector = null;
        this.rakVector = null;
        this.entryVectorSize = 0;
        if (this.nextQualifiers != null) {
            this.clearOrderableCache(this.nextQualifiers);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        this.checkCancellationFlag();
        ExecRow result = null;
        DataValueDescriptor[] columns = null;
        Object rak = null;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            do {
                if (this.firstNext) {
                    Object hashEntry;
                    this.firstNext = false;
                    if (this.keyColumns.length == 1) {
                        hashEntry = this.ht.get(this.nextQualifiers[0][0].getOrderable());
                        rak = this.ht.getFromRegionAndKeyHash(this.nextQualifiers[0][0].getOrderable());
                    } else {
                        KeyHasher mh = new KeyHasher(this.keyColumns.length);
                        for (int index = 0; index < this.keyColumns.length; ++index) {
                            mh.setObject(index, this.nextQualifiers[0][index].getOrderable());
                        }
                        if (mh == null) {
                            hashEntry = null;
                        } else {
                            hashEntry = this.ht.get(mh);
                            rak = this.ht.getFromRegionAndKeyHash(mh);
                        }
                    }
                    if (hashEntry instanceof List) {
                        this.entryVector = (List)hashEntry;
                        this.entryVectorSize = this.entryVector.size();
                        columns = (DataValueDescriptor[])this.entryVector.get(0);
                        if (rak != null) {
                            assert (rak instanceof List);
                            this.rakVector = (List)rak;
                            rak = this.rakVector.get(0);
                        }
                    } else {
                        this.entryVector = null;
                        this.entryVectorSize = 0;
                        this.rakVector = null;
                        columns = (DataValueDescriptor[])hashEntry;
                    }
                } else if (this.numFetchedOnNext < this.entryVectorSize) {
                    columns = (DataValueDescriptor[])this.entryVector.get(this.numFetchedOnNext);
                    if (this.rakVector != null) {
                        rak = (RegionAndKey)this.rakVector.get(this.numFetchedOnNext);
                    }
                }
                if (columns != null) {
                    int index;
                    for (int i = 0; i < columns.length; ++i) {
                        if (columns[0] instanceof Storable) continue;
                        SanityManager.THROWASSERT((String)("columns[" + i + "] expected to be Storable, not " + columns[i].getClass().getName()));
                    }
                    boolean qualifies = true;
                    SanityManager.ASSERT((this.nextQualifiers.length == 1 ? 1 : 0) != 0);
                    for (index = 0; index < this.nextQualifiers[0].length; ++index) {
                        Qualifier q = this.nextQualifiers[0][index];
                        qualifies = columns[q.getColumnId()].compare(q.getOperator(), q.getOrderable(), q.getOrderedNulls(), q.getUnknownRV());
                        if (q.negateCompareResult()) {
                            boolean bl = qualifies = !qualifies;
                        }
                        if (!qualifies) break;
                    }
                    if (qualifies) {
                        for (index = 0; index < columns.length; ++index) {
                            this.nextCandidate.setColumn(index + 1, columns[index]);
                        }
                        if (this.nextCandidate != null) {
                            this.nextCandidate.clearAllRegionAndKeyInfo();
                        }
                        result = this.doProjection(this.nextCandidate);
                    } else {
                        result = null;
                    }
                    ++this.numFetchedOnNext;
                    continue;
                }
                result = null;
            } while (result == null && this.numFetchedOnNext < this.entryVectorSize);
        }
        this.setCurrentRow(result);
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        if (this.runTimeStatsOn) {
            if (!this.isTopResultSet) {
                StatementContext sc = this.activation.getLanguageConnectionContext().getStatementContext();
                this.subqueryTrackingArray = sc.getSubqueryTrackingArray();
            }
            if (this.statisticsTimingOn) {
                this.nextTime += this.getElapsedNanos(this.beginTime);
            }
        }
        if (result != null) {
            if (rak != null) {
                assert (rak instanceof RegionAndKey);
                result.addRegionAndKey((RegionAndKey)rak);
            }
            if (this.localTXState != null && this.isTopResultSet && this.isForUpdate()) {
                this.updateRowLocationPostRead();
            }
        }
        return result;
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close(cleanupOnError);
            super.close(cleanupOnError);
            if (this.hashTableBuilt) {
                this.ht.close();
                this.ht = null;
                this.hashTableBuilt = false;
            }
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of ProjectRestrictResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        SanityManager.ASSERT((boolean)(this.source instanceof CursorResultSet), (String)"source not instance of CursorResultSet");
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        ExecRow candidateRow = null;
        ExecRow result = null;
        boolean restrict = false;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"PRRS is expected to be open");
        if (this.currentRow == null) {
            return null;
        }
        candidateRow = ((CursorResultSet)((Object)this.source)).getCurrentRow();
        if (candidateRow != null) {
            this.setCurrentRow(candidateRow);
            DataValueDescriptor restrictBoolean = (DataValueDescriptor)(this.singleTableRestriction == null ? null : this.singleTableRestriction.invoke(this.activation));
            boolean bl = restrict = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
        }
        if (candidateRow != null && restrict) {
            result = this.doProjection(candidateRow);
        }
        this.currentRow = result;
        if (result == null) {
            this.clearCurrentRow();
        }
        return this.currentRow;
    }

    protected ExecRow doProjection(ExecRow sourceRow) throws StandardException {
        if (this.reuseResult && this.projRow != null) {
            return this.projRow;
        }
        ExecRow result = this.projection != null ? (ExecRow)this.projection.invoke(this.activation) : this.mappedResultRow;
        for (int index = 0; index < this.projectMapping.length; ++index) {
            if (this.projectMapping[index] == -1) continue;
            result.setColumn(index + 1, sourceRow.getColumn(this.projectMapping[index]));
        }
        this.setCurrentRow(result);
        if (this.reuseResult) {
            this.projRow = result;
        }
        return result;
    }

    @Override
    public ExecRow getNextRowFromRowSource() throws StandardException {
        ExecRow execRow = this.source.getNextRowCore();
        while (execRow != null) {
            boolean restrict = false;
            ++this.rowsSeen;
            DataValueDescriptor restrictBoolean = (DataValueDescriptor)(this.singleTableRestriction == null ? null : this.singleTableRestriction.invoke(this.activation));
            boolean bl = restrict = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
            if (!restrict) {
                execRow = this.source.getNextRowCore();
                continue;
            }
            if (this.targetResultSet != null) {
                this.clonedExecRow = this.targetResultSet.preprocessSourceRow(execRow);
            }
            if (this.firstIntoHashtable) {
                this.nextCandidate = this.activation.getExecutionFactory().getValueRow(execRow.nColumns());
                this.firstIntoHashtable = false;
            }
            return execRow;
        }
        return null;
    }

    @Override
    public boolean isForUpdate() {
        if (this.source == null) {
            return false;
        }
        return this.source.isForUpdate();
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.source.updateRowLocationPostRead();
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        this.source.filteredRowLocationPostRead(localTXState);
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        int noChildren = 0;
        if (this.source != null) {
            ++noChildren;
        }
        if (this.subqueryTrackingArray != null) {
            noChildren += this.subqueryTrackingArray.length;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.source != null) {
            this.source.accept(visitor);
        }
        if (this.subqueryTrackingArray != null) {
            for (int index = 0; index < this.subqueryTrackingArray.length; ++index) {
                if (this.subqueryTrackingArray[index] == null) continue;
                this.subqueryTrackingArray[index].accept(visitor);
            }
        }
    }

    @Override
    public void resetStatistics() {
        this.restrictionTime = 0L;
        this.projectionTime = 0L;
        this.hashtableSize = 0;
        super.resetStatistics();
        this.source.resetStatistics();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "HASHTABLE");
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    public Iterator hashTableIterator() throws StandardException {
        if (this.isOpen && this.hashTableBuilt) {
            return this.ht.valuesIterator();
        }
        return null;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null ? this.source.resultSetNumber() : -1)));
        }
    }

    protected BackingStoreHashtable getBackingStoreHashtable() throws StandardException {
        TransactionController tc = this.activation.getTransactionController();
        return new BackingStoreHashtable(tc, this, this.keyColumns, this.removeDuplicates, (int)this.optimizerEstimatedRowCount, this.maxInMemoryRowCount, this.initialCapacity, this.loadFactor, this.skipNullKeyColumns, false);
    }

    public boolean moreRowsExpected() {
        return false;
    }

    public boolean fillUpHashTable() throws StandardException {
        SanityManager.THROWASSERT((String)"Should be called for derived class");
        return false;
    }

    public void purgeHashTable() {
        SanityManager.THROWASSERT((String)"Should be called for derived class");
    }
}

