/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Parser;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SPSDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CompilerContextImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CreateTriggerNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DMLModStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLSingleTableConstantAction;
import java.sql.Timestamp;
import java.util.List;

public class CreateTriggerConstantAction
extends DDLSingleTableConstantAction {
    private String triggerName;
    private String triggerSchemaName;
    private TableDescriptor triggerTable;
    private UUID triggerTableId;
    private int eventMask;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private boolean referencingOld;
    private boolean referencingNew;
    private UUID whenSPSId;
    private String whenText;
    private UUID actionSPSId;
    private String actionText;
    private String originalActionText;
    private String oldReferencingName;
    private String newReferencingName;
    private UUID spsCompSchemaId;
    private Timestamp creationTimestamp;
    private int[] referencedCols;
    private String gfxdIMActionText;
    private List<CreateTriggerNode.GfxdIMParamInfo> gfxdIMparaminfovec;

    CreateTriggerConstantAction(String triggerSchemaName, String triggerName, int eventMask, boolean isBefore, boolean isRow, boolean isEnabled, TableDescriptor triggerTable, UUID whenSPSId, String whenText, UUID actionSPSId, String actionText, UUID spsCompSchemaId, Timestamp creationTimestamp, int[] referencedCols, String originalActionText, boolean referencingOld, boolean referencingNew, String oldReferencingName, String newReferencingName) {
        super(triggerTable.getUUID());
        this.triggerName = triggerName;
        this.triggerSchemaName = triggerSchemaName;
        this.triggerTable = triggerTable;
        this.eventMask = eventMask;
        this.isBefore = isBefore;
        this.isRow = isRow;
        this.isEnabled = isEnabled;
        this.whenSPSId = whenSPSId;
        this.whenText = whenText;
        this.actionSPSId = actionSPSId;
        this.actionText = actionText;
        this.spsCompSchemaId = spsCompSchemaId;
        this.creationTimestamp = creationTimestamp;
        this.referencedCols = referencedCols;
        this.originalActionText = originalActionText;
        this.referencingOld = referencingOld;
        this.referencingNew = referencingNew;
        this.oldReferencingName = oldReferencingName;
        this.newReferencingName = newReferencingName;
        SanityManager.ASSERT((triggerSchemaName != null ? 1 : 0) != 0, (String)"triggerSchemaName sd is null");
        SanityManager.ASSERT((triggerName != null ? 1 : 0) != 0, (String)"trigger name is null");
        SanityManager.ASSERT((triggerTable != null ? 1 : 0) != 0, (String)"triggerTable is null");
        SanityManager.ASSERT((actionText != null ? 1 : 0) != 0, (String)"actionText is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        String tabName;
        SPSDescriptor whenspsd = null;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        SchemaDescriptor triggerSd = this.getSchemaDescriptorForCreate(dd, activation, this.triggerSchemaName);
        if (this.spsCompSchemaId == null) {
            SchemaDescriptor def = lcc.getDefaultSchema();
            if (def.getUUID() == null) {
                def = dd.getSchemaDescriptor(def.getDescriptorName(), tc, false);
            }
            if (def != null) {
                this.spsCompSchemaId = def.getUUID();
            }
        }
        if (this.triggerTable != null) {
            this.triggerTableId = this.triggerTable.getUUID();
            tabName = this.triggerTable.getName();
        } else {
            tabName = "with UUID " + this.triggerTableId;
        }
        this.triggerTable = dd.getTableDescriptor(this.triggerTableId);
        if (this.triggerTable == null) {
            throw StandardException.newException("X0X05.S", tabName);
        }
        lcc.verifyNoOpenResultSets(null, this.triggerTable, 28);
        this.lockTableForDDL(tc, this.triggerTable.getHeapConglomerateId(), true);
        this.triggerTable = dd.getTableDescriptor(this.triggerTableId);
        if (this.triggerTable == null) {
            throw StandardException.newException("X0X05.S", tabName);
        }
        dm.invalidateFor(this.triggerTable, 28, lcc);
        UUID tmpTriggerId = dd.getUUIDFactory().createUUID();
        this.actionSPSId = this.actionSPSId == null ? dd.getUUIDFactory().createUUID() : this.actionSPSId;
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        TriggerDescriptor triggerd = ddg.newTriggerDescriptor(triggerSd, tmpTriggerId, this.triggerName, this.eventMask, this.isBefore, this.isRow, this.isEnabled, this.triggerTable, whenspsd == null ? null : whenspsd.getUUID(), this.actionSPSId, this.creationTimestamp == null ? new Timestamp(System.currentTimeMillis()) : this.creationTimestamp, this.referencedCols, this.originalActionText, this.referencingOld, this.referencingNew, this.oldReferencingName, this.newReferencingName);
        dd.addDescriptor(triggerd, triggerSd, 13, false, tc);
        this.storeViewTriggerDependenciesOnPrivileges(activation, triggerd);
        CompilerContext cc = null;
        GfxdIndexManager indexManager = GfxdIndexManager.getGfxdIndexManager(this.triggerTable, lcc);
        if (lcc != null) {
            try {
                cc = (CompilerContext)lcc.getContextManager().getContext("CompilerContext");
                CompilerContextImpl cimpl = (CompilerContextImpl)cc;
                Dependent origDependent = cimpl.getCurrentDependent();
                cimpl.setCurrentDependent(triggerd);
                Parser p = cc.getParser();
                StatementNode st = null;
                try {
                    st = p.parseStatement(this.originalActionText);
                }
                finally {
                    cc.setCurrentDependent(origDependent);
                }
                if (st instanceof DMLModStatementNode) {
                    LocalRegion thisRegion;
                    TableName targetTabName = ((DMLModStatementNode)st).getTargetTable();
                    LocalRegion targetRegion = (LocalRegion)Misc.getRegionForTableByPath(targetTabName.getFullTableName(), false);
                    if (targetRegion == (thisRegion = (LocalRegion)Misc.getRegionForTableByPath(Misc.getRegionPath(this.triggerTable, lcc), true))) {
                        throw StandardException.newException("0A000.S", "cannot define triggers such that it modifies itself");
                    }
                    if (targetRegion != null) {
                        GfxdIndexManager targetIM = (GfxdIndexManager)targetRegion.getIndexUpdater();
                        if (targetIM.hasThisTableAsTarget(Misc.getRegionPath(this.triggerTable, lcc))) {
                            throw StandardException.newException("0A000.S", "two tables cannot have triggers such that they act on each other");
                        }
                        indexManager.addTriggerTargetTableName(targetTabName.getFullTableNameAsRegionPath());
                    }
                }
            }
            finally {
                if (cc != null) {
                    lcc.popCompilerContext(cc);
                }
            }
        }
        if (indexManager != null) {
            indexManager.addTriggerExecutor(triggerd, this.gfxdIMActionText, this.gfxdIMparaminfovec);
        }
    }

    public String toString() {
        return this.constructToString("CREATE TRIGGER ", this.triggerName);
    }

    @Override
    public final String getSchemaName() {
        return this.triggerTable.getSchemaName();
    }

    @Override
    public final String getTableName() {
        return this.triggerTable.getName();
    }

    @Override
    public final String getObjectName() {
        return this.triggerName;
    }

    public void setGfxdActionText(String gfxdActionText) {
        this.gfxdIMActionText = gfxdActionText;
    }

    public void setParamInfos(List<CreateTriggerNode.GfxdIMParamInfo> gfxdparaminfovec) {
        this.gfxdIMparaminfovec = gfxdparaminfovec;
    }
}

