/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.types.DefaultInfoImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.sql.compile.DistributionDefinitionNode;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizableList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizerFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Parser;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RequiredRowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DefaultDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AllResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BitConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BooleanConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CharConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectAndEliminateColumnsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CursorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DMLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NormalizeResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OptimizerImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RowResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Set;
import java.util.Vector;

public abstract class ResultSetNode
extends QueryTreeNode {
    int resultSetNumber;
    JBitSet referencedTableMap;
    ResultColumnList resultColumns;
    boolean statementResultSet;
    boolean cursorTargetTable;
    boolean insertSource;
    CostEstimate costEstimate;
    CostEstimate scratchCostEstimate;
    Optimizer optimizer;
    CostEstimate finalCostEstimate;
    protected boolean eliminateExtraColumns = false;
    private DistributionDefinitionNode distributionNode;

    public ResultSetNode() {
    }

    public ResultSetNode(ResultSetNode other) {
        super(other);
        try {
            if (other.resultColumns != null) {
                this.resultColumns = other.resultColumns.copyListAndObjects();
            }
            if (other.getReferencedTableMap() != null) {
                this.referencedTableMap = (JBitSet)other.getReferencedTableMap().clone();
            }
        }
        catch (StandardException e) {
            SanityManager.THROWASSERT((Throwable)e);
        }
        this.eliminateExtraColumns = other.eliminateExtraColumns;
    }

    @Override
    public String toString() {
        return "resultSetNumber: " + this.resultSetNumber + "\n" + "referencedTableMap: " + (this.referencedTableMap != null ? this.referencedTableMap.toString() : "null") + "\n" + "statementResultSet: " + this.statementResultSet + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.resultColumns != null) {
            this.printLabel(depth, "resultColumns: ");
            this.resultColumns.treePrint(depth);
        }
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public CostEstimate getCostEstimate() {
        if (this.costEstimate == null) {
            SanityManager.THROWASSERT((String)("costEstimate is not expected to be null for " + this.getClass().getName()));
        }
        return this.costEstimate;
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate == null) {
            SanityManager.THROWASSERT((String)("finalCostEstimate is not expected to be null for " + this.getClass().getName()));
        }
        return this.finalCostEstimate;
    }

    public void assignResultSetNumber() throws StandardException {
        this.resultSetNumber = this.getCompilerContext().getNextResultSetNumber();
        this.resultColumns.setResultSetNumber(this.resultSetNumber);
    }

    public void assignResultSetNumber(int rsNum) throws StandardException {
        this.resultColumns.setResultSetNumber(rsNum);
    }

    public void ncjAssignResultSetNumber(int rsNum) throws StandardException {
        this.resultSetNumber = rsNum;
        this.resultColumns.ncjSetResultSetNumber(rsNum);
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        return this;
    }

    public ResultSetNode bindVTITables(FromList fromListParam) throws StandardException {
        return this;
    }

    public void bindExpressions(FromList fromListParam) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("bindExpressions() is not expected to be called for " + this.getClass().toString()));
    }

    public void eliminateUnUsedColumns(ResultColumnList parentResultColumn, CollectAndEliminateColumnsVisitor finder) throws StandardException {
    }

    public void bindExpressionsWithTables(FromList fromListParam) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("bindExpressionsWithTables() is not expected to be called for " + this.getClass().toString()));
    }

    public void bindTargetExpressions(FromList fromListParam) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("bindTargetExpressions() is not expected to be called for " + this.getClass().toString()));
    }

    void setTableConstructorTypes(ResultColumnList typeColumns) throws StandardException {
        SanityManager.ASSERT((this.resultColumns.visibleSize() <= typeColumns.size() ? 1 : 0) != 0, (String)"More columns in ResultColumnList than in base table");
        int rclSize = this.resultColumns.size();
        for (int index = 0; index < rclSize; ++index) {
            TypeId colTypeId;
            ResultColumn typeCol;
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(index);
            ValueNode re = rc.getExpression();
            if (re.requiresTypeFromContext()) {
                typeCol = (ResultColumn)typeColumns.elementAt(index);
                re.setType(typeCol.getTypeServices());
                continue;
            }
            if (re instanceof CharConstantNode) {
                typeCol = (ResultColumn)typeColumns.elementAt(index);
                colTypeId = typeCol.getTypeId();
                if (colTypeId.isStringTypeId()) {
                    if (colTypeId.getJDBCTypeId() == 1) continue;
                    int maxWidth = re.getTypeServices().getMaximumWidth();
                    re.setType(new DataTypeDescriptor(colTypeId, true, maxWidth));
                    continue;
                }
                if (!colTypeId.isBitTypeId()) continue;
                if (colTypeId.getJDBCTypeId() == -3) {
                    TypeId tId = TypeId.getBuiltInTypeId(12);
                    re.setType(new DataTypeDescriptor(tId, true));
                    typeColumns.setElementAt(typeCol, index);
                    continue;
                }
                if (colTypeId.getJDBCTypeId() != -4) continue;
                TypeId tId = TypeId.getBuiltInTypeId(-1);
                re.setType(new DataTypeDescriptor(tId, true));
                typeColumns.setElementAt(typeCol, index);
                continue;
            }
            if (!(re instanceof BitConstantNode)) continue;
            typeCol = (ResultColumn)typeColumns.elementAt(index);
            colTypeId = typeCol.getTypeId();
            if (colTypeId.isBitTypeId()) {
                if (colTypeId.getJDBCTypeId() == -2 || colTypeId.getJDBCTypeId() == 2004) continue;
                int maxWidth = re.getTypeServices().getMaximumWidth();
                re.setType(new DataTypeDescriptor(colTypeId, true, maxWidth));
                continue;
            }
            if (!colTypeId.isStringTypeId()) continue;
            if (colTypeId.getJDBCTypeId() == 12) {
                TypeId tId = TypeId.getBuiltInTypeId(-3);
                re.setType(new DataTypeDescriptor(tId, true));
                typeColumns.setElementAt(typeCol, index);
                continue;
            }
            if (colTypeId.getJDBCTypeId() != -1) continue;
            TypeId tId = TypeId.getBuiltInTypeId(-4);
            re.setType(new DataTypeDescriptor(tId, true));
            typeColumns.setElementAt(typeCol, index);
        }
    }

    public void setInsertSource() {
        this.insertSource = true;
    }

    public void verifySelectStarSubquery(FromList outerFromList, int subqueryType) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("verifySelectStarSubquery() is not expected to be called for " + this.getClass().toString()));
    }

    public ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        SanityManager.THROWASSERT((String)("getAllResultColumns() not expected to be called for " + this.getClass().getName() + this));
        return null;
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        SanityManager.THROWASSERT((String)("getMatchingColumn() not expected to be called for " + this));
        return null;
    }

    public ResultSetNode setResultToBooleanTrueNode(boolean onlyConvertAlls) throws StandardException {
        ResultColumn resultColumn;
        if (this.resultColumns.elementAt(0) instanceof AllResultColumn) {
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, "", null, this.getContextManager());
        } else {
            if (onlyConvertAlls) {
                return this;
            }
            resultColumn = (ResultColumn)this.resultColumns.elementAt(0);
            if (resultColumn.getExpression().isBooleanTrue()) {
                return this;
            }
        }
        BooleanConstantNode booleanNode = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
        resultColumn.setExpression(booleanNode);
        resultColumn.setType(booleanNode.getTypeServices());
        resultColumn.setVirtualColumnId(1);
        this.resultColumns.setElementAt(resultColumn, 0);
        return this;
    }

    public FromList getFromList() throws StandardException {
        return (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
    }

    @Override
    public void disablePrivilegeCollection() {
        super.disablePrivilegeCollection();
        if (this.resultColumns != null) {
            this.resultColumns.disablePrivilegeCollection();
        }
    }

    public void bindResultColumns(FromList fromListParam) throws StandardException {
        this.resultColumns.bindResultColumnsToExpressions();
    }

    public void bindResultColumns(TableDescriptor targetTableDescriptor, FromVTI targetVTI, ResultColumnList targetColumnList, DMLStatementNode statement, FromList fromListParam) throws StandardException {
        if (this instanceof SelectNode) {
            this.resultColumns.expandAllsAndNameColumns(((SelectNode)this).fromList);
        }
        if (targetColumnList != null) {
            this.resultColumns.copyResultColumnNames(targetColumnList);
        }
        if (targetColumnList != null) {
            if (targetTableDescriptor != null) {
                this.resultColumns.bindResultColumnsByName(targetTableDescriptor, statement);
            } else {
                this.resultColumns.bindResultColumnsByName(targetVTI.getResultColumns(), targetVTI, statement);
            }
        } else {
            this.resultColumns.bindResultColumnsByPosition(targetTableDescriptor);
        }
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList rcl) throws StandardException {
    }

    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        SanityManager.THROWASSERT((String)("preprocess() not expected to be called for " + this.getClass().toString()));
        return null;
    }

    void projectResultColumns() throws StandardException {
    }

    public ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        SanityManager.THROWASSERT((String)("ensurePredicateList() not expected to be called for " + this.getClass().toString()));
        return null;
    }

    public ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        SanityManager.THROWASSERT((String)("addNewPredicate() not expected to be called for " + this.getClass().toString()));
        return null;
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        SanityManager.THROWASSERT((String)("flattenableInFromSubquery() not expected to be called for " + this.getClass().toString()));
        return false;
    }

    ResultSetNode genProjectRestrictForReordering() throws StandardException {
        ResultColumnList prRCList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        prRCList.genVirtualColumnNodes(this, this.resultColumns, false);
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, prRCList, null, null, null, null, null, this.getContextManager());
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicates, double outerRows) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("optimize() is not expected to be called for " + this.getClass().toString()));
        return null;
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        return this;
    }

    public ResultSetNode modifyAccessPaths(PredicateList predList) throws StandardException {
        return this.modifyAccessPaths();
    }

    ResultColumnDescriptor[] makeResultDescriptors() {
        return this.resultColumns.makeResultDescriptors();
    }

    boolean columnTypesAndLengthsMatch() throws StandardException {
        return this.resultColumns.columnTypesAndLengthsMatch();
    }

    public void setResultColumns(ResultColumnList newRCL) {
        this.resultColumns = newRCL;
    }

    public ResultColumnList getResultColumns() {
        return this.resultColumns;
    }

    public void setReferencedTableMap(JBitSet newRTM) {
        this.referencedTableMap = newRTM;
    }

    public JBitSet getReferencedTableMap() {
        return this.referencedTableMap;
    }

    public void fillInReferencedTableMap(JBitSet passedMap) {
    }

    public void rejectParameters() throws StandardException {
        if (this.resultColumns != null) {
            this.resultColumns.rejectParameters();
        }
    }

    public void rejectXMLValues() throws StandardException {
        if (this.resultColumns != null) {
            this.resultColumns.rejectXMLValues();
        }
    }

    public void renameGeneratedResultNames() throws StandardException {
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(i);
            if (!rc.isNameGenerated()) continue;
            if (Misc.getMemStore().isSnappyStore()) {
                rc.setName("_c" + Integer.toString(i));
                continue;
            }
            rc.setName(Integer.toString(i + 1));
        }
    }

    public void markStatementResultSet() {
        this.statementResultSet = true;
    }

    public void enhanceRCLForInsert(int numTargetColumns, int[] colMap, DataDictionary dataDictionary, TableDescriptor targetTD, FromVTI targetVTI) throws StandardException {
        ResultColumnList newResultCols = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        for (int index = 0; index < numTargetColumns; ++index) {
            ResultColumn newResultColumn = null;
            newResultColumn = colMap[index] != -1 ? this.resultColumns.getResultColumn(colMap[index] + 1) : this.genNewRCForInsert(targetTD, targetVTI, index + 1, dataDictionary);
            newResultCols.addResultColumn(newResultColumn);
        }
        this.resultColumns = newResultCols;
    }

    ResultColumn genNewRCForInsert(TableDescriptor targetTD, FromVTI targetVTI, int columnNumber, DataDictionary dataDictionary) throws StandardException {
        ResultColumn newResultColumn = null;
        if (targetVTI != null) {
            newResultColumn = targetVTI.getResultColumns().getResultColumn(columnNumber);
            newResultColumn = newResultColumn.cloneMe();
            newResultColumn.setExpressionToNullNode();
        } else {
            ColumnDescriptor colDesc = targetTD.getColumnDescriptor(columnNumber);
            DataTypeDescriptor colType = colDesc.getType();
            DefaultInfoImpl defaultInfo = (DefaultInfoImpl)colDesc.getDefaultInfo();
            if (defaultInfo != null && !colDesc.isAutoincrement()) {
                String defaultText = defaultInfo.getDefaultText();
                ValueNode defaultTree = this.parseDefault(defaultText);
                defaultTree = defaultTree.bindExpression(this.getFromList(), null, null);
                newResultColumn = (ResultColumn)this.getNodeFactory().getNode(80, defaultTree.getTypeServices(), defaultTree, this.getContextManager());
                DefaultDescriptor defaultDescriptor = colDesc.getDefaultDescriptor(dataDictionary);
                SanityManager.ASSERT((defaultDescriptor != null ? 1 : 0) != 0, (String)"defaultDescriptor expected to be non-null");
                this.getCompilerContext().createDependency(defaultDescriptor);
            } else if (colDesc.isAutoincrement()) {
                newResultColumn = (ResultColumn)this.getNodeFactory().getNode(80, colDesc, null, this.getContextManager());
                newResultColumn.setAutoincrementGenerated();
            } else {
                newResultColumn = (ResultColumn)this.getNodeFactory().getNode(80, colType, this.getNullNode(colType), this.getContextManager());
            }
        }
        newResultColumn.markGeneratedForUnmatchedColumnInInsert();
        return newResultColumn;
    }

    public ValueNode parseDefault(String defaultText) throws StandardException {
        CursorNode cn;
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        CompilerContext compilerContext = this.getCompilerContext();
        String values = "VALUES " + defaultText;
        CompilerContext newCC = lcc.pushCompilerContext();
        if (compilerContext.isPreparedStatement()) {
            newCC.setPreparedStatement();
        }
        newCC.allowOptimizeLiteral(false);
        Parser p = newCC.getParser();
        StatementNode qt = p.parseStatement(values);
        if (!(qt instanceof CursorNode)) {
            SanityManager.THROWASSERT((String)("qt expected to be instanceof CursorNode, not " + qt.getClass().getName()));
        }
        if (!((cn = (CursorNode)qt).getResultSetNode() instanceof RowResultSetNode)) {
            SanityManager.THROWASSERT((String)("cn.getResultSetNode() expected to be instanceof RowResultSetNode, not " + cn.getResultSetNode().getClass().getName()));
        }
        ValueNode defaultTree = ((ResultColumn)((CursorNode)qt).getResultSetNode().getResultColumns().elementAt(0)).getExpression();
        lcc.popCompilerContext(newCC);
        return defaultTree;
    }

    public ResultDescription makeResultDescription() {
        ResultColumnDescriptor[] colDescs = this.makeResultDescriptors();
        return this.getExecutionFactory().getResultDescription(colDescs, null);
    }

    boolean isUpdatableCursor(DataDictionary dd) throws StandardException {
        SanityManager.DEBUG((String)"DumpUpdateCheck", (String)"cursor is not a select result set");
        return false;
    }

    FromTable getCursorTargetTable() {
        return null;
    }

    public boolean markAsCursorTargetTable() {
        return false;
    }

    void notCursorTargetTable() {
        this.cursorTargetTable = false;
    }

    public ResultSetNode genProjectRestrict() throws StandardException {
        ResultColumnList prRCList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        prRCList.genVirtualColumnNodes(this, this.resultColumns);
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, prRCList, null, null, null, null, null, this.getContextManager());
    }

    protected ResultSetNode genProjectRestrict(int numTables) throws StandardException {
        return this.genProjectRestrict();
    }

    NormalizeResultSetNode genNormalizeResultSetNode(boolean forUpdate) throws StandardException {
        ResultColumnList prRCList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        prRCList.removeGeneratedGroupingColumns();
        prRCList.genVirtualColumnNodes(this, this.resultColumns);
        NormalizeResultSetNode nrsn = (NormalizeResultSetNode)this.getNodeFactory().getNode(122, this, prRCList, null, forUpdate, this.getContextManager());
        if (this.getReferencedTableMap() != null) {
            nrsn.setReferencedTableMap((JBitSet)this.getReferencedTableMap().clone());
        }
        return nrsn;
    }

    public void generateNormalizationResultSet(ActivationClassBuilder acb, MethodBuilder mb, int resultSetNumber, ResultDescription resultDescription) throws StandardException {
        int erdNumber = acb.addItem(resultDescription);
        mb.push(resultSetNumber);
        mb.push(erdNumber);
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.push(false);
        mb.callMethod((short)185, null, "getNormalizeResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 6);
    }

    public ResultSetNode changeAccessPath() throws StandardException {
        return this;
    }

    public boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return false;
    }

    boolean subqueryReferencesTarget(String name, boolean baseTable) throws StandardException {
        return false;
    }

    public boolean isOneRowResultSet() throws StandardException {
        return false;
    }

    public boolean isNotExists() {
        return false;
    }

    protected Optimizer getOptimizer(OptimizableList optList, OptimizablePredicateList predList, DataDictionary dataDictionary, RequiredRowOrdering requiredRowOrdering) throws StandardException {
        if (this.optimizer == null) {
            OptimizerFactory optimizerFactory = this.getLanguageConnectionContext().getOptimizerFactory();
            this.optimizer = optimizerFactory.getOptimizer(optList, predList, dataDictionary, requiredRowOrdering, this.getCompilerContext().getNumTables(), this.getLanguageConnectionContext());
        }
        this.optimizer.prepForNextRound();
        return this.optimizer;
    }

    protected OptimizerImpl getOptimizerImpl() {
        return (OptimizerImpl)this.optimizer;
    }

    protected CostEstimate getNewCostEstimate() throws StandardException {
        OptimizerFactory optimizerFactory = this.getLanguageConnectionContext().getOptimizerFactory();
        return optimizerFactory.getCostEstimate();
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.resultColumns != null && !v.stopTraversal()) {
            this.resultColumns = (ResultColumnList)this.resultColumns.accept(v);
        }
        return returnNode;
    }

    public ResultSetNode considerMaterialization(JBitSet outerTables) throws StandardException {
        return this;
    }

    public boolean performMaterialization(JBitSet outerTables) throws StandardException {
        return false;
    }

    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        SanityManager.THROWASSERT((String)("getFromTableByName() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    abstract void decrementLevel(int var1);

    void pushOrderByList(OrderByList orderByList) {
        SanityManager.THROWASSERT((String)("pushOrderByList() not expected to be called for " + this.getClass().getName()));
    }

    public void generateResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        System.out.println("I am a " + this.getClass());
        SanityManager.NOTREACHED();
    }

    public int updateTargetLockMode() {
        return 7;
    }

    void notFlattenableJoin() {
    }

    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, Vector fbtVector) throws StandardException {
        return false;
    }

    boolean returnsAtMostOneRow() {
        return false;
    }

    void replaceDefaults(TableDescriptor ttd, ResultColumnList tcl) throws StandardException {
    }

    boolean isPossibleDistinctScan(Set distinctColumns) {
        return false;
    }

    void markForDistinctScan() {
        SanityManager.THROWASSERT((String)("markForDistinctScan() not expected to be called for " + this.getClass().getName()));
    }

    void adjustForSortElimination() {
        SanityManager.THROWASSERT((String)("adjustForSortElimination() not expected to be called for " + this.getClass().getName()));
    }

    void adjustForSortElimination(RequiredRowOrdering rowOrdering) throws StandardException {
        this.adjustForSortElimination();
    }

    protected static final int numDistinctAggregates(Vector aggregateVector) {
        int count = 0;
        int size = aggregateVector.size();
        for (int index = 0; index < size; ++index) {
            if ((count += ((AggregateNode)aggregateVector.elementAt(index)).isDistinct() ? 1 : 0) <= 1) continue;
            count = ResultSetNode.numDistinctAvgAggregate(aggregateVector, index, count);
        }
        return count;
    }

    public JBitSet LOJgetReferencedTables(int numTables) throws StandardException {
        if (this instanceof FromTable && ((FromTable)this).tableNumber != -1) {
            JBitSet map = new JBitSet(numTables);
            map.set(((FromTable)this).tableNumber);
            return map;
        }
        return null;
    }

    public ResultSetNode getInnerMostPRN() {
        SanityManager.THROWASSERT((String)("getInnerMostPRN() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    private static int numDistinctAvgAggregate(Vector aggregateVector, int index, int count) {
        assert (index > 0) : "this check shouldn't be done for the first element.";
        AggregateNode curAgg = (AggregateNode)aggregateVector.elementAt(index);
        AggregateNode prevAgg = (AggregateNode)aggregateVector.elementAt(index - 1);
        if (curAgg.getOperand() == prevAgg.getOperand()) {
            return --count;
        }
        return count;
    }

    public void setDistributionDefinition(DistributionDefinitionNode dnode) {
        this.distributionNode = dnode;
    }

    public DistributionDefinitionNode getDistributionNode() {
        return this.distributionNode;
    }

    public void eliminateExtraColumns() {
        this.eliminateExtraColumns = true;
    }

    public void collectHashKeyColumns(Vector hashKeyVector, int tabNum, int colNum) throws StandardException {
        SanityManager.THROWASSERT((String)("collectHashKeyColumns not expected to be called for " + this.getClass().getName()));
    }

    protected FromBaseTable ncjGetOnlyOneFBTNode() throws StandardException {
        SanityManager.THROWASSERT((String)("ncjGetOnlyOneFBTNode not expected to be called for " + this.getClass().getName()));
        return null;
    }

    protected boolean assertProjectRestrictNode() {
        SanityManager.THROWASSERT((String)("Expected ProjectRestrictNode but got class " + this.getClass().getName()));
        return false;
    }

    protected boolean isJoinNode() {
        return false;
    }
}

