/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectAndEliminateColumnsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RowResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VerifyViewExpressionVisitor;

public class FromSubquery
extends FromTable {
    ResultSetNode subquery;

    @Override
    public void init(Object subquery, Object correlationName, Object derivedRCL, Object tableProperties) {
        super.init(correlationName, tableProperties);
        this.subquery = (ResultSetNode)subquery;
        this.resultColumns = (ResultColumnList)derivedRCL;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.subquery != null) {
            this.printLabel(depth, "subquery: ");
            this.subquery.treePrint(depth + 1);
        }
    }

    public ResultSetNode getSubquery() {
        return this.subquery;
    }

    @Override
    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return super.getFromTableByName(name, schemaName, exactMatch);
    }

    @Override
    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        this.subquery = this.subquery.bindNonVTITables(dataDictionary, fromListParam);
        return this;
    }

    @Override
    public ResultSetNode bindVTITables(FromList fromListParam) throws StandardException {
        this.subquery = this.subquery.bindVTITables(fromListParam);
        return this;
    }

    @Override
    public void rejectParameters() throws StandardException {
        this.subquery.rejectParameters();
    }

    @Override
    public void bindExpressions(FromList fromListParam) throws StandardException {
        FromList emptyFromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        ResultColumnList derivedRCL = this.resultColumns;
        FromList nestedFromList = emptyFromList;
        this.subquery.bindExpressions(nestedFromList);
        this.subquery.bindResultColumns(nestedFromList);
        ResultColumnList subqueryRCL = this.subquery.getResultColumns();
        if (this.resultColumns != null && this.resultColumns.getCountMismatchAllowed() && this.resultColumns.size() < subqueryRCL.size()) {
            for (int index = subqueryRCL.size() - 1; index >= this.resultColumns.size(); --index) {
                subqueryRCL.removeElementAt(index);
            }
        }
        this.subquery.setResultColumns(subqueryRCL.copyListAndObjects());
        subqueryRCL.genVirtualColumnNodes(this.subquery, this.subquery.getResultColumns());
        this.resultColumns = subqueryRCL;
        if (derivedRCL != null) {
            this.resultColumns.propagateDCLInfo(derivedRCL, this.correlationName);
        }
        VerifyViewExpressionVisitor viewHasGroupBy = new VerifyViewExpressionVisitor();
        this.accept(viewHasGroupBy);
        if (viewHasGroupBy.isThrowUnsupportedException()) {
            throw StandardException.newException("0A000.S", " View or FROM-subquery with GroupBy and Partitioned Table");
        }
    }

    @Override
    public void eliminateUnUsedColumns(ResultColumnList parentResultColumn, CollectAndEliminateColumnsVisitor finder) throws StandardException {
        this.subquery.eliminateUnUsedColumns(parentResultColumn, finder);
        this.resultColumns = this.resultColumns.eliminateUnUsedColumns(parentResultColumn, finder);
    }

    @Override
    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        ResultColumn resultColumn = null;
        String columnsTableName = columnReference.getTableName();
        if (columnReference.getGeneratedToReplaceAggregate()) {
            resultColumn = this.resultColumns.getResultColumn(columnReference.getColumnName());
        } else if (columnsTableName == null || columnsTableName.equals(this.correlationName)) {
            resultColumn = this.resultColumns.getAtMostOneResultColumn(columnReference, this.correlationName, false);
        }
        if (resultColumn != null) {
            columnReference.setTableNumber(this.tableNumber);
        }
        return resultColumn;
    }

    @Override
    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.subquery = this.subquery.preprocess(numTables, gbl, fromList);
        if ((gbl == null || gbl.size() == 0) && this.tableProperties == null && this.subquery.flattenableInFromSubquery(fromList)) {
            this.setReferencedTableMap(this.subquery.getReferencedTableMap());
            return this;
        }
        return this.extractSubquery(numTables);
    }

    public ResultSetNode extractSubquery(int numTables) throws StandardException {
        ResultSetNode newPRN = (ResultSetNode)this.getNodeFactory().getNode(151, this.subquery, this.resultColumns, null, null, null, null, this.tableProperties, this.getContextManager());
        JBitSet newJBS = new JBitSet(numTables);
        newJBS.set(this.tableNumber);
        newPRN.setReferencedTableMap(newJBS);
        ((FromTable)newPRN).setTableNumber(this.tableNumber);
        return newPRN;
    }

    @Override
    public FromList flatten(ResultColumnList rcl, PredicateList outerPList, SubqueryList sql, GroupByList gbl) throws StandardException {
        FromList fromList = null;
        this.resultColumns.setRedundant();
        this.subquery.getResultColumns().setRedundant();
        if (this.subquery instanceof SelectNode) {
            SelectNode selectNode = (SelectNode)this.subquery;
            fromList = selectNode.getFromList();
            if (selectNode.getWherePredicates().size() > 0) {
                outerPList.destructiveAppend(selectNode.getWherePredicates());
            }
            if (selectNode.getWhereSubquerys().size() > 0) {
                sql.destructiveAppend(selectNode.getWhereSubquerys());
            }
        } else if (!(this.subquery instanceof RowResultSetNode)) {
            SanityManager.THROWASSERT((String)("subquery expected to be either a SelectNode or a RowResultSetNode, but is a " + this.subquery.getClass().getName()));
        }
        rcl.remapColumnReferencesToExpressions();
        outerPList.remapColumnReferencesToExpressions();
        if (gbl != null) {
            gbl.remapColumnReferencesToExpressions();
        }
        return fromList;
    }

    @Override
    public String getExposedName() {
        return this.correlationName;
    }

    @Override
    public ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        ResultColumnList rcList = null;
        TableName toCompare = allTableName != null ? this.makeTableName(allTableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName);
        if (allTableName != null && !allTableName.equals(toCompare)) {
            return null;
        }
        TableName exposedName = this.makeTableName(null, this.correlationName);
        rcList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int rclSize = this.resultColumns.size();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(index);
            if (resultColumn.isGenerated()) continue;
            String columnName = resultColumn.getName();
            boolean isNameGenerated = resultColumn.isNameGenerated();
            TableName tableName = exposedName;
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, columnName, tableName, this.getContextManager());
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnName, valueNode, this.getContextManager());
            resultColumn.setNameGenerated(isNameGenerated);
            rcList.addResultColumn(resultColumn);
        }
        return rcList;
    }

    @Override
    public void disablePrivilegeCollection() {
        super.disablePrivilegeCollection();
        this.subquery.disablePrivilegeCollection();
    }

    @Override
    public boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return this.subquery.referencesTarget(name, baseTable);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.subquery.referencesSessionSchema();
    }

    @Override
    public void bindUntypedNullsToResultColumns(ResultColumnList bindingRCL) throws StandardException {
        this.subquery.bindUntypedNullsToResultColumns(bindingRCL);
    }

    @Override
    void decrementLevel(int decrement) {
        super.decrementLevel(decrement);
        this.subquery.decrementLevel(decrement);
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = super.accept(v);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.subquery != null) {
            this.subquery = (ResultSetNode)this.subquery.accept(v);
        }
        return returnNode;
    }
}

