/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.pivotal.gemfirexd.internal.engine.ddl.ServerGroupsTableAttribute;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import java.util.Map;

public class CreateAsyncEventListenerNode
extends DDLStatementNode {
    private String id;
    private String className;
    private String initParams;
    public int remoteDs = -1;
    public int socketBufferSize = 524288;
    public boolean manualStart = true;
    public int socketReadTimeout = GatewaySender.DEFAULT_SOCKET_READ_TIMEOUT;
    public boolean isBatchConflationEnabled = false;
    public int batchSize = 100;
    public int batchTimeInterval = 5;
    public boolean isPersistenceEnabled = false;
    private boolean diskSynchronous = false;
    public String diskStoreName;
    public int maximumQueueMemory = 100;
    public int alertThreshold = 0;
    public boolean isParallel;
    private ServerGroupsTableAttribute serverGroups;

    public String getName() {
        return "CreateAsyncEventListener";
    }

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws StandardException {
        this.id = (String)arg1;
        this.className = (String)arg2;
        this.initParams = (String)arg3;
        this.serverGroups = (ServerGroupsTableAttribute)arg4;
        Map attrs = (Map)arg5;
        for (Map.Entry entry : attrs.entrySet()) {
            String key = (String)entry.getKey();
            Object vn = entry.getValue();
            if (key.equalsIgnoreCase("manualstart")) {
                this.manualStart = (Boolean)vn;
                continue;
            }
            if (key.equalsIgnoreCase("enablebatchconflation")) {
                this.isBatchConflationEnabled = (Boolean)vn;
                continue;
            }
            if (key.equalsIgnoreCase("batchsize")) {
                this.batchSize = (Integer)vn;
                continue;
            }
            if (key.equalsIgnoreCase("batchtimeinterval")) {
                this.batchTimeInterval = (Integer)vn;
                continue;
            }
            if (key.equalsIgnoreCase("enablepersistence")) {
                this.isPersistenceEnabled = (Boolean)vn;
                continue;
            }
            if (key.equalsIgnoreCase("disksynchronous")) {
                this.diskSynchronous = (Boolean)vn;
                continue;
            }
            if (key.equalsIgnoreCase("diskstorename")) {
                this.diskStoreName = (String)vn;
                continue;
            }
            if (key.equalsIgnoreCase("maxqueuememory")) {
                this.maximumQueueMemory = (Integer)vn;
                continue;
            }
            if (key.equalsIgnoreCase("alertthreshold")) {
                this.alertThreshold = (Integer)vn;
                continue;
            }
            if (!key.equalsIgnoreCase("isparallel")) continue;
            this.isParallel = (Boolean)vn;
        }
        DistributionDescriptor.checkAvailableDataStore(this.getLanguageConnectionContext(), this.serverGroups != null ? this.serverGroups.getServerGroupSet() : null, "CREATE ASYNCEVENTLISTENER " + this.id);
    }

    @Override
    public ConstantAction makeConstantAction() {
        return this.getGenericConstantActionFactory().getCreateAsyncEventListenerConstantAction(this.id, this.serverGroups, this.manualStart, this.isBatchConflationEnabled, this.batchSize, this.batchTimeInterval, this.isPersistenceEnabled, this.diskSynchronous, this.diskStoreName, this.maximumQueueMemory, this.alertThreshold, this.isParallel, this.className, this.initParams);
    }

    @Override
    public String statementToString() {
        return "CREATE ASYNCEVENTLISTENER";
    }

    public static void dummy() {
    }
}

