/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.PrunedExpressionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.expression.GfxdExprNodeVirtualIDVisitor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CastNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public final class BinaryArithmeticOperatorNode
extends BinaryOperatorNode {
    private boolean isForAVG = false;

    @Override
    public void init(Object leftOperand, Object rightOperand) {
        super.init(leftOperand, rightOperand, "com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue", "com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue");
    }

    @Override
    public void init(Object leftOperand, Object rightOperand, Object isForAVG) {
        super.init(leftOperand, rightOperand, "com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue", "com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue");
        this.isForAVG = true;
    }

    @Override
    public void setNodeType(int nodeType) {
        String operator = null;
        String methodName = null;
        switch (nodeType) {
            case 40: {
                operator = "/";
                methodName = "divide";
                break;
            }
            case 46: {
                operator = "-";
                methodName = "minus";
                break;
            }
            case 48: {
                operator = "+";
                methodName = "plus";
                break;
            }
            case 49: {
                operator = "*";
                methodName = "times";
                break;
            }
            case 194: {
                operator = "mod";
                methodName = "mod";
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Unexpected nodeType = " + nodeType));
            }
        }
        this.setOperator(operator);
        this.setMethodName(methodName);
        super.setNodeType(nodeType);
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        super.bindExpression(fromList, subqueryList, aggregateVector);
        TypeId leftType = this.leftOperand.getTypeId();
        TypeId rightType = this.rightOperand.getTypeId();
        DataTypeDescriptor leftDTS = this.leftOperand.getTypeServices();
        DataTypeDescriptor rightDTS = this.rightOperand.getTypeServices();
        if (leftType.isStringTypeId() && rightType.isNumericTypeId()) {
            boolean nullableResult = leftDTS.isNullable() || rightDTS.isNullable();
            int precision = rightDTS.getPrecision();
            int scale = rightDTS.getScale();
            int maxWidth = rightDTS.getMaximumWidth();
            if (rightType.isDecimalTypeId()) {
                int charMaxWidth = leftDTS.getMaximumWidth();
                scale += charMaxWidth;
                maxWidth = (precision += 2 * charMaxWidth) + 3;
            }
            this.leftOperand = (ValueNode)this.getNodeFactory().getNode(60, this.leftOperand, new DataTypeDescriptor(rightType, precision, scale, nullableResult, maxWidth), this.getContextManager());
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        } else if (rightType.isStringTypeId() && leftType.isNumericTypeId()) {
            boolean nullableResult = leftDTS.isNullable() || rightDTS.isNullable();
            int precision = leftDTS.getPrecision();
            int scale = leftDTS.getScale();
            int maxWidth = leftDTS.getMaximumWidth();
            if (leftType.isDecimalTypeId()) {
                int charMaxWidth = rightDTS.getMaximumWidth();
                scale += charMaxWidth;
                maxWidth = (precision += 2 * charMaxWidth) + 3;
            }
            this.rightOperand = (ValueNode)this.getNodeFactory().getNode(60, this.rightOperand, new DataTypeDescriptor(leftType, precision, scale, nullableResult, maxWidth), this.getContextManager());
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        }
        this.setType(this.leftOperand.getTypeCompiler().resolveArithmeticOperation(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices(), this.isForAVG() ? "avg" : this.operator));
        return this;
    }

    @Override
    public QueryInfo computeQueryInfo(final QueryInfoContext qic) throws StandardException {
        final TableDescriptor[] td = new TableDescriptor[1];
        VisitorAdaptor infoCollector = new VisitorAdaptor(){
            private boolean sameRegionExpression = true;

            @Override
            public boolean skipChildren(Visitable node) throws StandardException {
                return false;
            }

            @Override
            public boolean stopTraversal() {
                return !this.sameRegionExpression;
            }

            @Override
            public Visitable visit(Visitable node) throws StandardException {
                if (node instanceof ColumnReference) {
                    ColumnQueryInfo cqi = (ColumnQueryInfo)((ColumnReference)node).computeQueryInfo(qic);
                    if (td[0] == null) {
                        td[0] = cqi.getTableDescriptor();
                    } else if (!cqi.getSchemaName().equals(td[0].getSchemaName()) || !cqi.getTableName().equals(td[0].getName())) {
                        td[0] = null;
                        this.sameRegionExpression = false;
                    }
                }
                return node;
            }
        };
        GfxdExprNodeVirtualIDVisitor visitor = new GfxdExprNodeVirtualIDVisitor(null, infoCollector, "DML");
        this.accept(visitor);
        TableDescriptor desc = td[0];
        if (desc == null) {
            return QueryInfoConstants.DUMMY;
        }
        Region rgn = Misc.getRegionByPath(desc, this.lcc, true);
        if (rgn.getAttributes().getDataPolicy().withPartitioning()) {
            GfxdPartitionResolver spr = (GfxdPartitionResolver)((PartitionedRegion)rgn).getPartitionResolver();
            String canonicalStr = visitor.getCanonicalizedExpression();
            if (canonicalStr.equals(spr.getCanonicalizedExpression())) {
                return new PrunedExpressionQueryInfo(this.getTypeServices(), (AbstractRegion)rgn, spr, desc.getSchemaName(), desc.getName(), canonicalStr, td[0]);
            }
            return QueryInfoConstants.DUMMY;
        }
        return QueryInfoConstants.DUMMY;
    }

    @Override
    boolean isForAVG() {
        return this.isForAVG;
    }
}

