/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import com.pivotal.gemfirexd.internal.iapi.services.io.LimitReader;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.load.ImportLobFile;
import com.pivotal.gemfirexd.internal.impl.load.LoadError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class ImportClobBase
implements Clob {
    private ImportLobFile lobFile;
    private long position;
    private long length;
    private long clobLength;
    private String clobData = null;

    public ImportClobBase(ImportLobFile lobFile, long position, long length) throws IOException {
        this.lobFile = lobFile;
        this.position = position;
        this.length = length;
        this.clobLength = lobFile.getClobDataLength(position, length);
    }

    public ImportClobBase(String data) {
        this.clobData = data;
        this.clobLength = data.length();
    }

    @Override
    public long length() throws SQLException {
        return this.clobLength;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        try {
            if (this.clobData != null) {
                StringReader ir = new StringReader(this.clobData);
                LimitReader lr = new LimitReader(ir);
                lr.setLimit((int)this.clobLength);
                return lr;
            }
            return this.lobFile.getCharacterStream(this.position, this.length);
        }
        catch (Exception e) {
            throw LoadError.unexpectedError(e);
        }
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public void free() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw Util.notImplemented();
    }
}

