/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import com.pivotal.gemfirexd.internal.iapi.services.io.LimitInputStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.load.ImportLobFile;
import com.pivotal.gemfirexd.internal.impl.load.LoadError;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class ImportBlobBase
implements Blob {
    private ImportLobFile lobFile;
    private long blobPosition;
    private long blobLength;
    private byte[] blobData = null;

    public ImportBlobBase(ImportLobFile lobFile, long position, long length) {
        this.lobFile = lobFile;
        this.blobPosition = position;
        this.blobLength = length;
    }

    public ImportBlobBase(byte[] data) {
        this.blobData = data;
        this.blobLength = data.length;
    }

    @Override
    public long length() throws SQLException {
        return this.blobLength;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            if (this.blobData != null) {
                ByteArrayInputStream fis = new ByteArrayInputStream(this.blobData);
                LimitInputStream limitIn = new LimitInputStream(fis);
                limitIn.setLimit((int)this.blobLength);
                return limitIn;
            }
            return this.lobFile.getBinaryStream(this.blobPosition, this.blobLength);
        }
        catch (Exception e) {
            throw LoadError.unexpectedError(e);
        }
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw LoadError.unexpectedError(new Exception("Method not implemented"));
    }

    @Override
    public void free() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw Util.notImplemented();
    }
}

