/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc.authentication;

import com.pivotal.gemfirexd.auth.callback.CredentialInitializer;
import com.pivotal.gemfirexd.auth.callback.UserAuthenticator;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.SecurityUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Properties;

public final class BasicAuthenticationServiceImpl
extends AuthenticationServiceBase
implements UserAuthenticator,
CredentialInitializer {
    protected static final String AUTHFACTORYMETHOD = BasicAuthenticationServiceImpl.class.getName() + ".getPeerAuthenticationService";

    @Override
    public boolean canSupport(String identifier, Properties properties) {
        return this.checkAndSetSchemeSupported(identifier, properties, "BUILTIN");
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        SecurityUtils.prepareUserDefinitionForBuiltInScheme(properties);
        super.boot(create, properties);
        try {
            MessageDigest digestAlgorithm = MessageDigest.getInstance("SHA-256");
            digestAlgorithm.reset();
            digestAlgorithm = MessageDigest.getInstance("SHA-1");
            digestAlgorithm.reset();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw Monitor.exceptionStartingModule(nsae);
        }
        this.setAuthenticationService(this);
    }

    @Override
    public String authenticateUser(String userName, String userPassword, String databaseName, Properties info) throws SQLException {
        String clientSecurityMechanism = null;
        int secMec = 0;
        if (userName == null) {
            return "Null user name";
        }
        String definedUserPassword = null;
        String passedUserPassword = null;
        clientSecurityMechanism = info.getProperty("drdaSecMec");
        if (clientSecurityMechanism != null) {
            secMec = Integer.parseInt(clientSecurityMechanism);
        }
        String userNameProperty = "gemfirexd.user.".concat(userName);
        String sqlfireUserNameProperty = "sqlfire.user.".concat(userName);
        definedUserPassword = this.getDatabaseProperty(userNameProperty);
        if (definedUserPassword == null) {
            definedUserPassword = this.getDatabaseProperty(sqlfireUserNameProperty);
        }
        if (definedUserPassword != null) {
            if (secMec != 8) {
                boolean v2Encrypt = false;
                boolean v3Encrypt = true;
                if (!definedUserPassword.startsWith("v33b60")) {
                    v3Encrypt = false;
                    v2Encrypt = definedUserPassword.startsWith("v23b60");
                }
                passedUserPassword = BasicAuthenticationServiceImpl.encryptUserPassword(userName, userPassword, false, v2Encrypt, v3Encrypt);
            } else {
                definedUserPassword = this.substitutePassword(userName, definedUserPassword, info, true);
                passedUserPassword = userPassword;
            }
        } else {
            definedUserPassword = this.getSystemProperty(userNameProperty);
            if (definedUserPassword == null) {
                definedUserPassword = this.getSystemProperty(sqlfireUserNameProperty);
            }
            passedUserPassword = userPassword;
            if (definedUserPassword != null && secMec == 8) {
                definedUserPassword = this.substitutePassword(userName, definedUserPassword, info, false);
            } else if (definedUserPassword != null) {
                boolean v2Encrypt = false;
                boolean v3Encrypt = true;
                if (!definedUserPassword.startsWith("v33b60")) {
                    v3Encrypt = false;
                    v2Encrypt = definedUserPassword.startsWith("v23b60");
                }
                passedUserPassword = BasicAuthenticationServiceImpl.encryptUserPassword(userName, userPassword, false, v2Encrypt, v3Encrypt);
            }
        }
        if (GemFireXDUtils.TraceAuthentication) {
            if (definedUserPassword == null) {
                SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("BUILTIN authentication couldn't find user definition for '" + userName + "'"));
            }
            if (passedUserPassword == null) {
                SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("BUILTIN authentication received improper credentials for user '" + userName + "'"));
            }
        }
        if (SanityManager.DEBUG_ON((String)"__PINT__")) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("BUILTIN authentication evaluating defined pwd " + definedUserPassword + " with incoming pwd " + passedUserPassword + " for user '" + userName + "'"));
        }
        if (definedUserPassword == null) {
            return "No such user '" + userName + "'";
        }
        if (!definedUserPassword.equals(passedUserPassword)) {
            return passedUserPassword != null ? "Incorrect password for user '" + userName + "'" : "Null password for user '" + userName + "'";
        }
        return null;
    }

    @Override
    public Properties getCredentials(Properties securityProps) throws SQLException {
        return SecurityUtils.getCredentials(securityProps);
    }

    public String toString() {
        return "BUILTIN";
    }
}

