/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.gemstone.gemfire.internal.shared.FinalizeHolder;
import com.gemstone.gemfire.internal.shared.FinalizeObject;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.io.DirFile;
import com.pivotal.gemfirexd.internal.impl.jdbc.LOBFile;
import com.pivotal.gemfirexd.internal.impl.jdbc.LOBInputStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.LOBOutputStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import com.pivotal.gemfirexd.internal.shared.common.error.ExceptionUtil;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;

class LOBStreamControl {
    private LOBFile tmpFile;
    private StorageFile lobFile;
    private byte[] dataBytes = new byte[0];
    private boolean isBytes = true;
    private final int bufferSize;
    private String dbName;
    private long updateCount;
    private static final int DEFAULT_MAX_BUF_SIZE = 4096;
    private FinalizeLOBControl finalizer;

    LOBStreamControl(String dbName) {
        this.dbName = dbName;
        this.updateCount = 0L;
        this.bufferSize = 4096;
    }

    LOBStreamControl(String dbName, byte[] data) throws IOException, StandardException {
        this.dbName = dbName;
        this.updateCount = 0L;
        this.bufferSize = Math.max(4096, data.length);
        this.write(data, 0, data.length, 0L);
    }

    private void init(byte[] b, long len) throws IOException, StandardException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, StandardException {
                    long n;
                    String child;
                    File f = null;
                    SecureRandom random = new SecureRandom();
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    do {
                        n = (n = random.nextLong()) == Long.MIN_VALUE ? 0L : Math.abs(n);
                    } while ((f = new File(tmpDir, child = "lob" + n + ".tmp")).exists() || !f.createNewFile());
                    LOBStreamControl.this.lobFile = new DirFile(f.getParent(), f.getName());
                    LOBStreamControl.this.tmpFile = new LOBFile(LOBStreamControl.this.lobFile);
                    LOBStreamControl.this.finalizer = new FinalizeLOBControl(LOBStreamControl.this);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof StandardException) {
                throw (StandardException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw Util.newIOException(e);
        }
        this.isBytes = false;
        if (len != 0L) {
            this.write(b, 0, (int)len, 0L);
        }
        this.dataBytes = null;
    }

    private long updateData(byte[] bytes, int offset, int len, long pos) throws StandardException {
        if (this.dataBytes == null) {
            if ((int)pos == 0) {
                this.dataBytes = new byte[len];
                System.arraycopy(bytes, offset, this.dataBytes, (int)pos, len);
                return len;
            }
            throw StandardException.newException("XJ076.S", new Long(pos));
        }
        if (pos > (long)this.dataBytes.length) {
            throw StandardException.newException("XJ076.S", new Long(pos));
        }
        if (pos + (long)len < (long)this.dataBytes.length) {
            System.arraycopy(bytes, offset, this.dataBytes, (int)pos, len);
        } else {
            byte[] tmpBytes = new byte[len + (int)pos];
            System.arraycopy(this.dataBytes, 0, tmpBytes, 0, (int)pos);
            System.arraycopy(bytes, offset, tmpBytes, (int)pos, len);
            this.dataBytes = tmpBytes;
        }
        return pos + (long)len;
    }

    private void isValidPostion(long pos) throws IOException, StandardException {
        if (pos < 0L) {
            throw StandardException.newException("XJ071.S", new Long(pos + 1L));
        }
        if (pos > Integer.MAX_VALUE) {
            throw StandardException.newException("XJ076.S", new Long(pos + 1L));
        }
        if (this.isBytes ? (this.dataBytes == null ? pos != 0L : (long)this.dataBytes.length < pos) : pos > this.tmpFile.length()) {
            throw StandardException.newException("XJ076.S", new Long(pos + 1L));
        }
    }

    private void isValidOffset(int off, int length) throws StandardException {
        if (off < 0 || off > length) {
            throw StandardException.newException("XJ078.S", new Integer(off));
        }
    }

    synchronized long write(int b, long pos) throws IOException, StandardException {
        this.isValidPostion(pos);
        ++this.updateCount;
        if (this.isBytes) {
            if (pos < (long)this.bufferSize) {
                byte[] bytes = new byte[]{(byte)b};
                this.updateData(bytes, 0, 1, pos);
                return pos + 1L;
            }
            this.init(this.dataBytes, pos);
        }
        this.tmpFile.seek(pos);
        this.tmpFile.write(b);
        return this.tmpFile.getFilePointer();
    }

    synchronized long write(byte[] b, int off, int len, long pos) throws IOException, StandardException {
        this.isValidPostion(pos);
        try {
            this.isValidOffset(off, b.length);
        }
        catch (StandardException e) {
            if (e.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier((String)"XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(e.getMessage());
            }
            throw e;
        }
        ++this.updateCount;
        if (this.isBytes) {
            if (pos + (long)len <= (long)this.bufferSize) {
                return this.updateData(b, off, len, pos);
            }
            this.init(this.dataBytes, pos);
        }
        this.tmpFile.seek(pos);
        this.tmpFile.write(b, off, len);
        return this.tmpFile.getFilePointer();
    }

    synchronized int read(long pos) throws IOException, StandardException {
        this.isValidPostion(pos);
        if (this.isBytes) {
            if ((long)this.dataBytes.length == pos) {
                return -1;
            }
            return this.dataBytes[(int)pos] & 0xFF;
        }
        if (this.tmpFile.getFilePointer() != pos) {
            this.tmpFile.seek(pos);
        }
        try {
            return this.tmpFile.readByte() & 0xFF;
        }
        catch (EOFException eof) {
            return -1;
        }
    }

    private int readBytes(byte[] b, int off, int len, long pos) {
        if (pos >= (long)this.dataBytes.length) {
            return -1;
        }
        int lengthFromPos = this.dataBytes.length - (int)pos;
        int actualLength = len > lengthFromPos ? lengthFromPos : len;
        System.arraycopy(this.dataBytes, (int)pos, b, off, actualLength);
        return actualLength;
    }

    synchronized int read(byte[] buff, int off, int len, long pos) throws IOException, StandardException {
        this.isValidPostion(pos);
        this.isValidOffset(off, buff.length);
        if (this.isBytes) {
            return this.readBytes(buff, off, len, pos);
        }
        this.tmpFile.seek(pos);
        return this.tmpFile.read(buff, off, len);
    }

    InputStream getInputStream(long pos) {
        return new LOBInputStream(this, pos);
    }

    OutputStream getOutputStream(long pos) {
        return new LOBOutputStream(this, pos);
    }

    long getLength() throws IOException {
        if (this.isBytes) {
            return this.dataBytes.length;
        }
        return this.tmpFile.length();
    }

    synchronized void truncate(long size) throws IOException, StandardException {
        this.isValidPostion(size);
        if (this.isBytes) {
            byte[] tmpByte = new byte[(int)size];
            System.arraycopy(this.dataBytes, 0, tmpByte, 0, (int)size);
            this.dataBytes = tmpByte;
        } else if (size < (long)this.bufferSize) {
            this.dataBytes = new byte[(int)size];
            this.read(this.dataBytes, 0, this.dataBytes.length, 0L);
            this.isBytes = true;
            this.tmpFile.close();
            this.tmpFile = null;
            FinalizeLOBControl finalizer = this.finalizer;
            if (finalizer != null) {
                finalizer.clearAll();
                this.finalizer = null;
            }
        } else {
            this.tmpFile.setLength(size);
        }
    }

    synchronized void copyData(InputStream inStream, long length) throws IOException, StandardException {
        int len;
        byte[] data = new byte[this.bufferSize];
        for (long sz = 0L; sz < length; sz += (long)len) {
            len = (int)Math.min(length - sz, (long)this.bufferSize);
            if ((len = inStream.read(data, 0, len)) < 0) {
                throw new EOFException("Reached end-of-stream prematurely at " + sz);
            }
            this.write(data, 0, len, sz);
        }
    }

    private static void deleteFile(StorageFile file) throws IOException {
        try {
            final StorageFile sf = file;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    sf.delete();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw Util.newIOException(e);
        }
    }

    void free() throws IOException {
        FinalizeLOBControl finalizer = this.finalizer;
        if (finalizer != null) {
            finalizer.clearAll();
            this.finalizer = null;
        }
        this.dataBytes = null;
        if (this.tmpFile != null) {
            this.tmpFile.close();
            LOBStreamControl.deleteFile(this.lobFile);
            this.tmpFile = null;
        }
    }

    synchronized long replaceBytes(byte[] buf, long stPos, long endPos) throws IOException, StandardException {
        long length = this.getLength();
        long finalLength = length - endPos + stPos + (long)buf.length;
        if (this.isBytes) {
            if (finalLength > (long)this.bufferSize) {
                byte[] tmpBytes = this.dataBytes;
                this.init(tmpBytes, stPos);
                this.write(buf, 0, buf.length, this.getLength());
                if (endPos < length) {
                    this.write(tmpBytes, (int)endPos, (int)(length - endPos), this.getLength());
                }
            } else {
                byte[] tmpByte = new byte[(int)finalLength];
                System.arraycopy(this.dataBytes, 0, tmpByte, 0, (int)stPos);
                System.arraycopy(buf, 0, tmpByte, (int)stPos, buf.length);
                if (endPos < length) {
                    System.arraycopy(this.dataBytes, (int)endPos, tmpByte, (int)(stPos + (long)buf.length), (int)(length - endPos));
                }
                this.dataBytes = tmpByte;
            }
        } else {
            int readLen;
            int actualLength;
            byte[] tmp = new byte[]{};
            LOBFile oldFile = this.tmpFile;
            StorageFile oldStoreFile = this.lobFile;
            this.init(tmp, 0L);
            byte[] tmpByte = new byte[1024];
            oldFile.seek(0L);
            for (long sz = stPos; sz != 0L && (actualLength = oldFile.read(tmpByte, 0, readLen = (int)Math.min(1024L, sz))) != -1; sz -= (long)actualLength) {
                this.tmpFile.write(tmpByte, 0, actualLength);
            }
            this.tmpFile.write(buf);
            oldFile.seek(endPos);
            if (endPos < length) {
                int rdLen;
                while ((rdLen = oldFile.read(tmpByte, 0, 1024)) != -1) {
                    this.tmpFile.write(tmpByte, 0, rdLen);
                }
                oldFile.close();
                LOBStreamControl.deleteFile(oldStoreFile);
            }
        }
        ++this.updateCount;
        return stPos + (long)buf.length;
    }

    long getUpdateCount() {
        return this.updateCount;
    }

    static final class FinalizeLOBControl
    extends FinalizeObject {
        private LOBFile tmpFile;
        private StorageFile lobFile;

        public FinalizeLOBControl(LOBStreamControl control) {
            super((Object)control, true);
            this.tmpFile = control.tmpFile;
            this.lobFile = control.lobFile;
        }

        protected final FinalizeHolder getHolder() {
            return FinalizeLOBControl.getServerHolder();
        }

        protected void clearThis() {
            this.tmpFile = null;
            this.lobFile = null;
        }

        protected final boolean doFinalize() throws IOException {
            LOBFile tmpFile = this.tmpFile;
            if (tmpFile != null) {
                tmpFile.close();
                LOBStreamControl.deleteFile(this.lobFile);
                this.tmpFile = null;
            }
            return true;
        }
    }
}

