/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.Checkpoint;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.gemstone.gemfire.internal.shared.UnsupportedGFXDVersionException;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.iapi.error.DerbySQLException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineLOB;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EnginePreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.jdbc.WrapperEngineBLOB;
import com.pivotal.gemfirexd.internal.iapi.jdbc.WrapperEngineCLOB;
import com.pivotal.gemfirexd.internal.iapi.services.info.JVMInfo;
import com.pivotal.gemfirexd.internal.iapi.services.io.ApplicationObjectInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialClob;
import com.pivotal.gemfirexd.internal.impl.drda.AppRequester;
import com.pivotal.gemfirexd.internal.impl.drda.CcsidManager;
import com.pivotal.gemfirexd.internal.impl.drda.CharacterEncodings;
import com.pivotal.gemfirexd.internal.impl.drda.CodePoint;
import com.pivotal.gemfirexd.internal.impl.drda.CodePointNameTable;
import com.pivotal.gemfirexd.internal.impl.drda.ConsistencyToken;
import com.pivotal.gemfirexd.internal.impl.drda.DDMReader;
import com.pivotal.gemfirexd.internal.impl.drda.DDMWriter;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAProtocolException;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAProtocolExceptionInfo;
import com.pivotal.gemfirexd.internal.impl.drda.DRDASocketTimeoutException;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAStatement;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAString;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAXAProtocol;
import com.pivotal.gemfirexd.internal.impl.drda.Database;
import com.pivotal.gemfirexd.internal.impl.drda.DecryptionManager;
import com.pivotal.gemfirexd.internal.impl.drda.EXTDTAInputStream;
import com.pivotal.gemfirexd.internal.impl.drda.EXTDTAReaderInputStream;
import com.pivotal.gemfirexd.internal.impl.drda.EbcdicCcsidManager;
import com.pivotal.gemfirexd.internal.impl.drda.FdocaConstants;
import com.pivotal.gemfirexd.internal.impl.drda.LayerBStreamedEXTDTAReaderInputStream;
import com.pivotal.gemfirexd.internal.impl.drda.NetworkServerControlImpl;
import com.pivotal.gemfirexd.internal.impl.drda.PiggyBackedSessionData;
import com.pivotal.gemfirexd.internal.impl.drda.Pkgnamcsn;
import com.pivotal.gemfirexd.internal.impl.drda.SQLTypes;
import com.pivotal.gemfirexd.internal.impl.drda.Session;
import com.pivotal.gemfirexd.internal.impl.drda.SignedBinary;
import com.pivotal.gemfirexd.internal.impl.drda.StandardEXTDTAReaderInputStream;
import com.pivotal.gemfirexd.internal.impl.drda.XADatabase;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.SingleHopInformation;
import com.pivotal.gemfirexd.internal.shared.common.io.DynamicByteArrayOutputStream;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;

class DRDAConnThread
extends Thread {
    private static final String leftBrace = "{  ";
    private static final String rightBrace = "  }";
    private static final byte PRPSQLSTT_ERROR = -1;
    private static final String SET_SCHEMA_STATEMENT = "SET CONNECTION_SCHEMA ";
    private String pendingSetSchema;
    private volatile long beginWaitMillis;
    private final AtomicLong numTimesWaited = new AtomicLong(0L);
    private final AtomicLong waitTime = new AtomicLong(0L);
    private final AtomicLong processTime = new AtomicLong(0L);
    private final AtomicLong numCmdsProcessed = new AtomicLong(0L);
    private static final byte NULL_VALUE = -1;
    private static final String SYNTAX_ERR = "42X01";
    private static final int MGRLVL_3 = 3;
    private static final int MGRLVL_4 = 4;
    private static final int MGRLVL_5 = 5;
    private static final int MGRLVL_6 = 6;
    private static final int MGRLVL_7 = 7;
    private static final int COMMIT = 1;
    private static final int ROLLBACK = 2;
    protected CcsidManager ccsidManager = new EbcdicCcsidManager();
    protected final boolean trace;
    private int correlationID;
    private InputStream sockis;
    private OutputStream sockos;
    private DDMReader reader;
    private DDMWriter writer;
    private DRDAXAProtocol xaProto;
    private static int[] ACCRDB_REQUIRED = new int[]{8463, 8501, 4398, 47, 53};
    private static int MAX_REQUIRED_LEN = 5;
    private int currentRequiredLength = 0;
    private int[] required = new int[MAX_REQUIRED_LEN];
    private NetworkServerControlImpl server;
    private Session session;
    private long timeSlice;
    private Object timeSliceSync = new Object();
    private boolean logConnections;
    private boolean sendWarningsOnCNTQRY = false;
    private Object logConnectionsSync = new Object();
    private boolean close;
    private Object closeSync = new Object();
    private static HeaderPrintWriter logStream;
    private AppRequester appRequester;
    private Database database;
    private int sqlamLevel;
    private byte diagnosticLevel = (byte)-16;
    private Vector unknownManagers;
    private Vector knownManagers;
    private Vector errorManagers;
    private Vector errorManagersLevel;
    private SQLException databaseAccessException;
    private Pkgnamcsn prevPkgnamcsn = null;
    private DRDAString rdbnam = new DRDAString(this.ccsidManager);
    private DRDAString rdbcolid = new DRDAString(this.ccsidManager);
    private DRDAString pkgid = new DRDAString(this.ccsidManager);
    private DRDAString pkgcnstkn = new DRDAString(this.ccsidManager);
    private int pkgsn;
    private static final String TIMEOUT_STATEMENT = "SET STATEMENT_TIMEOUT ";
    private int pendingStatementTimeout;
    private static DecryptionManager decryptionManager;
    private byte[] myPublicKey;
    private byte[] myTargetSeed;
    private static final byte[] eod00000;
    private static final byte[] eod02000;
    private static final byte[] nullSQLState;
    private static final byte[] errD4_D6;
    private static final byte[] warn0_warnA;
    private static final String AUTHENTICATION_PROVIDER_BUILTIN_CLASS = "com.pivotal.gemfirexd.internal.impl.jdbc.authentication.BasicAuthenticationServiceImpl";
    private static final String AUTHENTICATION_PROVIDER_NONE_CLASS = "com.pivotal.gemfirexd.internal.impl.jdbc.authentication.NoneAuthenticationServiceImpl";
    private static final DRDAProtocolExceptionInfo dummy;
    private boolean deferredReset = false;
    private Version gfxdClientVersion;
    private TXId currTxIdForSHOPExecution;
    private ClassFactory cf = null;
    public static final boolean SEND_TX_ID_ON_COMMIT;
    public static final boolean ROLLBACK_IMPLEMENTED_FULLY;

    DRDAConnThread(Session session, NetworkServerControlImpl server, long timeSlice, boolean logConnections) {
        NetworkServerControlImpl.setUniqueThreadName(this, "DRDAConnThread");
        this.session = session;
        this.server = server;
        this.trace = server.debugOutput;
        this.timeSlice = timeSlice;
        this.logConnections = logConnections;
        this.pendingStatementTimeout = -1;
        this.initialize();
    }

    @Override
    public void run() {
        if (this.trace) {
            this.trace("Starting new connection thread");
        }
        while (!this.closed()) {
            Session prevSession = this.session;
            this.session = this.server.getNextSession(this.session);
            if (this.session == null) {
                this.close();
            }
            if (this.closed()) break;
            if (this.session != prevSession) {
                this.initializeForSession();
            }
            try {
                long timeStart = System.currentTimeMillis();
                switch (this.session.state) {
                    case 1: {
                        this.sessionInitialState();
                        if (this.session == null) break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        long currentTimeSlice;
                        do {
                            try {
                                this.processCommands();
                            }
                            catch (DRDASocketTimeoutException dRDASocketTimeoutException) {
                                // empty catch block
                            }
                        } while ((currentTimeSlice = this.getTimeSlice()) <= 0L || System.currentTimeMillis() - timeStart < currentTimeSlice);
                        break;
                    }
                    default: {
                        this.agentError("Session in invalid state:" + this.session.state);
                    }
                }
            }
            catch (Exception e) {
                GemFireCacheImpl cache;
                GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                boolean cacheCloseFortesting = false;
                if (observer != null) {
                    cacheCloseFortesting = observer.isCacheClosedForTesting();
                }
                if (e instanceof DRDAProtocolException && ((DRDAProtocolException)e).isDisconnectException()) {
                    this.closeSession();
                    continue;
                }
                if (this.server.getShutdown() || (cache = Misc.getGemFireCacheNoThrow()) == null || cache.getCancelCriterion().cancelInProgress() != null || cacheCloseFortesting) {
                    if (SanityManager.TraceSingleHop || SanityManager.TraceClientHA) {
                        SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("DRDAConnThread::run got exception when cache shutting down: " + e), (Throwable)e);
                    }
                    this.closeSession();
                    this.close();
                    continue;
                }
                this.handleException(e);
            }
        }
        if (this.trace) {
            this.trace("Ending connection thread");
        }
        this.server.removeThread(this);
    }

    protected InputStream getInputStream() {
        return this.sockis;
    }

    protected OutputStream getOutputStream() {
        return this.sockos;
    }

    protected DDMReader getReader() {
        return this.reader;
    }

    protected DDMWriter getWriter() {
        return this.writer;
    }

    protected int getCorrelationID() {
        return this.correlationID;
    }

    protected Session getSession() {
        return this.session;
    }

    protected Database getDatabase() {
        return this.database;
    }

    protected NetworkServerControlImpl getServer() {
        return this.server;
    }

    protected byte[] getCrrtkn() {
        if (this.database != null) {
            return this.database.crrtkn;
        }
        return null;
    }

    protected String getDbName() {
        if (this.database != null) {
            return this.database.dbName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Object object = this.closeSync;
        synchronized (object) {
            this.close = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLogConnections(boolean value) {
        Object object = this.logConnectionsSync;
        synchronized (object) {
            this.logConnections = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTimeSlice(long value) {
        Object object = this.timeSliceSync;
        synchronized (object) {
            this.timeSlice = value;
        }
    }

    protected void markCommunicationsFailure(String arg1, String arg2, String arg3, String arg4) throws DRDAProtocolException {
        this.markCommunicationsFailure(null, arg1, arg2, arg3, arg4);
    }

    protected void markCommunicationsFailure(Exception e, String arg1, String arg2, String arg3, String arg4) throws DRDAProtocolException {
        String dbname = null;
        if (this.database != null) {
            dbname = this.database.dbName;
        }
        if (e != null) {
            DRDAConnThread.println2Log(dbname, this.session.drdaID, e.getMessage());
            this.server.consoleExceptionPrintTrace(e);
        }
        Object[] oa = new Object[]{arg1, arg2, arg3, arg4};
        throw DRDAProtocolException.newDisconnectException(this, oa);
    }

    protected void throwSyntaxrm(int errcd, int cpArg) throws DRDAProtocolException {
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_SYNTAXRM, this, cpArg, errcd);
    }

    protected void agentError(String msg) throws DRDAProtocolException {
        String dbname = null;
        if (this.database != null) {
            dbname = this.database.dbName;
        }
        throw DRDAProtocolException.newAgentError(this, 64, dbname, msg);
    }

    protected void missingCodePoint(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(14, codePoint);
    }

    protected static void println2Log(String dbname, String drdaID, String msg) {
        int endOfName;
        if (logStream == null) {
            logStream = Monitor.getStream();
        }
        if (dbname != null && (endOfName = dbname.indexOf(59)) != -1) {
            dbname = dbname.substring(0, endOfName);
        }
        logStream.printlnWithHeader("(DATABASE = " + dbname + "), (DRDAID = " + drdaID + "), " + msg);
    }

    protected void writeRDBNAM(String rdbnam) throws DRDAProtocolException {
        int len = rdbnam.length();
        if (len < 18) {
            len = 18;
        }
        this.writer.writeScalarHeader(8464, len);
        try {
            this.writer.writeScalarPaddedBytes(rdbnam.getBytes("UTF8"), len, (byte)32);
        }
        catch (UnsupportedEncodingException e) {
            this.agentError("Unsupported coding exception for server encoding " + "UTF8");
        }
    }

    private void initialize() {
        this.sockis = this.session.sessionInput;
        this.sockos = this.session.sessionOutput;
        this.reader = new DDMReader(this, this.session.dssTrace);
        this.writer = new DDMWriter(this.ccsidManager, this, this.session.dssTrace);
    }

    private void initializeForSession() {
        this.sockis = this.session.sessionInput;
        this.sockos = this.session.sessionOutput;
        this.reader.initialize(this, this.session.dssTrace);
        this.writer.reset(this.session.dssTrace);
        this.database = this.session.database;
        this.appRequester = this.session.appRequester;
        if (this.session.state == 2) {
            this.sqlamLevel = this.appRequester.getManagerLevel(9223);
        }
    }

    private void sessionInitialState() throws Exception {
        if (this.reader.isCmd()) {
            try {
                this.server.processCommands(this.reader, this.writer, this.session);
                this.reader.initialize(this, null);
                this.writer.reset(null);
                this.closeSession();
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    throw (InterruptedException)t;
                }
                this.server.consoleExceptionPrintTrace(t);
            }
        } else {
            this.exchangeServerAttributes();
        }
    }

    private void cleanUpAndCloseResultSet(DRDAStatement stmt, SQLException sqle, int writerMark) throws DRDAProtocolException {
        if (stmt != null) {
            this.writer.clearDSSesBackToMark(writerMark);
            if (!stmt.rsIsClosed()) {
                block5: {
                    try {
                        stmt.rsClose();
                    }
                    catch (SQLException ec) {
                        if (!this.trace) break block5;
                        this.trace("Warning: Error closing result set");
                    }
                }
                this.writeABNUOWRM();
                this.writeSQLCARD(sqle, 8, 0, 0L);
            }
        } else {
            this.writeSQLCARDs(sqle, 0);
        }
        this.errorInChain(sqle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processCommands() throws DRDAProtocolException {
        stmt = null;
        updateCount = 0;
        PRPSQLSTTfailed = false;
        checkSecurityCodepoint = this.session.requiresSecurityCodepoint();
        do {
            beginWaitNanos = 0L;
            if (ConnectionStats.clockStatsEnabled()) {
                beginWaitNanos = NanoTimer.getTime();
                this.beginWaitMillis = System.currentTimeMillis();
            }
            this.correlationID = this.reader.readDssHeader();
            beginProcessTime = 0L;
            if (ConnectionStats.clockStatsEnabled()) {
                var9_8 = this;
                synchronized (var9_8) {
                    endWait = NanoTimer.getTime();
                    currentWait = endWait - beginWaitNanos;
                    if (currentWait > 0L) {
                        this.waitTime.addAndGet(currentWait);
                    }
                    this.beginWaitMillis = 0L;
                    if (currentWait >= 5000000L) {
                        this.numTimesWaited.incrementAndGet();
                    }
                }
                beginProcessTime = NanoTimer.getTime();
            }
            codePoint = this.reader.readLengthAndCodePoint(false);
            writerMark = this.writer.markDSSClearPoint();
            finalizeChain = true;
            if (checkSecurityCodepoint) {
                this.verifyInOrderACCSEC_SECCHK(codePoint, this.session.getRequiredSecurityCodepoint());
            }
            switch (codePoint) {
                case 8198: {
                    try {
                        stmt = this.parseCNTQRY();
                        if (stmt == null) break;
                        stmt.setStatus("SENDING CNTQRY RESULTS");
                        this.writeQRYDTA(stmt);
                        stmt.checkBucketsStillHosted();
                        if (stmt.rsIsClosed()) {
                            this.writeENDQRYRM(4);
                            this.writeNullSQLCARDobject();
                        }
                        this.checkWarning(null, null, stmt.getResultSet(), 0, false, this.sendWarningsOnCNTQRY);
                        this.writePBSD();
                    }
                    catch (SQLException e) {
                        this.cleanUpAndCloseResultSet(stmt, e, writerMark);
                    }
                    break;
                }
                case 8202: {
                    try {
                        updateCount = this.parseEXCSQLIMM();
                        if (!this.database.RDBUPDRM_sent) {
                            this.writeRDBUPDRM();
                        }
                        this.checkWarning(null, this.database.getDefaultStatement().getStatement(), null, updateCount, true, true);
                        this.writePBSD();
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeSQLCARDs(e, 0);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8212: {
                    try {
                        if (!this.parseEXCSQLSET()) break;
                        this.writeSQLCARDs(null, 0);
                    }
                    catch (SQLWarning w) {
                        this.writeSQLCARD(w, 4, 0, 0L);
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeSQLCARDs(e, 0);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8205: {
                    PRPSQLSTTfailed = false;
                    try {
                        this.database.getConnection().clearWarnings();
                        this.database.getCurrentStatement().sqldaType = sqldaType = this.parsePRPSQLSTT();
                        if (sqldaType <= 0) ** GOTO lbl99
                        currStmt = this.database.getCurrentStatement();
                        currStmt.sqldaType = sqldaType;
                        if (!currStmt.isPrepared()) ** GOTO lbl97
                        if (currStmt.needStatementUUID()) {
                            try {
                                this.writeSQLSTMTID(currStmt.getStatementUUID());
                            }
                            finally {
                                currStmt.setSendStatementUUID(false);
                            }
                        }
                        if (SanityManager.TraceSingleHop) {
                            SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("DRDAConnThread::processCommand currStmt is: " + currStmt + " sqldaType: " + sqldaType));
                        }
                        this.writeSQLDARD(currStmt, sqldaType == 2, this.database.getConnection().getWarnings(), true, false);
                        break;
lbl97:
                        // 1 sources

                        currStmt.pstmtParseWriterMark = writerMark;
                        break;
lbl99:
                        // 1 sources

                        this.checkWarning(this.database.getConnection(), null, null, 0, true, true);
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeSQLCARDs(e, 0, true);
                        PRPSQLSTTfailed = true;
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8204: {
                    ps = null;
                    try {
                        if (PRPSQLSTTfailed) {
                            this.skipRemainder(true);
                            this.writeOPNQFLRM(null);
                            break;
                        }
                        pkgnamcsn = this.parseOPNQRY();
                        if (pkgnamcsn != null) {
                            stmt = this.database.getDRDAStatement(pkgnamcsn);
                            ps = stmt.getUnderlyingStatement();
                            ps.clearWarnings();
                            if (this.pendingStatementTimeout >= 0) {
                                ps.setQueryTimeout(this.pendingStatementTimeout);
                                this.pendingStatementTimeout = -1;
                            } else if (this.pendingSetSchema != null) {
                                stmt.setSchema(this.pendingSetSchema);
                                this.pendingSetSchema = null;
                            }
                            if (this.executeStatement(stmt, true) == -1) {
                                PRPSQLSTTfailed = true;
                                break;
                            }
                            this.writeOPNQRYRM(false, stmt);
                            this.checkWarning(null, ps, null, 0, false, true);
                            if (stmt.ps != null) {
                                sentVersion = stmt.versionCounter;
                                if (stmt.ps instanceof EnginePreparedStatement) {
                                    currentVersion = ((EnginePreparedStatement)stmt.ps).getVersionCounter();
                                    if (stmt.sqldaType == 2 && currentVersion != sentVersion) {
                                        this.writeSQLDARD(stmt, true, null, false, true);
                                    }
                                }
                            }
                            this.writeQRYDSC(stmt, false);
                            stmt.rsSuspend();
                            if (stmt.getQryprctyp() == 9239 && stmt.getQryrowset() != 0) {
                                drdars = stmt.getCurrentDrdaResultSet();
                                try {
                                    if (drdars != null && !drdars.hasLobColumns()) {
                                        stmt.setStatus("SENDING OPNQRY RESULTS");
                                        this.writeQRYDTA(stmt);
                                        stmt.checkBucketsStillHosted();
                                    }
                                }
                                catch (SQLException sqle) {
                                    this.cleanUpAndCloseResultSet(stmt, sqle, writerMark);
                                }
                            }
                        }
                        this.writePBSD();
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeOPNQFLRM(e);
                    }
                    break;
                }
                case 8206: 
                case 8222: {
                    try {
                        if (this.trace) {
                            this.trace("Received commit");
                        }
                        if (this.reader.moreDdmData()) {
                            cp = this.reader.readLengthAndCodePoint(false);
                            if (cp == 8464) {
                                this.setDatabase(8206);
                            } else {
                                this.codePointNotSupported(cp);
                            }
                        }
                        if (codePoint == 8222) {
                            this.getRegionsAndInformTX();
                        }
                        if ((batchStmt = this.database.getCurrentStatement()) != null && batchStmt.batchOutput && batchStmt.numBatchResults > 0) {
                            try {
                                this.executeBatch(batchStmt, false);
                                sendResult = true;
                            }
                            catch (SQLException e) {
                                this.sendBatchException(batchStmt, e, true);
                                batchStmt.setStatus("BATCH EXCEPTION " + e.getMessage());
                                sendResult = false;
                            }
                            if (sendResult) {
                                this.sendBatchResult(batchStmt);
                            }
                        }
                        if (!this.database.getConnection().getAutoCommit()) {
                            this.database.getConnection().clearWarnings();
                            this.database.commit();
                            this.writeENDUOWRM(1);
                            this.checkWarning(this.database.getConnection(), null, null, 0, true, true);
                        }
                        this.database.RDBUPDRM_sent = false;
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeENDUOWRM(1);
                        this.writeSQLCARDs(e, 0);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8207: {
                    try {
                        if (this.trace) {
                            this.trace("Received rollback");
                        }
                        if (this.reader.moreDdmData()) {
                            cp = this.reader.readLengthAndCodePoint(false);
                            if (cp == 8464) {
                                this.setDatabase(8206);
                            } else {
                                this.codePointNotSupported(cp);
                            }
                        }
                        this.database.getConnection().clearWarnings();
                        this.database.rollback();
                        this.writeENDUOWRM(2);
                        this.checkWarning(this.database.getConnection(), null, null, 0, true, true);
                        this.database.RDBUPDRM_sent = false;
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeENDUOWRM(2);
                        this.writeSQLCARDs(e, 0);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8197: {
                    try {
                        stmt = this.parseCLSQRY();
                        stmt.rsClose();
                        this.writeSQLCARDs(null, 0);
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeSQLCARDs(e, 0);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 4161: {
                    this.parseEXCSAT();
                    this.writeEXCSATRD();
                    break;
                }
                case 4205: {
                    securityCheckCode = this.parseACCSEC();
                    this.writeACCSECRD(securityCheckCode);
                    checkSecurityCodepoint = true;
                    break;
                }
                case 4206: {
                    try {
                        if (!this.parseDRDAConnection()) break;
                        checkSecurityCodepoint = false;
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.writeSQLCARDs(e, 0);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8194: {
                    this.reader.skipBytes();
                    this.writeSQLCARDs(null, 0);
                    break;
                }
                case 8196: {
                    this.reader.skipBytes();
                    this.parseSQLSTTDss();
                    this.writeSQLCARDs(null, 0);
                    break;
                }
                case 9241: {
                    this.reader.skipBytes();
                    break;
                }
                case 8201: {
                    this.reader.skipBytes();
                    this.writeSQLCARDs(null, 0);
                    break;
                }
                case 8200: {
                    if (PRPSQLSTTfailed) {
                        this.reader.skipBytes();
                        this.writeSQLCARDs(null, 0);
                        break;
                    }
                    try {
                        rtnOutput = this.parseDSCSQLSTT();
                        this.writeSQLDARD(this.database.getCurrentStatement(), rtnOutput, null, false, false);
                    }
                    catch (SQLException e) {
                        this.writer.clearDSSesBackToMark(writerMark);
                        this.server.consoleExceptionPrint(e);
                        try {
                            this.writeSQLDARD(this.database.getCurrentStatement(), true, e, false, false);
                        }
                        catch (SQLException e2) {
                            SanityManager.DEBUG_PRINT((String)"AGENT ERROR", (String)("Got another SQLException while writing one: " + SanityManager.getStackTrace((Throwable)e2)));
                            this.agentError("Why am I getting another SQLException?");
                        }
                        this.errorInChain(e);
                    }
                    break;
                }
                case 8203: {
                    if (PRPSQLSTTfailed) {
                        this.skipRemainder(true);
                        this.writeSQLCARDs(null, 0);
                        break;
                    }
                    try {
                        result = this.parseEXCSQLSTT();
                        if (result == -1) {
                            PRPSQLSTTfailed = true;
                            break;
                        }
                        finalizeChain = result == -15;
                        if (!finalizeChain) break;
                        currStmt = this.database.getCurrentStatement();
                        if (currStmt != null) {
                            currStmt.rsSuspend();
                        }
                        this.writePBSD();
                    }
                    catch (SQLException e) {
                        this.skipRemainder(true);
                        this.writer.clearDSSesBackToMark(writerMark);
                        if (this.trace) {
                            this.server.consoleExceptionPrint(e);
                        }
                        if ((currStmt = this.database.getCurrentStatement()) != null && currStmt.batchOutput) {
                            this.sendBatchException(currStmt, e, false);
                        }
                        this.writeSQLCARDs(e, 0);
                        this.errorInChain(e);
                    }
                    break;
                }
                case 4181: {
                    if (this.xaProto == null) {
                        this.xaProto = new DRDAXAProtocol(this);
                    }
                    this.xaProto.parseSYNCCTL();
                    try {
                        this.writePBSD();
                    }
                    catch (SQLException se) {
                        this.server.consoleExceptionPrint(se);
                        this.errorInChain(se);
                    }
                    break;
                }
                default: {
                    this.codePointNotSupported(codePoint);
                }
            }
            if (this.trace) {
                cpStr = new CodePointNameTable().lookup(codePoint);
                try {
                    pbsd = this.database.getPiggyBackedSessionData(false);
                    if (!this.deferredReset && pbsd != null) {
                        pbsd.refresh();
                        SanityManager.ASSERT((boolean)(pbsd.isModified() == false), (String)("Unexpected PBSD modification: " + pbsd + " after codePoint " + cpStr));
                    }
                }
                catch (SQLException sqle) {
                    this.server.consoleExceptionPrint(sqle);
                    SanityManager.THROWASSERT((String)("Unexpected exception after codePoint " + cpStr), (Throwable)sqle);
                }
            }
            if (finalizeChain) {
                this.finalizeChain();
            }
            if (ConnectionStats.clockStatsEnabled() && (currProcessTime = NanoTimer.getTime() - beginProcessTime) > 0L) {
                this.processTime.addAndGet(currProcessTime);
            }
            if (!ConnectionStats.isSamplingEnabled()) continue;
            this.numCmdsProcessed.incrementAndGet();
        } while (this.reader.isChainedWithSameID() || this.reader.isChainedWithDiffID());
    }

    private void getRegionsAndInformTX() throws DRDAProtocolException {
        int prs = this.reader.readNetworkShort();
        EngineConnection conn = this.database.getConnection();
        StringBuilder sb = null;
        for (int i = 0; i < prs; ++i) {
            if (sb == null && SanityManager.TraceSingleHop) {
                sb = new StringBuilder();
            }
            int prid = this.reader.readNetworkShort();
            int numBuckets = this.reader.readNetworkShort();
            for (int j = 0; j < numBuckets; ++j) {
                int bid = this.reader.readNetworkShort();
                try {
                    PartitionedRegion pr = PartitionedRegion.getPRFromId((int)prid);
                    Bucket b = pr.getRegionAdvisor().getBucket(bid);
                    conn.updateAffectedRegion(b);
                    if (sb == null) continue;
                    sb.append(prid);
                    sb.append(':');
                    sb.append(bid);
                    sb.append(" -- ");
                    sb.append(b.getName());
                    sb.append(" ");
                    continue;
                }
                catch (PRLocallyDestroyedException e) {
                    LogWriter logger = Misc.getCacheLogWriter();
                    if (logger == null) continue;
                    logger.warning("DrdaConnThread::getRegionsAndInformTX bucket region with prid=" + prid + ", and bucket id" + bid + " is locally destroyed", (Throwable)e);
                }
            }
        }
        if (SanityManager.TraceClientHA | SanityManager.TraceSingleHop) {
            SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("DrdaConnThread::getRegionsAndInformTX affected regions from client = " + sb.toString()));
        }
    }

    private void errorInChain(SQLException e) throws DRDAProtocolException {
        if (this.reader.terminateChainOnErr() && this.getExceptionSeverity(e) > 8) {
            if (this.trace) {
                this.trace("terminating the chain on error...");
            }
            this.skipRemainder(false);
        }
    }

    private void exchangeServerAttributes() throws DRDAProtocolException {
        int codePoint;
        this.correlationID = this.reader.readDssHeader();
        if (this.trace && this.correlationID == 0) {
            SanityManager.THROWASSERT((String)("Unexpected value for correlationId = " + this.correlationID));
        }
        if ((codePoint = this.reader.readLengthAndCodePoint(false)) != 4161) {
            throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_PRCCNVRM, this, codePoint, 6);
        }
        this.parseEXCSAT();
        this.writeEXCSATRD();
        this.finalizeChain();
        this.session.setState(2);
    }

    private boolean parseDRDAConnection() throws DRDAProtocolException, SQLException {
        boolean sessionOK = true;
        int securityCheckCode = this.parseSECCHK();
        if (this.trace) {
            this.trace("*** SECCHKRM securityCheckCode is: " + securityCheckCode);
        }
        this.writeSECCHKRM(securityCheckCode);
        if (securityCheckCode != 0) {
            return false;
        }
        this.correlationID = this.reader.readDssHeader();
        int codePoint = this.reader.readLengthAndCodePoint(false);
        this.verifyRequiredObject(codePoint, 8193);
        int svrcod = this.parseACCRDB();
        try {
            this.database.checkAndSetPossibleDuplicate();
        }
        catch (SQLException sqle) {
            this.databaseAccessException = sqle;
        }
        if (this.database.getConnection() == null && this.databaseAccessException == null) {
            this.writeRDBfailure(8730);
            return false;
        }
        if (this.databaseAccessException != null) {
            int failureType = this.getRdbAccessErrorCodePoint();
            if (failureType == 8721 || failureType == 8907) {
                this.writeRDBfailure(failureType);
            } else {
                this.writeRDBfailure(8730);
            }
            return false;
        }
        if (this.database.accessCount > 1) {
            this.writeRDBfailure(8711);
            return false;
        }
        this.writeACCRDBRM(svrcod);
        this.session.appRequester = this.server.getAppRequester(this.appRequester);
        return sessionOK;
    }

    private void writeRDBfailure(int codePoint) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(codePoint);
        this.writer.writeScalar2Bytes(4425, 8);
        this.writeRDBNAM(this.database.dbName);
        this.writer.endDdmAndDss();
        switch (codePoint) {
            case 8730: {
                this.writer.createDssObject();
                this.writer.writeScalarString(47, "QTDSQLASC");
                this.writeTYPDEFOVR();
                this.writer.endDss();
            }
            case 8721: 
            case 8907: {
                this.writeSQLCARD(this.databaseAccessException, 8, 0, 0L);
            }
            case 8711: {
                this.skipRemainder(false);
                this.finalizeChain();
            }
        }
    }

    private int getRdbAccessErrorCodePoint() {
        String sqlState = this.databaseAccessException.getSQLState();
        if (sqlState.regionMatches(0, "XJ004.C", 0, 5) || sqlState.regionMatches(0, "X0RQ3.C", 0, 5)) {
            return 8721;
        }
        if (this.isAuthenticationException(this.databaseAccessException) || sqlState.regionMatches(0, "28502", 0, 5)) {
            return 8907;
        }
        return 8730;
    }

    private boolean isAuthenticationException(SQLException sqlException) {
        boolean authFail = false;
        SQLException se = Util.getExceptionFactory().getArgumentFerry(sqlException);
        if (se instanceof DerbySQLException) {
            String msgId = ((DerbySQLException)((Object)se)).getMessageId();
            if (msgId.equals("08004.C.1")) {
                authFail = true;
            }
        } else {
            String sqlState = se.getSQLState();
            if (sqlState.regionMatches(0, "08004", 0, 5)) {
                authFail = true;
            }
        }
        return authFail;
    }

    private int verifyUserIdPassword() throws DRDAProtocolException {
        this.databaseAccessException = null;
        int retSecChkCode = 0;
        String realName = this.database.dbName;
        int endOfName = realName.indexOf(59);
        if (endOfName != -1) {
            realName = realName.substring(0, endOfName);
        }
        retSecChkCode = this.getConnFromDatabaseName();
        return retSecChkCode;
    }

    private int getConnFromDatabaseName() throws DRDAProtocolException {
        Properties p = new Properties();
        this.databaseAccessException = null;
        if (this.session.drdaID == null) {
            this.session.drdaID = leftBrace + this.session.connNum + rightBrace;
        }
        p.put("drdaID", this.session.drdaID);
        if (this.database.securityMechanism == 8 && this.database.dbName.indexOf("password") == -1) {
            p.put("drdaSecMec", String.valueOf(this.database.securityMechanism));
            p.put("drdaSecTokenIn", DecryptionManager.toHexString(this.database.secTokenIn, 0, this.database.secTokenIn.length));
            p.put("drdaSecTokenOut", DecryptionManager.toHexString(this.database.secTokenOut, 0, this.database.secTokenOut.length));
        }
        try {
            this.database.makeConnection(p);
        }
        catch (SQLException se) {
            this.database.incClientConnectionsFailed();
            String sqlState = se.getSQLState();
            this.databaseAccessException = se;
            while (se != null) {
                if (this.trace) {
                    this.trace(se.getMessage());
                }
                DRDAConnThread.println2Log(this.database.dbName, this.session.drdaID, se.getMessage());
                se = se.getNextException();
            }
            if (this.isAuthenticationException(this.databaseAccessException)) {
                return 19;
            }
            return 0;
        }
        catch (Exception e) {
            this.database.incClientConnectionsFailed();
            DRDAConnThread.println2Log(this.database.dbName, this.session.drdaID, "Driver not loaded" + e.getMessage());
            try {
                this.agentError("Driver not loaded");
            }
            catch (DRDAProtocolException dpe) {
                try {
                    this.server.startNetworkServer();
                }
                catch (Exception re) {
                    DRDAConnThread.println2Log(this.database.dbName, this.session.drdaID, "Failed attempt to reload driver " + re.getMessage());
                }
                throw dpe;
            }
        }
        if (this.getLogConnections()) {
            DRDAConnThread.println2Log(this.database.dbName, this.session.drdaID, "Pivotal GemFireXD Server connected to database " + this.database.dbName);
        }
        return 0;
    }

    private void parseEXCSAT() throws DRDAProtocolException {
        this.deferredReset = false;
        if (this.appRequester != null) {
            if (!this.appRequester.isXARequester()) {
                this.deferredReset = true;
            }
            this.parseEXCSAT2();
            return;
        }
        this.appRequester = new AppRequester();
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 4446: {
                    this.appRequester.extnam = this.reader.readString();
                    if (this.trace) {
                        this.trace("extName = " + this.appRequester.extnam);
                    }
                    if (this.appRequester.extnam.length() <= 255) break;
                    this.tooBig(4446);
                    break;
                }
                case 5124: {
                    this.parseMGRLVLLS(1);
                    break;
                }
                case 4445: {
                    this.appRequester.spvnam = this.reader.readString();
                    if (this.appRequester.spvnam == null) break;
                    this.badObjectLength(4445);
                    break;
                }
                case 4461: {
                    this.appRequester.srvnam = this.reader.readString();
                    if (this.trace) {
                        this.trace("serverName = " + this.appRequester.srvnam);
                    }
                    if (this.appRequester.srvnam.length() <= 255) break;
                    this.tooBig(4461);
                    break;
                }
                case 4442: {
                    this.appRequester.srvrlslv = this.reader.readString();
                    if (this.trace) {
                        this.trace("serverlslv = " + this.appRequester.srvrlslv);
                    }
                    if (this.appRequester.srvrlslv.length() <= 255) break;
                    this.tooBig(4442);
                    break;
                }
                case 4423: {
                    this.appRequester.srvclsnm = this.reader.readString();
                    if (this.trace) {
                        this.trace("serverClassName = " + this.appRequester.srvclsnm);
                    }
                    if (this.appRequester.srvclsnm.length() <= 255) break;
                    this.tooBig(4423);
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
    }

    private void parseEXCSAT2() throws DRDAProtocolException {
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 4423: 
                case 4442: 
                case 4445: 
                case 4446: 
                case 4461: {
                    this.reader.skipBytes();
                    break;
                }
                case 5124: {
                    this.parseMGRLVLLS(2);
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
    }

    private void parseMGRLVLLS(int time) throws DRDAProtocolException {
        this.unknownManagers = new Vector();
        this.knownManagers = new Vector();
        this.errorManagers = new Vector();
        this.errorManagersLevel = new Vector();
        if (this.trace) {
            this.trace("Manager Levels");
        }
        while (this.reader.moreDdmData()) {
            int manager = this.reader.readNetworkShort();
            int managerLevel = this.reader.readNetworkShort();
            if (CodePoint.isKnownManager(manager)) {
                this.knownManagers.addElement(manager);
                int currentLevel = this.appRequester.getManagerLevel(manager);
                if (currentLevel == -1) {
                    this.appRequester.setManagerLevel(manager, managerLevel);
                } else if (currentLevel != managerLevel) {
                    this.errorManagers.addElement(manager);
                    this.errorManagersLevel.addElement(managerLevel);
                }
            } else {
                this.unknownManagers.addElement(manager);
            }
            if (!this.trace) continue;
            this.trace("Manager = " + Integer.toHexString(manager) + " ManagerLevel " + managerLevel);
        }
        this.sqlamLevel = this.appRequester.getManagerLevel(9223);
        if (this.errorManagers.size() > 0) {
            Object[] oa = new Object[this.errorManagers.size() * 2];
            int j = 0;
            for (int i = 0; i < this.errorManagers.size(); ++i) {
                oa[j++] = this.errorManagers.elementAt(i);
                oa[j++] = this.errorManagersLevel.elementAt(i);
            }
            throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_MGRLVLRM, this, 0, 0, oa);
        }
    }

    private void writeEXCSATRD() throws DRDAProtocolException {
        this.writer.createDssObject();
        this.writer.startDdm(5187);
        this.writer.writeScalarString(4446, NetworkServerControlImpl.att_extnam);
        if (this.knownManagers != null && this.knownManagers.size() > 0) {
            this.writeMGRLEVELS();
        }
        this.writer.writeScalarString(4423, NetworkServerControlImpl.att_srvclsnm);
        this.writer.writeScalarString(4461, "NetworkServerControl");
        this.writer.writeScalarString(4442, NetworkServerControlImpl.att_srvrlslv);
        this.writer.endDdmAndDss();
    }

    private void writeMGRLEVELS() throws DRDAProtocolException {
        int manager;
        int i;
        this.writer.startDdm(5124);
        for (i = 0; i < this.knownManagers.size(); ++i) {
            manager = (Integer)this.knownManagers.elementAt(i);
            int appLevel = this.appRequester.getManagerLevel(manager);
            int serverLevel = this.server.getManagerLevel(manager);
            if (serverLevel >= appLevel) {
                this.writer.writeCodePoint4Bytes(manager, appLevel);
                continue;
            }
            this.writer.writeCodePoint4Bytes(manager, serverLevel);
            this.appRequester.setManagerLevel(manager, serverLevel);
        }
        for (i = 0; i < this.unknownManagers.size(); ++i) {
            manager = (Integer)this.unknownManagers.elementAt(i);
            this.writer.writeCodePoint4Bytes(manager, 0);
        }
        this.writer.endDdm();
    }

    private int parseACCSEC() throws DRDAProtocolException {
        int securityCheckCode = 0;
        int securityMechanism = 0;
        byte[] secTokenIn = null;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 4502: {
                    if (this.reader.getDdmLength() == 0L) break;
                    this.badObjectLength(4502);
                    break;
                }
                case 4514: {
                    this.checkLength(4514, 2);
                    securityMechanism = this.reader.readNetworkShort();
                    if (this.trace) {
                        this.trace("parseACCSEC - Security mechanism = " + securityMechanism);
                    }
                    if (this.server.getSecurityMechanism() != -1 && securityMechanism != this.server.getSecurityMechanism()) {
                        securityCheckCode = 1;
                        if (!this.trace) break;
                        this.trace("parseACCSEC - SECCHKCD_NOTSUPPORTED [1] - " + securityMechanism + " <> " + this.server.getSecurityMechanism() + "\n");
                        break;
                    }
                    if (securityMechanism == 3 || securityMechanism == 4) break;
                    if ((securityMechanism != 9 || securityMechanism == 9 && !this.server.supportsEUSRIDPWD()) && securityMechanism != 8) {
                        securityCheckCode = 1;
                        if (!this.trace) break;
                        this.trace("parseACCSEC - SECCHKCD_NOTSUPPORTED [2]\n");
                        break;
                    }
                    if (securityMechanism == 8) break;
                    try {
                        if (decryptionManager == null) {
                            decryptionManager = new DecryptionManager();
                        }
                        this.myPublicKey = decryptionManager.obtainPublicKey();
                    }
                    catch (SQLException e) {
                        DRDAConnThread.println2Log(null, this.session.drdaID, e.getMessage());
                        securityCheckCode = 10;
                    }
                    break;
                }
                case 8464: {
                    String dbname = this.parseRDBNAM();
                    this.setRdbName(dbname);
                    break;
                }
                case 4572: {
                    secTokenIn = this.reader.readBytes();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (securityMechanism == 0) {
            this.missingCodePoint(4514);
        }
        if (this.database == null) {
            this.setRdbName("gemfirexd");
        }
        this.database.securityMechanism = securityMechanism;
        this.database.secTokenIn = secTokenIn;
        if (securityCheckCode == 0 && this.database.securityMechanism == 8) {
            if (this.trace) {
                SanityManager.ASSERT((securityCheckCode == 0 ? 1 : 0) != 0, (String)("SECMEC_USRSSBPWD: securityCheckCode should not already be set, found it initialized with a value of '" + securityCheckCode + "'."));
            }
            securityCheckCode = this.validateSecMecUSRSSBPWD();
        }
        if (securityCheckCode == 0 && (this.database.securityMechanism == 9 || this.database.securityMechanism == 8) && this.database.secTokenIn == null) {
            securityCheckCode = 14;
        }
        if (securityCheckCode == 0 && (this.database.securityMechanism == 3 || this.database.securityMechanism == 4) && this.database.secTokenIn != null) {
            securityCheckCode = 14;
        }
        if (this.trace) {
            this.trace("** ACCSECRD securityCheckCode is: " + securityCheckCode);
        }
        if (securityCheckCode == 0) {
            this.session.setState(3);
        } else {
            this.session.setState(2);
        }
        return securityCheckCode;
    }

    private void setRdbName(String dbname) {
        Database d = this.session.getDatabase(dbname);
        if (d == null) {
            this.addDatabase(dbname);
        } else {
            if (!this.deferredReset) {
                d.reset();
            }
            this.database = d;
        }
    }

    private Pkgnamcsn parseOPNQRY() throws DRDAProtocolException, SQLException {
        DRDAStatement stmt;
        Pkgnamcsn pkgnamcsn = null;
        boolean gotQryblksz = false;
        int blksize = 0;
        boolean localExecDueToSHOP = false;
        int isolationlevel = 0;
        Set<Integer> bucketSet = null;
        boolean dbSync = false;
        int qryblkctl = 9239;
        int maxblkext = 0;
        int qryrowset = -1;
        int qryclsimp = 2;
        int outovropt = 1;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8464: {
                    this.setDatabase(8204);
                    break;
                }
                case 8467: 
                case 12288: 
                case 12289: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    if (codePoint != 8467) {
                        this.checkPre1302ClientVersionForSingleHop("OPNQRY");
                        bucketSet = this.readBucketSet();
                        if (bucketSet != null) {
                            byte txID;
                            if (bucketSet.contains(ResolverUtils.TOKEN_FOR_DB_SYNC)) {
                                dbSync = true;
                                bucketSet.remove(ResolverUtils.TOKEN_FOR_DB_SYNC);
                            }
                            if (Version.GFXD_20.compareTo(this.gfxdClientVersion) <= 0 && (txID = this.reader.readByte()) == 1) {
                                assert (this.currTxIdForSHOPExecution == null) : "txid not expected as the client has already sent it";
                                isolationlevel = this.reader.readInt(this.getByteOrder());
                                long memberId = this.reader.readLong(this.getByteOrder());
                                long uniqueId = this.reader.readLong(this.getByteOrder());
                                this.currTxIdForSHOPExecution = TXId.valueOf((long)memberId, (int)((int)uniqueId));
                            }
                        }
                        localExecDueToSHOP = true;
                    }
                    if (!SanityManager.TraceSingleHop) break;
                    SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("DRDAConnThread::parseOPNQRY pkgnamcsn: " + pkgnamcsn));
                    break;
                }
                case 8468: {
                    blksize = this.parseQRYBLKSZ();
                    gotQryblksz = true;
                    break;
                }
                case 8498: {
                    qryblkctl = this.reader.readNetworkShort();
                    if (qryblkctl != 9232) {
                        this.invalidCodePoint(qryblkctl);
                    }
                    if (this.trace) {
                        this.trace("!!qryblkctl = " + Integer.toHexString(qryblkctl));
                    }
                    gotQryblksz = true;
                    break;
                }
                case 8513: {
                    maxblkext = this.reader.readSignedNetworkShort();
                    if (!this.trace) break;
                    this.trace("maxblkext = " + maxblkext);
                    break;
                }
                case 8519: {
                    outovropt = this.parseOUTOVROPT();
                    break;
                }
                case 8534: {
                    qryrowset = this.parseQRYROWSET(0);
                    break;
                }
                case 8541: {
                    qryclsimp = this.parseQRYCLSIMP();
                    break;
                }
                case 8542: {
                    this.parseQRYCLSRLS();
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
            return null;
        }
        if (!gotQryblksz) {
            this.missingCodePoint(8468);
        }
        if ((stmt = this.database.getDRDAStatement(pkgnamcsn)) != null && localExecDueToSHOP) {
            EngineConnection conn = this.database.getConnection();
            Checkpoint cp = null;
            if (this.currTxIdForSHOPExecution != null) {
                cp = conn.masqueradeAsTxn(this.currTxIdForSHOPExecution, isolationlevel);
            }
            LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
            if (SanityManager.TraceSingleHop) {
                boolean origSkipLocks = lcc.skipLocks();
                SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("DRDAConnThread::parseOPNQRY conn: stmt == null for pkgnamcsn: " + pkgnamcsn + ", bucketset: " + bucketSet + ", local exec due to shop: " + true + ", origSkipLocks: " + origSkipLocks + " and lcc: " + lcc + " dbSync: " + dbSync + ", currTXIDForSHOPExecution " + this.currTxIdForSHOPExecution));
            }
            stmt.incSingleHopStats();
            lcc.setExecuteLocally(bucketSet, stmt.getRegion(), dbSync, cp);
        }
        if (stmt == null) {
            this.invalidValue(8467);
            return pkgnamcsn;
        }
        stmt.setOPNQRYOptions(blksize, qryblkctl, maxblkext, outovropt, qryrowset, qryclsimp);
        if (this.reader.isChainedWithSameID()) {
            if (this.trace) {
                this.trace("&&&&&& parsing SQLDTA");
            }
            this.parseOPNQRYobjects(stmt);
        }
        return pkgnamcsn;
    }

    private Set<Integer> readBucketSet() throws DRDAProtocolException {
        int sz = this.reader.readNetworkShort();
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < sz; ++i) {
            int bid = this.reader.readNetworkShort();
            set.add(bid);
        }
        return set;
    }

    private void parseOPNQRYobjects(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        do {
            this.correlationID = this.reader.readDssHeader();
            block7: while (this.reader.moreDssData()) {
                int codePoint = this.reader.readLengthAndCodePoint(false);
                switch (codePoint) {
                    case 47: {
                        this.setStmtOrDbByteOrder(false, stmt, this.parseTYPDEFNAM());
                        continue block7;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(stmt);
                        continue block7;
                    }
                    case 9234: {
                        this.parseSQLDTA(stmt);
                        continue block7;
                    }
                    case 5228: {
                        this.readAndSetAllExtParams(stmt, false);
                        continue block7;
                    }
                }
                this.invalidCodePoint(codePoint);
            }
        } while (this.reader.isChainedWithSameID());
    }

    private int parseOUTOVROPT() throws DRDAProtocolException {
        this.checkLength(8519, 1);
        int outovropt = this.reader.readUnsignedByte();
        if (this.trace) {
            this.trace("output override option: " + outovropt);
        }
        if (outovropt != 1 && outovropt != 2) {
            this.invalidValue(8519);
        }
        return outovropt;
    }

    private int parseQRYBLKSZ() throws DRDAProtocolException {
        this.checkLength(8468, 4);
        int blksize = this.reader.readNetworkInt();
        if (this.trace) {
            this.trace("qryblksz = " + blksize);
        }
        if (blksize < 512 || blksize > 0xA00000) {
            this.invalidValue(8468);
        }
        return blksize;
    }

    private int parseNCJBATCHSIZE() throws DRDAProtocolException {
        this.checkLength(12291, 4);
        int batchsize = this.reader.readNetworkInt();
        if (this.trace) {
            this.trace("ncjbatchsize = " + batchsize);
        }
        if (batchsize < 0) {
            this.invalidValue(12291);
        }
        return batchsize;
    }

    private int parseNCJCACHESIZE() throws DRDAProtocolException {
        this.checkLength(8534, 4);
        int cachesize = this.reader.readNetworkInt();
        if (this.trace) {
            this.trace("ncjcachesize = " + cachesize);
        }
        if (cachesize < 0) {
            this.invalidValue(12292);
        }
        return cachesize;
    }

    private int parseQRYROWSET(int minVal) throws DRDAProtocolException {
        this.checkLength(8534, 4);
        int qryrowset = this.reader.readNetworkInt();
        if (this.trace) {
            this.trace("qryrowset = " + qryrowset);
        }
        if (qryrowset < minVal || qryrowset > Short.MAX_VALUE) {
            this.invalidValue(8534);
        }
        return qryrowset;
    }

    private int parseQRYCLSIMP() throws DRDAProtocolException {
        this.checkLength(8541, 1);
        int qryclsimp = this.reader.readUnsignedByte();
        if (this.trace) {
            this.trace("qryclsimp = " + qryclsimp);
        }
        if (qryclsimp != 0 && qryclsimp != 1 && qryclsimp != 2) {
            this.invalidValue(8541);
        }
        return qryclsimp;
    }

    private int parseQRYCLSRLS() throws DRDAProtocolException {
        this.reader.skipBytes();
        return 0;
    }

    private void writeQRYPOPRM() throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8719);
        this.writer.writeScalar2Bytes(4425, 8);
        this.writeRDBNAM(this.database.dbName);
        this.writePKGNAMCSN();
        this.writer.endDdmAndDss();
    }

    private void writeQRYNOPRM(int svrCod) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8706);
        this.writer.writeScalar2Bytes(4425, svrCod);
        this.writeRDBNAM(this.database.dbName);
        this.writePKGNAMCSN();
        this.writer.endDdmAndDss();
    }

    private void writeOPNQFLRM(SQLException e) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8722);
        this.writer.writeScalar2Bytes(4425, 8);
        this.writeRDBNAM(this.database.dbName);
        this.writer.endDdm();
        this.writer.startDdm(9224);
        this.writeSQLCAGRP(e, this.getSqlCode(this.getExceptionSeverity(e)), 0, 0L);
        this.writer.endDdmAndDss();
    }

    private void writePKGNAMCSN(byte[] pkgcnstkn) throws DRDAProtocolException {
        this.writer.startDdm(8467);
        if (this.rdbnam.length() <= 18 && this.rdbcolid.length() <= 18 && this.pkgid.length() <= 18) {
            this.writer.writeScalarPaddedString(this.rdbnam, 18);
            this.writer.writeScalarPaddedString(this.rdbcolid, 18);
            this.writer.writeScalarPaddedString(this.pkgid, 18);
            this.writer.writeScalarPaddedBytes(pkgcnstkn, 8, (byte)0);
            this.writer.writeShort(this.pkgsn);
        } else {
            int len = Math.max(18, this.rdbnam.length());
            this.writer.writeShort(len);
            this.writer.writeScalarPaddedString(this.rdbnam, len);
            len = Math.max(18, this.rdbcolid.length());
            this.writer.writeShort(len);
            this.writer.writeScalarPaddedString(this.rdbcolid, len);
            len = Math.max(18, this.pkgid.length());
            this.writer.writeShort(len);
            this.writer.writeScalarPaddedString(this.pkgid, len);
            this.writer.writeScalarPaddedBytes(pkgcnstkn, 8, (byte)0);
            this.writer.writeShort(this.pkgsn);
        }
        this.writer.endDdm();
    }

    private void writePKGNAMCSN() throws DRDAProtocolException {
        this.writePKGNAMCSN(this.pkgcnstkn.getBytes());
    }

    private DRDAStatement parseCNTQRY() throws DRDAProtocolException, SQLException {
        DRDAStatement stmt;
        Pkgnamcsn pkgnamcsn = null;
        boolean gotQryblksz = false;
        boolean qryrelscr = true;
        long qryrownbr = 1L;
        boolean qryrfrtbl = false;
        int nbrrow = 1;
        int blksize = 0;
        int maxblkext = -1;
        boolean gotQryinsid = false;
        int qryscrorn = 1;
        boolean qryrowsns = false;
        boolean gotQryrowsns = false;
        boolean qryblkrst = false;
        boolean qryrtndta = true;
        int qryrowset = -1;
        int rtnextdta = 1;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            block0 : switch (codePoint) {
                case 8464: {
                    this.setDatabase(8198);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8468: {
                    blksize = this.parseQRYBLKSZ();
                    gotQryblksz = true;
                    break;
                }
                case 8508: {
                    qryrelscr = this.readBoolean(8508);
                    if (!this.trace) break;
                    this.trace("qryrelscr = " + qryrelscr);
                    break;
                }
                case 8530: {
                    this.checkLength(8530, 1);
                    qryscrorn = this.reader.readUnsignedByte();
                    if (this.trace) {
                        this.trace("qryscrorn = " + qryscrorn);
                    }
                    switch (qryscrorn) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block0;
                        }
                    }
                    this.invalidValue(8530);
                    break;
                }
                case 8509: {
                    this.checkLength(8509, 8);
                    qryrownbr = this.reader.readNetworkLong();
                    if (!this.trace) break;
                    this.trace("qryrownbr = " + qryrownbr);
                    break;
                }
                case 8531: {
                    this.checkLength(8531, 1);
                    qryrowsns = this.readBoolean(8531);
                    if (this.trace) {
                        this.trace("qryrowsns = " + qryrowsns);
                    }
                    gotQryrowsns = true;
                    break;
                }
                case 8532: {
                    this.checkLength(8532, 1);
                    qryblkrst = this.readBoolean(8532);
                    if (!this.trace) break;
                    this.trace("qryblkrst = " + qryblkrst);
                    break;
                }
                case 8533: {
                    qryrtndta = this.readBoolean(8533);
                    if (!this.trace) break;
                    this.trace("qryrtndta = " + qryrtndta);
                    break;
                }
                case 8534: {
                    qryrowset = this.parseQRYROWSET(1);
                    if (!this.trace) break;
                    this.trace("qryrowset = " + qryrowset);
                    break;
                }
                case 8510: {
                    qryrfrtbl = this.readBoolean(8510);
                    if (!this.trace) break;
                    this.trace("qryrfrtbl = " + qryrfrtbl);
                    break;
                }
                case 8506: {
                    this.checkLength(8506, 4);
                    nbrrow = this.reader.readNetworkInt();
                    if (!this.trace) break;
                    this.trace("nbrrow = " + nbrrow);
                    break;
                }
                case 8513: {
                    this.checkLength(8513, 2);
                    maxblkext = this.reader.readSignedNetworkShort();
                    if (!this.trace) break;
                    this.trace("maxblkext = " + maxblkext);
                    break;
                }
                case 8520: {
                    this.checkLength(8520, 1);
                    rtnextdta = this.reader.readUnsignedByte();
                    if (rtnextdta != 1 && rtnextdta != 2) {
                        this.invalidValue(8520);
                    }
                    if (!this.trace) break;
                    this.trace("rtnextdta = " + rtnextdta);
                    break;
                }
                case 8539: {
                    this.checkLength(8539, 8);
                    long qryinsid = this.reader.readNetworkLong();
                    gotQryinsid = true;
                    if (!this.trace) break;
                    this.trace("qryinsid = " + qryinsid);
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
            return null;
        }
        if (!gotQryblksz) {
            this.missingCodePoint(8468);
        }
        if (this.sqlamLevel >= 7 && !gotQryinsid) {
            this.missingCodePoint(8539);
        }
        if ((stmt = this.database.getDRDAStatement(pkgnamcsn)) == null) {
            this.invalidValue(8198);
            return null;
        }
        if (stmt.rsIsClosed()) {
            this.writeQRYNOPRM(8);
            this.skipRemainder(true);
            return null;
        }
        stmt.setQueryOptions(blksize, qryrelscr, qryrownbr, qryrfrtbl, nbrrow, maxblkext, qryscrorn, qryrowsns, qryblkrst, qryrtndta, qryrowset, rtnextdta);
        if (this.reader.isChainedWithSameID()) {
            this.parseCNTQRYobjects(stmt);
        }
        return stmt;
    }

    private void skipRemainder(boolean onlySkipSameIds) throws DRDAProtocolException {
        this.reader.skipDss();
        while (this.reader.isChainedWithSameID() || !onlySkipSameIds && this.reader.isChainedWithDiffID()) {
            this.reader.readDssHeader();
            this.reader.skipDss();
        }
    }

    private void parseCNTQRYobjects(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        do {
            this.correlationID = this.reader.readDssHeader();
            block4: while (this.reader.moreDssData()) {
                int codePoint = this.reader.readLengthAndCodePoint(false);
                switch (codePoint) {
                    case 9237: {
                        this.parseOUTOVR(stmt);
                        continue block4;
                    }
                }
                this.invalidCodePoint(codePoint);
            }
        } while (this.reader.isChainedWithSameID());
    }

    private void parseOUTOVR(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        boolean first = true;
        int start = 0;
        while (true) {
            int dtaGrpLen = this.reader.readUnsignedByte();
            int tripType = this.reader.readUnsignedByte();
            int tripId = this.reader.readUnsignedByte();
            if (tripType == 113) break;
            int numVars = (dtaGrpLen - 3) / 3;
            if (this.trace) {
                this.trace("num of vars is: " + numVars);
            }
            int[] outovr_drdaType = null;
            if (first) {
                outovr_drdaType = new int[numVars];
                first = false;
            } else {
                int[] oldoutovr_drdaType = stmt.getOutovr_drdaType();
                int oldlen = oldoutovr_drdaType.length;
                outovr_drdaType = new int[oldlen + numVars];
                System.arraycopy(oldoutovr_drdaType, 0, outovr_drdaType, 0, oldlen);
                start = oldlen;
            }
            for (int i = start; i < numVars + start; ++i) {
                int drdaType = this.reader.readUnsignedByte();
                if (!this.database.supportsLocator() && drdaType >= 24 && drdaType <= 27) {
                    if (this.trace) {
                        this.trace("ignoring drdaType: " + drdaType);
                    }
                    this.reader.readNetworkShort();
                    continue;
                }
                outovr_drdaType[i] = drdaType;
                if (this.trace) {
                    this.trace("drdaType is: " + outovr_drdaType[i]);
                }
                int precision = this.reader.readNetworkShort();
                if (this.trace) {
                    this.trace("drdaLength is: " + precision);
                }
                int n = i;
                outovr_drdaType[n] = outovr_drdaType[n] | precision << 8;
            }
            stmt.setOutovr_drdaType(outovr_drdaType);
        }
        this.reader.skipBytes();
    }

    private void writePBSD() throws SQLException, DRDAProtocolException {
        boolean logRegionsSent;
        StringBuilder sb;
        LanguageConnectionContext lcc;
        Database database = this.database;
        if (database == null || !this.appRequester.supportsSessionDataCaching()) {
            return;
        }
        PiggyBackedSessionData pbsd = database.getPiggyBackedSessionData(true);
        if (this.trace) {
            SanityManager.ASSERT((pbsd != null ? 1 : 0) != 0, (String)"pbsd is not expected to be null");
        }
        if (pbsd == null) {
            return;
        }
        this.deferredReset = false;
        pbsd.refresh();
        Checkpoint cp = null;
        EngineConnection econn = database.getConnection();
        if (econn != null && (lcc = econn.getLanguageConnectionContext()) != null) {
            cp = lcc.getCheckpoint();
        }
        boolean endDdmDdsToBeWritten = false;
        boolean endDdmDdsWritten = false;
        boolean modified = pbsd.isModified();
        if (modified) {
            this.writer.createDssReply();
            this.writer.startDdm(49152);
            if (pbsd.isIsoModified()) {
                this.writer.writeScalar1Byte(49153, pbsd.getIso());
            }
            if (pbsd.isSchemaModified()) {
                this.writer.startDdm(49154);
                this.writer.writeString(pbsd.getSchema());
                this.writer.endDdm();
            }
            if (pbsd.isIsoModified() && this.gfxdClientVersion != null) {
                TXId newTxId = pbsd.getTXId();
                int nonNullTxIdFlag = 0;
                long memberId = 0L;
                long uniqId = 0L;
                if (newTxId == null) {
                    nonNullTxIdFlag = 0;
                } else {
                    nonNullTxIdFlag = 1;
                    memberId = newTxId.getMemberId();
                    uniqId = newTxId.getUniqId();
                }
                this.writer.writeScalar1Byte(49155, nonNullTxIdFlag);
                if (nonNullTxIdFlag == 1) {
                    this.writer.writeLong(memberId);
                    this.writer.writeLong(uniqId);
                }
            }
            if (pbsd.isModified() && !pbsd.serverVersionSent() && this.gfxdClientVersion != null) {
                Version v = Version.CURRENT;
                this.writer.writeScalar2Bytes(49156, v.ordinal());
            }
            endDdmDdsToBeWritten = true;
            if (cp == null) {
                endDdmDdsWritten = true;
                this.writer.endDdmAndDss();
            }
        }
        if (!modified && cp != null && this.gfxdClientVersion != null) {
            if (SanityManager.TraceSingleHop) {
                SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)"writing codepoint pbsd: 49152");
            }
            this.writer.createDssReply();
            this.writer.startDdm(49152);
            endDdmDdsToBeWritten = true;
        }
        StringBuilder stringBuilder = sb = (logRegionsSent = SanityManager.TraceSingleHop) ? new StringBuilder() : null;
        if (cp != null) {
            Object[] brs = this.getBuckets(cp);
            int numChanged = brs == null || brs.length == 0 ? 0 : brs.length;
            this.writer.writeScalar2Bytes(49157, numChanged);
            for (int i = 0; i < numChanged; ++i) {
                Bucket b = (Bucket)brs[i];
                int prid = b.getPartitionedRegion().getPRId();
                int bid = b.getId();
                this.writer.writeShort(prid);
                this.writer.writeShort(bid);
                if (sb == null) continue;
                sb.append(prid);
                sb.append(':');
                sb.append(bid);
                sb.append(" --  ");
                sb.append(b.getName());
                sb.append(" ");
            }
        }
        if (sb != null) {
            SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("affected regions being sent: " + sb.toString()));
        }
        if (endDdmDdsToBeWritten && !endDdmDdsWritten) {
            this.writer.endDdmAndDss();
        }
        pbsd.setUnmodified();
        if (this.trace) {
            PiggyBackedSessionData pbsdNew = database.getPiggyBackedSessionData(true);
            SanityManager.ASSERT((pbsdNew == pbsd ? 1 : 0) != 0, (String)"pbsdNew and pbsd are expected to reference the same object");
            pbsd.refresh();
            SanityManager.ASSERT((!pbsd.isModified() ? 1 : 0) != 0, (String)("pbsd=(" + pbsd + ") is not expected to be modified"));
        }
    }

    private Object[] getBuckets(Checkpoint cp) {
        int numChanged = cp.numChanged();
        if (numChanged == 0) {
            return null;
        }
        ArrayList<Bucket> buckets = null;
        for (int i = 0; i < numChanged; ++i) {
            Object ob = cp.elementAt(i);
            if (!(ob instanceof Bucket)) continue;
            if (buckets == null) {
                buckets = new ArrayList<Bucket>();
            }
            buckets.add((Bucket)ob);
        }
        return buckets.toArray();
    }

    private void writeOPNQRYRM(boolean isDssObject, DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        if (this.trace) {
            this.trace("WriteOPNQRYRM");
        }
        if (isDssObject) {
            this.writer.createDssObject();
        } else {
            this.writer.createDssReply();
        }
        this.writer.startDdm(8709);
        this.writer.writeScalar2Bytes(4425, 0);
        int prcType = stmt.getQryprctyp();
        if (this.trace) {
            this.trace("sending QRYPRCTYP: " + prcType);
        }
        this.writer.writeScalar2Bytes(8450, prcType);
        if (stmt.getCurrentDrdaResultSet().withHoldCursor == 1) {
            this.writer.writeScalar1Byte(8479, -15);
        }
        if (this.sqlamLevel >= 7) {
            this.writer.writeScalarHeader(8539, 8);
            this.writer.writeInt(0);
            this.writer.writeInt(this.session.qryinsid++);
            if (stmt.isScrollable()) {
                this.writer.writeScalar1Byte(8521, -15);
                if (stmt.getConcurType() == 1008 && stmt.getResultSet().getType() == 1004) {
                    this.writer.writeScalar1Byte(8535, 2);
                } else {
                    this.writer.writeScalar1Byte(8535, 1);
                }
            }
            if (stmt.getConcurType() == 1008) {
                if (stmt.getResultSet() != null) {
                    if (stmt.getResultSet().getConcurrency() == 1008) {
                        this.writer.writeScalar1Byte(8528, 4);
                    } else {
                        this.writer.writeScalar1Byte(8528, 1);
                    }
                } else {
                    this.writer.writeScalar1Byte(8528, 4);
                }
            } else {
                this.writer.writeScalar1Byte(8528, 1);
            }
        }
        this.writer.endDdmAndDss();
    }

    private void writeENDQRYRM(int svrCod) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8715);
        this.writer.writeScalar2Bytes(4425, svrCod);
        this.writer.endDdmAndDss();
    }

    private void writeABNUOWRM() throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8717);
        this.writer.writeScalar2Bytes(4425, 8);
        this.writeRDBNAM(this.database.dbName);
        this.writer.endDdmAndDss();
    }

    private String parseRDBNAM() throws DRDAProtocolException {
        byte[] rdbName = this.reader.readBytes();
        if (rdbName.length == 0) {
            this.rdbNotFound(null);
        }
        if (rdbName.length < 18 || rdbName.length > 255) {
            this.badObjectLength(8464);
        }
        String name = this.reader.convertBytes(rdbName);
        name = name.trim();
        if (this.trace) {
            this.trace("RdbName = " + name + "; actual = " + "gemfirexd");
        }
        return "gemfirexd";
    }

    private void writeACCSECRD(int securityCheckCode) throws DRDAProtocolException {
        this.writer.createDssObject();
        this.writer.startDdm(5292);
        if (securityCheckCode != 1) {
            this.writer.writeScalar2Bytes(4514, this.database.securityMechanism);
        } else if (this.server.getSecurityMechanism() != -1) {
            this.writer.writeScalar2Bytes(4514, this.server.getSecurityMechanism());
        } else {
            this.writer.writeScalar2Bytes(4514, 3);
            if (this.server.supportsEUSRIDPWD()) {
                this.writer.writeScalar2Bytes(4514, 9);
            }
            this.writer.writeScalar2Bytes(4514, 4);
            this.writer.writeScalar2Bytes(4514, 8);
        }
        if (securityCheckCode != 0) {
            this.writer.writeScalar1Byte(4516, securityCheckCode);
        } else if (this.database.securityMechanism == 9) {
            this.writer.writeScalarBytes(4572, this.myPublicKey);
        } else if (this.database.securityMechanism == 8) {
            this.writer.writeScalarBytes(4572, this.myTargetSeed);
        }
        this.writer.endDdmAndDss();
        if (securityCheckCode != 0) {
            this.skipRemainder(false);
        }
        this.finalizeChain();
    }

    /*
     * Unable to fully structure code
     */
    private int parseSECCHK() throws DRDAProtocolException {
        block43: {
            block42: {
                securityCheckCode = 0;
                securityMechanism = 0;
                this.databaseAccessException = null;
                this.reader.markCollection();
                codePoint = this.reader.getCodePoint();
                if (!this.deferredReset) break block42;
                while (codePoint != -1) {
                    switch (codePoint) {
                        case 4502: 
                        case 4512: 
                        case 4513: 
                        case 4514: 
                        case 4572: 
                        case 4574: 
                        case 8464: {
                            this.reader.skipBytes();
                            break;
                        }
                        default: {
                            this.invalidCodePoint(codePoint);
                        }
                    }
                    codePoint = this.reader.getCodePoint();
                }
                break block43;
            }
            while (codePoint != -1) {
                switch (codePoint) {
                    case 4502: {
                        this.reader.skipBytes();
                        break;
                    }
                    case 4514: {
                        this.checkLength(4514, 2);
                        securityMechanism = this.reader.readNetworkShort();
                        if (this.trace) {
                            this.trace("parseSECCHK - Security mechanism = " + securityMechanism);
                        }
                        if (securityMechanism == this.database.securityMechanism) break;
                        this.invalidValue(4514);
                        break;
                    }
                    case 4572: {
                        if (this.database.securityMechanism != 9 && this.database.securityMechanism != 8) {
                            securityCheckCode = 14;
                            this.reader.skipBytes();
                            break;
                        }
                        if (this.database.securityMechanism != 9) ** GOTO lbl61
                        if (this.database.decryptedUserId != null) ** GOTO lbl49
                        try {
                            this.database.decryptedUserId = this.reader.readEncryptedString(DRDAConnThread.decryptionManager, this.database.securityMechanism, this.myPublicKey, this.database.secTokenIn);
                        }
                        catch (SQLException se) {
                            DRDAConnThread.println2Log(this.database.dbName, this.session.drdaID, se.getMessage());
                            if (securityCheckCode != 0) ** GOTO lbl45
                            securityCheckCode = 19;
                        }
lbl45:
                        // 3 sources

                        this.database.userId = this.database.decryptedUserId;
                        if (!this.trace) break;
                        this.trace("**decrypted userid is: " + this.database.userId);
                        break;
lbl49:
                        // 1 sources

                        if (this.database.decryptedPassword != null) break;
                        try {
                            this.database.decryptedPassword = this.reader.readEncryptedString(DRDAConnThread.decryptionManager, this.database.securityMechanism, this.myPublicKey, this.database.secTokenIn);
                        }
                        catch (SQLException se) {
                            DRDAConnThread.println2Log(this.database.dbName, this.session.drdaID, se.getMessage());
                            if (securityCheckCode != 0) ** GOTO lbl57
                            securityCheckCode = 15;
                        }
lbl57:
                        // 3 sources

                        this.database.password = this.database.decryptedPassword;
                        if (!this.trace) break;
                        this.trace("**decrypted password is: " + this.database.password);
                        break;
lbl61:
                        // 1 sources

                        if (this.database.securityMechanism == 8) {
                            if (this.database.passwordSubstitute != null) break;
                            this.database.passwordSubstitute = this.reader.readBytes();
                            if (this.trace) {
                                this.trace("** Substitute Password is:" + DecryptionManager.toHexString(this.database.passwordSubstitute, 0, this.database.passwordSubstitute.length));
                            }
                            this.database.password = DecryptionManager.toHexString(this.database.passwordSubstitute, 0, this.database.passwordSubstitute.length);
                            break;
                        }
                        this.tooMany(4572);
                        break;
                    }
                    case 4513: {
                        this.database.password = this.reader.readString();
                        if (!this.trace) break;
                        this.trace("PASSWORD " + this.database.password);
                        break;
                    }
                    case 4574: {
                        this.reader.skipBytes();
                        break;
                    }
                    case 4512: {
                        this.database.userId = this.reader.readString();
                        if (!this.trace) break;
                        this.trace("USERID " + this.database.userId);
                        break;
                    }
                    case 8464: {
                        dbname = this.parseRDBNAM();
                        if (this.database != null) {
                            if (this.database.dbName.equals(dbname)) break;
                            this.rdbnamMismatch(4206);
                            break;
                        }
                        this.addDatabase(dbname);
                        break;
                    }
                    default: {
                        this.invalidCodePoint(codePoint);
                    }
                }
                codePoint = this.reader.getCodePoint();
            }
            if (securityMechanism == 0) {
                this.missingCodePoint(4514);
            }
            if (securityCheckCode == 0 && (this.database.securityMechanism == 3 || this.database.securityMechanism == 4)) {
                if (this.database.userId == null) {
                    securityCheckCode = 18;
                } else if (this.database.securityMechanism == 3 && this.database.password == null) {
                    securityCheckCode = 16;
                }
            }
            if (securityCheckCode == 0 && this.database.securityMechanism == 8) {
                if (this.database.userId == null) {
                    securityCheckCode = 18;
                } else if (this.database.passwordSubstitute == null) {
                    securityCheckCode = 16;
                }
            }
            if (securityCheckCode == 0 && this.database.securityMechanism == 9) {
                if (this.database.decryptedUserId == null) {
                    securityCheckCode = 18;
                } else if (this.database.decryptedPassword == null) {
                    securityCheckCode = 16;
                }
            }
        }
        if (securityCheckCode == 0 && this.databaseAccessException == null) {
            if (this.deferredReset) {
                try {
                    this.database.getConnection().resetFromPool();
                    this.database.getConnection().setHoldability(1);
                }
                catch (SQLException sqle) {
                    this.handleException(sqle);
                }
            } else {
                securityCheckCode = this.verifyUserIdPassword();
            }
        }
        if (securityCheckCode == 0) {
            this.session.setState(4);
        }
        return securityCheckCode;
    }

    private void writeSECCHKRM(int securityCheckCode) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(4633);
        this.writer.writeScalar2Bytes(4425, this.svrcodFromSecchkcd(securityCheckCode));
        this.writer.writeScalar1Byte(4516, securityCheckCode);
        this.writer.endDdmAndDss();
        if (securityCheckCode != 0) {
            this.skipRemainder(false);
        }
        this.finalizeChain();
    }

    private int svrcodFromSecchkcd(int securityCheckCode) {
        if (securityCheckCode == 0 || securityCheckCode == 2 || securityCheckCode == 5 || securityCheckCode == 8) {
            return 0;
        }
        return 8;
    }

    /*
     * Unable to fully structure code
     */
    private int parseACCRDB() throws DRDAProtocolException, SQLException {
        svrcod = 0;
        this.copyToRequired(DRDAConnThread.ACCRDB_REQUIRED);
        this.reader.markCollection();
        codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8463: {
                    this.checkLength(8463, 2);
                    sqlam = this.reader.readNetworkShort();
                    if (this.trace) {
                        this.trace("RDBACCCL = " + sqlam);
                    }
                    if (sqlam != 9223) {
                        this.invalidValue(8463);
                    }
                    this.removeFromRequired(8463);
                    break;
                }
                case 8501: {
                    this.database.crrtkn = this.reader.readBytes();
                    if (this.trace) {
                        this.trace("crrtkn " + this.convertToHexString(this.database.crrtkn));
                    }
                    this.removeFromRequired(8501);
                    l = this.database.crrtkn.length;
                    if (l > 255) {
                        this.tooBig(8501);
                    }
                    if (l < 9 || l > 23) {
                        this.invalidValue(8501);
                    }
                    part1 = new byte[l - 6];
                    for (i = 0; i < part1.length; ++i) {
                        part1[i] = this.database.crrtkn[i];
                    }
                    time = SignedBinary.getLong(this.database.crrtkn, l - 8, 1);
                    this.session.drdaID = this.reader.convertBytes(part1) + time + "{  " + this.session.connNum + "  }";
                    if (this.trace) {
                        this.trace("******************************************drdaID is: " + this.session.drdaID);
                    }
                    this.database.setDrdaID(this.session.drdaID);
                    break;
                }
                case 8464: {
                    dbname = this.parseRDBNAM();
                    if (this.database != null) {
                        if (!this.database.dbName.equals(dbname)) {
                            this.rdbnamMismatch(8193);
                        }
                    } else {
                        d = this.session.getDatabase(dbname);
                        if (d == null) {
                            this.addDatabase(dbname);
                        } else {
                            this.database = d;
                            ++this.database.accessCount;
                        }
                    }
                    this.removeFromRequired(8464);
                    break;
                }
                case 4398: {
                    this.appRequester.setClientVersion(this.reader.readString());
                    if (this.trace) {
                        this.trace("prdId " + this.appRequester.prdid);
                    }
                    if (this.appRequester.prdid.length() > 8) {
                        this.tooBig(4398);
                    }
                    if (this.appRequester.getClientType() == 1 && this.appRequester.greaterThanOrEqualTo(1, 5, 0)) ** GOTO lbl-1000
                    if (this.appRequester.getClientType() == 3) lbl-1000:
                    // 2 sources

                    {
                        this.sendWarningsOnCNTQRY = true;
                    } else {
                        this.sendWarningsOnCNTQRY = false;
                    }
                    if (this.appRequester.getClientType() == 3 && this.appRequester.greaterThanOrEqualTo(10, 2, 0)) {
                        this.diagnosticLevel = (byte)-15;
                    }
                    this.removeFromRequired(4398);
                    break;
                }
                case 47: {
                    this.setStmtOrDbByteOrder(true, null, this.parseTYPDEFNAM());
                    this.removeFromRequired(47);
                    break;
                }
                case 53: {
                    this.parseTYPDEFOVR(null);
                    this.removeFromRequired(53);
                    break;
                }
                case 8474: {
                    this.checkLength(8474, 1);
                    allowUpd = this.reader.readByte() & 255;
                    this.database.resetFlags();
                    if ((allowUpd & 2) == 2) {
                        this.database.disableStreaming = true;
                        allowUpd &= -3;
                    }
                    if ((allowUpd & 4) == 4) {
                        this.database.skipListeners = true;
                        allowUpd &= -5;
                    }
                    if ((allowUpd & 8) == 8) {
                        this.database.skipConstraintChecks = true;
                        allowUpd &= -9;
                    }
                    if (((allowUpdHN = allowUpd & -16) & -32) == allowUpdHN) {
                        this.database.failover = true;
                    }
                    if ((allowUpdHN & -48) == allowUpdHN) {
                        this.database.syncCommits = true;
                    }
                    if ((allowUpdHN & -80) == allowUpdHN) {
                        this.database.disableTXBatching = true;
                    }
                    if ((allowUpdHN & 127) == allowUpdHN) {
                        if (!Misc.getMemStore().isSnappyStore()) {
                            this.database.queryHDFS = true;
                        } else {
                            this.database.routeQuery = true;
                        }
                    }
                    this.database.rdbAllowUpdates = (allowUpd & 15) == 1;
                    goodImplicitSavePoint = 0;
                    memberId = 0L;
                    uniqueId = 0L;
                    isolationlevel = 0;
                    if (this.database.failover && this.gfxdClientVersion != null && (txnFailoverCtxWritten = this.reader.readByte()) == 1) {
                        goodImplicitSavePoint = this.reader.readInt(this.getByteOrder());
                        isolationlevel = this.reader.readInt(this.getByteOrder());
                        memberId = this.reader.readLong(this.getByteOrder());
                        uniqueId = this.reader.readLong(this.getByteOrder());
                        conn = this.database.getConnection();
                        if (conn != null && DRDAConnThread.ROLLBACK_IMPLEMENTED_FULLY) {
                            gft = (GemFireTransaction)conn.getLanguageConnectionContext().getTransactionExecute();
                            gft.rollbackToPreviousState(isolationlevel, goodImplicitSavePoint, memberId, (int)uniqueId);
                        }
                    }
                    if (!this.trace) break;
                    this.trace("rdbAllowUpdates = " + this.database.rdbAllowUpdates);
                    break;
                }
                case 8452: {
                    if (this.reader.getDdmLength() > 255L) {
                        this.tooBig(8452);
                    }
                    prdlen = (int)this.reader.getDdmLength();
                    this.reader.readByte();
                    bytesRead = this.checkPRDDTAForGFXDClientMagic(prdlen);
                    this.gfxdClientVersion = null;
                    if (bytesRead == ClientSharedData.BYTES_PREFIX_CLIENT_VERSION_LENGTH) {
                        byteOrder = true;
                        versionOrdinal = this.reader.readShort(1);
                        if (versionOrdinal > 0) {
                            try {
                                this.gfxdClientVersion = Version.fromOrdinal((short)versionOrdinal, (boolean)false);
                                if (Version.GFXD_20.compareTo(this.gfxdClientVersion) > 0) {
                                    this.gfxdClientVersion = null;
                                }
                            }
                            catch (UnsupportedGFXDVersionException var21_24) {
                                // empty catch block
                            }
                        }
                        if (((connProps = this.reader.readInt(1)) & 1) != 0) {
                            this.database.skipLocks = true;
                        }
                        bytesRead += 6;
                    }
                    this.reader.skipBytes(prdlen - 1 - bytesRead);
                    break;
                }
                case 8507: {
                    b = this.reader.readByte();
                    if ((b & 255) != 241) break;
                    this.database.sendTRGDFTRT = true;
                    break;
                }
                case 8481: {
                    decDelim = this.reader.readNetworkShort();
                    if (this.trace) {
                        this.trace("decimal delimiter = " + Integer.toHexString(decDelim));
                    }
                    if (decDelim == 9276 || decDelim == 9246) break;
                    throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_VALNSPRM, this, codePoint, 0, new Object[]{"unsupported decimal delimiter code " + Integer.toHexString(decDelim)});
                }
                case 8480: {
                    strDelim = this.reader.readNetworkShort();
                    if (this.trace) {
                        this.trace("string delimiter = " + Integer.toHexString(strDelim));
                    }
                    if (strDelim == 9254 || strDelim == 9246) break;
                    throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_VALNSPRM, this, codePoint, 0, new Object[]{"unsupported string delimiter code " + Integer.toHexString(strDelim)});
                }
                case 8544: {
                    lvl = this.reader.readByte();
                    if (lvl == -15 || lvl == -14) {
                        this.diagnosticLevel = lvl;
                        break;
                    }
                    this.diagnosticLevel = (byte)-16;
                    break;
                }
                case 12292: {
                    this.database.ncjCacheSize = this.parseNCJCACHESIZE();
                    this.database.checkAndSetPossibleNCJCacheSizeDuplicate();
                    break;
                }
                case 12291: {
                    this.database.ncjBatchSize = this.parseNCJBATCHSIZE();
                    this.database.checkAndSetPossibleNCJBatchSizeDuplicate();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        this.checkRequired(8193);
        if (this.database.ccsidDBC != 0 && !this.server.supportsCCSID(this.database.ccsidDBC) || this.database.ccsidMBC != 0 && !this.server.supportsCCSID(this.database.ccsidMBC)) {
            svrcod = 4;
        }
        return svrcod;
    }

    private String parseTYPDEFNAM() throws DRDAProtocolException {
        String typDefNam = this.reader.readString();
        if (this.trace) {
            this.trace("typeDefName " + typDefNam);
        }
        if (typDefNam.length() > 255) {
            this.tooBig(47);
        }
        this.checkValidTypDefNam(typDefNam);
        if (!(typDefNam.equals("QTDSQLASC") || typDefNam.equals("QTDSQLJVM") || typDefNam.equals("QTDSQL370") || typDefNam.equals("QTDSQL400") || typDefNam.equals("QTDSQLX86"))) {
            this.valueNotSupported(47);
        }
        return typDefNam;
    }

    private void setStmtOrDbByteOrder(boolean setDatabase, DRDAStatement stmt, String typDefNam) {
        int byteOrder;
        int n = byteOrder = typDefNam.equals("QTDSQLX86") ? 2 : 1;
        if (setDatabase) {
            this.database.typDefNam = typDefNam;
            this.database.byteOrder = byteOrder;
        } else {
            stmt.typDefNam = typDefNam;
            stmt.byteOrder = byteOrder;
        }
    }

    private void writeACCRDBRM(int svrcod) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8705);
        this.writer.writeScalar2Bytes(4425, svrcod);
        this.writer.writeScalarString(4398, NetworkServerControlImpl.prdId);
        this.writer.writeScalarString(47, "QTDSQLASC");
        this.writeTYPDEFOVR();
        this.writer.endDdmAndDss();
        if (this.appRequester.getClientType() == 3 && this.appRequester.greaterThanOrEqualTo(10, 7, 0) || this.gfxdClientVersion != null) {
            try {
                this.writePBSD();
            }
            catch (SQLException se) {
                this.server.consoleExceptionPrint(se);
                this.errorInChain(se);
            }
        }
        this.finalizeChain();
    }

    private void writeTYPDEFOVR() throws DRDAProtocolException {
        this.writer.startDdm(53);
        this.writer.writeScalar2Bytes(4508, 1208);
        this.writer.writeScalar2Bytes(4510, 1208);
        if (this.database.sendTRGDFTRT) {
            this.writer.startDdm(8485);
            this.writer.writeShort(9269);
            this.writer.endDdm();
            this.writer.startDdm(4512);
            this.writer.writeString(this.database.userId);
            this.writer.endDdm();
        }
        this.writer.endDdm();
    }

    /*
     * Unable to fully structure code
     */
    private void parseTYPDEFOVR(DRDAStatement st) throws DRDAProtocolException {
        ccsidSBC = 0;
        ccsidDBC = 0;
        ccsidMBC = 0;
        ccsidSBCEncoding = null;
        ccsidDBCEncoding = null;
        ccsidMBCEncoding = null;
        this.reader.markCollection();
        codePoint = this.reader.getCodePoint();
        if (codePoint == -1 && st != null) {
            this.missingCodePoint(4508);
        }
        while (codePoint != -1) {
            switch (codePoint) {
                case 4508: {
                    this.checkLength(4508, 2);
                    ccsidSBC = this.reader.readNetworkShort();
                    try {
                        ccsidSBCEncoding = CharacterEncodings.getJavaEncoding(ccsidSBC);
                    }
                    catch (Exception e) {
                        this.valueNotSupported(4508);
                    }
                    if (!this.trace) break;
                    this.trace("ccsidsbc = " + ccsidSBC + " encoding = " + ccsidSBCEncoding);
                    break;
                }
                case 4509: {
                    this.checkLength(4509, 2);
                    ccsidDBC = this.reader.readNetworkShort();
                    try {
                        ccsidDBCEncoding = CharacterEncodings.getJavaEncoding(ccsidDBC);
                    }
                    catch (Exception e) {
                        ccsidDBCEncoding = null;
                        if (st == null) ** GOTO lbl34
                        this.valueNotSupported(4508);
                    }
lbl34:
                    // 3 sources

                    if (!this.trace) break;
                    this.trace("ccsiddbc = " + ccsidDBC + " encoding = " + ccsidDBCEncoding);
                    break;
                }
                case 4510: {
                    this.checkLength(4510, 2);
                    ccsidMBC = this.reader.readNetworkShort();
                    try {
                        ccsidMBCEncoding = CharacterEncodings.getJavaEncoding(ccsidMBC);
                    }
                    catch (Exception e) {
                        ccsidMBCEncoding = null;
                        if (st == null) ** GOTO lbl47
                        this.valueNotSupported(4510);
                    }
lbl47:
                    // 3 sources

                    if (!this.trace) break;
                    this.trace("ccsidmbc = " + ccsidMBC + " encoding = " + ccsidMBCEncoding);
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (st == null) {
            if (ccsidSBC != 0) {
                this.database.ccsidSBC = ccsidSBC;
                this.database.ccsidSBCEncoding = ccsidSBCEncoding;
            }
            if (ccsidDBC != 0) {
                this.database.ccsidDBC = ccsidDBC;
                this.database.ccsidDBCEncoding = ccsidDBCEncoding;
            }
            if (ccsidMBC != 0) {
                this.database.ccsidMBC = ccsidMBC;
                this.database.ccsidMBCEncoding = ccsidMBCEncoding;
            }
        } else {
            if (ccsidSBC != 0) {
                st.ccsidSBC = ccsidSBC;
                st.ccsidSBCEncoding = ccsidSBCEncoding;
            }
            if (ccsidDBC != 0) {
                st.ccsidDBC = ccsidDBC;
                st.ccsidDBCEncoding = ccsidDBCEncoding;
            }
            if (ccsidMBC != 0) {
                st.ccsidMBC = ccsidMBC;
                st.ccsidMBCEncoding = ccsidMBCEncoding;
            }
        }
    }

    private int parsePRPSQLSTT() throws DRDAProtocolException, SQLException {
        boolean rtnsqlda = false;
        boolean rtnOutput = true;
        boolean isUnprepared = false;
        boolean sendSingleHopInfo = false;
        boolean createQueryInfo = true;
        String regionName = null;
        boolean sendStatementUUID = false;
        Pkgnamcsn pkgnamcsn = null;
        DRDAStatement stmt = null;
        Database databaseToSet = null;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8464: {
                    this.setDatabase(8205);
                    databaseToSet = this.database;
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 12289: {
                    this.checkPre1302ClientVersionForSingleHop("PRPSQLSTT");
                    pkgnamcsn = this.parsePKGNAMCSN();
                    regionName = this.parseNOCMorNOCS();
                    if (regionName == null || regionName.length() <= 0) break;
                    createQueryInfo = false;
                    break;
                }
                case 8470: {
                    this.checkLength(8470, 1);
                    byte val = this.reader.readByte();
                    isUnprepared = (val & 4) == 4;
                    if (isUnprepared) {
                        val = (byte)(val & 0xFFFFFFFB);
                        isUnprepared = true;
                    } else {
                        isUnprepared = false;
                    }
                    if (val == -15) {
                        rtnsqlda = true;
                        break;
                    }
                    if (val == -16) {
                        rtnsqlda = false;
                        break;
                    }
                    this.invalidCodePoint(codePoint);
                    break;
                }
                case 8518: {
                    this.checkLength(8518, 1);
                    int sqldaType = this.reader.readByte();
                    if (sqldaType == 6) {
                        this.checkPre1302ClientVersionForSingleHop("PRPSQLSTT");
                        sqldaType = 4;
                        sendSingleHopInfo = true;
                        if (SanityManager.TraceSingleHop) {
                            SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("DRDAConnThread::parsePRPSQLSTT requires single hop information as sqldaType is: " + sqldaType));
                        }
                    }
                    rtnOutput = this.parseTYPSQLDA((byte)sqldaType);
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                case 12290: {
                    this.reader.skipBytes();
                    sendStatementUUID = true;
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        stmt = this.database.newDRDAStatement(pkgnamcsn);
        stmt.setStatus("PARSING");
        this.database.setCurrentStatement(stmt);
        if (sendSingleHopInfo) {
            stmt.setSendSingleHopInfo(true);
        }
        String sqlStmt = this.parsePRPSQLSTTobjects(stmt);
        if (databaseToSet != null) {
            stmt.setDatabase(this.database);
        }
        if (this.pendingSetSchema != null) {
            stmt.setSchema(this.pendingSetSchema);
            this.pendingSetSchema = null;
        }
        if (isUnprepared) {
            stmt.implicitPrepare(sqlStmt);
        } else {
            stmt.explicitPrepare(sqlStmt, createQueryInfo);
            if (regionName != null) {
                stmt.setRegionName(regionName);
            }
        }
        if (sendStatementUUID) {
            stmt.setSendStatementUUID(true);
        }
        stmt.setStatus("COMPILED");
        if (!rtnsqlda) {
            return 0;
        }
        if (rtnOutput) {
            return 2;
        }
        return 1;
    }

    private String parsePRPSQLSTTobjects(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        String sqlStmt = null;
        do {
            this.correlationID = this.reader.readDssHeader();
            block7: while (this.reader.moreDssData()) {
                int codePoint = this.reader.readLengthAndCodePoint(false);
                switch (codePoint) {
                    case 9236: {
                        sqlStmt = this.parseEncodedString();
                        if (sqlStmt == null) {
                            sqlStmt = "";
                        }
                        if (!this.trace) continue block7;
                        this.trace("sqlStmt = " + sqlStmt);
                        continue block7;
                    }
                    case 47: {
                        this.setStmtOrDbByteOrder(false, stmt, this.parseTYPDEFNAM());
                        continue block7;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(stmt);
                        continue block7;
                    }
                    case 9296: {
                        this.parseSQLATTR(stmt);
                        continue block7;
                    }
                }
                this.invalidCodePoint(codePoint);
            }
        } while (this.reader.isChainedWithSameID());
        if (sqlStmt == null) {
            this.missingCodePoint(9236);
        }
        return sqlStmt;
    }

    private boolean parseTYPSQLDA(byte sqldaType) throws DRDAProtocolException {
        if (this.trace) {
            this.trace("typSQLDa " + sqldaType);
        }
        if (sqldaType == 0 || sqldaType == 2 || sqldaType == 4) {
            return true;
        }
        if (sqldaType == 1 || sqldaType == 3 || sqldaType == 5) {
            return false;
        }
        this.invalidValue(8518);
        return false;
    }

    protected void parseSQLATTR(DRDAStatement stmt) throws DRDAProtocolException {
        String attrs = this.parseEncodedString();
        if (this.trace) {
            this.trace("sqlattr = '" + attrs + "'");
        }
        boolean validAttribute = false;
        if (attrs.indexOf("INSENSITIVE SCROLL") != -1 || attrs.indexOf("SCROLL INSENSITIVE") != -1) {
            stmt.scrollType = 1004;
            stmt.concurType = 1007;
            validAttribute = true;
        }
        if (attrs.indexOf("SENSITIVE DYNAMIC SCROLL") != -1 || attrs.indexOf("SENSITIVE STATIC SCROLL") != -1) {
            stmt.scrollType = 1005;
            validAttribute = true;
        }
        if (attrs.indexOf("FOR UPDATE") != -1) {
            validAttribute = true;
            stmt.concurType = 1008;
        }
        if (attrs.indexOf("WITH HOLD") != -1) {
            stmt.withHoldCursor = 1;
            validAttribute = true;
        }
        if (!validAttribute) {
            this.invalidValue(9296);
        }
    }

    private boolean parseDSCSQLSTT() throws DRDAProtocolException, SQLException {
        boolean rtnOutput = true;
        Pkgnamcsn pkgnamcsn = null;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8518: {
                    this.checkLength(8518, 1);
                    byte sqldaType = this.reader.readByte();
                    if (sqldaType == 6) {
                        sqldaType = 4;
                    }
                    rtnOutput = this.parseTYPSQLDA(sqldaType);
                    break;
                }
                case 8464: {
                    this.setDatabase(8200);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    DRDAStatement stmt = this.database.getDRDAStatement(pkgnamcsn);
                    if (stmt != null) break;
                    this.invalidValue(8467);
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
        }
        return rtnOutput;
    }

    private byte parseEXCSQLSTT() throws DRDAProtocolException, SQLException {
        boolean sendSQLDTARD;
        boolean hasResultSet;
        byte result;
        boolean isProcedure;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        boolean outputExpected = false;
        boolean batchOutput = false;
        boolean localExecDueToSHOP = false;
        int isolationlevel = 0;
        Set<Integer> bucketSet = null;
        boolean dbSync = false;
        boolean rtnsqlda = false;
        boolean rtnOutput = true;
        Pkgnamcsn pkgnamcsn = null;
        int numRows = 1;
        int blkSize = 0;
        int maxrslcnt = 0;
        int maxblkext = 0;
        int qryrowset = -1;
        int outovropt = 1;
        byte[] rslsetflg = null;
        String procName = null;
        while (codePoint != -1) {
            switch (codePoint) {
                case 8464: {
                    this.setDatabase(8203);
                    break;
                }
                case 8467: 
                case 12288: 
                case 12289: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    if (codePoint != 8467) {
                        this.checkPre1302ClientVersionForSingleHop("EXCSQLSTT");
                        bucketSet = this.readBucketSet();
                        if (bucketSet != null) {
                            byte txID;
                            if (bucketSet.contains(ResolverUtils.TOKEN_FOR_DB_SYNC)) {
                                dbSync = true;
                                bucketSet.remove(ResolverUtils.TOKEN_FOR_DB_SYNC);
                            }
                            if (Version.GFXD_20.compareTo(this.gfxdClientVersion) <= 0 && (txID = this.reader.readByte()) == 1) {
                                assert (this.currTxIdForSHOPExecution == null) : "txid = " + this.currTxIdForSHOPExecution + "not expected as the client has already sent it";
                                isolationlevel = this.reader.readInt(this.getByteOrder());
                                long memberId = this.reader.readLong(this.getByteOrder());
                                long uniqueId = this.reader.readLong(this.getByteOrder());
                                this.currTxIdForSHOPExecution = TXId.valueOf((long)memberId, (int)((int)uniqueId));
                            }
                        }
                        localExecDueToSHOP = true;
                    }
                    if (!SanityManager.TraceSingleHop) break;
                    SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("DRDAConnThread::parseEXCSQLSTT pkgnamcsn: " + pkgnamcsn));
                    break;
                }
                case 8465: {
                    this.checkLength(8465, 1);
                    batchOutput = false;
                    byte outv = this.reader.readByte();
                    if ((outv & 2) == 2) {
                        batchOutput = true;
                        outv = (byte)(outv & 0xFFFFFFFD);
                    } else {
                        batchOutput = false;
                    }
                    if (outv == -15) {
                        outputExpected = true;
                    } else if (outv == -16) {
                        outputExpected = false;
                    } else {
                        this.invalidCodePoint(8465);
                    }
                    if (!this.trace) break;
                    this.trace("outexp = " + outputExpected + " batchOutput = " + batchOutput);
                    break;
                }
                case 8506: {
                    this.checkLength(8506, 4);
                    numRows = this.reader.readNetworkInt();
                    if (!this.trace) break;
                    this.trace("# of rows: " + numRows);
                    break;
                }
                case 8504: {
                    procName = this.reader.readString();
                    if (!this.trace) break;
                    this.trace("Procedure Name = " + procName);
                    break;
                }
                case 8468: {
                    blkSize = this.parseQRYBLKSZ();
                    break;
                }
                case 8512: {
                    this.checkLength(8512, 2);
                    maxrslcnt = this.reader.readNetworkShort();
                    if (!this.trace) break;
                    this.trace("max rs count: " + maxrslcnt);
                    break;
                }
                case 8513: {
                    this.checkLength(8513, 2);
                    maxblkext = this.reader.readNetworkShort();
                    if (!this.trace) break;
                    this.trace("max extra blocks: " + maxblkext);
                    break;
                }
                case 8514: {
                    rslsetflg = this.reader.readBytes();
                    for (int i = 0; i < rslsetflg.length; ++i) {
                        if (!this.trace) continue;
                        this.trace("rslsetflg: " + rslsetflg[i]);
                    }
                    break;
                }
                case 8453: {
                    this.parseRDBCMTOK();
                    break;
                }
                case 8519: {
                    outovropt = this.parseOUTOVROPT();
                    break;
                }
                case 8534: {
                    qryrowset = this.parseQRYROWSET(0);
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                case 8470: {
                    rtnsqlda = this.readBoolean(8470);
                    break;
                }
                case 8518: {
                    this.checkLength(8518, 1);
                    byte sqldaType = this.reader.readByte();
                    rtnOutput = this.parseTYPSQLDA(sqldaType);
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
            return -16;
        }
        boolean needPrepareCall = false;
        DRDAStatement stmt = this.database.getDRDAStatement(pkgnamcsn);
        if (SanityManager.TraceSingleHop) {
            SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("DRDAConnThread::parseEXCSQLSTT statement obtained from database: " + stmt.toDebugString(" ")));
        }
        boolean bl = isProcedure = procName != null || stmt != null && stmt.wasExplicitlyPrepared() && stmt.isCall;
        if (isProcedure) {
            if (stmt == null || !stmt.wasExplicitlyPrepared()) {
                stmt = this.database.newDRDAStatement(pkgnamcsn);
                stmt.setQryprctyp(9239);
                needPrepareCall = true;
            }
            stmt.procName = procName;
            stmt.outputExpected = outputExpected;
        } else {
            if (stmt != null && localExecDueToSHOP) {
                EngineConnection conn = this.database.getConnection();
                Checkpoint cp = null;
                if (this.currTxIdForSHOPExecution != null) {
                    cp = conn.masqueradeAsTxn(this.currTxIdForSHOPExecution, isolationlevel);
                }
                LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
                if (SanityManager.TraceSingleHop) {
                    boolean origSkipLocks = lcc.skipLocks();
                    SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("DRDAConnThread::parseEXCSQLSTT conn: stmt == null for pkgnamcsn: " + pkgnamcsn + ", bucketset: " + bucketSet + ", local exec due to shop: " + true + ", skipLocks: " + origSkipLocks + " and lcc: " + lcc + " dbSync: " + dbSync));
                }
                stmt.incSingleHopStats();
                lcc.setExecuteLocally(bucketSet, stmt.getRegion(), dbSync, cp);
            }
            if (stmt == null) {
                this.invalidValue(8467);
                return -16;
            }
            stmt.setQryprctyp(9239);
        }
        stmt.nbrrow = numRows;
        stmt.qryrowset = qryrowset;
        stmt.blksize = blkSize;
        stmt.maxblkext = maxblkext;
        stmt.maxrslcnt = maxrslcnt;
        stmt.outovropt = outovropt;
        stmt.rslsetflg = rslsetflg;
        stmt.batchOutput = batchOutput;
        if (this.pendingSetSchema != null) {
            stmt.setSchema(this.pendingSetSchema);
            this.pendingSetSchema = null;
        }
        if (this.pendingStatementTimeout >= 0) {
            stmt.getUnderlyingStatement().setQueryTimeout(this.pendingStatementTimeout);
            this.pendingStatementTimeout = -1;
        }
        this.database.setCurrentStatement(stmt);
        boolean batchAdd = false;
        boolean batchExec = false;
        if (this.reader.isChainedWithSameID()) {
            result = this.parseEXCSQLSTTobjects(stmt);
            if (result == -1) {
                return -1;
            }
            if (result == 2) {
                batchAdd = true;
            } else if ((result & 2) == 2) {
                batchExec = true;
                result = (byte)(result & 0xFFFFFFFD);
            }
            hasResultSet = result == -15;
        } else {
            if (isProcedure && needPrepareCall) {
                String prepareString = "call " + stmt.procName + "()";
                if (this.trace) {
                    this.trace("$$$prepareCall is: " + prepareString);
                }
                this.database.getConnection().clearWarnings();
                CallableStatement callableStatement = (CallableStatement)stmt.prepare(prepareString);
            }
            stmt.getUnderlyingStatement().clearWarnings();
            result = this.executeStatement(stmt, false);
            if (result == -1) {
                return -1;
            }
            hasResultSet = result == -15;
        }
        ResultSet rs = null;
        if (hasResultSet) {
            rs = stmt.getResultSet();
        }
        hasResultSet = rs != null;
        int numResults = 0;
        if (hasResultSet) {
            numResults = stmt.getNumResultSets();
            this.writeRSLSETRM(stmt);
        }
        boolean bl2 = sendSQLDTARD = stmt.hasOutputParams() && outputExpected;
        if (isProcedure) {
            if (sendSQLDTARD) {
                this.writer.createDssObject();
                this.writer.startDdm(9235);
                this.writer.startDdm(16);
                this.writeQRYDSC(stmt, true);
                this.writer.endDdm();
                this.writer.startDdm(5242);
                this.writeFDODTA(stmt);
                this.writer.endDdm();
                this.writer.endDdmAndDss();
                if (stmt.getExtDtaObjects() != null) {
                    this.writeEXTDTA(stmt);
                }
            } else if (hasResultSet) {
                this.writeNullSQLCARDobject();
            }
        }
        stmt.finishParams();
        Statement ps = stmt.getUnderlyingStatement();
        int rsNum = 0;
        do {
            if (hasResultSet) {
                stmt.setCurrentDrdaResultSet(rsNum);
                stmt.setQryrtndta(true);
                if (!isProcedure) {
                    this.checkWarning(null, ps, null, -1, true, true);
                }
                if (rsNum == 0) {
                    this.writeSQLRSLRD(stmt);
                }
                this.writeOPNQRYRM(true, stmt);
                this.writeSQLCINRD(stmt);
                this.writeQRYDSC(stmt, false);
                stmt.rsSuspend();
                if (stmt.getQryprctyp() != 9239) continue;
                stmt.setStatus("SENDING EXCSQLSTT RESULTS " + rsNum);
                this.writeQRYDTA(stmt);
                continue;
            }
            if (sendSQLDTARD) continue;
            if (batchAdd) {
                ++stmt.numBatchResults;
            } else if (batchExec) {
                this.sendBatchResult(stmt);
            } else {
                int updateCount = ps.getUpdateCount();
                this.checkWarning(this.database.getConnection(), stmt.getUnderlyingStatement(), null, updateCount, null, true, true);
                return -15;
            }
            return -16;
        } while (hasResultSet && ++rsNum < numResults);
        return -15;
    }

    private void parseRDBCMTOK() throws DRDAProtocolException {
        boolean rdbcmtok = this.readBoolean(8453);
        if (this.trace) {
            this.trace("rdbcmtok = " + rdbcmtok);
        }
    }

    private byte parseEXCSQLSTTobjects(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        boolean gotSQLDTA = false;
        boolean gotEXTDTA = false;
        byte result = -16;
        do {
            this.correlationID = this.reader.readDssHeader();
            block8: while (this.reader.moreDssData()) {
                int codePoint = this.reader.readLengthAndCodePoint(true);
                switch (codePoint) {
                    case 47: {
                        this.setStmtOrDbByteOrder(false, stmt, this.parseTYPDEFNAM());
                        stmt.setTypDefValues();
                        continue block8;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(stmt);
                        stmt.setTypDefValues();
                        continue block8;
                    }
                    case 9234: {
                        this.parseSQLDTA(stmt);
                        gotSQLDTA = true;
                        continue block8;
                    }
                    case 5228: {
                        this.readAndSetAllExtParams(stmt, true);
                        stmt.getUnderlyingStatement().clearWarnings();
                        result = stmt.batchOutput ? this.executeBatch(stmt, true) : this.executeStatement(stmt, false);
                        gotEXTDTA = true;
                        continue block8;
                    }
                    case 9237: {
                        this.parseOUTOVR(stmt);
                        continue block8;
                    }
                }
                this.invalidCodePoint(codePoint);
            }
        } while (this.reader.isChainedWithSameID());
        if (!gotSQLDTA) {
            this.missingCodePoint(9234);
        }
        if (!gotEXTDTA) {
            stmt.getUnderlyingStatement().clearWarnings();
            if (stmt.batchOutput) {
                return this.executeBatch(stmt, true);
            }
            return this.executeStatement(stmt, false);
        }
        return result;
    }

    private byte executeBatch(DRDAStatement stmt, boolean doAdd) throws SQLException {
        if (doAdd) {
            stmt.addBatch();
        }
        if (this.reader.getCurrChainState() != 0) {
            return 2;
        }
        boolean result = stmt.execute(true);
        return (byte)(2 | (result ? -15 : -16));
    }

    private void sendBatchResult(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        this.checkWarning(this.database.getConnection(), stmt.ps, null, -3, stmt.batchResult, true, true);
        stmt.resetBatch();
    }

    private void sendBatchException(DRDAStatement stmt, SQLException e, boolean lastFinalize) throws DRDAProtocolException {
        BatchUpdateException batchEx = null;
        int index = 0;
        if (e instanceof BatchUpdateException && (batchEx = (BatchUpdateException)e).getNextException() != null) {
            e = batchEx.getNextException();
        }
        OutputStream os = this.getOutputStream();
        while (index < stmt.numBatchResults) {
            this.writeSQLCARDs(e, 0);
            this.errorInChain(e);
            if (lastFinalize && index == stmt.numBatchResults - 1) {
                this.writer.finalizeChain(this.reader.getCurrChainState(), os);
            } else {
                this.writer.finalizeChain((byte)64, os);
            }
            if (e.getNextException() != null) {
                e = e.getNextException();
            }
            ++index;
        }
        stmt.resetBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte executeStatement(DRDAStatement stmt, boolean isOpenQry) throws DRDAProtocolException, SQLException {
        if (stmt.isPrepared()) {
            return stmt.execute(false) ? (byte)-15 : -16;
        }
        try {
            if (stmt.needStatementUUID()) {
                try {
                    this.writeSQLSTMTID(stmt.getStatementUUID());
                    this.finalizeChain();
                }
                finally {
                    stmt.setSendStatementUUID(false);
                }
            }
            boolean result = stmt.execute(false);
            this.writeSQLDARD(stmt, stmt.sqldaType == 2, this.database.getConnection().getWarnings(), false, false);
            this.finalizeChain();
            return result ? (byte)-15 : -16;
        }
        catch (SQLException sqle) {
            this.writer.clearDSSesBackToMark(stmt.pstmtParseWriterMark);
            this.writeSQLCARDs(sqle, 0, true);
            this.errorInChain(sqle);
            this.finalizeChain();
            if (this.reader.isChainedWithSameID() || this.reader.isChainedWithDiffID()) {
                this.skipRemainder(true);
                if (isOpenQry) {
                    this.writeOPNQFLRM(null);
                } else {
                    this.writeSQLCARDs(null, 0);
                }
            }
            return -1;
        }
    }

    private void checkPre1302ClientVersionForSingleHop(String command) throws SQLException {
        if (ResolverUtils.isUsingGFXD1302Hashing() && (this.appRequester.getClientType() != 3 || !this.appRequester.greaterThanOrEqualTo(10, 4, 1))) {
            throw Util.generateCsSQLException("0A000.C.6", "{ " + command + " with pre GemFireXD 1.3.0.2 clients against " + "GemFireXD 1.3.0.2 or greater servers }");
        }
    }

    private void writeSQLCINRD(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        ResultSet rs = stmt.getResultSet();
        this.writer.createDssObject();
        this.writer.startDdm(9227);
        if (this.sqlamLevel >= 7) {
            this.writeSQLDHROW(rs.getHoldability());
        }
        ResultSetMetaData rsmeta = rs.getMetaData();
        int ncols = rsmeta.getColumnCount();
        this.writer.writeShort(ncols);
        if (this.sqlamLevel >= 7) {
            for (int i = 0; i < ncols; ++i) {
                this.writeSQLDAGRP(rsmeta, null, i, true);
            }
        } else {
            for (int i = 0; i < ncols; ++i) {
                this.writeVCMorVCS(rsmeta.getColumnName(i + 1));
                this.writeVCMorVCS(rsmeta.getColumnLabel(i + 1));
                this.writeVCMorVCS(null);
            }
        }
        this.writer.endDdmAndDss();
    }

    private void writeSQLRSLRD(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        int numResults = stmt.getNumResultSets();
        this.writer.createDssObject();
        this.writer.startDdm(9230);
        this.writer.writeShort(numResults);
        for (int i = 0; i < numResults; ++i) {
            this.writer.writeInt(i);
            this.writeVCMorVCS(stmt.getResultSetCursorName(i));
            this.writer.writeInt(1);
        }
        this.writer.endDdmAndDss();
    }

    private void writeRSLSETRM(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        int numResults = stmt.getNumResultSets();
        this.writer.createDssReply();
        this.writer.startDdm(8729);
        this.writer.writeScalar2Bytes(4425, 0);
        this.writer.startDdm(8505);
        for (int i = 0; i < numResults; ++i) {
            this.writePKGNAMCSN(stmt.getResultSetPkgcnstkn(i).getBytes());
        }
        this.writer.endDdm();
        this.writer.endDdmAndDss();
    }

    private void parseSQLDTA(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        try {
            this.parseSQLDTA_work(stmt);
        }
        catch (SQLException se) {
            this.skipRemainder(true);
            throw se;
        }
    }

    private void parseSQLDTA_work(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        PreparedStatement ps = stmt.getPreparedStatement();
        ParameterMetaData pmeta = null;
        stmt.clearDrdaParams();
        int numVars = 0;
        boolean rtnParam = false;
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 16: {
                    while (this.reader.getDdmLength() > 6L) {
                        int dtaGrpLen = this.reader.readUnsignedByte();
                        int numVarsInGrp = (dtaGrpLen - 3) / 3;
                        if (this.trace) {
                            this.trace("num of vars in this group is: " + numVarsInGrp);
                        }
                        this.reader.readByte();
                        this.reader.readByte();
                        for (int j = 0; j < numVarsInGrp; ++j) {
                            byte t = this.reader.readByte();
                            if (this.trace) {
                                this.trace("drdaType is: 0x" + Integer.toHexString(t));
                            }
                            int drdaLength = this.reader.readNetworkShort();
                            if (this.trace) {
                                this.trace("drdaLength is: " + drdaLength);
                            }
                            stmt.addDrdaParam(t, drdaLength);
                        }
                    }
                    numVars = stmt.getDrdaParamCount();
                    if (this.trace) {
                        this.trace("numVars = " + numVars);
                    }
                    if (ps == null) {
                        String marks = "(?";
                        for (int i = 1; i < numVars; ++i) {
                            marks = marks + ", ?";
                        }
                        String prepareString = "call " + stmt.procName + marks + ")";
                        if (this.trace) {
                            this.trace("$$ prepareCall is: " + prepareString);
                        }
                        CallableStatement cs = null;
                        try {
                            cs = (CallableStatement)stmt.prepare(prepareString);
                            stmt.registerAllOutParams();
                        }
                        catch (SQLException se) {
                            if (!stmt.outputExpected || !se.getSQLState().equals("42X50")) {
                                throw se;
                            }
                            if (this.trace) {
                                this.trace("****** second try with return parameter...");
                            }
                            prepareString = numVars == 1 ? "? = call " + stmt.procName + "()" : "? = call " + stmt.procName + "(" + marks.substring(3) + ")";
                            if (this.trace) {
                                this.trace("$$ prepareCall is: " + prepareString);
                            }
                            try {
                                cs = (CallableStatement)stmt.prepare(prepareString);
                            }
                            catch (SQLException se2) {
                                throw se;
                            }
                            rtnParam = true;
                        }
                        stmt.ps = ps = cs;
                    }
                    pmeta = stmt.getParameterMetaData();
                    this.reader.readBytes(6);
                    break;
                }
                case 5242: {
                    this.reader.readByte();
                    for (int i = 0; i < numVars; ++i) {
                        int nullData;
                        if ((stmt.getParamDRDAType(i + 1) & 1) == 1 && ((nullData = this.reader.readUnsignedByte()) & 0xFF) == 255) {
                            if (this.trace) {
                                this.trace("******param null");
                            }
                            if (pmeta.getParameterMode(i + 1) != 4) {
                                ps.setNull(i + 1, pmeta.getParameterType(i + 1));
                            }
                            if (!stmt.isOutputParam(i + 1)) continue;
                            stmt.registerOutParam(i + 1);
                            continue;
                        }
                        this.readAndSetParams(i, stmt, pmeta);
                    }
                    break;
                }
                case 5228: {
                    this.readAndSetAllExtParams(stmt, false);
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
    }

    private int getByteOrder() {
        DRDAStatement stmt = this.database.getCurrentStatement();
        return stmt != null && stmt.typDefNam != null ? stmt.byteOrder : this.database.byteOrder;
    }

    private void readAndSetParams(int i, DRDAStatement stmt, ParameterMetaData pmeta) throws DRDAProtocolException, SQLException {
        PreparedStatement ps = stmt.getPreparedStatement();
        int drdaType = (stmt.getParamDRDAType(i + 1) | 1) & 0xFF;
        int paramLenNumBytes = stmt.getParamLen(i + 1);
        if (ps instanceof CallableStatement && stmt.isOutputParam(i + 1)) {
            CallableStatement cs = (CallableStatement)ps;
            cs.registerOutParameter(i + 1, stmt.getOutputParamType(i + 1));
        }
        switch (drdaType) {
            case 5: {
                short paramVal = this.reader.readShort(this.getByteOrder());
                if (this.trace) {
                    this.trace("short parameter value is: " + paramVal);
                }
                if (pmeta.getParameterType(i + 1) == 16) {
                    ps.setBoolean(i + 1, paramVal == 1);
                    break;
                }
                ps.setShort(i + 1, paramVal);
                break;
            }
            case 3: {
                int paramVal = this.reader.readInt(this.getByteOrder());
                if (this.trace) {
                    this.trace("integer parameter value is: " + paramVal);
                }
                ps.setInt(i + 1, paramVal);
                break;
            }
            case 23: {
                long paramVal = this.reader.readLong(this.getByteOrder());
                if (this.trace) {
                    this.trace("parameter value is: " + paramVal);
                }
                ps.setLong(i + 1, paramVal);
                break;
            }
            case 13: {
                float paramVal = this.reader.readFloat(this.getByteOrder());
                if (this.trace) {
                    this.trace("parameter value is: " + paramVal);
                }
                ps.setFloat(i + 1, paramVal);
                break;
            }
            case 11: {
                double paramVal = this.reader.readDouble(this.getByteOrder());
                if (this.trace) {
                    this.trace("nfloat8 parameter value is: " + paramVal);
                }
                ps.setDouble(i + 1, paramVal);
                break;
            }
            case 15: {
                int precision = paramLenNumBytes >> 8 & 0xFF;
                int scale = paramLenNumBytes & 0xFF;
                BigDecimal paramVal = this.reader.readBigDecimal(precision, scale);
                if (this.trace) {
                    this.trace("ndecimal parameter value is: " + paramVal);
                }
                ps.setBigDecimal(i + 1, paramVal);
                break;
            }
            case 33: {
                Object paramVal = this.reader.readStringData(10).trim();
                if (this.trace) {
                    this.trace("ndate parameter value is: \"" + (String)paramVal + "\"");
                }
                try {
                    ps.setDate(i + 1, java.sql.Date.valueOf((String)paramVal));
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new SQLException("22007.S.181", "22007.S.181".substring(0, 5));
                }
            }
            case 35: {
                Object paramVal = this.reader.readStringData(8).trim();
                if (this.trace) {
                    this.trace("ntime parameter value is: " + (String)paramVal);
                }
                try {
                    ps.setTime(i + 1, Time.valueOf((String)paramVal));
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new SQLException("22007.S.181", "22007.S.181".substring(0, 5));
                }
            }
            case 37: {
                Object paramVal = this.reader.readStringData(26).trim();
                if (this.trace) {
                    this.trace("ntimestamp parameter value is: " + (String)paramVal);
                }
                try {
                    String tsString = ((String)paramVal).substring(0, 10) + " " + ((String)paramVal).substring(11, 19).replace('.', ':') + ((String)paramVal).substring(19);
                    if (this.trace) {
                        this.trace("tsString is: " + tsString);
                    }
                    ps.setTimestamp(i + 1, Timestamp.valueOf(tsString));
                    break;
                }
                catch (IllegalArgumentException e1) {
                    throw new SQLException("22007.S.181", "22007.S.181".substring(0, 5));
                }
                catch (StringIndexOutOfBoundsException e2) {
                    throw new SQLException("22007.S.181", "22007.S.181".substring(0, 5));
                }
            }
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 63: 
            case 65: {
                Object paramVal = this.reader.readLDStringData(stmt.ccsidMBCEncoding);
                if (this.trace) {
                    this.trace("for type " + drdaType + " with encoding " + stmt.ccsidMBCEncoding + " char/varchar parameter value is: " + (String)paramVal);
                }
                ps.setString(i + 1, (String)paramVal);
                break;
            }
            case 39: {
                Object paramVal = this.reader.readBytes();
                if (this.trace) {
                    this.trace("fix bytes parameter value is: " + this.convertToHexString((byte[])paramVal));
                }
                ps.setBytes(i + 1, (byte[])paramVal);
                break;
            }
            case 41: 
            case 43: {
                int length = this.reader.readNetworkShort();
                if (this.trace) {
                    this.trace("===== binary param length is: " + length);
                }
                byte[] paramVal = this.reader.readBytes(length);
                ps.setBytes(i + 1, paramVal);
                break;
            }
            case 81: {
                Object paramVal = this.readUDT();
                ps.setObject(i + 1, paramVal);
                break;
            }
            case 201: 
            case 203: 
            case 205: 
            case 207: {
                long length = this.readLobLength(paramLenNumBytes);
                if (length != 0L) {
                    stmt.addExtPosition(i);
                    break;
                }
                if (drdaType == 201) {
                    ps.setBytes(i + 1, new byte[0]);
                    break;
                }
                ps.setString(i + 1, "");
                break;
            }
            case 25: {
                int paramVal = this.reader.readInt(this.getByteOrder());
                if (this.trace) {
                    this.trace("locator value is: " + paramVal);
                }
                Blob blobFromLocator = (Blob)this.database.getConnection().getLOBMapping(paramVal);
                ps.setBlob(i + 1, blobFromLocator);
                break;
            }
            case 27: {
                int paramVal = this.reader.readInt(this.getByteOrder());
                if (this.trace) {
                    this.trace("locator value is: " + paramVal);
                }
                Clob clobFromLocator = (Clob)this.database.getConnection().getLOBMapping(paramVal);
                ps.setClob(i + 1, clobFromLocator);
                break;
            }
            default: {
                Object paramVal = this.reader.readLDStringData(stmt.ccsidMBCEncoding);
                if (this.trace) {
                    this.trace("default type parameter value is: " + (String)paramVal);
                }
                ps.setObject(i + 1, paramVal);
            }
        }
    }

    private Object readUDT() throws DRDAProtocolException {
        int length = this.reader.readNetworkShort();
        this.trace("===== udt param length is: " + length);
        byte[] bytes = this.reader.readBytes(length);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            if (this.cf == null) {
                this.cf = Misc.getMemStore().getDatabase().getClassFactory();
            }
            ApplicationObjectInputStream ois = new ApplicationObjectInputStream(bais, this.cf);
            return ois.readObject();
        }
        catch (Exception e) {
            this.markCommunicationsFailure(e, "DRDAConnThread.readUDT()", "", e.getMessage(), "*");
            return null;
        }
    }

    private long readLobLength(int extLenIndicator) throws DRDAProtocolException {
        switch (extLenIndicator) {
            case 32770: {
                return this.reader.readNetworkShort();
            }
            case 32772: {
                return this.reader.readNetworkInt();
            }
            case 32774: {
                return this.reader.readNetworkSixByteLong();
            }
            case 32776: {
                return this.reader.readNetworkLong();
            }
        }
        this.throwSyntaxrm(12, extLenIndicator);
        return 0L;
    }

    private void readAndSetAllExtParams(DRDAStatement stmt, boolean streamLOB) throws SQLException, DRDAProtocolException {
        int numExt = stmt.getExtPositionCount();
        for (int i = 0; i < numExt; ++i) {
            int paramPos = stmt.getExtPosition(i);
            boolean doStreamLOB = streamLOB && i == numExt - 1;
            this.readAndSetExtParam(paramPos, stmt, stmt.getParamDRDAType(paramPos + 1), stmt.getParamLen(paramPos + 1), doStreamLOB);
            if (i >= numExt - 1) continue;
            this.correlationID = this.reader.readDssHeader();
            int n = this.reader.readLengthAndCodePoint(true);
        }
    }

    private void readAndSetExtParam(int i, DRDAStatement stmt, int drdaType, int extLen, boolean streamLOB) throws DRDAProtocolException, SQLException {
        PreparedStatement ps = stmt.getPreparedStatement();
        boolean checkNullability = false;
        if (this.sqlamLevel >= 7 && FdocaConstants.isNullable(drdaType &= 0xFF)) {
            checkNullability = true;
        }
        try {
            switch (drdaType) {
                case 200: 
                case 201: {
                    boolean useSetBinaryStream;
                    String paramString = "";
                    boolean bl = useSetBinaryStream = stmt.getParameterMetaData().getParameterType(i + 1) == 2004;
                    if (streamLOB && useSetBinaryStream) {
                        Object paramBytes = null;
                        EXTDTAReaderInputStream stream = this.reader.getEXTDTAReaderInputStream(checkNullability);
                        stmt.setStreamedParameter(stream);
                        if (stream instanceof StandardEXTDTAReaderInputStream) {
                            StandardEXTDTAReaderInputStream stdeis = (StandardEXTDTAReaderInputStream)stream;
                            ps.setBinaryStream(i + 1, (InputStream)stdeis, (int)stdeis.getLength());
                        } else if (stream instanceof LayerBStreamedEXTDTAReaderInputStream) {
                            ps.setBinaryStream(i + 1, stream);
                        } else if (stream == null) {
                            ps.setBytes(i + 1, null);
                        } else {
                            throw new IllegalStateException();
                        }
                        if (this.trace) {
                            if (stream == null) {
                                this.trace("parameter value : NULL");
                                break;
                            }
                            this.trace("parameter value will be streamed");
                        }
                        break;
                    }
                    EXTDTAReaderInputStream stream = this.reader.getEXTDTAReaderInputStream(checkNullability);
                    if (stream == null) {
                        ps.setBytes(i + 1, null);
                        if (this.trace) {
                            this.trace("parameter value : NULL");
                        }
                        break;
                    }
                    ByteArrayInputStream bais = DRDAConnThread.convertAsByteArrayInputStream(stream);
                    if (this.trace) {
                        this.trace("parameter value is a LOB with length:" + bais.available());
                    }
                    ps.setBinaryStream(i + 1, (InputStream)bais, bais.available());
                    break;
                }
                case 202: 
                case 203: {
                    DRDAConnThread.setAsCharacterStream(stmt, i, checkNullability, this.reader, streamLOB, stmt.ccsidSBCEncoding);
                    break;
                }
                case 204: 
                case 205: {
                    DRDAConnThread.setAsCharacterStream(stmt, i, checkNullability, this.reader, streamLOB, stmt.ccsidDBCEncoding);
                    break;
                }
                case 206: 
                case 207: {
                    DRDAConnThread.setAsCharacterStream(stmt, i, checkNullability, this.reader, streamLOB, stmt.ccsidMBCEncoding);
                    break;
                }
                default: {
                    Object paramBytes = null;
                    String paramString = "";
                    this.invalidValue(drdaType);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int parseEXCSQLIMM() throws DRDAProtocolException, SQLException {
        int updCount;
        this.reader.markCollection();
        Pkgnamcsn pkgnamcsn = null;
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8464: {
                    this.setDatabase(8202);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8453: {
                    this.parseRDBCMTOK();
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        DRDAStatement drdaStmt = this.database.getDefaultStatement(pkgnamcsn);
        drdaStmt.initialize();
        String sqlStmt = this.parseEXECSQLIMMobjects();
        Statement statement = drdaStmt.getStatement();
        statement.clearWarnings();
        if (this.pendingStatementTimeout >= 0) {
            statement.setQueryTimeout(this.pendingStatementTimeout);
            this.pendingStatementTimeout = -1;
        }
        if (this.pendingSetSchema != null) {
            drdaStmt.setSchema(this.pendingSetSchema);
            this.pendingSetSchema = null;
        }
        drdaStmt.sqlText = sqlStmt;
        try {
            drdaStmt.setStatus("EXECUTING STATEMENT");
            updCount = statement.executeUpdate(sqlStmt);
            drdaStmt.setStatus("DONE");
        }
        finally {
            this.database.getConnection().setPossibleDuplicate(false);
        }
        return updCount;
    }

    private boolean parseEXCSQLSET() throws DRDAProtocolException, SQLException {
        this.reader.markCollection();
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8464: {
                    this.setDatabase(8212);
                    break;
                }
                case 8466: {
                    String pkgnamct = this.parsePKGNAMCT();
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                case 8467: {
                    Pkgnamcsn pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        return this.parseEXCSQLSETobjects();
    }

    private String parseEXECSQLIMMobjects() throws DRDAProtocolException, SQLException {
        String sqlStmt = null;
        DRDAStatement stmt = this.database.getDefaultStatement();
        do {
            this.correlationID = this.reader.readDssHeader();
            block6: while (this.reader.moreDssData()) {
                int codePoint = this.reader.readLengthAndCodePoint(false);
                switch (codePoint) {
                    case 47: {
                        this.setStmtOrDbByteOrder(false, stmt, this.parseTYPDEFNAM());
                        continue block6;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(stmt);
                        continue block6;
                    }
                    case 9236: {
                        sqlStmt = this.parseEncodedString();
                        if (!this.trace) continue block6;
                        this.trace("sqlStmt = " + sqlStmt);
                        continue block6;
                    }
                }
                this.invalidCodePoint(codePoint);
            }
        } while (this.reader.isChainedWithSameID());
        if (sqlStmt == null) {
            this.missingCodePoint(9236);
        }
        return sqlStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseEXCSQLSETobjects() throws DRDAProtocolException, SQLException {
        boolean gotSqlStt = false;
        boolean hadUnrecognizedStmt = false;
        boolean result = true;
        String sqlStmt = null;
        DRDAStatement drdaStmt = this.database.getDefaultStatement();
        drdaStmt.initialize();
        do {
            this.correlationID = this.reader.readDssHeader();
            block11: while (this.reader.moreDssData()) {
                int codePoint = this.reader.readLengthAndCodePoint(false);
                result = true;
                switch (codePoint) {
                    case 47: {
                        this.setStmtOrDbByteOrder(false, drdaStmt, this.parseTYPDEFNAM());
                        continue block11;
                    }
                    case 53: {
                        this.parseTYPDEFOVR(drdaStmt);
                        continue block11;
                    }
                    case 9236: {
                        sqlStmt = this.parseEncodedString();
                        if (sqlStmt != null) {
                            gotSqlStt = true;
                        }
                        if (sqlStmt.startsWith(TIMEOUT_STATEMENT)) {
                            String timeoutString = sqlStmt.substring(TIMEOUT_STATEMENT.length());
                            this.pendingStatementTimeout = Integer.valueOf(timeoutString);
                            continue block11;
                        }
                        if (sqlStmt.startsWith(SET_SCHEMA_STATEMENT)) {
                            this.pendingSetSchema = sqlStmt.substring(SET_SCHEMA_STATEMENT.length());
                            result = false;
                            continue block11;
                        }
                        if (this.canIgnoreStmt(sqlStmt)) continue block11;
                        if (this.trace) {
                            this.trace("sqlStmt = " + sqlStmt);
                        }
                        drdaStmt.initialize();
                        drdaStmt.getStatement().clearWarnings();
                        try {
                            drdaStmt.getStatement().executeUpdate(sqlStmt);
                            continue block11;
                        }
                        catch (SQLException e) {
                            if (e.getSQLState().equals(SYNTAX_ERR)) {
                                hadUnrecognizedStmt = true;
                                continue block11;
                            }
                            throw e;
                        }
                        finally {
                            this.database.getConnection().setPossibleDuplicate(false);
                            continue block11;
                        }
                    }
                }
                this.invalidCodePoint(codePoint);
            }
        } while (this.reader.isChainedWithSameID());
        if (!gotSqlStt) {
            this.missingCodePoint(9236);
        }
        if (hadUnrecognizedStmt) {
            SQLWarning warn = new SQLWarning("One or more SET statements not recognized.", "01000");
            throw warn;
        }
        return result;
    }

    private boolean canIgnoreStmt(String stmt) {
        return stmt.indexOf("SET CLIENT") != -1;
    }

    private void writeRDBUPDRM() throws DRDAProtocolException {
        this.database.RDBUPDRM_sent = true;
        this.writer.createDssReply();
        this.writer.startDdm(8728);
        this.writer.writeScalar2Bytes(4425, 0);
        this.writeRDBNAM(this.database.dbName);
        this.writer.endDdmAndDss();
    }

    private String parsePKGNAMCT() throws DRDAProtocolException {
        this.reader.skipBytes();
        return null;
    }

    private Pkgnamcsn parsePKGNAMCSN() throws DRDAProtocolException {
        if (this.reader.getDdmLength() == 64L) {
            this.reader.readString(this.rdbnam, 18, true);
            if (this.trace) {
                this.trace("rdbnam = " + this.rdbnam + "; actual = " + "gemfirexd");
            }
            if (!"gemfirexd".equals(this.rdbnam.toString())) {
                this.rdbnam.setString("gemfirexd");
            }
            if ((this.appRequester.getClientType() != 3 || this.appRequester.greaterThanOrEqualTo(10, 3, 0)) && !this.rdbnam.toString().equals(this.database.dbName)) {
                this.rdbnamMismatch(8467);
            }
            this.reader.readString(this.rdbcolid, 18, true);
            if (this.trace) {
                this.trace("rdbcolid = " + this.rdbcolid);
            }
            this.reader.readString(this.pkgid, 18, true);
            if (this.trace) {
                this.trace("pkgid = " + this.pkgid);
            }
            this.reader.readString(this.pkgcnstkn, 8, false);
            if (this.trace) {
                this.trace("pkgcnstkn = " + this.pkgcnstkn);
            }
            this.pkgsn = this.reader.readNetworkShort();
            if (this.trace) {
                this.trace("pkgsn = " + this.pkgsn);
            }
        } else {
            int length = this.reader.readNetworkShort();
            if (length < 18 || length > 255) {
                this.badObjectLength(8464);
            }
            this.reader.readString(this.rdbnam, length, true);
            if (this.trace) {
                this.trace("rdbnam = " + this.rdbnam + "; actual = " + "gemfirexd");
            }
            if (!"gemfirexd".equals(this.rdbnam.toString())) {
                this.rdbnam.setString("gemfirexd");
            }
            if ((this.appRequester.getClientType() != 3 || this.appRequester.greaterThanOrEqualTo(10, 3, 0)) && !this.rdbnam.toString().equals(this.database.dbName)) {
                this.rdbnamMismatch(8467);
            }
            length = this.reader.readNetworkShort();
            this.reader.readString(this.rdbcolid, length, true);
            if (this.trace) {
                this.trace("rdbcolid = " + this.rdbcolid);
            }
            if ((length = this.reader.readNetworkShort()) != 18) {
                this.badObjectLength(8457);
            }
            this.reader.readString(this.pkgid, 18, true);
            if (this.trace) {
                this.trace("pkgid = " + this.pkgid);
            }
            this.reader.readString(this.pkgcnstkn, 8, false);
            if (this.trace) {
                this.trace("pkgcnstkn = " + this.pkgcnstkn);
            }
            this.pkgsn = this.reader.readNetworkShort();
            if (this.trace) {
                this.trace("pkgsn = " + this.pkgsn);
            }
        }
        if (Version.GFXD_20.compareTo(this.gfxdClientVersion) <= 0) {
            int execSeq = this.reader.readNetworkShort();
            this.setExecutionSequence(execSeq);
        }
        if (this.prevPkgnamcsn == null || this.rdbnam.wasModified() || this.rdbcolid.wasModified() || this.pkgid.wasModified() || this.pkgcnstkn.wasModified() || this.prevPkgnamcsn.getPkgsn() != this.pkgsn) {
            byte[] token = new byte[this.pkgcnstkn.length()];
            System.arraycopy(this.pkgcnstkn.getBytes(), 0, token, 0, token.length);
            this.prevPkgnamcsn = new Pkgnamcsn(this.rdbnam.toString(), this.rdbcolid.toString(), this.pkgid.toString(), this.pkgsn, new ConsistencyToken(token));
        }
        return this.prevPkgnamcsn;
    }

    private void setExecutionSequence(int execSeq) {
        assert (this.database != null) : "database expected to be non null";
        EngineConnection conn = this.database.getConnection();
        conn.setExecutionSequence(execSeq);
    }

    private String parseSQLSTTDss() throws DRDAProtocolException {
        this.correlationID = this.reader.readDssHeader();
        int codePoint = this.reader.readLengthAndCodePoint(false);
        String strVal = this.parseEncodedString();
        if (this.trace) {
            this.trace("SQL Statement = " + strVal);
        }
        return strVal;
    }

    private String parseEncodedString() throws DRDAProtocolException {
        if (this.sqlamLevel < 7) {
            return this.parseVCMorVCS();
        }
        return this.parseNOCMorNOCS();
    }

    private String parseVCMorVCS() throws DRDAProtocolException {
        int vcs_length;
        String strVal = null;
        int vcm_length = this.reader.readNetworkShort();
        if (vcm_length > 0) {
            strVal = this.parseCcsidMBC(vcm_length);
        }
        if ((vcs_length = this.reader.readNetworkShort()) > 0) {
            if (strVal != null) {
                this.agentError("Both VCM and VCS have lengths > 0");
            }
            strVal = this.parseCcsidSBC(vcs_length);
        }
        return strVal;
    }

    private String parseNOCMorNOCS() throws DRDAProtocolException {
        byte nocs_nullByte;
        int length;
        byte nocm_nullByte = this.reader.readByte();
        String strVal = null;
        if (nocm_nullByte != -1) {
            length = this.reader.readNetworkInt();
            strVal = this.parseCcsidMBC(length);
        }
        if ((nocs_nullByte = this.reader.readByte()) != -1) {
            if (strVal != null) {
                this.agentError("Both CM and CS are non null");
            }
            length = this.reader.readNetworkInt();
            strVal = this.parseCcsidSBC(length);
        }
        return strVal;
    }

    private String parseCcsidMBC(int length) throws DRDAProtocolException {
        String strVal = null;
        DRDAStatement currentStatement = this.database.getCurrentStatement();
        if (currentStatement == null) {
            currentStatement = this.database.getDefaultStatement();
            currentStatement.initialize();
        }
        String ccsidMBCEncoding = currentStatement.ccsidMBCEncoding;
        if (length == 0) {
            return null;
        }
        byte[] byteStr = this.reader.readBytes(length);
        if (ccsidMBCEncoding != null) {
            try {
                strVal = new String(byteStr, 0, length, ccsidMBCEncoding);
            }
            catch (UnsupportedEncodingException e) {
                this.agentError("Unsupported encoding " + ccsidMBCEncoding + "in parseCcsidMBC");
            }
        } else {
            this.agentError("Attempt to decode mixed byte string without CCSID being set");
        }
        return strVal;
    }

    private String parseCcsidSBC(int length) throws DRDAProtocolException {
        String strVal = null;
        DRDAStatement currentStatement = this.database.getCurrentStatement();
        if (currentStatement == null) {
            currentStatement = this.database.getDefaultStatement();
            currentStatement.initialize();
        }
        String ccsidSBCEncoding = currentStatement.ccsidSBCEncoding;
        System.out.println("ccsidSBCEncoding - " + ccsidSBCEncoding);
        if (length == 0) {
            return null;
        }
        byte[] byteStr = this.reader.readBytes(length);
        if (ccsidSBCEncoding != null) {
            try {
                strVal = new String(byteStr, 0, length, ccsidSBCEncoding);
            }
            catch (UnsupportedEncodingException e) {
                this.agentError("Unsupported encoding " + ccsidSBCEncoding + "in parseCcsidSBC");
            }
        } else {
            this.agentError("Attempt to decode single byte string without CCSID being set");
        }
        return strVal;
    }

    private DRDAStatement parseCLSQRY() throws DRDAProtocolException, SQLException {
        DRDAStatement stmt;
        Pkgnamcsn pkgnamcsn = null;
        this.reader.markCollection();
        long qryinsid = 0L;
        boolean gotQryinsid = false;
        int codePoint = this.reader.getCodePoint();
        while (codePoint != -1) {
            switch (codePoint) {
                case 8464: {
                    this.setDatabase(8197);
                    break;
                }
                case 8467: {
                    pkgnamcsn = this.parsePKGNAMCSN();
                    break;
                }
                case 8539: {
                    qryinsid = this.reader.readNetworkLong();
                    gotQryinsid = true;
                    break;
                }
                case 6400: {
                    this.parseMONITOR();
                    break;
                }
                default: {
                    this.invalidCodePoint(codePoint);
                }
            }
            codePoint = this.reader.getCodePoint();
        }
        if (pkgnamcsn == null) {
            this.missingCodePoint(8467);
            return null;
        }
        if (this.sqlamLevel >= 7 && !gotQryinsid) {
            this.missingCodePoint(8539);
        }
        if ((stmt = this.database.getDRDAStatement(pkgnamcsn)) == null) {
            this.invalidValue(8467);
            return null;
        }
        if (stmt.wasExplicitlyClosed()) {
            pkgnamcsn = null;
        }
        stmt.CLSQRY();
        return stmt;
    }

    private void parseMONITOR() throws DRDAProtocolException {
        this.reader.skipBytes();
    }

    private void writeSQLCARDs(SQLException e, int updateCount) throws DRDAProtocolException {
        this.writeSQLCARDs(e, updateCount, false);
    }

    private void writeSQLCARDs(SQLException e, int updateCount, boolean sendSQLERRRM) throws DRDAProtocolException {
        int severity = 0;
        if (e == null) {
            this.writeSQLCARD(e, severity, updateCount, 0L);
            return;
        }
        severity = this.getExceptionSeverity(e);
        if (severity > 8) {
            this.writeCMDCHKRM(severity);
        } else if (sendSQLERRRM) {
            this.writeSQLERRRM(severity);
        }
        this.writeSQLCARD(e, severity, updateCount, 0L);
    }

    private int getSqlCode(int severity) {
        if (severity == 4) {
            return 100;
        }
        if (severity == 0) {
            return 0;
        }
        return -1;
    }

    private void writeSQLCARD(SQLException e, int severity, int updateCount, long rowCount) throws DRDAProtocolException {
        String sqlState;
        this.writer.createDssObject();
        this.writer.startDdm(9224);
        this.writeSQLCAGRP(e, this.getSqlCode(severity), updateCount, rowCount);
        this.writer.endDdmAndDss();
        if (e != null && (sqlState = e.getSQLState()).regionMatches(0, "XJ015.M", 0, 5)) {
            try {
                this.server.startNetworkServer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void writeNullSQLCARDobject() throws DRDAProtocolException {
        this.writer.createDssObject();
        this.writer.startDdm(9224);
        this.writeSQLCAGRP(nullSQLState, 0, 0, 0L);
        this.writer.endDdmAndDss();
    }

    private void writeSQLERRRM(int severity) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(8723);
        this.writer.writeScalar2Bytes(4425, severity);
        this.writer.endDdmAndDss();
    }

    private void writeCMDCHKRM(int severity) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(4692);
        this.writer.writeScalar2Bytes(4425, severity);
        this.writer.endDdmAndDss();
    }

    private int getExceptionSeverity(SQLException e) {
        int severity = 0;
        if (e == null) {
            return severity;
        }
        int ec = e.getErrorCode();
        switch (ec) {
            case 20000: 
            case 30000: {
                severity = 8;
                break;
            }
            case 10000: {
                severity = 4;
                break;
            }
            case 40000: 
            case 45000: 
            case 50000: {
                severity = 128;
                break;
            }
            default: {
                String sqlState = e.getSQLState();
                severity = sqlState != null && sqlState.startsWith("01") ? 4 : 8;
            }
        }
        return severity;
    }

    private void writeSQLCAGRP(SQLException e, int sqlcode, int updateCount, long rowCount) throws DRDAProtocolException {
        if (e == null) {
            this.writeSQLCAGRP(nullSQLState, sqlcode, updateCount, rowCount);
            return;
        }
        if (rowCount < 0L && updateCount < 0) {
            this.writer.writeByte(255);
            return;
        }
        if (this.trace && sqlcode < 0) {
            this.trace("handle SQLException here");
            this.trace("reason is: " + e.getMessage());
            this.trace("SQLState is: " + e.getSQLState());
            this.trace("vendorCode is: " + e.getErrorCode());
            this.trace("nextException is: " + e.getNextException());
            this.server.consoleExceptionPrint(e);
            this.trace("wrapping SQLException into SQLCARD...");
        }
        this.writer.writeByte(0);
        this.writer.writeInt(sqlcode);
        this.writer.writeString(e.getSQLState());
        this.writer.writeBytes(NetworkServerControlImpl.prdIdBytes_);
        this.writeSQLCAXGRP(updateCount, rowCount, this.buildSqlerrmc(e), e.getNextException());
    }

    private void writeSQLCAGRP(byte[] sqlState, int sqlcode, int updateCount, long rowCount) throws DRDAProtocolException {
        if (rowCount < 0L && updateCount < 0) {
            this.writer.writeByte(255);
            return;
        }
        this.writer.writeByte(0);
        this.writer.writeInt(sqlcode);
        this.writer.writeBytes(sqlState);
        this.writer.writeBytes(NetworkServerControlImpl.prdIdBytes_);
        this.writeSQLCAXGRP(updateCount, rowCount, null, null);
    }

    private String buildSqlerrmc(SQLException se) {
        int maxlen;
        boolean severe = se.getErrorCode() >= 40000;
        String sqlerrmc = null;
        se = Util.getExceptionFactory().getArgumentFerry(se);
        sqlerrmc = se instanceof DerbySQLException && !severe && ((DerbySQLException)((Object)se)).getArguments() != null ? this.buildTokenizedSqlerrmc(se) : this.buildPreformattedSqlerrmc(se);
        int n = maxlen = sqlerrmc == null ? -1 : Math.min(sqlerrmc.length(), this.appRequester.supportedMessageParamLength());
        if (maxlen >= 0 && sqlerrmc.length() > maxlen) {
            sqlerrmc = sqlerrmc.substring(0, maxlen);
        }
        return sqlerrmc;
    }

    private String buildPreformattedSqlerrmc(SQLException se) {
        if (se == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.addServerInformation(sb);
        do {
            sb.append(se.getLocalizedMessage());
            se = se.getNextException();
            if (se == null) continue;
            sb.append(ClientSharedData.SQLERRMC_PREFORMATTED_MESSAGE_DELIMITER + "SQLSTATE: " + se.getSQLState());
        } while (se != null);
        return sb.toString();
    }

    private final void addServerInformation(StringBuilder sb) {
        Socket sock = this.session.clientSocket;
        InetAddress addr = sock.getLocalAddress();
        String host = addr.getHostName();
        sb.append("(Server=").append(host != null ? host : addr.getHostAddress());
        sb.append('[').append(sock.getLocalPort()).append("],");
        sb.append(DRDAConnThread.currentThread()).append(") ");
    }

    private String buildTokenizedSqlerrmc(SQLException se) {
        StringBuilder sqlerrmc = new StringBuilder();
        this.addServerInformation(sqlerrmc);
        sqlerrmc.append(ClientSharedData.SQLERRMC_SERVER_DELIMITER);
        do {
            if (se instanceof DerbySQLException) {
                DerbySQLException ese = (DerbySQLException)((Object)se);
                String messageId = ese.getMessageId();
                Object[] args = ese.getArguments();
                for (int i = 0; args != null && i < args.length; ++i) {
                    sqlerrmc.append(args[i]).append(ClientSharedData.SQLERRMC_TOKEN_DELIMITER);
                }
                sqlerrmc.append(messageId);
            }
            if ((se = se.getNextException()) == null || !(se instanceof DerbySQLException)) continue;
            sqlerrmc.append(ClientSharedData.SQLERRMC_MESSAGE_DELIMITER).append(se.getSQLState()).append(':');
        } while (se != null);
        return sqlerrmc.toString();
    }

    private void writeSQLCAXGRP(int updateCount, long rowCount, String sqlerrmc, SQLException nextException) throws DRDAProtocolException {
        this.writer.writeByte(0);
        if (this.sqlamLevel < 7) {
            this.writeRDBNAM(this.database.dbName);
            this.writeSQLCAERRWARN(updateCount, rowCount);
        } else {
            this.writeSQLCAERRWARN(updateCount, rowCount);
            this.writer.writeShort(0);
        }
        this.writeVCMorVCS(sqlerrmc);
        if (this.sqlamLevel >= 7) {
            this.writeSQLDIAGGRP(nextException);
        }
    }

    private void writeSQLCAERRWARN(int updateCount, long rowCount) {
        this.writer.writeInt((int)(rowCount >>> 32));
        this.writer.writeInt((int)(rowCount & 0xFFFFFFFFL));
        this.writer.writeInt(updateCount);
        this.writer.writeBytes(errD4_D6);
        this.writer.writeBytes(warn0_warnA);
    }

    private void writeSQLDIAGGRP(SQLException nextException) throws DRDAProtocolException {
        while (nextException != null && nextException.getSQLState() != "rwupd" && nextException.getSQLState() != "02502") {
            nextException = nextException.getNextException();
        }
        if (nextException == null || this.diagnosticLevel == -16) {
            this.writer.writeByte(255);
            return;
        }
        this.writer.writeByte(0);
        this.writeSQLDIAGSTT();
        this.writeSQLDIAGCI(nextException);
        this.writeSQLDIAGCN();
    }

    private void writeSQLDIAGSTT() throws DRDAProtocolException {
        this.writer.writeByte(255);
    }

    private void writeSQLDIAGCI(SQLException nextException) throws DRDAProtocolException {
        SQLException se;
        long rowNum = 1L;
        this.writeSQLNUMROW(se);
        for (se = nextException; se != null; se = se.getNextException()) {
            String sqlState = se.getSQLState();
            int severity = this.getExceptionSeverity(se);
            int sqlCode = -1;
            if (severity == 4) {
                sqlCode = 1;
            } else if (severity == 0) {
                sqlCode = 0;
            }
            String sqlerrmc = "";
            if (this.diagnosticLevel == -15) {
                sqlerrmc = se.getLocalizedMessage();
            }
            if (this.diagnosticLevel == -16 && se instanceof DerbySQLException) {
                Object[] args = ((DerbySQLException)((Object)se)).getArguments();
                for (int i = 0; args != null && i < args.length; ++i) {
                    sqlerrmc = sqlerrmc + args[i].toString() + ClientSharedData.SQLERRMC_TOKEN_DELIMITER;
                }
            }
            String dbname = null;
            if (this.database != null) {
                dbname = this.database.dbName;
            }
            this.writeSQLDCROW(rowNum++, sqlCode, sqlState, dbname, sqlerrmc);
        }
    }

    private void writeSQLNUMROW(SQLException nextException) throws DRDAProtocolException {
        this.writeSQLNUMGRP(nextException);
    }

    private void writeSQLNUMGRP(SQLException nextException) throws DRDAProtocolException {
        int i = 0;
        for (SQLException se = nextException; se != null; se = se.getNextException()) {
            ++i;
        }
        this.writer.writeShort(i);
    }

    private void writeSQLDCROW(long rowNum, int sqlCode, String sqlState, String dbname, String sqlerrmc) throws DRDAProtocolException {
        this.writeSQLDCGRP(rowNum, sqlCode, sqlState, dbname, sqlerrmc);
    }

    private void writeSQLDCGRP(long rowNum, int sqlCode, String sqlState, String dbname, String sqlerrmc) throws DRDAProtocolException {
        this.writer.writeInt(sqlCode);
        this.writer.writeString(sqlState);
        this.writer.writeInt(0);
        this.writer.writeInt(0);
        this.writer.writeLong(rowNum);
        byte[] byteArray = new byte[1];
        this.writer.writeScalarPaddedBytes(byteArray, 47, (byte)0);
        this.writer.writeShort(0);
        this.writer.writeByte(255);
        this.writer.writeLDString(sqlerrmc);
        this.writeVCMorVCS(null);
        this.writeVCMorVCS(null);
        this.writeVCMorVCS(null);
        this.writer.writeByte(255);
    }

    private void writeSQLDIAGCN() throws DRDAProtocolException {
        this.writer.writeByte(255);
    }

    private void writeSQLSTMTID(String statementID) throws DRDAProtocolException {
        this.writer.createDssObject();
        this.writer.startDdm(12290);
        int length = 0;
        if (statementID != null) {
            byte[] buf = statementID.getBytes();
            length = buf.length;
            this.writer.writeInt(length);
            this.writer.writeBytes(buf, 0, length);
        } else {
            this.writer.writeInt(length);
        }
        this.writer.endDdmAndDss();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSQLDARD(DRDAStatement stmt, boolean rtnOutput, SQLException e, boolean writeSingleHopInformation, boolean metadataChanged) throws DRDAProtocolException, SQLException {
        Statement ps = stmt.getUnderlyingStatement();
        ResultSetMetaData rsmeta = null;
        ParameterMetaData pmeta = null;
        int numElems = 0;
        if (e == null || e instanceof SQLWarning) {
            if (!metadataChanged && stmt.ps != null) {
                rsmeta = stmt.ps.getMetaData();
                pmeta = stmt.getParameterMetaData();
            } else {
                ResultSet rs = ps.getResultSet();
                if (rs != null) {
                    rsmeta = rs.getMetaData();
                }
            }
            if (rtnOutput && rsmeta != null) {
                numElems = rsmeta.getColumnCount();
            } else if (!rtnOutput && pmeta != null) {
                numElems = pmeta.getParameterCount();
            }
        }
        this.writer.createDssObject();
        this.writer.startDdm(9233);
        this.writeSQLCAGRP(e, this.getSqlCode(this.getExceptionSeverity(e)), 0, 0L);
        if (this.sqlamLevel >= 7) {
            this.writeSQLDHROW(ps.getResultSetHoldability());
        }
        if (this.trace) {
            this.trace("num Elements = " + numElems);
        }
        this.writer.writeShort(numElems);
        for (int i = 0; i < numElems; ++i) {
            this.writeSQLDAGRP(rsmeta, pmeta, i, rtnOutput);
        }
        if (writeSingleHopInformation && stmt.needSendSingleHopInfo()) {
            SingleHopInformation shifn = stmt.fillAndGetSingleHopInformation();
            if (SanityManager.TraceSingleHop) {
                SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("DRDAConnThread::writeSQLDARD write for stmnt: " + stmt.sqlText + " writing single hop information: " + shifn));
            }
            byte[] buffer = null;
            int length = 0;
            try {
                DynamicByteArrayOutputStream dbaos = new DynamicByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream((OutputStream)dbaos);
                oos.writeObject(shifn);
                buffer = dbaos.getByteArray();
                length = dbaos.getUsed();
                this.writer.writeInt(length);
                this.writer.writeBytes(buffer, 0, length);
            }
            catch (IOException ioe) {
                this.handleException(ioe);
            }
            finally {
                stmt.setSendSingleHopInLccToFalse();
                stmt.setSendSingleHopInfo(false);
            }
        }
        this.writer.endDdmAndDss();
    }

    private void writeQRYDSC(DRDAStatement stmt, boolean FDODSConly) throws DRDAProtocolException, SQLException {
        int remaining;
        int firstcols;
        int blksize;
        ResultSet rs = null;
        ResultSetMetaData rsmeta = null;
        ParameterMetaData pmeta = null;
        if (!stmt.needsToSendParamData) {
            rs = stmt.getResultSet();
        }
        if (rs == null) {
            pmeta = stmt.getParameterMetaData();
        } else {
            rsmeta = rs.getMetaData();
        }
        int numCols = rsmeta != null ? rsmeta.getColumnCount() : pmeta.getParameterCount();
        int numGroups = 1;
        int colStart = 1;
        int colEnd = numCols;
        int n = blksize = stmt.getBlksize() > 0 ? stmt.getBlksize() : 0xA00000;
        if (this.trace) {
            this.trace("numCols = " + numCols);
        }
        if ((firstcols = (remaining = blksize - this.writer.getDSSLength() % blksize - (3 + FdocaConstants.SQLCADTA_SQLDTARD_RLO_SIZE)) / 3) < numCols || numCols > 84) {
            if (firstcols > 84) {
                if (this.trace) {
                    SanityManager.ASSERT((numCols > 84 ? 1 : 0) != 0, (String)("Number of columns " + numCols + " is less than MAX_VARS_IN_NGDA"));
                }
                if (84 * (numGroups = numCols / 84) < numCols) {
                    ++numGroups;
                }
                colEnd = 84;
            } else {
                colEnd = firstcols;
                if (84 * (numGroups += (numCols - firstcols) / 84) < numCols) {
                    ++numGroups;
                }
            }
        }
        if (!FDODSConly) {
            this.writer.createDssObject();
            this.writer.startDdm(9242);
        }
        for (int i = 0; i < numGroups; ++i) {
            this.writeSQLDTAGRP(stmt, rsmeta, pmeta, colStart, colEnd, i == 0, !FDODSConly);
            if (i == numGroups - 1) continue;
            colStart = colEnd + 1;
            if ((colEnd += 84) <= numCols) continue;
            colEnd = numCols;
        }
        if (colEnd < numCols) {
            int left = numCols - colEnd;
            if (this.trace) {
                this.trace("number of columns still not sent = " + left);
            }
            int remainder = left % 84;
            int remainingGroups = 0;
            remainingGroups = remainder == 0 ? left / 84 : left / 84 + 1;
            colStart = colEnd + 1;
            if ((colEnd = colStart + 84) > numCols) {
                colEnd = numCols;
            }
            for (int i = 0; i < remainingGroups; ++i) {
                this.writeSQLDTAGRP(stmt, rsmeta, pmeta, colStart, colEnd, false, !FDODSConly);
                colStart = colEnd + 1;
                if ((colEnd += 84) <= numCols) continue;
                colEnd = numCols;
            }
        }
        this.writer.writeBytes(FdocaConstants.SQLCADTA_SQLDTARD_RLO);
        if (!FDODSConly) {
            this.writer.endDdmAndDss();
        }
    }

    private void writeSQLDTAGRP(DRDAStatement stmt, ResultSetMetaData rsmeta, ParameterMetaData pmeta, int colStart, int colEnd, boolean first, boolean useIncomingLength) throws DRDAProtocolException, SQLException {
        int length = 3 * (colEnd + 1 - colStart) + 3;
        this.writer.writeByte(length);
        if (first) {
            this.writer.writeByte(118);
            this.writer.writeByte(208);
        } else {
            this.writer.writeByte(127);
            this.writer.writeByte(0);
        }
        boolean hasRs = rsmeta != null;
        for (int i = colStart; i <= colEnd; ++i) {
            boolean nullable = hasRs ? rsmeta.isNullable(i) == 1 : pmeta.isNullable(i) == 1;
            int colType = hasRs ? rsmeta.getColumnType(i) : pmeta.getParameterType(i);
            int[] outlen = new int[]{-1};
            int drdaType = FdocaConstants.mapJdbcTypeToDrdaType(colType, nullable, this.appRequester, outlen);
            boolean isDecimal = (drdaType | 1) == 15;
            int precision = 0;
            int scale = 0;
            if (hasRs) {
                precision = rsmeta.getPrecision(i);
                scale = rsmeta.getScale(i);
                stmt.setRsDRDAType(i, drdaType);
                stmt.setRsPrecision(i, precision);
                stmt.setRsScale(i, scale);
            } else if (isDecimal && stmt.isOutputParam(i)) {
                precision = pmeta.getPrecision(i);
                scale = pmeta.getScale(i);
                ((CallableStatement)stmt.ps).registerOutParameter(i, 3, scale);
            }
            int paramLen = -1;
            this.writer.writeByte(drdaType);
            if (isDecimal) {
                this.writer.writeByte(precision);
                this.writer.writeByte(scale);
            } else if (outlen[0] != -1) {
                paramLen = outlen[0];
                this.writer.writeShort(paramLen);
            } else if (hasRs) {
                paramLen = colType == 1 ? rsmeta.getPrecision(i) : rsmeta.getColumnDisplaySize(i);
                this.writer.writeShort(paramLen);
            } else if (useIncomingLength) {
                paramLen = stmt.getParamLen(i);
                this.writer.writeShort(paramLen);
            } else {
                paramLen = pmeta.getPrecision(i);
                this.writer.writeShort(paramLen);
            }
            if (!this.trace) continue;
            this.trace("jdbcType=" + colType + "  \tdrdaType=0x" + Integer.toHexString(drdaType) + " \tlen=" + paramLen);
        }
    }

    private void writeSQLDHROW(int holdability) throws DRDAProtocolException, SQLException {
        if (JVMInfo.JDK_ID < 2) {
            this.writer.writeByte(255);
            return;
        }
        this.writer.writeByte(0);
        this.writer.writeShort(holdability);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writer.writeShort(0);
        this.writeVCMorVCS(null);
    }

    private void writeQRYDTA(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        boolean qryclsOnLmtblkprc;
        boolean getMoreData = true;
        boolean sentExtData = false;
        int startLength = 0;
        this.writer.createDssObject();
        if (this.trace) {
            this.trace("Write QRYDTA");
        }
        this.writer.startDdm(9243);
        if (this.processLeftoverQRYDTA(stmt)) {
            if (stmt.getSplitQRYDTA() == null) {
                ++stmt.rowCount;
                if (stmt.getExtDtaObjects() != null) {
                    this.writeEXTDTA(stmt);
                }
            }
            return;
        }
        while (getMoreData) {
            sentExtData = false;
            getMoreData = this.writeFDODTA(stmt);
            if (stmt.getExtDtaObjects() != null && stmt.getSplitQRYDTA() == null) {
                this.writer.endDdmAndDss();
                this.writeEXTDTA(stmt);
                getMoreData = false;
                sentExtData = true;
            }
            if (!getMoreData) continue;
            int endLength = this.writer.getDSSLength();
            int rowsize = endLength - startLength;
            if (stmt.getBlksize() - endLength < rowsize) {
                getMoreData = false;
            }
            startLength = endLength;
        }
        if (!sentExtData) {
            this.writer.endDdmAndDss();
        }
        if (!stmt.hasdata() && stmt.isRSCloseImplicit(qryclsOnLmtblkprc = this.appRequester.supportsQryclsimpForLmtblkprc())) {
            stmt.rsClose();
        }
    }

    private boolean writeFDODTA(DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        int numCols;
        boolean hasdata = false;
        int blksize = stmt.getBlksize() > 0 ? stmt.getBlksize() : 0xA00000;
        long rowCount = 0L;
        ResultSet rs = null;
        boolean moreData = stmt.getQryprctyp() == 9239;
        stmt.setStatus("SENDING RESULTS");
        if (!stmt.needsToSendParamData) {
            rs = stmt.getResultSet();
        }
        boolean isScrollable = stmt.isScrollable();
        if (rs != null) {
            numCols = stmt.getNumRsCols();
            hasdata = isScrollable ? this.positionCursor(stmt, rs) : rs.next();
        } else {
            hasdata = stmt.hasOutputParams();
            numCols = stmt.getDrdaParamCount();
            if (hasdata) {
                stmt.setStatus("SENDING OutputParams: " + numCols);
            }
        }
        do {
            boolean noRetrieveRS;
            boolean rowDeleted;
            boolean candidateForChanges;
            SQLWarning sqlw;
            if (!hasdata) {
                this.doneData(stmt, rs, isScrollable);
                moreData = false;
                return moreData;
            }
            SQLWarning sQLWarning = sqlw = rs != null ? rs.getWarnings() : null;
            if (rs != null) {
                rs.clearWarnings();
            }
            boolean bl = candidateForChanges = rs != null && (!(rs instanceof EmbedResultSet) || ((EmbedResultSet)rs).candidateForChanges());
            if (candidateForChanges && rs.rowUpdated()) {
                SQLWarning w = new SQLWarning("", "rwupd", 10000);
                if (sqlw != null) {
                    sqlw.setNextWarning(w);
                } else {
                    sqlw = w;
                }
            }
            boolean bl2 = rowDeleted = candidateForChanges && rs.rowDeleted();
            if (rowDeleted) {
                SQLWarning w = new SQLWarning("", "02502", 10000);
                if (sqlw != null) {
                    sqlw.setNextWarning(w);
                } else {
                    sqlw = w;
                }
            }
            if (sqlw == null) {
                this.writeSQLCAGRP(nullSQLState, 0, -1, -1L);
            } else {
                this.writeSQLCAGRP(sqlw, sqlw.getErrorCode(), 1, -1L);
            }
            boolean bl3 = noRetrieveRS = rs != null && (!stmt.getQryrtndta() || rowDeleted);
            if (noRetrieveRS) {
                this.writer.writeByte(255);
            } else {
                this.writer.writeByte(0);
            }
            block10: for (int i = 1; i <= numCols && !noRetrieveRS; ++i) {
                boolean valNull;
                int scale;
                int precision;
                int drdaType;
                Object val = null;
                if (rs != null) {
                    drdaType = stmt.getRsDRDAType(i) & 0xFF;
                    precision = stmt.getRsPrecision(i);
                    scale = stmt.getRsScale(i);
                    int ndrdaType = drdaType | 1;
                    if (this.trace) {
                        this.trace("!!drdaType = " + Integer.toHexString(drdaType) + " precision=" + precision + " scale = " + scale);
                    }
                    switch (ndrdaType) {
                        case 201: 
                        case 207: {
                            EXTDTAInputStream extdtaStream = EXTDTAInputStream.getEXTDTAStream(rs, i, drdaType);
                            this.writeFdocaVal(i, extdtaStream, drdaType, precision, scale, extdtaStream.isNull(), stmt);
                            break;
                        }
                        case 3: {
                            int ival = rs.getInt(i);
                            valNull = rs.wasNull();
                            if (this.trace) {
                                this.trace("====== writing int: " + ival + " is null: " + valNull);
                            }
                            this.writeNullability(drdaType, valNull);
                            if (valNull) continue block10;
                            this.writer.writeInt(ival);
                            break;
                        }
                        case 5: {
                            short sval = rs.getShort(i);
                            valNull = rs.wasNull();
                            if (this.trace) {
                                this.trace("====== writing small: " + sval + " is null: " + valNull);
                            }
                            this.writeNullability(drdaType, valNull);
                            if (valNull) continue block10;
                            this.writer.writeShort(sval);
                            break;
                        }
                        case 23: {
                            long lval = rs.getLong(i);
                            valNull = rs.wasNull();
                            if (this.trace) {
                                this.trace("====== writing long: " + lval + " is null: " + valNull);
                            }
                            this.writeNullability(drdaType, valNull);
                            if (valNull) continue block10;
                            this.writer.writeLong(lval);
                            break;
                        }
                        case 13: {
                            float fval = rs.getFloat(i);
                            valNull = rs.wasNull();
                            if (this.trace) {
                                this.trace("====== writing float: " + fval + " is null: " + valNull);
                            }
                            this.writeNullability(drdaType, valNull);
                            if (valNull) continue block10;
                            this.writer.writeFloat(fval);
                            break;
                        }
                        case 11: {
                            double dval = rs.getDouble(i);
                            valNull = rs.wasNull();
                            if (this.trace) {
                                this.trace("====== writing double: " + dval + " is null: " + valNull);
                            }
                            this.writeNullability(drdaType, valNull);
                            if (valNull) continue block10;
                            this.writer.writeDouble(dval);
                            break;
                        }
                        case 49: 
                        case 51: 
                        case 53: 
                        case 61: 
                        case 63: 
                        case 65: {
                            String valStr = rs.getString(i);
                            if (this.trace) {
                                this.trace("====== writing char/varchar/mix :" + valStr + ":");
                            }
                            this.writeFdocaVal(i, valStr, drdaType, precision, scale, rs.wasNull(), stmt);
                            break;
                        }
                        default: {
                            Object obj = rs.getObject(i);
                            this.writeFdocaVal(i, obj, drdaType, precision, scale, obj == null || rs.wasNull(), stmt);
                            break;
                        }
                    }
                    continue;
                }
                drdaType = stmt.getParamDRDAType(i) & 0xFF;
                precision = stmt.getParamPrecision(i);
                scale = stmt.getParamScale(i);
                if (stmt.isOutputParam(i)) {
                    int[] outlen = new int[1];
                    drdaType = FdocaConstants.mapJdbcTypeToDrdaType(stmt.getOutputParamType(i), true, this.appRequester, outlen);
                    precision = stmt.getOutputParamPrecision(i);
                    scale = stmt.getOutputParamScale(i);
                    if (this.trace) {
                        this.trace("***getting Object " + i);
                    }
                    valNull = (val = this.getObjectForWriteFdoca((CallableStatement)stmt.ps, i, drdaType)) == null;
                    this.writeFdocaVal(i, val, drdaType, precision, scale, valNull, stmt);
                    continue;
                }
                this.writeFdocaVal(i, null, drdaType, precision, scale, true, stmt);
            }
            if (this.writer.getDSSLength() > blksize) {
                this.splitQRYDTA(stmt, blksize);
                return false;
            }
            if (rs == null) {
                stmt.setStatus("DONE");
                return moreData;
            }
            if (++rowCount < (long)stmt.getQryrowset()) {
                hasdata = rs.next();
                continue;
            }
            if (!isScrollable && !noRetrieveRS) continue;
            moreData = false;
        } while (hasdata && rowCount < (long)stmt.getQryrowset());
        if (!isScrollable) {
            stmt.rowCount += rowCount;
            stmt.setStatus("SENDING RESULTS " + stmt.rowCount);
        }
        if (!hasdata) {
            this.doneData(stmt, rs, isScrollable);
            moreData = false;
        }
        if (!isScrollable) {
            stmt.setHasdata(hasdata);
        }
        return moreData;
    }

    private Object getObjectForWriteFdoca(CallableStatement cs, int index, int drdaType) throws SQLException {
        int ndrdaType = drdaType | 1;
        switch (ndrdaType) {
            case 201: 
            case 207: {
                return EXTDTAInputStream.getEXTDTAStream(cs, index, drdaType);
            }
        }
        return cs.getObject(index);
    }

    private void splitQRYDTA(DRDAStatement stmt, int blksize) throws SQLException, DRDAProtocolException {
        byte[] temp = this.writer.copyDSSDataToEnd(blksize);
        this.writer.truncateDSS(blksize);
        if (temp.length == 0) {
            this.agentError("LMTBLKPRC violation: splitQRYDTA was called to split a QRYDTA block, but the entire row fit successfully into the current block. Server rowsize computation was probably incorrect (perhaps an off-by-one bug?). QRYDTA blocksize: " + blksize);
        }
        stmt.setSplitQRYDTA(temp);
    }

    private boolean processLeftoverQRYDTA(DRDAStatement stmt) throws SQLException, DRDAProtocolException {
        int blksize;
        byte[] leftovers = stmt.getSplitQRYDTA();
        if (leftovers == null) {
            return false;
        }
        int n = blksize = stmt.getBlksize() > 0 ? stmt.getBlksize() : 0xA00000;
        if (leftovers.length < (blksize -= 10)) {
            this.writer.writeBytes(leftovers, 0, leftovers.length);
            stmt.setSplitQRYDTA(null);
        } else {
            this.writer.writeBytes(leftovers, 0, blksize);
            byte[] newLeftovers = new byte[leftovers.length - blksize];
            for (int i = 0; i < newLeftovers.length; ++i) {
                newLeftovers[i] = leftovers[blksize + i];
            }
            stmt.setSplitQRYDTA(newLeftovers);
        }
        this.writer.endDdmAndDss();
        return true;
    }

    private void doneData(DRDAStatement stmt, ResultSet rs, boolean isScrollable) throws DRDAProtocolException, SQLException {
        int blksize;
        stmt.setStatus("DONE RESULTS DATA");
        if (this.trace) {
            this.trace("*****NO MORE DATA!!");
        }
        int n = blksize = stmt.getBlksize() > 0 ? stmt.getBlksize() : 0xA00000;
        if (rs != null) {
            if (isScrollable) {
                boolean isAfterLast = rs.isAfterLast();
                boolean isBeforeFirst = rs.isBeforeFirst();
                rs.last();
                stmt.rowCount = rs.getRow();
                if (isAfterLast) {
                    rs.afterLast();
                }
                if (isBeforeFirst) {
                    rs.beforeFirst();
                }
            } else {
                boolean qryclsOnLmtblkprc = this.appRequester.supportsQryclsimpForLmtblkprc();
                if (stmt.isRSCloseImplicit(qryclsOnLmtblkprc)) {
                    stmt.rsClose();
                    stmt.rsSuspend();
                }
            }
        }
        boolean isQRYSCRAFT = stmt.getQryscrorn() == 3;
        this.writeSQLCAGRP(isQRYSCRAFT ? eod00000 : eod02000, isQRYSCRAFT ? 0 : 100, 0, stmt.rowCount);
        this.writer.writeByte(255);
        if (this.writer.getDSSLength() > blksize) {
            this.splitQRYDTA(stmt, blksize);
        }
    }

    private boolean positionCursor(DRDAStatement stmt, ResultSet rs) throws SQLException, DRDAProtocolException {
        boolean retval = false;
        switch (stmt.getQryscrorn()) {
            case 1: {
                int rows = (int)stmt.getQryrownbr();
                if (rs.isAfterLast() && rows > 0 || rs.isBeforeFirst() && rows < 0) {
                    retval = false;
                    break;
                }
                retval = rs.relative(rows);
                break;
            }
            case 2: {
                if (stmt.getQryrownbr() == 0L) {
                    rs.beforeFirst();
                    retval = false;
                    break;
                }
                retval = rs.absolute((int)stmt.getQryrownbr());
                break;
            }
            case 3: {
                rs.afterLast();
                retval = false;
                break;
            }
            case 4: {
                rs.beforeFirst();
                retval = false;
                break;
            }
            default: {
                this.agentError("Invalid value for cursor orientation " + stmt.getQryscrorn());
            }
        }
        return retval;
    }

    private void writeSQLDAGRP(ResultSetMetaData rsmeta, ParameterMetaData pmeta, int elemNum, boolean rtnOutput) throws DRDAProtocolException, SQLException {
        int scale;
        int precision;
        int jdbcElemNum = elemNum + 1;
        int[] outlen = new int[]{-1};
        int elemType = rtnOutput ? rsmeta.getColumnType(jdbcElemNum) : pmeta.getParameterType(jdbcElemNum);
        int n = precision = rtnOutput ? rsmeta.getPrecision(jdbcElemNum) : pmeta.getPrecision(jdbcElemNum);
        if (precision > 127) {
            precision = 127;
        }
        int n2 = scale = rtnOutput ? rsmeta.getScale(jdbcElemNum) : pmeta.getScale(jdbcElemNum);
        if (elemType == 3 || elemType == 2) {
            this.writer.writeShort(precision);
            this.writer.writeShort(scale);
        } else {
            this.writer.writeShort(0);
            this.writer.writeShort(0);
        }
        boolean nullable = rtnOutput ? rsmeta.isNullable(jdbcElemNum) == 1 : pmeta.isNullable(jdbcElemNum) == 1;
        int sqlType = SQLTypes.mapJdbcTypeToDB2SqlType(elemType, nullable, this.appRequester, outlen);
        if (outlen[0] == -1) {
            switch (elemType) {
                case 2: 
                case 3: {
                    outlen[0] = precision << 8 | scale << 0;
                    if (!this.trace) break;
                    this.trace("\n\nprecision = " + precision + " scale = " + scale);
                    break;
                }
                default: {
                    outlen[0] = Math.min(FdocaConstants.LONGVARCHAR_MAX_LEN, rtnOutput ? rsmeta.getColumnDisplaySize(jdbcElemNum) : pmeta.getPrecision(jdbcElemNum));
                }
            }
        }
        switch (elemType) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2005: 
            case 4002: {
                int n3 = outlen[0] = rtnOutput ? rsmeta.getPrecision(jdbcElemNum) : pmeta.getPrecision(jdbcElemNum);
            }
        }
        if (this.trace) {
            this.trace("SQLDAGRP len = 0x" + Integer.toHexString(outlen[0]) + " for type:" + elemType);
        }
        if (this.sqlamLevel >= 6) {
            this.writer.writeLong(outlen[0]);
        } else {
            this.writer.writeInt(outlen[0]);
        }
        if (this.trace) {
            String typeName = rtnOutput ? rsmeta.getColumnTypeName(jdbcElemNum) : pmeta.getParameterTypeName(jdbcElemNum);
            this.trace("jdbcType = " + typeName + " sqlType = " + sqlType + " len = " + outlen[0]);
        }
        this.writer.writeShort(sqlType);
        if (elemType == 1 || elemType == 12 || elemType == -1 || elemType == 2005) {
            this.writer.writeScalar2Bytes(1208);
        } else {
            this.writer.writeScalar2Bytes(0);
        }
        if (this.sqlamLevel < 7) {
            this.writeVCMorVCS(rtnOutput ? rsmeta.getColumnName(jdbcElemNum) : null);
            this.writeVCMorVCS(null);
            this.writeVCMorVCS(null);
            if (this.sqlamLevel == 6) {
                this.writeSQLUDTGRP(rsmeta, pmeta, jdbcElemNum, rtnOutput);
            }
        } else {
            this.writeSQLDOPTGRP(rsmeta, pmeta, jdbcElemNum, rtnOutput);
        }
    }

    private void writeVCMorVCS(String s) throws DRDAProtocolException {
        if (s == null) {
            this.writer.writeShort(0);
            this.writer.writeShort(0);
            return;
        }
        this.writer.writeLDString(s);
        this.writer.writeShort(0);
    }

    private void writeSQLUDTGRP(ResultSetMetaData rsmeta, ParameterMetaData pmeta, int jdbcElemNum, boolean rtnOutput) throws DRDAProtocolException, SQLException {
        int jdbcType;
        int n = jdbcType = rtnOutput ? rsmeta.getColumnType(jdbcElemNum) : pmeta.getParameterType(jdbcElemNum);
        if (jdbcType != 2000 || !this.appRequester.supportsUDTs()) {
            this.writer.writeByte(255);
            return;
        }
        String typeName = rtnOutput ? rsmeta.getColumnTypeName(jdbcElemNum) : pmeta.getParameterTypeName(jdbcElemNum);
        String className = rtnOutput ? rsmeta.getColumnClassName(jdbcElemNum) : pmeta.getParameterClassName(jdbcElemNum);
        this.writeVCMorVCS(typeName);
        this.writeVCMorVCS(className);
    }

    private void writeSQLDOPTGRP(ResultSetMetaData rsmeta, ParameterMetaData pmeta, int jdbcElemNum, boolean rtnOutput) throws DRDAProtocolException, SQLException {
        this.writer.writeByte(0);
        this.writer.writeShort(0);
        this.writeVCMorVCS(rtnOutput ? rsmeta.getColumnName(jdbcElemNum) : null);
        this.writeVCMorVCS(null);
        this.writeVCMorVCS(null);
        this.writeSQLUDTGRP(rsmeta, pmeta, jdbcElemNum, rtnOutput);
        this.writeSQLDXGRP(rsmeta, pmeta, jdbcElemNum, rtnOutput);
    }

    private void writeSQLDXGRP(ResultSetMetaData rsmeta, ParameterMetaData pmeta, int jdbcElemNum, boolean rtnOutput) throws DRDAProtocolException, SQLException {
        this.writer.writeByte(0);
        int pk = rtnOutput && rsmeta instanceof EmbedResultSetMetaData ? (int)((EmbedResultSetMetaData)rsmeta).primaryKey(jdbcElemNum, this.database.getConnection()) : 0;
        this.writer.writeShort(pk);
        this.writer.writeShort(rtnOutput ? !rsmeta.isReadOnly(jdbcElemNum) : false);
        if (rtnOutput && rsmeta.isAutoIncrement(jdbcElemNum)) {
            this.writer.writeShort(2);
        } else {
            this.writer.writeShort(0);
        }
        if (pmeta != null && !rtnOutput) {
            int type;
            int mode = pmeta.getParameterMode(jdbcElemNum);
            if (mode == 0 && (type = DRDAStatement.getOutputParameterTypeFromClassName(pmeta.getParameterClassName(jdbcElemNum))) != DRDAStatement.NOT_OUTPUT_PARAM) {
                mode = 2;
            }
            this.writer.writeShort(mode);
        } else {
            this.writer.writeShort(0);
        }
        this.writer.writeShort(0);
        this.writeVCMorVCS(null);
        this.writeVCMorVCS(rtnOutput ? rsmeta.getTableName(jdbcElemNum) : null);
        this.writeVCMorVCS(rtnOutput ? rsmeta.getSchemaName(jdbcElemNum) : null);
        this.writeVCMorVCS(rtnOutput ? rsmeta.getColumnName(jdbcElemNum) : null);
    }

    protected void writeFdocaVal(int index, Object val, int drdaType, int precision, int scale, boolean valNull, DRDAStatement stmt) throws DRDAProtocolException, SQLException {
        this.writeNullability(drdaType, valNull);
        if (!valNull) {
            int ndrdaType = drdaType | 1;
            long valLength = 0L;
            switch (ndrdaType) {
                case 5: {
                    if (val instanceof Boolean) {
                        this.writer.writeShort((Boolean)val);
                        break;
                    }
                    if (val instanceof Short) {
                        this.writer.writeShort(((Short)val).shortValue());
                        break;
                    }
                    if (val instanceof Byte) {
                        this.writer.writeShort(((Byte)val).byteValue());
                        break;
                    }
                    this.writer.writeShort(((Integer)val).shortValue());
                    break;
                }
                case 3: {
                    this.writer.writeInt((Integer)val);
                    break;
                }
                case 23: {
                    this.writer.writeLong((Long)val);
                    break;
                }
                case 13: {
                    this.writer.writeFloat(((Float)val).floatValue());
                    break;
                }
                case 11: {
                    this.writer.writeDouble((Double)val);
                    break;
                }
                case 15: {
                    if (precision == 0) {
                        precision = 38;
                    }
                    BigDecimal bd = (BigDecimal)val;
                    this.writer.writeBigDecimal(bd, precision, scale);
                    break;
                }
                case 33: {
                    this.writer.writeString(((java.sql.Date)val).toString());
                    break;
                }
                case 35: {
                    this.writer.writeString(((Time)val).toString());
                    break;
                }
                case 37: {
                    String ts1 = ((Timestamp)val).toString();
                    String ts2 = ts1.replace(' ', '-').replace(':', '.');
                    int tsLen = ts2.length();
                    if (tsLen < 26) {
                        for (int i = 0; i < 26 - tsLen; ++i) {
                            ts2 = ts2 + "0";
                        }
                    } else if (tsLen > 26) {
                        ts2 = ts2.substring(0, 26);
                    }
                    this.writer.writeString(ts2);
                    break;
                }
                case 49: 
                case 61: {
                    this.writer.writeString(((String)val).toString());
                    break;
                }
                case 51: 
                case 53: 
                case 63: 
                case 65: {
                    this.writer.writeLDString(val.toString(), index);
                    break;
                }
                case 201: 
                case 207: {
                    if (!((EXTDTAInputStream)val).isEmptyStream()) {
                        stmt.addExtDtaObject(val, index);
                        this.writer.writeExtendedLength(32768L);
                        break;
                    }
                    this.writer.writeExtendedLength(0L);
                    break;
                }
                case 39: {
                    this.writer.writeBytes((byte[])val);
                    break;
                }
                case 41: 
                case 43: {
                    this.writer.writeLDBytes((byte[])val, index);
                    break;
                }
                case 25: {
                    if (val instanceof EngineLOB) {
                        this.writer.writeInt(((EngineLOB)val).getLocator());
                        break;
                    }
                    WrapperEngineBLOB blob = new WrapperEngineBLOB(this.database.getConnection(), (Blob)val);
                    this.writer.writeInt(blob.getLocator());
                    break;
                }
                case 27: {
                    if (val instanceof EngineLOB) {
                        this.writer.writeInt(((EngineLOB)val).getLocator());
                        break;
                    }
                    if (val instanceof String) {
                        val = new HarmonySerialClob((String)val);
                    }
                    WrapperEngineCLOB clob = new WrapperEngineCLOB(this.database.getConnection(), (Clob)val);
                    this.writer.writeInt(clob.getLocator());
                    break;
                }
                case 81: {
                    this.writer.writeUDT(val, index);
                    break;
                }
                default: {
                    if (this.trace) {
                        this.trace("ndrdaType is: " + ndrdaType);
                    }
                    this.writer.writeLDString(val.toString(), index);
                }
            }
        }
    }

    private void writeNullability(int drdaType, boolean valNull) {
        if (FdocaConstants.isNullable(drdaType)) {
            if (valNull) {
                this.writer.writeByte(255);
            } else {
                this.writer.writeByte(0);
            }
        }
    }

    private void copyToRequired(int[] req) {
        this.currentRequiredLength = req.length;
        if (this.currentRequiredLength > this.required.length) {
            this.required = new int[this.currentRequiredLength];
        }
        for (int i = 0; i < req.length; ++i) {
            this.required[i] = req[i];
        }
    }

    private void removeFromRequired(int codePoint) {
        for (int i = 0; i < this.currentRequiredLength; ++i) {
            if (this.required[i] != codePoint) continue;
            this.required[i] = 0;
        }
    }

    private void checkRequired(int codePoint) throws DRDAProtocolException {
        int firstMissing = 0;
        for (int i = 0; i < this.currentRequiredLength; ++i) {
            if (this.required[i] == 0) continue;
            firstMissing = this.required[i];
            break;
        }
        if (firstMissing != 0) {
            this.missingCodePoint(firstMissing);
        }
    }

    private void tooMany(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(15, codePoint);
    }

    private void tooBig(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(9, codePoint);
    }

    private void badObjectLength(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(11, codePoint);
    }

    private void rdbNotFound(String rdbnam) throws DRDAProtocolException {
        Object[] oa = new Object[]{rdbnam};
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_RDBNFNRM, this, 0, 0, oa);
    }

    private void invalidValue(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(20, codePoint);
    }

    protected void invalidCodePoint(int codePoint) throws DRDAProtocolException {
        this.throwSyntaxrm(29, codePoint);
    }

    protected void codePointNotSupported(int codePoint) throws DRDAProtocolException {
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_CMDNSPRM, this, codePoint, 0);
    }

    private void valueNotSupported(int codePoint) throws DRDAProtocolException {
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_VALNSPRM, this, codePoint, 0);
    }

    private void verifyRequiredObject(int codePoint, int reqCodePoint) throws DRDAProtocolException {
        if (codePoint != reqCodePoint) {
            this.throwSyntaxrm(14, codePoint);
        }
    }

    private void verifyInOrderACCSEC_SECCHK(int codePoint, int reqCodePoint) throws DRDAProtocolException {
        if (codePoint != reqCodePoint) {
            throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_PRCCNVRM, this, codePoint, 17);
        }
    }

    private void rdbnamMismatch(int codePoint) throws DRDAProtocolException {
        throw new DRDAProtocolException(DRDAProtocolException.DRDA_Proto_PRCCNVRM, this, codePoint, 18);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession() {
        if (this.session == null) {
            return;
        }
        if (this.xaProto != null) {
            this.xaProto.rollbackCurrentTransaction();
        }
        this.server.removeFromSessionTable(this.session.connNum);
        try {
            this.session.close();
        }
        catch (SQLException se) {
            this.sendUnexpectedException(se);
            this.close();
        }
        catch (Exception e) {
            this.sendUnexpectedException(e);
            this.close();
        }
        finally {
            this.session = null;
            this.database = null;
            this.appRequester = null;
            this.sockis = null;
            this.sockos = null;
            this.databaseAccessException = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Exception e) {
        if (SanityManager.TraceSingleHop) {
            SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("DRDAConnThread::handleException sending exception: " + e), (Throwable)e);
        }
        try {
            if (e instanceof DRDAProtocolException) {
                this.sendProtocolException((DRDAProtocolException)e);
            } else {
                this.sendUnexpectedException(e);
                this.server.consoleExceptionPrintTrace(e);
            }
        }
        finally {
            this.closeSession();
            this.close();
        }
    }

    private void sendProtocolException(DRDAProtocolException de) {
        String dbname = null;
        if (this.database != null) {
            dbname = this.database.dbName;
        }
        try {
            DRDAConnThread.println2Log(dbname, this.session.drdaID, de.getMessage());
            this.server.consoleExceptionPrintTrace(de);
            this.reader.clearBuffer();
            de.write(this.writer);
            this.finalizeChain();
        }
        catch (DRDAProtocolException ioe) {
            DRDAConnThread.println2Log(dbname, this.session.drdaID, de.getMessage());
            this.server.consoleExceptionPrintTrace(ioe);
        }
    }

    private void sendUnexpectedException(Exception e) {
        String dbname = null;
        try {
            if (this.database != null) {
                dbname = this.database.dbName;
            }
            DRDAConnThread.println2Log(dbname, this.session.drdaID, e.getMessage());
            this.server.consoleExceptionPrintTrace(e);
            DRDAProtocolException unExpDe = DRDAProtocolException.newAgentError(this, 64, dbname, e.getMessage());
            this.reader.clearBuffer();
            unExpDe.write(this.writer);
            this.finalizeChain();
        }
        catch (DRDAProtocolException dRDAProtocolException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closed() {
        Object object = this.closeSync;
        synchronized (object) {
            return this.close;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getLogConnections() {
        Object object = this.logConnectionsSync;
        synchronized (object) {
            return this.logConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTimeSlice() {
        Object object = this.timeSliceSync;
        synchronized (object) {
            return this.timeSlice;
        }
    }

    protected void trace(String value) {
        if (this.trace) {
            this.server.consoleMessage(value);
        }
    }

    @SuppressWarnings(value={"DM_GC"})
    public static void showmem() {
        Runtime rt = null;
        Date d = null;
        rt = Runtime.getRuntime();
        rt.gc();
        d = new Date();
        System.out.println("total memory: " + rt.totalMemory() + " free: " + rt.freeMemory() + " " + d.toString());
    }

    private String convertToHexString(byte[] buf) {
        StringBuilder str = new StringBuilder();
        str.append("0x");
        for (int i = 0; i < buf.length; ++i) {
            int byteVal = buf[i] & 0xFF;
            String val = Integer.toHexString(byteVal);
            if (val.length() < 2) {
                str.append("0");
            }
            str.append(val);
        }
        return str.toString();
    }

    private void checkValidTypDefNam(String typdefnam) throws DRDAProtocolException {
        if (typdefnam.equals("QTDSQL370")) {
            return;
        }
        if (typdefnam.equals("QTDSQL400")) {
            return;
        }
        if (typdefnam.equals("QTDSQLX86")) {
            return;
        }
        if (typdefnam.equals("QTDSQLASC")) {
            return;
        }
        if (typdefnam.equals("QTDSQLVAX")) {
            return;
        }
        if (typdefnam.equals("QTDSQLJVM")) {
            return;
        }
        this.invalidValue(47);
    }

    private void checkLength(int codepoint, int reqlen) throws DRDAProtocolException {
        long len = this.reader.getDdmLength();
        if (len < (long)reqlen) {
            this.badObjectLength(codepoint);
        } else if (len > (long)reqlen) {
            this.tooBig(codepoint);
        }
    }

    private boolean readBoolean(int codepoint) throws DRDAProtocolException {
        this.checkLength(codepoint, 1);
        byte val = this.reader.readByte();
        if (val == -15) {
            return true;
        }
        if (val == -16) {
            return false;
        }
        this.invalidValue(codepoint);
        return false;
    }

    private void addDatabase(String dbname) {
        Database db = this.appRequester.isXARequester() ? new XADatabase(dbname) : new Database(dbname);
        this.session.addDatabase(db);
        this.session.database = db;
        this.database = db;
    }

    private void setDatabase(int codePoint) throws DRDAProtocolException {
        String rdbnam = this.parseRDBNAM();
        if (this.database != null && this.database.dbName.equals(rdbnam)) {
            return;
        }
        Database d = this.session.getDatabase(rdbnam);
        if (d == null) {
            this.rdbnamMismatch(codePoint);
        } else {
            this.database = d;
        }
        this.session.database = d;
    }

    private void writeENDUOWRM(int opType) {
        this.writer.createDssReply();
        this.writer.startDdm(8716);
        this.writer.writeScalar2Bytes(4425, 4);
        this.writer.writeScalar1Byte(8469, opType);
        if (SanityManager.TraceClientHA | SanityManager.TraceSingleHop) {
            SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("DRDAConnThread:writeENDUOWRM gfxdClientVersion = " + this.gfxdClientVersion));
        }
        if (!(this.gfxdClientVersion == null || SEND_TX_ID_ON_COMMIT && this.startNewTransactionAndWriteNewTXID())) {
            this.writer.writeByte(0);
        }
        this.writer.endDdmAndDss();
    }

    private boolean startNewTransactionAndWriteNewTXID() {
        EngineConnection conn = this.database.getConnection();
        if (conn != null) {
            LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
            int isolationLevel = lcc.getCurrentIsolationLevel();
            GemFireTransaction gft = (GemFireTransaction)conn.getLanguageConnectionContext().getTransactionExecute();
            TXId txid = gft.getNewTXId(true);
            this.writer.writeByte(1);
            this.writer.writeLong(txid.getMemberId());
            this.writer.writeLong(txid.getUniqId());
            if (SanityManager.TraceClientHA | SanityManager.TraceSingleHop) {
                SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("DRDAConnThread:startNewTransactionAndWriteNewTXID new txid sent: " + txid));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeEXTDTA(DRDAStatement stmt) throws SQLException, DRDAProtocolException {
        ArrayList extdtaValues = stmt.getExtDtaObjects();
        if (extdtaValues == null) {
            return;
        }
        boolean writeNullByte = false;
        for (int i = 0; i < extdtaValues.size(); ++i) {
            Object o;
            boolean chainedWithSameCorrelator;
            boolean chainFlag;
            if (i != extdtaValues.size() - 1) {
                chainFlag = true;
                chainedWithSameCorrelator = true;
            } else {
                chainFlag = false;
                chainedWithSameCorrelator = false;
            }
            if (this.sqlamLevel >= 7 && stmt.isExtDtaValueNullable(i)) {
                writeNullByte = true;
            }
            if (!((o = extdtaValues.get(i)) instanceof EXTDTAInputStream)) continue;
            EXTDTAInputStream stream = (EXTDTAInputStream)o;
            try {
                stream.initInputStream();
                this.writer.writeScalarStream(chainedWithSameCorrelator, 5228, stream, writeNullByte);
                continue;
            }
            finally {
                DRDAConnThread.closeStream(stream);
            }
        }
        stmt.clearExtDtaObjects();
    }

    private void checkWarning(Connection conn, Statement stmt, ResultSet rs, int updateCount, boolean alwaysSend, boolean sendWarn) throws DRDAProtocolException, SQLException {
        this.checkWarning(conn, stmt, rs, updateCount, null, alwaysSend, sendWarn);
    }

    private void checkWarning(Connection conn, Statement stmt, ResultSet rs, int updateCount, int[] updateCounts, boolean alwaysSend, boolean sendWarn) throws DRDAProtocolException, SQLException {
        SQLWarning reportWarning;
        block13: {
            SQLWarning warning = null;
            reportWarning = null;
            try {
                if (stmt != null && (warning = stmt.getWarnings()) != null) {
                    stmt.clearWarnings();
                    reportWarning = warning;
                }
                if (rs != null && (warning = rs.getWarnings()) != null) {
                    rs.clearWarnings();
                    if (reportWarning == null) {
                        reportWarning = warning;
                    }
                }
                if (conn != null && (warning = conn.getWarnings()) != null) {
                    conn.clearWarnings();
                    if (reportWarning == null) {
                        reportWarning = warning;
                    }
                }
            }
            catch (SQLException se) {
                if (!this.trace) break block13;
                this.trace("got SQLException while trying to get warnings.");
            }
        }
        if ((alwaysSend || reportWarning != null) && sendWarn) {
            if (updateCounts == null) {
                this.writeSQLCARDs(reportWarning, updateCount);
            } else {
                int lastIdx = updateCounts.length - 1;
                if (lastIdx >= 0) {
                    OutputStream os = this.getOutputStream();
                    for (int index = 0; index < lastIdx; ++index) {
                        this.writeSQLCARDs(reportWarning, updateCounts[index]);
                        this.writer.finalizeChain((byte)64, os);
                    }
                    this.writeSQLCARDs(reportWarning, updateCounts[lastIdx]);
                    DRDAStatement curStmt = this.database.getCurrentStatement();
                    if (curStmt != null) {
                        curStmt.rsSuspend();
                    }
                    this.writePBSD();
                    this.writer.finalizeChain(this.reader.getCurrChainState(), os);
                }
            }
        }
    }

    boolean hasSession() {
        return this.session != null;
    }

    long getBytesRead() {
        return this.reader.totalByteCount;
    }

    long getBytesWritten() {
        return this.writer.totalByteCount;
    }

    protected String buildRuntimeInfo(String indent, LocalizedResource localLangUtil) {
        String s = "";
        if (!this.hasSession()) {
            return s;
        }
        s = s + this.session.buildRuntimeInfo("", localLangUtil);
        s = s + "\n";
        return s;
    }

    private void finalizeChain() throws DRDAProtocolException {
        LanguageConnectionContext lcc;
        EngineConnection econn;
        EngineConnection engineConnection = econn = this.database != null ? this.database.getConnection() : null;
        if (econn != null && (lcc = econn.getLanguageConnectionContext()) != null) {
            if (SanityManager.TraceSingleHop) {
                SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("DRDAConnThread::finalizeChain resetting bucketSet in lcc: " + lcc + " to null and send single hop info to false"));
            }
            lcc.setExecuteLocally(null, null, false, null);
            lcc.setSendSingleHopInformation(false);
        }
        this.writer.finalizeChain(this.reader.getCurrChainState(), this.getOutputStream());
    }

    private int validateSecMecUSRSSBPWD() throws DRDAProtocolException {
        String authClassName;
        String dbName = null;
        AuthenticationService authenticationService = null;
        com.pivotal.gemfirexd.internal.iapi.db.Database databaseObj = null;
        String srvrlslv = this.appRequester.srvrlslv;
        if (srvrlslv == null || srvrlslv.length() == 0 || srvrlslv.length() < 8 || srvrlslv.indexOf("DNC") == -1) {
            return 1;
        }
        this.appRequester.setClientVersion(srvrlslv.substring(0, 8));
        if (!this.appRequester.supportsSecMecUSRSSBPWD()) {
            return 1;
        }
        dbName = this.database.shortDbName;
        if (dbName == null || dbName.length() == 0) {
            authenticationService = ((InternalDriver)((Object)NetworkServerControlImpl.getDriver())).getAuthenticationService();
        } else {
            if (Monitor.getMonitor() != null) {
                databaseObj = (com.pivotal.gemfirexd.internal.iapi.db.Database)Monitor.findService("com.pivotal.gemfirexd.internal.database.Database", dbName);
            }
            if (databaseObj == null) {
                this.database.makeDummyConnection();
                databaseObj = (com.pivotal.gemfirexd.internal.iapi.db.Database)Monitor.findService("com.pivotal.gemfirexd.internal.database.Database", dbName);
            }
            try {
                if (databaseObj != null) {
                    authenticationService = databaseObj.getAuthenticationService();
                }
            }
            catch (StandardException se) {
                DRDAConnThread.println2Log(null, this.session.drdaID, se.getMessage());
                return 10;
            }
        }
        if (authenticationService != null && !(authClassName = authenticationService.getClass().getName()).equals(AUTHENTICATION_PROVIDER_BUILTIN_CLASS) && !authClassName.equals(AUTHENTICATION_PROVIDER_NONE_CLASS)) {
            return 1;
        }
        try {
            this.myTargetSeed = decryptionManager.generateSeed();
            this.database.secTokenOut = this.myTargetSeed;
        }
        catch (SQLException se) {
            DRDAConnThread.println2Log(null, this.session.drdaID, se.getMessage());
            return 10;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int peekStream(EXTDTAInputStream is) throws IOException {
        is.mark(1);
        try {
            int n = is.read();
            return n;
        }
        finally {
            is.reset();
        }
    }

    private static void closeStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            Util.javaException(e);
        }
    }

    private static ByteArrayInputStream convertAsByteArrayInputStream(EXTDTAReaderInputStream stream) throws IOException {
        int byteArrayLength = stream instanceof StandardEXTDTAReaderInputStream ? (int)((StandardEXTDTAReaderInputStream)stream).getLength() : 32;
        PublicBufferOutputStream pbos = new PublicBufferOutputStream(byteArrayLength);
        byte[] buffer = new byte[32768];
        int c = 0;
        while ((c = stream.read(buffer, 0, buffer.length)) > -1) {
            pbos.write(buffer, 0, c);
        }
        return new ByteArrayInputStream(pbos.getBuffer(), 0, pbos.getCount());
    }

    private static void setAsCharacterStream(DRDAStatement stmt, int i, boolean checkNullability, DDMReader reader, boolean streamLOB, String encoding) throws DRDAProtocolException, SQLException, IOException {
        PreparedStatement ps = stmt.getPreparedStatement();
        EXTDTAReaderInputStream extdtastream = reader.getEXTDTAReaderInputStream(checkNullability);
        if (streamLOB) {
            stmt.setStreamedParameter(extdtastream);
        }
        InputStream is = streamLOB ? extdtastream : DRDAConnThread.convertAsByteArrayInputStream(extdtastream);
        InputStreamReader streamReader = new InputStreamReader(is, encoding);
        ps.setCharacterStream(i + 1, streamReader);
    }

    private int checkPRDDTAForGFXDClientMagic(int prdlen) throws DRDAProtocolException {
        int lenOfMagic = ClientSharedData.BYTES_PREFIX_CLIENT_VERSION_LENGTH;
        if (prdlen < lenOfMagic) {
            return 0;
        }
        for (int i = 0; i < lenOfMagic; ++i) {
            byte b = this.reader.readByte();
            if (b == ClientSharedData.BYTES_PREFIX_CLIENT_VERSION[i]) continue;
            return i + 1;
        }
        return lenOfMagic;
    }

    public long getAndResetBytesRead() {
        return this.readAndResetAtomicLong(this.reader.bytesRead);
    }

    public long getAndResetBytesWritten() {
        return this.readAndResetAtomicLong(this.writer.bytesWritten);
    }

    public synchronized void getAndResetConnActivityStats(long[] stats) {
        assert (stats.length == 5) : "Atleast five statistics is to be returned.";
        stats[0] = this.beginWaitMillis;
        stats[1] = this.readAndResetAtomicLong(this.numTimesWaited);
        stats[2] = this.readAndResetAtomicLong(this.waitTime);
        stats[3] = this.readAndResetAtomicLong(this.numCmdsProcessed);
        stats[4] = this.readAndResetAtomicLong(this.processTime);
    }

    private long readAndResetAtomicLong(AtomicLong l) {
        long v;
        while (!l.compareAndSet(v = l.get(), 0L)) {
        }
        return v;
    }

    static {
        eod00000 = new byte[]{48, 48, 48, 48, 48};
        eod02000 = new byte[]{48, 50, 48, 48, 48};
        nullSQLState = new byte[]{32, 32, 32, 32, 32};
        errD4_D6 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        warn0_warnA = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        dummy = new DRDAProtocolExceptionInfo(0, 0, 0, false);
        SEND_TX_ID_ON_COMMIT = SystemProperties.getServerInstance().getBoolean("gemfirexd.send-tx-id-on-commit", false);
        ROLLBACK_IMPLEMENTED_FULLY = SystemProperties.getServerInstance().getBoolean("gemfirexd.rollback-implemented", false);
    }

    private static class PublicBufferOutputStream
    extends ByteArrayOutputStream {
        PublicBufferOutputStream(int size) {
            super(size);
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }
}

