/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.types.RowMultiSetImpl;
import com.pivotal.gemfirexd.internal.catalog.types.TypeDescriptorImpl;
import com.pivotal.gemfirexd.internal.catalog.types.UserDefinedTypeIdImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.JSON;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;
import java.text.RuleBasedCollator;

public final class DataTypeDescriptor
implements Formatable {
    public static final DataTypeDescriptor INTEGER = new DataTypeDescriptor(TypeId.INTEGER_ID, true);
    public static final DataTypeDescriptor INTEGER_NOT_NULL = INTEGER.getNullabilityType(false);
    public static final DataTypeDescriptor SMALLINT = new DataTypeDescriptor(TypeId.SMALLINT_ID, true);
    public static final DataTypeDescriptor SMALLINT_NOT_NULL = SMALLINT.getNullabilityType(false);
    private TypeDescriptorImpl typeDescriptor;
    private TypeId typeId;
    private int collationDerivation = 1;

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int jdbcType) {
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcType, true);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int jdbcType, int length) {
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcType, true, length);
    }

    public static DataTypeDescriptor getType(TypeDescriptor catalogType) {
        TypeDescriptorImpl typeDescriptor = (TypeDescriptorImpl)catalogType;
        TypeId typeId = TypeId.getTypeId(catalogType);
        DataTypeDescriptor dtd = new DataTypeDescriptor(typeDescriptor, typeId);
        dtd.collationDerivation = 1;
        return dtd;
    }

    public static TypeDescriptor getCatalogType(int jdbcType, int length) {
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcType, length).getCatalogType();
    }

    public static TypeDescriptor getCatalogType(int jdbcType) {
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcType).getCatalogType();
    }

    public static TypeDescriptor getCatalogType(TypeDescriptor catalogType, int collationType) {
        if (catalogType.isRowMultiSet()) {
            return DataTypeDescriptor.getRowMultiSetCollation(catalogType, collationType);
        }
        if (catalogType.getCollationType() == collationType) {
            return catalogType;
        }
        return DataTypeDescriptor.getType(catalogType).getCollatedType(collationType, 1).getCatalogType();
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int jdbcType, boolean isNullable) {
        switch (jdbcType) {
            case 4: {
                return isNullable ? INTEGER : INTEGER_NOT_NULL;
            }
            case 5: {
                return isNullable ? SMALLINT : SMALLINT_NOT_NULL;
            }
        }
        TypeId typeId = TypeId.getBuiltInTypeId(jdbcType);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, isNullable);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(int jdbcType, boolean isNullable, int maxLength) {
        TypeId typeId = TypeId.getBuiltInTypeId(jdbcType);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, isNullable, maxLength);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(String sqlTypeName) {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(sqlTypeName), true);
    }

    public static DataTypeDescriptor getBuiltInDataTypeDescriptor(String sqlTypeName, int length) {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(sqlTypeName), true, length);
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String javaTypeName) throws StandardException {
        return DataTypeDescriptor.getSQLDataTypeDescriptor(javaTypeName, true);
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String javaTypeName, boolean isNullable) throws StandardException {
        TypeId typeId = TypeId.getSQLTypeForJavaType(javaTypeName);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, isNullable);
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String javaTypeName, Object typeParam, boolean isNullable) throws StandardException {
        TypeId typeId = TypeId.getSQLTypeForJavaType(javaTypeName, typeParam);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, isNullable);
    }

    public int getDVDTypeFormatId() {
        switch (this.typeId.getTypeFormatId()) {
            case 27: {
                return 87;
            }
            case 4: {
                return 77;
            }
            case 5: {
                return 78;
            }
            case 197: {
                return 200;
            }
            case 6: {
                return 79;
            }
            case 7: {
                return 80;
            }
            case 11: {
                return 84;
            }
            case 232: {
                return 234;
            }
            case 440: {
                return 443;
            }
            case 444: {
                return 447;
            }
            case 475: {
                return 478;
            }
            case 230: {
                return 235;
            }
            case 8: {
                return 81;
            }
            case 9: {
                return 82;
            }
            case 10: {
                return 83;
            }
            case 195: {
                return 199;
            }
            case 40: {
                return 298;
            }
            case 35: {
                return 299;
            }
            case 36: {
                return 31;
            }
            case 267: {
                return 266;
            }
            case 29: {
                return 88;
            }
            case 13: {
                return 85;
            }
            case 456: {
                return 464;
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in getDVDTypeFormatId() " + this.typeId.getTypeFormatId()));
        return -1;
    }

    public static DataTypeDescriptor getSQLDataTypeDescriptor(String javaTypeName, int precision, int scale, boolean isNullable, int maximumWidth) throws StandardException {
        TypeId typeId = TypeId.getSQLTypeForJavaType(javaTypeName);
        if (typeId == null) {
            return null;
        }
        return new DataTypeDescriptor(typeId, precision, scale, isNullable, maximumWidth);
    }

    public static TypeDescriptor getRowMultiSet(String[] columnNames, TypeDescriptor[] catalogTypes) {
        RowMultiSetImpl rms = new RowMultiSetImpl(columnNames, catalogTypes);
        return new TypeDescriptorImpl(rms, true, -1);
    }

    public DataTypeDescriptor() {
    }

    public DataTypeDescriptor(TypeId typeId, int precision, int scale, boolean isNullable, int maximumWidth) {
        this.typeId = typeId;
        this.typeDescriptor = new TypeDescriptorImpl(typeId.getBaseTypeId(), precision, scale, isNullable, maximumWidth);
    }

    public DataTypeDescriptor(TypeId typeId, int precision, int scale, boolean isNullable, int maximumWidth, int collationType, int collationDerivation) {
        this.typeId = typeId;
        this.typeDescriptor = new TypeDescriptorImpl(typeId.getBaseTypeId(), precision, scale, isNullable, maximumWidth, collationType);
        this.collationDerivation = collationDerivation;
    }

    public DataTypeDescriptor(TypeId typeId, boolean isNullable, int maximumWidth) {
        this.typeId = typeId;
        this.typeDescriptor = new TypeDescriptorImpl(typeId.getBaseTypeId(), isNullable, maximumWidth);
    }

    public DataTypeDescriptor(TypeId typeId, boolean isNullable) {
        this.typeId = typeId;
        this.typeDescriptor = new TypeDescriptorImpl(typeId.getBaseTypeId(), typeId.getMaximumPrecision(), typeId.getMaximumScale(), isNullable, typeId.getMaximumMaximumWidth());
    }

    private DataTypeDescriptor(DataTypeDescriptor source, boolean isNullable) {
        this.typeId = source.typeId;
        this.typeDescriptor = new TypeDescriptorImpl(source.typeDescriptor, source.getPrecision(), source.getScale(), isNullable, source.getMaximumWidth(), source.getCollationType());
        this.collationDerivation = source.getCollationDerivation();
    }

    private DataTypeDescriptor(DataTypeDescriptor source, int collationType, int collationDerivation) {
        this.typeId = source.typeId;
        this.typeDescriptor = new TypeDescriptorImpl(source.typeDescriptor, source.getPrecision(), source.getScale(), source.isNullable(), source.getMaximumWidth(), collationType);
        this.collationDerivation = collationDerivation;
    }

    public DataTypeDescriptor(DataTypeDescriptor source, int precision, int scale, boolean isNullable, int maximumWidth) {
        this.typeId = source.typeId;
        this.typeDescriptor = new TypeDescriptorImpl(source.typeDescriptor, precision, scale, isNullable, maximumWidth, source.getCollationType());
        this.collationDerivation = source.getCollationDerivation();
    }

    public DataTypeDescriptor(DataTypeDescriptor source, boolean isNullable, int maximumWidth) {
        this.typeId = source.typeId;
        this.typeDescriptor = new TypeDescriptorImpl(source.typeDescriptor, source.getPrecision(), source.getScale(), isNullable, maximumWidth, source.getCollationType());
        this.collationDerivation = source.getCollationDerivation();
    }

    private DataTypeDescriptor(TypeDescriptorImpl source, TypeId typeId) {
        this.typeDescriptor = source;
        this.typeId = typeId;
    }

    public DataValueDescriptor normalize(DataValueDescriptor source, DataValueDescriptor cachedDest) throws StandardException {
        String t2;
        String t1;
        if (!(cachedDest == null || this.getTypeId().isUserDefinedTypeId() || (t1 = this.getTypeName()).equals(t2 = cachedDest.getTypeName()) || (t1.equals("DECIMAL") || t1.equals("NUMERIC")) && (t2.equals("DECIMAL") || t2.equals("NUMERIC")) || t1.startsWith("INT") && t2.startsWith("INT"))) {
            SanityManager.THROWASSERT((String)("Normalization of " + t2 + " being asked to convert to " + t1));
        }
        if (source.isNull()) {
            if (!this.isNullable()) {
                throw StandardException.newException("23502", "");
            }
            if (cachedDest == null) {
                cachedDest = this.getNull();
            } else {
                cachedDest.setToNull();
            }
        } else {
            if (cachedDest == null) {
                cachedDest = this.getNull();
            }
            int jdbcId = this.getJDBCTypeId();
            cachedDest.normalize(this, source);
            if ((jdbcId == -1 || jdbcId == -4) && source.getClass() == cachedDest.getClass()) {
                return source;
            }
        }
        return cachedDest;
    }

    public DataTypeDescriptor getDominantType(DataTypeDescriptor otherDTS, ClassFactory cf) throws StandardException {
        DataTypeDescriptor higherType;
        int maximumWidth;
        DataTypeDescriptor lowerType = null;
        int precision = this.getPrecision();
        int scale = this.getScale();
        TypeId thisType = this.getTypeId();
        TypeId otherType = otherDTS.getTypeId();
        boolean nullable = this.isNullable() || otherDTS.isNullable();
        int n = maximumWidth = this.getMaximumWidth() > otherDTS.getMaximumWidth() ? this.getMaximumWidth() : otherDTS.getMaximumWidth();
        if (!thisType.userType() && !otherType.userType()) {
            TypeId lowerTypeId;
            TypeId higherTypeId;
            if (thisType.typePrecedence() > otherType.typePrecedence()) {
                higherType = this;
                lowerType = otherDTS;
                higherTypeId = thisType;
                lowerTypeId = otherType;
            } else {
                higherType = otherDTS;
                lowerType = this;
                higherTypeId = otherType;
                lowerTypeId = thisType;
            }
            if (higherTypeId.isRealTypeId() && !lowerTypeId.isRealTypeId() && lowerTypeId.isNumericTypeId()) {
                higherType = DataTypeDescriptor.getBuiltInDataTypeDescriptor(8);
                higherTypeId = TypeId.getBuiltInTypeId(8);
            }
            if (higherTypeId.isDecimalTypeId() && !lowerTypeId.isStringTypeId()) {
                precision = higherTypeId.getPrecision(this, otherDTS);
                if (precision > 127) {
                    precision = 127;
                }
                maximumWidth = (scale = higherTypeId.getScale(this, otherDTS)) > 0 ? precision + 3 : precision + 1;
            } else if (thisType.typePrecedence() != otherType.typePrecedence()) {
                int charMaxWidth;
                precision = higherType.getPrecision();
                scale = higherType.getScale();
                if (lowerTypeId.isStringTypeId() && higherTypeId.isBitTypeId() && !higherTypeId.isLongConcatableTypeId()) {
                    if (lowerTypeId.isLongConcatableTypeId()) {
                        maximumWidth = maximumWidth > 0x7FFFFFF ? Integer.MAX_VALUE : (maximumWidth *= 16);
                    } else {
                        int fromWidth = lowerType.getMaximumWidth();
                        charMaxWidth = fromWidth > 0x7FFFFFF ? Integer.MAX_VALUE : 16 * fromWidth;
                        int n2 = maximumWidth = maximumWidth >= charMaxWidth ? maximumWidth : charMaxWidth;
                    }
                }
                if (lowerTypeId.isStringTypeId() && !lowerTypeId.isLongConcatableTypeId() && higherTypeId.isDecimalTypeId()) {
                    charMaxWidth = lowerType.getMaximumWidth();
                    int charPrecision = charMaxWidth > 0x3FFFFFFE ? 0x7FFFFFFC : charMaxWidth * 2;
                    if (precision < charPrecision) {
                        precision = charPrecision;
                    }
                    if (scale < charMaxWidth) {
                        scale = charMaxWidth;
                    }
                    maximumWidth = precision + 3;
                }
            }
        } else {
            ClassInspector cu = cf.getClassInspector();
            TypeId thisCompType = thisType;
            TypeId otherCompType = otherType;
            higherType = cu.assignableTo(thisCompType.getCorrespondingJavaTypeName(), otherCompType.getCorrespondingJavaTypeName()) ? otherDTS : this;
            precision = higherType.getPrecision();
            scale = higherType.getScale();
        }
        higherType = new DataTypeDescriptor(higherType, precision, scale, nullable, maximumWidth);
        if (higherType.getTypeId().isStringTypeId()) {
            higherType = this.getCollationDerivation() != otherDTS.getCollationDerivation() ? (this.getCollationDerivation() == 0 ? higherType.getCollatedType(otherDTS.getCollationType(), otherDTS.getCollationDerivation()) : (otherDTS.getCollationDerivation() == 0 ? higherType.getCollatedType(this.getCollationType(), this.getCollationDerivation()) : higherType.getCollatedType(0, 0))) : (this.getCollationType() != otherDTS.getCollationType() ? higherType.getCollatedType(0, 0) : higherType.getCollatedType(this.getCollationType(), this.getCollationDerivation()));
        }
        return higherType;
    }

    public boolean isExactTypeAndLengthMatch(DataTypeDescriptor otherDTS) {
        TypeId otherType;
        if (this.getMaximumWidth() != otherDTS.getMaximumWidth()) {
            return false;
        }
        if (this.getScale() != otherDTS.getScale()) {
            return false;
        }
        if (this.getPrecision() != otherDTS.getPrecision()) {
            return false;
        }
        TypeId thisType = this.getTypeId();
        return thisType.equals(otherType = otherDTS.getTypeId());
    }

    public int getMaximumWidth() {
        return this.typeDescriptor.getMaximumWidth();
    }

    public TypeId getTypeId() {
        return this.typeId;
    }

    public DataValueDescriptor getNull() throws StandardException {
        DataValueDescriptor returnDVD = this.typeId.getNull();
        if (this.typeDescriptor.getCollationType() == 0 || returnDVD instanceof JSON) {
            return returnDVD;
        }
        if (returnDVD instanceof StringDataValue) {
            try {
                RuleBasedCollator rbs = ConnectionUtil.getCurrentLCC().getDataValueFactory().getCharacterCollator(this.typeDescriptor.getCollationType());
                return ((StringDataValue)returnDVD).getValue(rbs);
            }
            catch (SQLException sqle) {
                throw StandardException.plainWrapException(sqle);
            }
        }
        return returnDVD;
    }

    public String getTypeName() {
        return this.typeDescriptor.getTypeName();
    }

    public int getJDBCTypeId() {
        return this.typeDescriptor.getJDBCTypeId();
    }

    public int getPrecision() {
        return this.typeDescriptor.getPrecision();
    }

    public int getScale() {
        return this.typeDescriptor.getScale();
    }

    public int getCollationType() {
        return this.typeDescriptor.getCollationType();
    }

    public static int getCollationType(String collationName) {
        if (collationName.equalsIgnoreCase("UCS_BASIC")) {
            return 0;
        }
        if (collationName.equalsIgnoreCase("TERRITORY_BASED")) {
            return 1;
        }
        if (collationName.equalsIgnoreCase("TERRITORY_BASED:PRIMARY")) {
            return 2;
        }
        if (collationName.equalsIgnoreCase("TERRITORY_BASED:SECONDARY")) {
            return 3;
        }
        if (collationName.equalsIgnoreCase("TERRITORY_BASED:TERTIARY")) {
            return 4;
        }
        if (collationName.equalsIgnoreCase("TERRITORY_BASED:IDENTICAL")) {
            return 5;
        }
        return -1;
    }

    public String getCollationName() {
        if (this.getCollationDerivation() == 0) {
            return "NONE";
        }
        return DataTypeDescriptor.getCollationName(this.getCollationType());
    }

    public static String getCollationName(int collationType) {
        switch (collationType) {
            case 1: {
                return "TERRITORY_BASED";
            }
            case 2: {
                return "TERRITORY_BASED:PRIMARY";
            }
            case 3: {
                return "TERRITORY_BASED:SECONDARY";
            }
            case 4: {
                return "TERRITORY_BASED:TERTIARY";
            }
            case 5: {
                return "TERRITORY_BASED:IDENTICAL";
            }
        }
        return "UCS_BASIC";
    }

    public int getCollationDerivation() {
        return this.collationDerivation;
    }

    public boolean isNullable() {
        return this.typeDescriptor.isNullable();
    }

    public DataTypeDescriptor getNullabilityType(boolean isNullable) {
        if (this.isNullable() == isNullable) {
            return this;
        }
        return new DataTypeDescriptor(this, isNullable);
    }

    public DataTypeDescriptor getCollatedType(int collationType, int collationDerivation) {
        if (!this.typeDescriptor.isStringType()) {
            return this;
        }
        if (this.getCollationType() == collationType && this.getCollationDerivation() == collationDerivation) {
            return this;
        }
        return new DataTypeDescriptor(this, collationType, collationDerivation);
    }

    private static TypeDescriptor getRowMultiSetCollation(TypeDescriptor catalogType, int collationType) {
        TypeDescriptor[] rowTypes = catalogType.getRowTypes();
        TypeDescriptor[] newTypes = null;
        for (int t = 0; t < rowTypes.length; ++t) {
            TypeDescriptor newType = DataTypeDescriptor.getCatalogType(rowTypes[t], collationType);
            if (newType == rowTypes[t]) continue;
            if (newTypes == null) {
                newTypes = new TypeDescriptor[rowTypes.length];
                System.arraycopy(rowTypes, 0, newTypes, 0, rowTypes.length);
            }
            newTypes[t] = newType;
        }
        if (newTypes == null) {
            return catalogType;
        }
        return DataTypeDescriptor.getRowMultiSet(catalogType.getRowColumnNames(), newTypes);
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataTypeDescriptor)) {
            return false;
        }
        DataTypeDescriptor odtd = (DataTypeDescriptor)other;
        return this.typeDescriptor.equals(odtd.typeDescriptor) && this.collationDerivation == odtd.collationDerivation;
    }

    public int hashCode() {
        return this.typeDescriptor.hashCode();
    }

    public boolean comparable(DataTypeDescriptor compareWithDTD, boolean forEquals, ClassFactory cf) {
        Object classParam;
        TypeId compareWithTypeID = compareWithDTD.getTypeId();
        int compareWithJDBCTypeId = compareWithTypeID.getJDBCTypeId();
        if (!compareWithTypeID.isStringTypeId() && compareWithTypeID.isLongConcatableTypeId() || !this.typeId.isStringTypeId() && this.typeId.isLongConcatableTypeId()) {
            return false;
        }
        if (this.typeId.isRefTypeId() || compareWithTypeID.isRefTypeId()) {
            return false;
        }
        if (this.typeId.isUserDefinedTypeId() && (classParam = ((UserDefinedTypeIdImpl)this.typeId.getBaseTypeId()).getClassParam()) != null && classParam instanceof DataTypeDescriptor) {
            DataTypeDescriptor dtd = (DataTypeDescriptor)classParam;
            return dtd.comparable(compareWithDTD, forEquals, cf);
        }
        if (!this.typeId.isUserDefinedTypeId() && compareWithTypeID.isUserDefinedTypeId()) {
            return compareWithDTD.comparable(this, forEquals, cf);
        }
        if (this.typeId.isNumericTypeId()) {
            return compareWithTypeID.isNumericTypeId() || compareWithTypeID.isBooleanTypeId();
        }
        if (this.typeId.isStringTypeId()) {
            if (compareWithTypeID.isDateTimeTimeStampTypeID() || compareWithTypeID.isBooleanTypeId()) {
                return true;
            }
            if (compareWithTypeID.isStringTypeId()) {
                return this.compareCollationInfo(compareWithDTD);
            }
            return false;
        }
        if (this.typeId.isBitTypeId()) {
            return compareWithTypeID.isBitTypeId();
        }
        if (this.typeId.isBooleanTypeId()) {
            return compareWithTypeID.getSQLTypeName().equals(this.typeId.getSQLTypeName()) || compareWithTypeID.isStringTypeId() || compareWithTypeID.isNumericTypeId();
        }
        if (this.typeId.getJDBCTypeId() == 91) {
            return compareWithJDBCTypeId == 91 || compareWithTypeID.isStringTypeId();
        }
        if (this.typeId.getJDBCTypeId() == 92) {
            return compareWithJDBCTypeId == 92 || compareWithTypeID.isStringTypeId();
        }
        if (this.typeId.getJDBCTypeId() == 93) {
            return compareWithJDBCTypeId == 93 || compareWithTypeID.isStringTypeId();
        }
        if (this.typeId.isUserDefinedTypeId() || this.typeId.getJDBCTypeId() == 1111) {
            return forEquals;
        }
        return false;
    }

    public boolean compareCollationInfo(DataTypeDescriptor compareWithDTD) {
        if (this.getCollationDerivation() == compareWithDTD.getCollationDerivation() && this.getCollationDerivation() == 0) {
            return false;
        }
        return this.getCollationDerivation() == compareWithDTD.getCollationDerivation() && this.getCollationType() == compareWithDTD.getCollationType();
    }

    public String getSQLstring() {
        return this.typeId.toParsableString(this);
    }

    public TypeDescriptor getCatalogType() {
        return this.typeDescriptor;
    }

    public double estimatedMemoryUsage() {
        switch (this.typeId.getTypeFormatId()) {
            case 232: {
                return 10000.0;
            }
            case 27: {
                return (double)this.getMaximumWidth() / 8.0 + 0.5;
            }
            case 4: {
                return 4.0;
            }
            case 5: 
            case 13: {
                return 2.0 * (double)this.getMaximumWidth();
            }
            case 230: {
                return 10000.0;
            }
            case 197: {
                return (double)this.getPrecision() * 0.415 + 1.5;
            }
            case 6: {
                return 8.0;
            }
            case 7: {
                return 4.0;
            }
            case 11: {
                return 8.0;
            }
            case 8: {
                return 4.0;
            }
            case 10: {
                return 2.0;
            }
            case 195: {
                return 1.0;
            }
            case 9: {
                return 12.0;
            }
            case 267: {
                if (this.typeId.userType()) {
                    return 256.0;
                }
            }
            case 35: 
            case 36: 
            case 40: {
                return 12.0;
            }
        }
        return 0.0;
    }

    public static boolean isJDBCTypeEquivalent(int existingType, int jdbcTypeId) {
        if (existingType == jdbcTypeId) {
            return true;
        }
        if (DataTypeDescriptor.isNumericType(existingType)) {
            if (DataTypeDescriptor.isNumericType(jdbcTypeId)) {
                return true;
            }
            return DataTypeDescriptor.isCharacterType(jdbcTypeId);
        }
        if (DataTypeDescriptor.isCharacterType(existingType)) {
            if (DataTypeDescriptor.isCharacterType(jdbcTypeId)) {
                return true;
            }
            if (DataTypeDescriptor.isNumericType(jdbcTypeId)) {
                return true;
            }
            switch (jdbcTypeId) {
                case 91: 
                case 92: 
                case 93: {
                    return true;
                }
            }
            return false;
        }
        if (DataTypeDescriptor.isBinaryType(existingType)) {
            return DataTypeDescriptor.isBinaryType(jdbcTypeId);
        }
        if (existingType == 91 || existingType == 92) {
            if (DataTypeDescriptor.isCharacterType(jdbcTypeId)) {
                return true;
            }
            return jdbcTypeId == 93;
        }
        if (existingType == 93) {
            if (DataTypeDescriptor.isCharacterType(jdbcTypeId)) {
                return true;
            }
            return jdbcTypeId == 91;
        }
        return existingType == 2005 && DataTypeDescriptor.isCharacterType(jdbcTypeId);
    }

    public static boolean isNumericType(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private static boolean isCharacterType(int jdbcType) {
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static boolean isBinaryType(int jdbcType) {
        switch (jdbcType) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAsciiStreamAssignable(int jdbcType) {
        return jdbcType == 2005 || DataTypeDescriptor.isCharacterType(jdbcType) || jdbcType == 4002;
    }

    public static boolean isBinaryStreamAssignable(int jdbcType) {
        return jdbcType == 2004 || DataTypeDescriptor.isBinaryType(jdbcType);
    }

    public static boolean isCharacterStreamAssignable(int jdbcType) {
        return DataTypeDescriptor.isAsciiStreamAssignable(jdbcType);
    }

    public String toString() {
        return this.typeDescriptor.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.typeDescriptor = (TypeDescriptorImpl)in.readObject();
        this.typeId = TypeId.getBuiltInTypeId(this.getTypeName());
        this.collationDerivation = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.typeDescriptor);
        out.writeInt(this.getCollationDerivation());
    }

    @Override
    public int getTypeFormatId() {
        return 240;
    }

    public boolean isUserCreatableType() throws StandardException {
        switch (this.typeId.getJDBCTypeId()) {
            case 16: {
                return false;
            }
            case 2000: {
                return this.getTypeId().getBaseTypeId().isAnsiUDT();
            }
            case 3: {
                return this.getPrecision() <= this.typeId.getMaximumPrecision() && this.getScale() <= this.typeId.getMaximumScale();
            }
        }
        return true;
    }

    public String getFullSQLTypeName() {
        StringBuilder sbuf = new StringBuilder(this.typeId.getSQLTypeName());
        if (this.typeId.isDecimalTypeId() || this.typeId.isNumericTypeId()) {
            sbuf.append("(");
            sbuf.append(this.getPrecision());
            sbuf.append(", ");
            sbuf.append(this.getScale());
            sbuf.append(")");
        } else if (this.typeId.variableLength()) {
            sbuf.append("(");
            sbuf.append(this.getMaximumWidth());
            sbuf.append(")");
        }
        return sbuf.toString();
    }

    public String getSQLTypeNameWithCollation() {
        String name = this.typeId.getSQLTypeName();
        if (this.typeId.isStringTypeId()) {
            name = name + " (" + this.getCollationName() + ")";
        }
        return name;
    }

    public final void assertTypeEquivalent(DataValueDescriptor dvd, int colIdx) {
        this.typeId.assertTypeEquivalent(dvd, colIdx);
    }
}

