/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.ManagementConstants;
import com.pivotal.gemfirexd.internal.GemFireXDVersion;
import com.pivotal.gemfirexd.internal.engine.management.GfxdMemberMXBean;
import com.pivotal.gemfirexd.internal.engine.management.TableMXBean;
import java.text.MessageFormat;
import javax.management.ObjectName;

public abstract class ManagementUtils
implements ManagementConstants {
    public static final String DEFAULT_SERVER_GROUP = "DEFAULT";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int DEFAULT_MBEAN_UPDATE_RATE_MILLIS = 5000;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String NA = "NA";
    public static final GfxdMemberMXBean.GfxdMemberMetaData MEMBER_METADATA_NA = new GfxdMemberMXBean.GfxdMemberMetaData("NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA");
    public static final TableMXBean.TableMetadata TABLE_METADATA_NA = new TableMXBean.TableMetadata("NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA");
    public static final String PRODUCT_NAME = GemFireXDVersion.getProductName();

    private static String makeServerGroupCompliant(String groupName) {
        return ManagementUtils.makeCompliantName(ManagementUtils.quoteIfNeeded(groupName.toUpperCase()));
    }

    public static ObjectName getMemberMBeanName(String memberNameOrId, String groupName) {
        return MBeanJMXAdapter.getObjectName((String)ManagementUtils.format("GemFireXD:group={0},type=Member,member={1}", ManagementUtils.makeServerGroupCompliant(groupName), ManagementUtils.makeCompliantName(ManagementUtils.quoteIfNeeded(memberNameOrId))));
    }

    public static ObjectName getMemberMBeanNamePattern(String memberNameOrId) {
        return MBeanJMXAdapter.getObjectName((String)ManagementUtils.format("GemFireXD:group={0},type=Member,member={1}", "*", ManagementUtils.makeCompliantName(ManagementUtils.quoteIfNeeded(memberNameOrId))));
    }

    public static ObjectName getTableMBeanName(String groupName, String memberNameOrId, String tableName) {
        return MBeanJMXAdapter.getObjectName((String)ManagementUtils.format("GemFireXD:group={0},service=Table,type=Member,member={1},table={2}", ManagementUtils.makeServerGroupCompliant(groupName), ManagementUtils.makeCompliantName(ManagementUtils.quoteIfNeeded(memberNameOrId)), ManagementUtils.makeCompliantName(ManagementUtils.quoteIfNeeded(tableName))));
    }

    public static ObjectName getTableMBeanGroupPattern(String memberNameOrId, String tableName) {
        return MBeanJMXAdapter.getObjectName((String)ManagementUtils.format("GemFireXD:group={0},service=Table,type=Member,member={1},table={2}", "*", ManagementUtils.makeCompliantName(ManagementUtils.quoteIfNeeded(memberNameOrId)), ManagementUtils.makeCompliantName(ManagementUtils.quoteIfNeeded(tableName))));
    }

    public static ObjectName getGfxdMBeanPattern() {
        return MBeanJMXAdapter.getObjectName((String)"GemFireXD:*");
    }

    public static ObjectName getStatementMBeanName(String memberNameOrId, String executeStatementNameAndSchema) {
        String name = ManagementUtils.quoteIfNeeded(ManagementUtils.makeCompliantName(executeStatementNameAndSchema));
        return MBeanJMXAdapter.getObjectName((String)ManagementUtils.format("GemFireXD:service=Statement,type=Member,member={0},name={1}", ManagementUtils.makeCompliantName(ManagementUtils.quoteIfNeeded(memberNameOrId)), name));
    }

    public static ObjectName getAggregateStatementMBeanName(String name) {
        String compliantName = ManagementUtils.quoteIfNeeded(ManagementUtils.makeCompliantName(name));
        return MBeanJMXAdapter.getObjectName((String)ManagementUtils.format("GemFireXD:service=Statement,type=Aggregate,name={0}", new Object[]{compliantName}));
    }

    public static ObjectName getAggrgateTableMBeanName(String fullPath) {
        return MBeanJMXAdapter.getObjectName((String)ManagementUtils.format("GemFireXD:service=Table,type=Aggregate,table={0}", new Object[]{fullPath}));
    }

    public static ObjectName getClusterMBeanName() {
        return MBeanJMXAdapter.getObjectName((String)"GemFireXD:service=Cluster");
    }

    private static String makeCompliantName(String value) {
        return MBeanJMXAdapter.makeCompliantName((String)value);
    }

    private static String quoteIfNeeded(String stringToCheck) {
        return stringToCheck != null && stringToCheck.indexOf(34) != -1 ? ObjectName.quote(stringToCheck) : stringToCheck;
    }

    public static String format(String pattern, Object argument) {
        return ManagementUtils.format(pattern, new Object[]{argument});
    }

    public static String format(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }
}

