/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.utils;

import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;

public final class DataTypeUtils {
    public static int serializeBigIntMagnitudeToBytes(int[] magnitude, byte[] outBytes, int startPos) {
        int size_1 = magnitude.length - 1;
        if (size_1 >= 0) {
            int numBytes;
            long firstInt = (long)magnitude[0] & 0xFFFFFFFFL;
            int numBytesInFirstInt = ResolverUtils.numBytesWithoutZeros((long)firstInt);
            int offset = startPos;
            while (numBytesInFirstInt-- > 0) {
                outBytes[offset++] = (byte)(firstInt >>> 8 * numBytesInFirstInt);
            }
            for (int index = 1; index <= size_1; ++index) {
                int intValue = magnitude[index];
                outBytes[offset++] = (byte)(intValue >>> 24);
                outBytes[offset++] = (byte)(intValue >>> 16);
                outBytes[offset++] = (byte)(intValue >>> 8);
                outBytes[offset++] = (byte)intValue;
            }
            assert (offset - startPos == (numBytes = (size_1 << 2) + ResolverUtils.numBytesWithoutZeros((long)firstInt))) : "unexpected mismatch of byte length, expected=" + numBytes + " actual=" + (offset - startPos);
            return offset - startPos;
        }
        return 0;
    }
}

