/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.resolver;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.expression.ExpressionCompiler;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.SingleHopInformation;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public final class GfxdPartitionByExpressionResolver
extends GfxdPartitionResolver {
    private final ExpressionCompiler exprCompiler;
    private int[] columnPositionsInRow;
    private int[] columnPositionsInKey;
    private boolean isSubSetOfPrimary;
    private boolean requiresSerializedHash;
    private boolean customHashing;
    private String[] partColsOrigOrder;
    private final Map<String, Integer> columnToIndexMap = new HashMap<String, Integer>();
    private boolean defaultPartitioning;
    private String toStringString;
    private int[] typeFormatIdArray;
    private boolean snappyStore = Misc.getMemStore().isSnappyStore();

    public GfxdPartitionByExpressionResolver() {
        this.defaultPartitioning = true;
        this.exprCompiler = null;
    }

    public GfxdPartitionByExpressionResolver(ValueNode node) {
        if (node instanceof ColumnReference) {
            String columnName = node.getColumnName();
            this.partColsOrigOrder = new String[1];
            this.partColsOrigOrder[0] = columnName;
            this.columnToIndexMap.put(columnName, 0);
            this.partitionColumnNames = (String[])this.partColsOrigOrder.clone();
            this.exprCompiler = null;
        } else {
            this.exprCompiler = new ExpressionCompiler(node, this.columnToIndexMap, "PARTITION BY");
        }
    }

    public GfxdPartitionByExpressionResolver(Object[] columns) {
        this.partColsOrigOrder = new String[columns.length];
        for (int index = 0; index < columns.length; ++index) {
            String columnName;
            this.partColsOrigOrder[index] = columnName = ((ColumnReference)columns[index]).getColumnName();
            this.columnToIndexMap.put(columnName, index);
        }
        this.partitionColumnNames = (String[])this.partColsOrigOrder.clone();
        this.exprCompiler = null;
    }

    private GfxdPartitionByExpressionResolver(ExpressionCompiler compiler) {
        this.exprCompiler = compiler;
    }

    @Override
    public void setDistributionDescriptor(DistributionDescriptor desc) {
        String[] descCols = desc.getPartitionColumnNames();
        if (descCols != null) {
            this.partColsOrigOrder = (String[])descCols.clone();
            this.partitionColumnNames = (String[])this.partColsOrigOrder.clone();
            this.isPrimaryKeyPartitioningKey = false;
        } else if (this.partColsOrigOrder != null && this.partColsOrigOrder.length > 0 && desc.getPolicy() != 3) {
            desc.setPartitionColumnNames(this.partColsOrigOrder);
        }
        this.distributionDesc = desc;
    }

    @Override
    public void bindExpression(FromList fromList, SubqueryList subqueryList, Vector<?> aggregateVector) throws StandardException {
        if (this.exprCompiler != null) {
            this.partColsOrigOrder = this.exprCompiler.bindExpression(fromList, subqueryList, aggregateVector);
            this.partitionColumnNames = (String[])this.partColsOrigOrder.clone();
        }
        this.toStringString = this.makeToStringString();
    }

    private String makeToStringString() {
        StringBuilder sb = new StringBuilder("GfxdPartitionByExpressionResolver@").append(Integer.toHexString(System.identityHashCode(this))).append('(').append(this.getQualifiedTableName()).append("): columnNames=").append(Arrays.toString(this.partitionColumnNames)).append(" isPrimaryKeyPartitionKey=").append(this.isPrimaryKeyPartitioningKey).append(" isSubSetOfPrimary=").append(this.isSubSetOfPrimary).append(" defaultPartitioning=").append(this.defaultPartitioning).append(" globalIndexRegion=").append(this.globalIndexContainer).append(" requiresSerializedHash=").append(this.requiresSerializedHash);
        if (this.exprCompiler != null) {
            sb.append(" expression=").append(this.exprCompiler.getCanonicalizedExpression());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toStringString;
    }

    @Override
    public String getDDLString() {
        if (this.exprCompiler != null) {
            return "PARTITION BY (" + this.exprCompiler.getCanonicalizedExpression() + ')';
        }
        if (this.isPrimaryKeyPartitioningKey) {
            return "PARTITION BY PRIMARY KEY";
        }
        return "PARTITION BY COLUMN (" + GemFireXDUtils.toCSV(this.partitionColumnNames) + ')';
    }

    public void setPartitionByPrimaryKey() {
        this.isPrimaryKeyPartitioningKey = true;
        this.isSubSetOfPrimary = true;
        this.columnPositionsInKey = null;
        this.defaultPartitioning = false;
    }

    public boolean isDefaultPartitioning() {
        return this.defaultPartitioning;
    }

    private boolean checkColumnsCompletelyPartOfPrimary(Map<String, Integer> pkMap) {
        this.isPrimaryKeyPartitioningKey = false;
        this.isSubSetOfPrimary = ExpressionCompiler.checkColumnsPartOfPrimaryKey(pkMap, this.partColsOrigOrder);
        if (this.isSubSetOfPrimary) {
            this.isPrimaryKeyPartitioningKey = pkMap.size() == this.partColsOrigOrder.length;
            return true;
        }
        return false;
    }

    public void setCustomHashing(boolean input) {
        this.customHashing = input;
    }

    private void setPrimaryColumnNames(Collection<String> pkColumnNames) {
        assert (pkColumnNames != null && pkColumnNames.size() > 0);
        int cnt = 0;
        this.partColsOrigOrder = new String[pkColumnNames.size()];
        Iterator<String> i$ = pkColumnNames.iterator();
        while (i$.hasNext()) {
            String pkColumnName;
            this.partColsOrigOrder[cnt] = pkColumnName = i$.next();
            this.columnToIndexMap.put(pkColumnName, cnt);
            ++cnt;
        }
        this.partitionColumnNames = (String[])this.partColsOrigOrder.clone();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setColumnInfo(TableDescriptor td, Activation activation) throws StandardException {
        Map<String, Integer> pkMap;
        LanguageConnectionContext lcc;
        DistributionDescriptor distDescp;
        block28: {
            if (td == null) {
                throw new AssertionError((Object)"GfxdPartitionByExpressionResolver: td cannot be null");
            }
            distDescp = td.getDistributionDescriptor();
            lcc = activation.getLanguageConnectionContext();
            pkMap = GemFireXDUtils.getPrimaryKeyColumnNamesToIndexMap(td, lcc);
            if (this.defaultPartitioning) {
                if (distDescp.getPolicy() == 3) {
                    this.partColsOrigOrder = new String[0];
                    this.partitionColumnNames = new String[0];
                    this.distributionDesc = distDescp;
                    if (pkMap != null && pkMap.size() > 0) {
                        this.setPartitionByPrimaryKey();
                        break block28;
                    } else {
                        this.isPrimaryKeyPartitioningKey = false;
                        this.isSubSetOfPrimary = true;
                        this.columnPositionsInKey = null;
                        this.columnPositionsInRow = null;
                        this.columnToIndexMap.clear();
                        this.toStringString = this.makeToStringString();
                        return;
                    }
                }
                this.partColsOrigOrder = distDescp.getPartitionColumnNames();
                this.partitionColumnNames = (String[])this.partColsOrigOrder.clone();
                this.masterTable = distDescp.getColocateTableName();
            }
        }
        if ((this.partColsOrigOrder == null || this.partColsOrigOrder.length == 0) && this.isPrimaryKeyPartitioningKey) {
            assert (pkMap != null && pkMap.size() > 0);
            this.setPrimaryColumnNames(pkMap.keySet());
            this.isSubSetOfPrimary = true;
        } else if (pkMap != null && !this.checkColumnsCompletelyPartOfPrimary(pkMap)) {
            this.globalIndexContainer = GfxdPartitionResolver.getContainerOfGlobalIndex(td, pkMap);
            this.setGlobalIndexCaching(this.globalIndexContainer);
        }
        this.columnPositionsInKey = null;
        if (this.isSubSetOfPrimary) {
            boolean isContiguous = true;
            HashSet partCols = new HashSet();
            Collections.addAll(partCols, this.partColsOrigOrder);
            int cnt = 0;
            if (pkMap != null) {
                for (String pkCol : pkMap.keySet()) {
                    if (partCols.size() == 0) break;
                    if (!partCols.remove(pkCol)) {
                        isContiguous = false;
                        break;
                    }
                    this.partitionColumnNames[cnt++] = pkCol;
                }
            }
            if (!isContiguous) {
                this.partitionColumnNames = (String[])this.partColsOrigOrder.clone();
                int numPartCols = this.partColsOrigOrder.length;
                if (numPartCols >= 1) {
                    this.columnPositionsInKey = new int[this.partColsOrigOrder.length];
                    for (int index = 0; index < this.partColsOrigOrder.length; ++index) {
                        String partCol = this.partColsOrigOrder[index];
                        int keyIndex = 0;
                        for (String indexCol : pkMap.keySet()) {
                            if (indexCol.equals(partCol)) break;
                            ++keyIndex;
                        }
                        assert (keyIndex < pkMap.size());
                        this.columnPositionsInKey[index] = keyIndex + 1;
                    }
                }
            }
        }
        this.columnPositionsInRow = new int[this.partitionColumnNames.length];
        this.columnToIndexMap.clear();
        HashMap<String, Integer> columnMap = GemFireXDUtils.getColumnNamesToIndexMap(td, true);
        for (int index = 0; index < this.partitionColumnNames.length; ++index) {
            String columnName = this.partitionColumnNames[index];
            Integer colIndex = columnMap.get(columnName);
            if (colIndex == null) {
                throw StandardException.newException("42X01", "The partition column (" + columnName + ") does not exist in the table's column list for table " + td.getQualifiedName());
            }
            this.columnToIndexMap.put(columnName, index);
            this.columnPositionsInRow[index] = colIndex;
        }
        if (this.exprCompiler != null) {
            if (this.exprCompiler.compileExpression(td, lcc)) {
                this.requiresSerializedHash = false;
            }
        } else {
            String colocatedTable = distDescp.getColocateTableName();
            if (colocatedTable != null) {
                GfxdPartitionByExpressionResolver resolver = (GfxdPartitionByExpressionResolver)GemFireXDUtils.getResolver((AbstractRegion)Misc.getRegionForTableByPath(colocatedTable, true));
                if (resolver != null) {
                    this.requiresSerializedHash = resolver.requiresSerializedHash;
                }
            } else {
                this.requiresSerializedHash = !this.customHashing;
            }
            PartitionedRegion pr = (PartitionedRegion)Misc.getRegionForTableByPath(Misc.getFullTableName(td, lcc), false);
            if (pr != null) {
                Map colocatedRegions = ColocationHelper.getAllColocationRegions((PartitionedRegion)pr);
                for (PartitionedRegion childPR : colocatedRegions.values()) {
                    GfxdPartitionByExpressionResolver resolver = (GfxdPartitionByExpressionResolver)GemFireXDUtils.getResolver((AbstractRegion)childPR);
                    if (resolver == null) continue;
                    resolver.requiresSerializedHash = this.requiresSerializedHash;
                }
            }
        }
        distDescp.setPartitionColumnNames(this.partitionColumnNames);
        distDescp.setColumnPositions(this.columnPositionsInRow);
        this.distributionDesc = distDescp;
        this.toStringString = this.makeToStringString();
        this.fillTypeFormatId(td);
    }

    @Override
    public GfxdPartitionResolver cloneObject() {
        GfxdPartitionByExpressionResolver clone = new GfxdPartitionByExpressionResolver(this.exprCompiler);
        clone.defaultPartitioning = this.defaultPartitioning;
        clone.partColsOrigOrder = (String[])this.partColsOrigOrder.clone();
        clone.partitionColumnNames = (String[])this.partitionColumnNames.clone();
        clone.columnToIndexMap.putAll(this.columnToIndexMap);
        return clone;
    }

    @Override
    public String[] getColumnNames() {
        return this.partitionColumnNames;
    }

    @Override
    public int getPartitioningColumnIndex(String partitionColumn) {
        Integer idx = this.columnToIndexMap.get(partitionColumn);
        if (idx != null) {
            return idx;
        }
        return -1;
    }

    @Override
    public final int getPartitioningColumnsCount() {
        return this.partColsOrigOrder.length;
    }

    private Serializable calcRoutingObject(DataValueDescriptor dvd, LanguageConnectionContext lcc) {
        if (this.exprCompiler == null) {
            if (this.snappyStore && this.customHashing) {
                return Integer.valueOf(Misc.getUnifiedHashCodeFromDVD(dvd));
            }
            return Integer.valueOf(Misc.getHashCodeFromDVD(dvd));
        }
        return this.invokeExpressionEvaluator(dvd, null, lcc);
    }

    private Serializable calcRoutingObject(DataValueDescriptor[] dvds, LanguageConnectionContext lcc) {
        if (this.exprCompiler == null) {
            if (this.snappyStore && this.customHashing) {
                return Integer.valueOf(Misc.getUnifiedHashCodeFromDVD(dvds));
            }
            int hash = 0;
            if (dvds.length == 1) {
                hash = Misc.getHashCodeFromDVD(dvds[0]);
            } else {
                assert (this.partitionColumnNames.length <= dvds.length);
                for (int index = 0; index < this.partitionColumnNames.length; ++index) {
                    hash ^= Misc.getHashCodeFromDVD(dvds[index]);
                }
            }
            return Integer.valueOf(hash);
        }
        return this.invokeExpressionEvaluator(null, dvds, lcc);
    }

    private Serializable invokeExpressionEvaluator(DataValueDescriptor dvd, DataValueDescriptor[] dvds, LanguageConnectionContext lcc) {
        EmbedConnection conn = null;
        boolean contextSet = false;
        try {
            GemFireXDQueryObserver observer;
            if (lcc == null && (lcc = Misc.getLanguageConnectionContext()) == null) {
                conn = GemFireXDUtils.getTSSConnection(true, true, false);
                conn.getTR().setupContextStack();
                contextSet = true;
                lcc = conn.getLanguageConnectionContext();
                if (lcc == null) {
                    Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
                }
            }
            DataValueDescriptor res = this.exprCompiler.evaluateExpression(dvd, dvds, lcc);
            if (GemFireXDUtils.TraceConglomRead) {
                SanityManager.DEBUG_PRINT((String)"TraceConglomRead", (String)(this.toString() + ": returning expression result: " + res + "(type: " + res.getTypeName() + ",id=" + res.getTypeFormatId() + ')'));
            }
            if ((observer = GemFireXDQueryObserverHolder.getInstance()) != null) {
                observer.afterGetRoutingObject(res);
            }
            Integer n = res.hashCode();
            return n;
        }
        catch (StandardException ex) {
            throw GemFireXDRuntimeException.newRuntimeException("GfxdPartitionByExpressionResolver: " + this + " unexpected exception", ex);
        }
        finally {
            if (contextSet) {
                conn.getTR().restoreContextStack();
            }
        }
    }

    @Override
    public Object getRoutingObjectForExpression(DataValueDescriptor expressionValue) {
        assert (!this.requiresSerializedHash && this.exprCompiler != null) : "GfxdPartitionByExpressionResolver.getRoutingObjectForExpression: should never use hash based partitioning: " + this.toString();
        return Misc.getHashCodeFromDVD(expressionValue);
    }

    @Override
    public String getCanonicalizedExpression() {
        return this.exprCompiler != null ? this.exprCompiler.getCanonicalizedExpression() : null;
    }

    @Override
    public Object getRoutingKeyForColumn(DataValueDescriptor partColumnValue) {
        assert (this.partitionColumnNames.length == 1) : "GfxdPartitionByExpressionResolver.getRoutingKeyForColumn: should be called only if partitioning column count is 1: " + this.toString();
        if (this.requiresSerializedHash) {
            DataTypeDescriptor dtd = this.gfContainer.getCurrentRowFormatter().getType(this.columnPositionsInRow[0]);
            return GfxdPartitionByExpressionResolver.computeHashCode(partColumnValue, dtd, 0);
        }
        return this.calcRoutingObject(partColumnValue, null);
    }

    @Override
    public final Serializable getRoutingObjectFromDvdArray(DataValueDescriptor[] values) {
        int numColumns = this.columnPositionsInRow.length;
        assert (values != null && values.length >= numColumns);
        if (numColumns == 1) {
            int pos = this.columnPositionsInRow[0];
            if (this.requiresSerializedHash) {
                DataTypeDescriptor dtd = this.gfContainer.getCurrentRowFormatter().getType(pos);
                return Integer.valueOf(GfxdPartitionByExpressionResolver.computeHashCode(values[pos - 1], dtd, 0));
            }
            return this.calcRoutingObject(values[pos - 1], null);
        }
        if (this.requiresSerializedHash) {
            int hash = 0;
            RowFormatter rf = this.gfContainer.getCurrentRowFormatter();
            for (int index = 0; index < numColumns; ++index) {
                int pos = this.columnPositionsInRow[index];
                hash = GfxdPartitionByExpressionResolver.computeHashCode(values[pos - 1], rf.getType(pos), hash);
            }
            return Integer.valueOf(hash);
        }
        DataValueDescriptor[] valuesInOrder = new DataValueDescriptor[numColumns];
        for (int index = 0; index < numColumns; ++index) {
            valuesInOrder[index] = values[this.columnPositionsInRow[index] - 1];
        }
        return this.calcRoutingObject(valuesInOrder, null);
    }

    @Override
    public Object[] getRoutingObjectsForList(DataValueDescriptor[] keys) {
        assert (this.partitionColumnNames.length == 1) : "GfxdPartitionByExpressionResolver.getRoutingObjectsForList: should be called only if partitioning column count is 1: " + this.toString();
        Object[] routingObjects = new Object[keys.length];
        if (this.requiresSerializedHash) {
            DataTypeDescriptor dtd = this.gfContainer.getCurrentRowFormatter().getType(this.columnPositionsInRow[0]);
            for (int index = 0; index < keys.length; ++index) {
                routingObjects[index] = GfxdPartitionByExpressionResolver.computeHashCode(keys[index], dtd, 0);
            }
            return routingObjects;
        }
        for (int index = 0; index < keys.length; ++index) {
            routingObjects[index] = this.calcRoutingObject(keys[index], null);
        }
        return routingObjects;
    }

    @Override
    public Object getRoutingObjectsForPartitioningColumns(DataValueDescriptor[] partitioningColumnObjects) {
        if (this.partitionColumnNames.length == partitioningColumnObjects.length) {
            if (this.requiresSerializedHash) {
                int hash = 0;
                RowFormatter rf = this.gfContainer.getCurrentRowFormatter();
                for (int index = 0; index < partitioningColumnObjects.length; ++index) {
                    hash = GfxdPartitionByExpressionResolver.computeHashCode(partitioningColumnObjects[index], rf.getType(this.columnPositionsInRow[index]), hash);
                }
                return hash;
            }
            return this.calcRoutingObject(partitioningColumnObjects, null);
        }
        throw new AssertionError((Object)("GfxdPartitionByExpressionResolver.getRoutingObjectsForPartitioningColumns: size of partitioningColumnObjects=" + partitioningColumnObjects.length + " should be equal to the size of " + "partitioningColumns=" + this.partitionColumnNames.length + " for " + this.toString()));
    }

    @Override
    public Object[] getRoutingObjectsForRange(DataValueDescriptor lowerBound, boolean lowerBoundInclusive, DataValueDescriptor upperBound, boolean upperBoundInclusive) {
        if (lowerBound != null && upperBound != null && this.partitionColumnNames.length == 1 && lowerBound.equals(upperBound) && lowerBoundInclusive && upperBoundInclusive) {
            if (this.requiresSerializedHash) {
                return new Object[]{GfxdPartitionByExpressionResolver.computeHashCode(lowerBound, this.gfContainer.getCurrentRowFormatter().getType(this.columnPositionsInRow[0]), 0)};
            }
            return new Object[]{this.calcRoutingObject(lowerBound, null)};
        }
        return null;
    }

    @Override
    public boolean isUsedInPartitioning(String columnToCheck) {
        return this.columnToIndexMap.containsKey(columnToCheck);
    }

    @Override
    public boolean okForColocation(GfxdPartitionResolver rslvr) {
        if (rslvr instanceof GfxdPartitionByExpressionResolver) {
            GfxdPartitionByExpressionResolver passed = (GfxdPartitionByExpressionResolver)rslvr;
            return !(this.exprCompiler != null && passed.exprCompiler == null || this.exprCompiler == null && passed.exprCompiler != null);
        }
        return false;
    }

    @Override
    public boolean requiresGlobalIndex() {
        return !this.isSubSetOfPrimary;
    }

    @Override
    public boolean requiresConnectionContext() {
        return this.exprCompiler != null;
    }

    public boolean columnsSubsetOfPrimary() {
        return this.isSubSetOfPrimary;
    }

    @Override
    public void setPartitionColumns(String[] partCols, String[] refPartCols) {
        this.partColsOrigOrder = (String[])partCols.clone();
        this.partitionColumnNames = (String[])partCols.clone();
    }

    public String getName() {
        return "gfxd-expression-partition-resolver";
    }

    @Override
    protected final boolean isPartitioningSubsetOfKey() {
        return this.isSubSetOfPrimary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getRoutingObject(Object key, Object val, Region<?, ?> region) {
        Object routingObject;
        RegionKey gfkey;
        block30: {
            block34: {
                DataValueDescriptor[] dvds;
                RowFormatter rf;
                int numCols;
                block31: {
                    block33: {
                        block32: {
                            if (SanityManager.isFineEnabled) {
                                this.gflogger.fine("GfxdPartitionByExpressionResolver:getRoutingObject: key=" + key + "; value=" + val);
                            }
                            numCols = this.getPartitioningColumnsCount();
                            gfkey = null;
                            if (key instanceof RegionKey) {
                                gfkey = (RegionKey)key;
                            }
                            if (!this.isSubSetOfPrimary) break block31;
                            if (gfkey != null) break block32;
                            routingObject = GfxdPartitionByExpressionResolver.getGeneratedKeyRoutingObject(key);
                            break block30;
                        }
                        if (!this.requiresSerializedHash) break block33;
                        assert (this.exprCompiler == null);
                        CompactCompositeRegionKey ccrk = (CompactCompositeRegionKey)gfkey;
                        ExtraTableInfo tabInfo = ccrk.getTableInfo();
                        Object kbs = null;
                        int tries = 1;
                        try {
                            int[] keyPositions;
                            byte[] kbytes;
                            block29: {
                                do {
                                    if ((kbytes = ccrk.getKeyBytes()) != null) {
                                        rf = tabInfo.getPrimaryKeyFormatter();
                                        keyPositions = this.columnPositionsInKey;
                                        break block29;
                                    }
                                    kbs = ccrk.getValueByteSource();
                                    if (kbs != null) {
                                        rf = tabInfo.getRowFormatter();
                                        keyPositions = this.columnPositionsInKey == null ? tabInfo.getPrimaryKeyColumns() : this.columnPositionsInRow;
                                        break block29;
                                    }
                                    if (tries++ % 1000 != 0) continue;
                                    Thread.yield();
                                } while (tries <= 10000000);
                                throw RegionEntryUtils.checkCacheForNullKeyValue("GfxdPartitionByExpressionResolver#getRoutingObject");
                            }
                            routingObject = kbytes != null ? GfxdPartitionByExpressionResolver.computeHashCode(kbytes, rf, keyPositions, numCols) : GfxdPartitionByExpressionResolver.computeHashCode(kbs, rf, keyPositions, numCols);
                            if (kbs == null) break block30;
                        }
                        catch (Throwable throwable) {
                            if (kbs != null) {
                                ccrk.releaseValueByteSource(kbs);
                            }
                            throw throwable;
                        }
                        ccrk.releaseValueByteSource(kbs);
                        break block30;
                    }
                    if (numCols == 1) {
                        if (this.columnPositionsInKey == null) {
                            routingObject = this.calcRoutingObject(gfkey.getKeyColumn(0), null);
                            break block30;
                        } else {
                            assert (this.columnPositionsInKey.length == 1);
                            routingObject = this.calcRoutingObject(gfkey.getKeyColumn(this.columnPositionsInKey[0] - 1), null);
                        }
                        break block30;
                    } else {
                        dvds = new DataValueDescriptor[numCols];
                        if (this.columnPositionsInKey == null) {
                            gfkey.getKeyColumns(dvds);
                        } else {
                            for (int index = 0; index < this.columnPositionsInKey.length; ++index) {
                                dvds[index] = gfkey.getKeyColumn(this.columnPositionsInKey[index] - 1);
                            }
                        }
                        routingObject = this.calcRoutingObject(dvds, null);
                    }
                    break block30;
                }
                if (val == null || val instanceof GemFireContainer.SerializableDelta) break block34;
                if (this.requiresSerializedHash) {
                    assert (this.exprCompiler == null);
                    rf = this.gfContainer.getCurrentRowFormatter();
                    routingObject = GfxdPartitionByExpressionResolver.computeHashCode(val, rf, this.columnPositionsInRow, this.columnPositionsInRow.length);
                    break block30;
                } else if (numCols == 1) {
                    assert (this.columnPositionsInRow.length == 1) : "unexpected positions " + Arrays.toString(this.columnPositionsInRow);
                    DataValueDescriptor dvd = RegionEntryUtils.getDVDFromValue(val, this.columnPositionsInRow[0], this.gfContainer);
                    routingObject = this.calcRoutingObject(dvd, null);
                    break block30;
                } else {
                    dvds = RegionEntryUtils.getDVDArrayFromValue(val, this.columnPositionsInRow, this.gfContainer);
                    routingObject = this.calcRoutingObject(dvds, null);
                }
                break block30;
            }
            assert (this.globalIndexContainer != null && gfkey != null) : "expected to find global index in resolver " + this.toString() + " and the key: " + gfkey;
            LocalRegion globalIndex = this.globalIndexContainer.getRegion();
            boolean queryHDFS = false;
            if (region instanceof PartitionedRegion) {
                queryHDFS = ((PartitionedRegion)region).includeHDFSResults();
            }
            if (globalIndex instanceof PartitionedRegion) {
                ((PartitionedRegion)globalIndex).setQueryHDFS(queryHDFS);
            }
            routingObject = GfxdPartitionByExpressionResolver.getRoutingObjectFromGlobalIndex(this.globalIndexContainer, gfkey);
        }
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            ExecRow execRow = null;
            if (val != null && !(val instanceof GemFireContainer.SerializableDelta)) {
                execRow = this.gfContainer.newExecRow(val);
            }
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.toString() + ": returning routingObject=" + routingObject + " for key=" + key + ", value=" + (execRow != null ? execRow.toString() : "(NA)")));
        }
        if (this.globalIndexContainer != null) {
            this.updateGlobalIndexCache(gfkey, routingObject);
        }
        return routingObject;
    }

    public static Integer getGeneratedKeyRoutingObject(Object key) {
        return key.hashCode();
    }

    private static int computeHashCode(byte[] bytes, RowFormatter rf, int[] columnPositions, int numPositions) {
        int hash = 0;
        if (columnPositions != null) {
            for (int index = 0; index < numPositions; ++index) {
                hash = rf.computeHashCode(columnPositions[index], bytes, hash);
            }
        } else {
            for (int position = 1; position <= numPositions; ++position) {
                hash = rf.computeHashCode(position, bytes, hash);
            }
        }
        return hash;
    }

    private static int computeHashCode(byte[][] byteArrays, RowFormatter rf, int[] columnPositions, int numPositions) {
        int hash = 0;
        if (columnPositions != null) {
            for (int index = 0; index < numPositions; ++index) {
                int position = columnPositions[index];
                hash = rf.computeHashCode(position, rf.getColumnAsByteSource(byteArrays, position), hash);
            }
        } else {
            for (int position = 1; position <= numPositions; ++position) {
                hash = rf.computeHashCode(position, rf.getColumnAsByteSource(byteArrays, position), hash);
            }
        }
        return hash;
    }

    private static int computeHashCode(Object val, RowFormatter rf, int[] columnPositions, int numPositions) {
        long bsAddr;
        int bsLen;
        OffHeapRowWithLobs bsLobs;
        OffHeapRow bsRow;
        if (val != null) {
            Class<?> vclass = val.getClass();
            if (vclass == byte[][].class) {
                return GfxdPartitionByExpressionResolver.computeHashCode((byte[][])val, rf, columnPositions, numPositions);
            }
            if (vclass == byte[].class) {
                return GfxdPartitionByExpressionResolver.computeHashCode((byte[])val, rf, columnPositions, numPositions);
            }
            if (vclass == OffHeapRow.class) {
                bsRow = (OffHeapRow)((Object)val);
                bsLobs = null;
                bsLen = bsRow.getLength();
                bsAddr = bsRow.getUnsafeAddress(0, bsLen);
            } else {
                bsRow = null;
                bsLobs = (OffHeapRowWithLobs)((Object)val);
                bsLen = bsLobs.getLength();
                bsAddr = bsLobs.getUnsafeAddress(0, bsLen);
            }
        } else {
            return 0;
        }
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int hash = 0;
        for (int index = 0; index < numPositions; ++index) {
            int logicalPosition = columnPositions != null ? columnPositions[index] : index + 1;
            if (bsRow != null) {
                hash = rf.computeHashCode(logicalPosition, unsafe, bsAddr, bsLen, hash);
                continue;
            }
            Object bsLob = rf.getColumnAsByteSource(bsLobs, logicalPosition);
            if (bsLob == null) continue;
            if (bsLob == bsLobs) {
                hash = rf.computeHashCode(logicalPosition, unsafe, bsAddr, bsLen, hash);
                continue;
            }
            if (bsLob instanceof OffHeapRow) {
                OffHeapRow ohrow = (OffHeapRow)((Object)bsLob);
                int bytesLen = ohrow.getLength();
                long memAddr = ohrow.getUnsafeAddress(0, bytesLen);
                hash = rf.computeHashCode(logicalPosition, unsafe, memAddr, bytesLen, hash);
                continue;
            }
            hash = rf.computeHashCode(logicalPosition, (byte[])bsLob, hash);
        }
        return hash;
    }

    public static int computeHashCode(DataValueDescriptor dvd, DataTypeDescriptor dtd, int hash) {
        if (dvd != null && !dvd.isNull()) {
            return dvd.computeHashCode(dtd != null ? dtd.getMaximumWidth() : 0, hash);
        }
        return ResolverUtils.addByteToBucketHash((byte)0, (int)hash, (int)dtd.getTypeId().getTypeFormatId());
    }

    @Override
    public void setResolverInfoInSingleHopInfoObject(SingleHopInformation info) throws StandardException {
        if (this.exprCompiler != null || this.distributionDesc != null && this.distributionDesc.getPolicy() == 3) {
            info.setResolverType(0);
            return;
        }
        info.setResolverType(4);
        info.setRequiredSerializedHash(this.requiresSerializedHash);
        if (this.isValidTypeForSingleHop(this.typeFormatIdArray, info)) {
            info.setTypeFormatIdArray(this.typeFormatIdArray);
        } else {
            info.setResolverType(0);
        }
    }

    private void fillTypeFormatId(TableDescriptor td) {
        this.typeFormatIdArray = new int[this.partitionColumnNames.length];
        for (int i = 0; i < this.partitionColumnNames.length; ++i) {
            this.typeFormatIdArray[i] = td.getColumnDescriptor(this.partitionColumnNames[i]).getType().getDVDTypeFormatId();
        }
    }
}

