/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.resolver;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.THashMapWithLongContext;
import com.gemstone.gemfire.internal.cache.TObjectHashingStrategyWithLongContext;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNodeList;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.SingleHopInformation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public final class GfxdListPartitionResolver
extends GfxdPartitionResolver {
    private String columnName;
    private final ArrayList<ValueNodeList> valueLists;
    protected final HashMap<Object, Integer> valueListMap;
    protected final THashMapWithLongContext serializedValueListMap;
    protected Integer newListValue;
    private int pkIndexInGemFireKey = -1;
    private int colIndexInVal = -1;
    private ColumnReference colRef;
    private volatile String ddlString;
    private static final TObjectHashingStrategy bytesCompareStrategy = new TObjectHashingStrategy(){
        private static final long serialVersionUID = 4635405514016630546L;

        public final int computeHashCode(Object o) {
            return ResolverUtils.addBytesToHash((byte[])((byte[])o), (int)0);
        }

        public final boolean equals(Object o1, Object o2) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
    };

    public GfxdListPartitionResolver(ColumnReference columnRef, ArrayList<ValueNodeList> valueLists) {
        this.columnName = columnRef.getSQLColumnName();
        this.valueLists = valueLists;
        this.valueListMap = new HashMap();
        this.serializedValueListMap = new THashMapWithLongContext(bytesCompareStrategy, (TObjectHashingStrategyWithLongContext)new SerializedBytesCompare());
        this.newListValue = 0;
        this.colRef = columnRef;
    }

    public GfxdListPartitionResolver(List<List<Object>> valueLists) {
        this.valueListMap = new HashMap();
        int idx = 0;
        for (List<Object> arrList : valueLists) {
            for (Object val : arrList) {
                this.valueListMap.put(val, idx);
            }
            ++idx;
        }
        this.valueLists = null;
        this.serializedValueListMap = null;
    }

    private GfxdListPartitionResolver(ArrayList<ValueNodeList> valueLists, HashMap<Object, Integer> valueListMap, THashMapWithLongContext serializedValueListMap) {
        this.valueLists = valueLists;
        this.valueListMap = valueListMap;
        this.serializedValueListMap = serializedValueListMap;
    }

    public Properties getConfig() {
        Properties props = new Properties();
        props.setProperty("LISTS", this.valueListMap.toString());
        return props;
    }

    public String toString() {
        return "GfxdListPartitionResolver(" + this.getQualifiedTableName() + "): pkindexingfkey = " + this.pkIndexInGemFireKey + " colindexinval = " + this.colIndexInVal + ", keys in valueList: " + this.valueListMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDDLString() {
        if (this.ddlString == null) {
            GfxdListPartitionResolver gfxdListPartitionResolver = this;
            synchronized (gfxdListPartitionResolver) {
                if (this.ddlString == null) {
                    ArrayList list;
                    int index;
                    StringBuilder sb = new StringBuilder("PARTITION BY LIST (");
                    ArrayList[] lists = new ArrayList[this.valueListMap.size()];
                    for (Map.Entry<Object, Integer> entry : this.valueListMap.entrySet()) {
                        index = entry.getValue();
                        if (lists[index] == null) {
                            lists[index] = new ArrayList();
                        }
                        lists[index].add(entry.getKey());
                    }
                    for (index = 0; index < lists.length && (list = lists[index]) != null; ++index) {
                        sb.append(list);
                        sb.append(',');
                    }
                    sb.setCharAt(sb.length() - 1, ')');
                    this.ddlString = sb.toString();
                }
            }
        }
        return this.ddlString;
    }

    @Override
    public String[] getColumnNames() {
        return this.partitionColumnNames;
    }

    @Override
    public boolean isUsedInPartitioning(String columnToCheck) {
        return this.columnName.equals(columnToCheck);
    }

    @Override
    public int getPartitioningColumnIndex(String partitionColumn) {
        if (this.columnName.equals(partitionColumn)) {
            return 0;
        }
        return -1;
    }

    @Override
    public void setColumnInfo(TableDescriptor td, Activation activation) throws StandardException {
        assert (td != null);
        DistributionDescriptor distDescp = td.getDistributionDescriptor();
        assert (distDescp != null);
        String[] partitionColNames = td.getDistributionDescriptor().getPartitionColumnNames();
        assert (partitionColNames != null);
        assert (partitionColNames.length == 1);
        assert (partitionColNames[0].equals(this.columnName));
        Map<String, Integer> pkMap = GemFireXDUtils.getPrimaryKeyColumnNamesToIndexMap(td, activation.getLanguageConnectionContext());
        Integer partitioningColIdxInPKey = null;
        if (pkMap == null || (partitioningColIdxInPKey = pkMap.get(this.columnName)) == null) {
            this.setColumnIndexForNonPrimaryColumn(td);
            if (pkMap != null) {
                this.globalIndexContainer = GfxdPartitionResolver.getContainerOfGlobalIndex(td, pkMap);
                this.setGlobalIndexCaching(this.globalIndexContainer);
            }
        } else {
            this.pkIndexInGemFireKey = GfxdListPartitionResolver.getIndexInPrimaryKey(pkMap, partitioningColIdxInPKey);
            if (pkMap.containsKey(this.columnName) && pkMap.size() == 1) {
                this.isPrimaryKeyPartitioningKey = true;
            }
            this.colIndexInVal = partitioningColIdxInPKey - 1;
        }
        this.partitionColumnNames = new String[]{this.columnName};
    }

    private void setColumnIndexForNonPrimaryColumn(TableDescriptor td) throws StandardException {
        HashMap<String, Integer> colNameToIdxMap = GemFireXDUtils.getColumnNamesToIndexMap(td, false);
        assert (colNameToIdxMap != null);
        Integer thisColIdx = colNameToIdxMap.get(this.columnName);
        assert (thisColIdx != null);
        this.colIndexInVal = thisColIdx;
        --this.colIndexInVal;
    }

    @Override
    public void bindExpression(FromList fromList, SubqueryList subqueryList, Vector<?> aggregateVector) throws StandardException {
        this.colRef.bindExpression(fromList, subqueryList, aggregateVector);
        for (ValueNodeList vnlist : this.valueLists) {
            vnlist.bindExpression(fromList, subqueryList, aggregateVector);
            vnlist.accept(new GfxdValueListVisitor("PARTITION BY LIST (" + this.columnName + ')'));
            this.incrementNewListValue();
        }
    }

    public String getName() {
        return "gfxd-list-partition-resolver";
    }

    @Override
    protected final boolean isPartitioningSubsetOfKey() {
        return this.pkIndexInGemFireKey != -1;
    }

    @Override
    public Object getRoutingObject(Object key, Object val, Region<?, ?> region) {
        int keyIndex;
        Object routingObject = null;
        RegionKey gfkey = null;
        if (key instanceof RegionKey) {
            gfkey = (RegionKey)key;
        }
        if ((keyIndex = this.pkIndexInGemFireKey) != -1) {
            int logicalPosition;
            RowFormatter rf;
            byte[] kbytes;
            block23: {
                CompactCompositeRegionKey ccrk = (CompactCompositeRegionKey)gfkey;
                ExtraTableInfo tabInfo = ccrk.getTableInfo();
                int tries = 1;
                do {
                    if ((kbytes = ccrk.getValueBytes()) != null) {
                        rf = tabInfo.getRowFormatter();
                        int[] keyPositions = tabInfo.getPrimaryKeyColumns();
                        logicalPosition = keyPositions[keyIndex];
                        break block23;
                    }
                    kbytes = ccrk.getKeyBytes();
                    if (kbytes != null) {
                        rf = tabInfo.getPrimaryKeyFormatter();
                        logicalPosition = keyIndex + 1;
                        break block23;
                    }
                    if (tries++ % 1000 != 0) continue;
                    Thread.yield();
                } while (tries <= 10000000);
                throw RegionEntryUtils.checkCacheForNullKeyValue("GfxdListPartitionResolver#getRoutingObject");
            }
            long offsetAndWidth = rf.getOffsetAndWidth(logicalPosition, kbytes);
            if (offsetAndWidth >= 0L) {
                routingObject = this.serializedValueListMap.get((Object)kbytes, offsetAndWidth);
                if (routingObject == null) {
                    int typeId = rf.getColumnDescriptor(logicalPosition - 1).getType().getTypeId().getTypeFormatId();
                    routingObject = ResolverUtils.addBytesToBucketHash((byte[])kbytes, (int)((int)(offsetAndWidth >>> 32)), (int)((int)(offsetAndWidth & 0xFFFFFFFFL)), (int)0, (int)typeId);
                }
            } else if (offsetAndWidth == -6L) {
                routingObject = this.valueListMap.get(rf.getColumnDescriptor((int)(logicalPosition - 1)).columnDefault);
            }
            if (this.gflogger.finerEnabled()) {
                this.gflogger.finer("primary key is partition key and key for which routing wanted = " + key + " routingObject calculated = " + routingObject);
            }
        } else if (val != null && !(val instanceof GemFireContainer.SerializableDelta)) {
            assert (this.colIndexInVal != -1) : "unexpected colIndexInVal=-1 with val " + val;
            RowFormatter rf = this.gfContainer.getCurrentRowFormatter();
            ColumnDescriptor cd = rf.getColumnDescriptor(this.colIndexInVal);
            Class<?> vclass = val.getClass();
            byte[] vbytes = vclass == byte[].class ? (cd.isLob ? cd.columnDefaultBytes : (byte[])val) : (vclass == byte[][].class ? (cd.isLob ? rf.getLob((byte[][])val, this.colIndexInVal + 1) : ((byte[][])val)[0]) : (vclass == OffHeapRowWithLobs.class ? (cd.isLob ? rf.getLob((OffHeapRowWithLobs)((Object)val), this.colIndexInVal + 1) : ((OffHeapRowWithLobs)((Object)val)).getRowBytes()) : (cd.isLob ? cd.columnDefaultBytes : ((OffHeapByteSource)((Object)val)).getRowBytes())));
            long offsetAndWidth = rf.getOffsetAndWidth(this.colIndexInVal + 1, vbytes, cd);
            if (offsetAndWidth >= 0L) {
                routingObject = this.serializedValueListMap.get((Object)vbytes, offsetAndWidth);
                if (routingObject == null) {
                    int typeId = rf.getColumnDescriptor(this.colIndexInVal).getType().getTypeId().getTypeFormatId();
                    routingObject = ResolverUtils.addBytesToBucketHash((byte[])vbytes, (int)((int)(offsetAndWidth >>> 32)), (int)((int)(offsetAndWidth & 0xFFFFFFFFL)), (int)0, (int)typeId);
                }
            } else if (offsetAndWidth == -6L) {
                routingObject = this.valueListMap.get(rf.getColumnDescriptor((int)this.colIndexInVal).columnDefault);
            }
        } else {
            assert (this.globalIndexContainer != null && gfkey != null) : "expected to find global index in resolver " + this.toString();
            LocalRegion globalIndex = this.globalIndexContainer.getRegion();
            boolean queryHDFS = false;
            if (region instanceof PartitionedRegion) {
                queryHDFS = ((PartitionedRegion)region).includeHDFSResults();
            }
            if (globalIndex instanceof PartitionedRegion) {
                ((PartitionedRegion)globalIndex).setQueryHDFS(queryHDFS);
            }
            routingObject = GfxdListPartitionResolver.getRoutingObjectFromGlobalIndex(this.globalIndexContainer, gfkey);
        }
        if (routingObject == null) {
            routingObject = -1;
        }
        if (this.globalIndexContainer != null) {
            this.updateGlobalIndexCache(gfkey, routingObject);
        }
        return routingObject;
    }

    @Override
    public Object[] getRoutingObjectsForList(DataValueDescriptor[] keys) {
        Object[] routingObjects = new Object[keys.length];
        for (int index = 0; index < keys.length; ++index) {
            DataValueDescriptor key = keys[index];
            Integer routingObject = this.valueListMap.get(key);
            routingObjects[index] = routingObject == null ? this.getRoutingObjectForValueNotInList(key) : routingObject;
        }
        return routingObjects;
    }

    @Override
    public Object[] getRoutingObjectsForRange(DataValueDescriptor lowerBound, boolean lowerBoundInclusive, DataValueDescriptor upperBound, boolean upperBoundInclusive) {
        if (lowerBound != null && upperBound != null && lowerBound.equals(upperBound) && lowerBoundInclusive && lowerBoundInclusive == upperBoundInclusive) {
            Object routingObject = this.valueListMap.get(lowerBound);
            if (routingObject == null) {
                routingObject = this.getRoutingObjectForValueNotInList(lowerBound);
            }
            return new Object[]{routingObject};
        }
        return null;
    }

    @Override
    public Object getRoutingKeyForColumn(DataValueDescriptor partitioningColumnValue) {
        Object routingObject = this.valueListMap.get(partitioningColumnValue);
        if (routingObject == null) {
            routingObject = this.getRoutingObjectForValueNotInList(partitioningColumnValue);
        }
        return routingObject;
    }

    private Object getRoutingObjectForValueNotInList(DataValueDescriptor partitioningColumnValue) {
        Integer routingObject = null;
        DataTypeDescriptor dtd = this.gfContainer.getCurrentRowFormatter().getType(this.colIndexInVal + 1);
        routingObject = GfxdPartitionByExpressionResolver.computeHashCode(partitioningColumnValue, dtd, 0);
        return routingObject;
    }

    private void incrementNewListValue() {
        GfxdListPartitionResolver gfxdListPartitionResolver = this;
        gfxdListPartitionResolver.newListValue = gfxdListPartitionResolver.newListValue + 1;
    }

    @Override
    public Serializable getRoutingObjectFromDvdArray(DataValueDescriptor[] values) {
        if (values == null) {
            throw new IllegalArgumentException("GfxdListPartitionResolver: Passed in dvd array is null");
        }
        Object routingObject = null;
        if (this.colIndexInVal != -1) {
            DataValueDescriptor val = values[this.colIndexInVal];
            routingObject = this.valueListMap.get(val);
            if (routingObject == null) {
                routingObject = val == null ? Integer.valueOf(0) : this.getRoutingObjectForValueNotInList(val);
            }
            return routingObject;
        }
        throw new IllegalStateException("GfxdListPartitionResolver: The state of this resolver is unexpected");
    }

    @Override
    public Object getRoutingObjectsForPartitioningColumns(DataValueDescriptor[] partitioningColumnObjects) {
        if (partitioningColumnObjects.length != 1) {
            throw new IllegalArgumentException("GfxdListPartitionResolver.getRoutingObjectsForPartitioningColumns: list partitioning is done only on single column");
        }
        Object routingObject = null;
        routingObject = this.valueListMap.get(partitioningColumnObjects[0]);
        if (routingObject == null) {
            routingObject = this.getRoutingObjectForValueNotInList(partitioningColumnObjects[0]);
        }
        return routingObject;
    }

    @Override
    public boolean requiresGlobalIndex() {
        return this.pkIndexInGemFireKey < 0;
    }

    @Override
    public GfxdPartitionResolver cloneObject() {
        GfxdListPartitionResolver newRslvr = new GfxdListPartitionResolver(this.valueLists, this.valueListMap, this.serializedValueListMap);
        newRslvr.newListValue = 0;
        newRslvr.columnName = this.columnName;
        return newRslvr;
    }

    @Override
    public void setPartitionColumns(String[] partCols, String[] refPartCols) {
        assert (partCols.length == 1) : "List partitioning is valid for single column only";
        this.columnName = partCols[0];
    }

    @Override
    public boolean okForColocation(GfxdPartitionResolver rslvr) {
        if (rslvr instanceof GfxdListPartitionResolver) {
            HashMap<Object, Integer> valueListMapOfThePassedRslvr = ((GfxdListPartitionResolver)rslvr).valueListMap;
            if (this.valueListMap.size() != valueListMapOfThePassedRslvr.size()) {
                return false;
            }
            for (Map.Entry<Object, Integer> entry : this.valueListMap.entrySet()) {
                Object thiskey = entry.getKey();
                Integer thisvalue = entry.getValue();
                Integer valueFromPassed = valueListMapOfThePassedRslvr.get(thiskey);
                if (valueFromPassed == null) {
                    return false;
                }
                if (((Object)valueFromPassed).equals(thisvalue)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setResolverInfoInSingleHopInfoObject(SingleHopInformation info) throws StandardException {
        assert (info != null) : "unexpected null SingleHopInformation object";
        info.setResolverType(2);
        boolean typeFormatSet = false;
        HashMap<Short, Integer> map = null;
        for (Object val : this.valueListMap.keySet()) {
            assert (val instanceof DataValueDescriptor);
            DataValueDescriptor dvd = (DataValueDescriptor)val;
            if (!typeFormatSet) {
                int typeFormatId = dvd.getTypeFormatId();
                int[] typeArray = new int[]{typeFormatId};
                if (this.isValidTypeForSingleHop(typeArray, info)) {
                    info.setTypeFormatIdArray(typeArray);
                    map = new HashMap<Short, Integer>(5);
                    typeFormatSet = true;
                } else {
                    info.setResolverType(0);
                    return;
                }
            }
            if (dvd.getTypeFormatId() == 83) {
                map.put(dvd.getShort(), this.valueListMap.get(dvd));
                continue;
            }
            map.put((Short)dvd.getObject(), this.valueListMap.get(dvd));
        }
        info.setMapOfListValues(map);
    }

    final class GfxdValueListVisitor
    extends VisitorAdaptor {
        final String command;

        public GfxdValueListVisitor(String command) {
            this.command = command;
        }

        @Override
        public Visitable visit(Visitable node) throws StandardException {
            if (node instanceof ValueNode) {
                try {
                    ConstantNode valueNode = (ConstantNode)node;
                    DataTypeDescriptor dtd = GfxdListPartitionResolver.this.colRef.getTypeServices();
                    if (dtd.getTypeId().isJSONTypeId()) {
                        throw StandardException.newException("0A000.S", "JSON column '" + GfxdListPartitionResolver.this.colRef.getColumnName() + "' in partition by clause");
                    }
                    DataValueDescriptor dvd = GfxdPartitionResolver.getDVDFromConstantNode(valueNode, GfxdListPartitionResolver.this.colRef);
                    Integer oldVal = GfxdListPartitionResolver.this.valueListMap.put(dvd, GfxdListPartitionResolver.this.newListValue);
                    if (oldVal != null && !oldVal.equals(GfxdListPartitionResolver.this.newListValue)) {
                        throw StandardException.newException("42Y49", "PARTITION BY LIST for value " + dvd);
                    }
                    int length = dvd.getLengthInBytes(dtd);
                    if (dtd.getTypeId().isStringTypeId() && dvd.getLength() > dtd.getMaximumWidth()) {
                        throw StandardException.newException("22003", (Object)"partition by list value too long", (Object)GfxdListPartitionResolver.this.colRef.getColumnName());
                    }
                    boolean valueIsStringType = false;
                    boolean colIsStringType = false;
                    if (valueNode != null) {
                        int typeId = valueNode.getValue().getTypeFormatId();
                        boolean bl = valueIsStringType = typeId == 78 || typeId == 85 || typeId == 235 || typeId == 447;
                    }
                    if (valueIsStringType != (colIsStringType = dtd.getTypeId().isStringTypeId())) {
                        throw StandardException.newException("22003", (Object)"partition by list value not compatible with column type", (Object)GfxdListPartitionResolver.this.colRef.getColumnName());
                    }
                    byte[] bytes = new byte[length];
                    dvd.writeBytes(bytes, 0, dtd);
                    GfxdListPartitionResolver.this.serializedValueListMap.put((Object)bytes, (Object)GfxdListPartitionResolver.this.newListValue);
                }
                catch (ClassCastException ex) {
                    throw StandardException.newException("22003", ex, (Object)"partition by list", (Object)GfxdListPartitionResolver.this.colRef.getColumnName());
                }
            }
            return node;
        }

        @Override
        public boolean skipChildren(Visitable node) {
            return false;
        }

        @Override
        public boolean stopTraversal() {
            return false;
        }
    }

    static final class SerializedBytesCompare
    implements TObjectHashingStrategyWithLongContext {
        SerializedBytesCompare() {
        }

        public final int computeHashCode(Object obj, long offsetAndWidth) {
            byte[] bytes = (byte[])obj;
            int width = (int)(offsetAndWidth & 0xFFFFFFFFL);
            int offset = (int)(offsetAndWidth >>> 32);
            return ResolverUtils.addBytesToHash((byte[])bytes, (int)offset, (int)width, (int)0);
        }

        public final boolean equals(Object obj1, Object obj2, long offsetAndWidth) {
            byte[] bytes = (byte[])obj1;
            byte[] otherBytes = (byte[])obj2;
            int width = (int)(offsetAndWidth & 0xFFFFFFFFL);
            int offset = (int)(offsetAndWidth >>> 32);
            if (bytes.length == width) {
                for (int index = 0; index < bytes.length; ++index) {
                    if (bytes[index] == otherBytes[offset + index]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

