/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.tools;

import com.gemstone.gemfire.internal.cache.Status;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.LauncherBase;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

class QuickLauncher
extends LauncherBase {
    private static final String DIR_OPT = "-dir=";
    private static final String CLASSPATH_OPT = "-classpath=";
    private static final String HEAP_SIZE_OPT = "-heap-size=";
    private static final String WAIT_FOR_SYNC_OPT = "-sync=";
    private static final String PASSWORD_OPT = "-password";
    private final String launcherClass;
    private final boolean isLocator;
    private Path workingDir;

    public static void main(String[] args) throws Exception {
        QuickLauncher launch;
        if (args.length < 2) {
            throw QuickLauncher.illegalArgument("QuickLauncher: expected at least two args", args);
        }
        String nodeType = args[0];
        String action = args[1];
        if (nodeType.equalsIgnoreCase("server")) {
            launch = new QuickLauncher("SnappyData Server", "snappyserver", "io.snappydata.tools.ServerLauncher", false);
        } else if (nodeType.equalsIgnoreCase("leader")) {
            launch = new QuickLauncher("SnappyData Leader", "snappyleader", "io.snappydata.tools.LeaderLauncher", false);
            launch.waitForData = true;
        } else if (nodeType.equalsIgnoreCase("locator")) {
            launch = new QuickLauncher("SnappyData Locator", "snappylocator", "io.snappydata.tools.LocatorLauncher", true);
        } else {
            throw QuickLauncher.illegalArgument("QuickLauncher: unknown node type '" + nodeType + "'", args);
        }
        if ("start".equalsIgnoreCase(action)) {
            System.exit(launch.start(args));
        } else if ("stop".equalsIgnoreCase(action)) {
            System.exit(launch.stop(args));
        } else if ("status".equalsIgnoreCase(action)) {
            launch.status(args);
        } else {
            throw QuickLauncher.illegalArgument("QuickLauncher: unsupported action '" + action + "'", args);
        }
    }

    private QuickLauncher(String displayName, String baseName, String launcherClass, boolean locator) {
        super(displayName, baseName);
        this.launcherClass = launcherClass;
        this.isLocator = locator;
        this.waitForData = false;
    }

    protected Path getWorkingDirPath() {
        return this.workingDir;
    }

    protected long getDefaultHeapSizeMB(boolean hostData) {
        return this.isLocator ? 1024L : super.getDefaultHeapSizeMB(hostData);
    }

    protected long getDefaultSmallHeapSizeMB(boolean hostData) {
        return this.isLocator ? 512L : super.getDefaultSmallHeapSizeMB(hostData);
    }

    private static IllegalArgumentException illegalArgument(String message, String[] args) {
        return new IllegalArgumentException(message + " (args=" + Arrays.toString(args) + ')');
    }

    private int start(String[] args) throws IOException, InterruptedException {
        ArrayList<String> commandLine = new ArrayList<String>(16);
        HashMap<String, String> env = new HashMap<String, String>(2);
        String snappyHome = System.getenv("SNAPPY_HOME");
        if (snappyHome == null || snappyHome.isEmpty()) {
            throw new IllegalArgumentException("SNAPPY_HOME not set");
        }
        commandLine.add(System.getProperty("java.home") + "/bin/java");
        commandLine.add("-server");
        try {
            String agentPath;
            if (Platform.isLinux()) {
                if (Platform.is64Bit()) {
                    agentPath = snappyHome + "/jars/libgemfirexd64.so";
                    System.load(agentPath);
                    commandLine.add("-agentpath:" + agentPath);
                } else {
                    agentPath = snappyHome + "/jars/libgemfirexd.so";
                    System.load(agentPath);
                    commandLine.add("-agentpath:" + agentPath);
                }
            } else if (Platform.isMac()) {
                if (Platform.is64Bit()) {
                    agentPath = snappyHome + "/jars/libgemfirexd64.dylib";
                    System.load(agentPath);
                    commandLine.add("-agentpath:" + agentPath);
                } else {
                    agentPath = snappyHome + "/jars/libgemfirexd.dylib";
                    System.load(agentPath);
                    commandLine.add("-agentpath:" + agentPath);
                }
            }
        }
        catch (SecurityException | UnsatisfiedLinkError e) {
            System.out.println("WARNING: agent not loaded due to " + e + ". Service might not be killed on OutOfMemory. Build jvmkill.c on your platform using build.sh script from source on your platform and replace the library in product jars directory to enable the agent.");
        }
        HashMap<String, Object> options = this.getStartOptions(args, snappyHome, commandLine, env);
        int state = this.verifyAndClearStatus();
        if (state != 0) {
            if (state == 2) {
                return 10;
            }
            return 1;
        }
        commandLine.add(this.launcherClass);
        commandLine.add("server");
        String logFile = (String)options.get("log-file");
        if (logFile == null || logFile.isEmpty()) {
            if (!ClientSharedUtils.isDefaultLoggingConfiguration()) {
                logFile = ClientSharedUtils.isRootLoggingOnlyOnConsole() ? this.startLogFileName : ClientSharedUtils.getRootLog4jFileName();
            }
        } else {
            logFile = logFile.substring("log-file".length() + 2);
        }
        if (logFile == null || logFile.isEmpty()) {
            logFile = this.defaultLogFileName;
        }
        this.startLogFileName = "start_" + logFile;
        options.put("log-file", "-log-file=" + logFile);
        for (Object option : options.values()) {
            commandLine.add((String)option);
        }
        assert (this.pidFileName != null);
        Path startLogFile = this.workingDir.resolve(this.startLogFileName);
        Path pidFile = this.workingDir.resolve(this.pidFileName);
        Files.deleteIfExists(startLogFile);
        Files.deleteIfExists(pidFile);
        StringBuilder fullCommandLine = new StringBuilder(1024);
        fullCommandLine.append("PLAIN:").append('[');
        Iterator<String> cmds = commandLine.iterator();
        while (cmds.hasNext()) {
            String cmd = cmds.next();
            if (cmd.equals("-cp")) {
                cmds.next();
                continue;
            }
            if (cmd.indexOf(32) != -1) {
                fullCommandLine.append('\"').append(cmd).append('\"');
            } else {
                fullCommandLine.append(cmd);
            }
            fullCommandLine.append(' ');
        }
        fullCommandLine.setCharAt(fullCommandLine.length() - 1, ']');
        env.put("env_2", fullCommandLine.toString());
        ProcessBuilder process = new ProcessBuilder(commandLine);
        process.environment().putAll(env);
        process.directory(this.workingDir.toFile());
        process.redirectErrorStream(true);
        process.redirectOutput(startLogFile.toFile());
        process.start();
        if (!Paths.get(logFile, new String[0]).isAbsolute()) {
            logFile = this.workingDir.resolve(logFile).toString();
        }
        return this.waitForRunning(logFile);
    }

    private int stop(String[] args) throws IOException {
        this.setWorkingDir(args);
        Path statusFile = this.getStatusPath();
        int exitStatus = 1;
        this.readStatus(false, statusFile);
        Status status = this.status;
        if (status != null) {
            if (status.state != 0) {
                status = Status.create((String)this.baseName, (int)3, (int)status.pid, (Path)statusFile);
                status.write();
                this.status = status;
            }
            this.pollCacheServerForShutdown(statusFile);
            if (this.status.state == 0) {
                System.out.println(MessageFormat.format("The {0} on {1} has stopped.", this.baseName, this.getHostNameAndDir()));
                Status.delete((Path)statusFile);
                exitStatus = 0;
            } else {
                System.out.println(MessageFormat.format("Timeout waiting for {0} to shutdown on {1}, status is: {2}", this.baseName, this.hostName, this.status));
            }
        } else {
            if (Files.exists(statusFile, new LinkOption[0])) {
                throw new IllegalStateException(MessageFormat.format("No available status. Either status file \"{0}\" is not readable or reading the status file timed out.", this.statusName));
            }
            System.out.println(MessageFormat.format("The specified working directory ({0}) on {1} contains no status file", this.workingDir, this.hostName));
        }
        return exitStatus;
    }

    private void status(String[] args) throws FileNotFoundException {
        this.setWorkingDir(args);
        Path statusFile = this.workingDir.resolve(this.statusName);
        this.readStatus(true, statusFile);
        if (args.length > 2 && args[2].equalsIgnoreCase("verbose")) {
            System.out.println(this.status);
        } else {
            System.out.println(this.status.shortStatus());
        }
    }

    private String getHostNameAndDir() {
        return this.workingDir != null ? this.hostName + '(' + this.workingDir.getFileName() + ')' : this.hostName;
    }

    private HashMap<String, Object> getStartOptions(String[] args, String snappyHome, ArrayList<String> commandLine, HashMap<String, String> env) throws FileNotFoundException {
        StringBuilder classPath = new StringBuilder();
        classPath.append(snappyHome).append("/conf").append(File.pathSeparator);
        classPath.append(snappyHome).append("/jars/*");
        int numArgs = args.length;
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>(numArgs);
        ArrayList vmArgs = new ArrayList(2);
        boolean hostData = !this.isLocator;
        for (int i = 2; i < numArgs; ++i) {
            String arg = args[i];
            if (arg.startsWith(DIR_OPT)) {
                this.processDirOption(arg.substring(DIR_OPT.length()));
                continue;
            }
            if (arg.startsWith(CLASSPATH_OPT)) {
                classPath.append(File.pathSeparator).append(arg.substring(CLASSPATH_OPT.length()));
                continue;
            }
            if (arg.startsWith(HEAP_SIZE_OPT)) {
                this.processHeapSize(arg.substring(HEAP_SIZE_OPT.length()), vmArgs);
                continue;
            }
            if (arg.startsWith("-J")) {
                this.processVMArg(arg.substring(2), vmArgs);
                continue;
            }
            if (arg.startsWith("-D") || arg.startsWith("-XX:")) {
                this.processVMArg(arg, vmArgs);
                continue;
            }
            if (arg.startsWith(PASSWORD_OPT)) {
                String pwd;
                if (arg.length() > PASSWORD_OPT.length()) {
                    if (arg.charAt(PASSWORD_OPT.length()) != '=') {
                        throw new IllegalArgumentException("Unexpected option (should be -password or -password=): " + arg);
                    }
                    pwd = arg.substring(PASSWORD_OPT.length() + 1);
                } else {
                    pwd = LauncherBase.readPassword((String)"Password: ");
                }
                if (pwd == null) continue;
                env.put("env_1", "PLAIN:" + pwd);
                continue;
            }
            if (arg.startsWith(WAIT_FOR_SYNC_OPT)) {
                this.processWaitForSync(arg.substring(WAIT_FOR_SYNC_OPT.length()));
                continue;
            }
            if (arg.length() > 0 && arg.charAt(0) == '-') {
                int eqIndex = arg.indexOf(61);
                String key = eqIndex != -1 ? arg.substring(1, eqIndex) : arg.substring(1);
                options.put(key, arg);
                if (!key.equals("host-data") || eqIndex == -1) continue;
                hostData = !"false".equalsIgnoreCase(arg.substring(eqIndex + 1));
                continue;
            }
            throw new IllegalArgumentException("Unexpected command-line option: " + arg);
        }
        commandLine.add("-cp");
        commandLine.add(classPath.toString());
        commandLine.add("-Djava.awt.headless=true");
        commandLine.add("-Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.Log4JLogger");
        this.setDefaultVMArgs(options, hostData, commandLine);
        if (!vmArgs.isEmpty()) {
            commandLine.addAll(vmArgs);
        }
        return options;
    }

    private void setWorkingDir(String[] args) throws FileNotFoundException {
        String workDir = null;
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith(DIR_OPT)) {
                workDir = arg.substring(DIR_OPT.length());
                continue;
            }
            if (arg.equalsIgnoreCase("stop") || arg.equalsIgnoreCase("status") || arg.equalsIgnoreCase("wait") || arg.equalsIgnoreCase("verbose")) continue;
            throw new IllegalArgumentException(MessageFormat.format("Unknown argument: {0}", arg));
        }
        this.processDirOption(workDir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processDirOption(String dir) throws FileNotFoundException {
        if (dir != null) {
            Path workingDirectory = Paths.get(dir, new String[0]);
            if (!Files.exists(workingDirectory, new LinkOption[0])) throw new FileNotFoundException(MessageFormat.format("The input working directory does not exist:  {0}", dir));
            this.workingDir = workingDirectory.toAbsolutePath();
            return;
        } else {
            this.workingDir = Paths.get(".", new String[0]);
        }
    }

    private void readStatus(boolean emptyForMissing, Path statusFile) {
        this.status = null;
        if (Files.exists(statusFile, new LinkOption[0])) {
            for (int i = 1; i <= 3; ++i) {
                this.status = Status.spinRead((String)this.baseName, (Path)statusFile);
                if (this.status.dsMsg != null) break;
            }
        }
        if (this.status == null && emptyForMissing) {
            this.status = Status.create((String)this.baseName, (int)0, (int)0, (Path)statusFile);
        }
    }
}

