/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Native {
    public static final int MIN_JNI_SIZE = Integer.getInteger("spark.utf8.jniSize", 32);
    public static final boolean debug = Boolean.getBoolean("spark.native.debug");
    private static final Logger logger;
    private static boolean isMac;
    private static boolean isWindows;
    private static boolean isSolaris;
    private static final boolean is64Bit;
    private static final boolean nativeLoaded;

    private Native() {
    }

    public static boolean is64Bit() {
        return is64Bit;
    }

    public static boolean isMac() {
        return isMac;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isSolaris() {
        return isSolaris;
    }

    public static boolean isLoaded() {
        return nativeLoaded;
    }

    public static native boolean arrayEquals(long var0, long var2, long var4);

    public static native int compareString(long var0, long var2, long var4);

    public static native boolean containsString(long var0, int var2, long var3, int var5);

    static {
        String suffix = "";
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (os.startsWith("mac") || os.startsWith("darwin")) {
            isMac = true;
        } else if (os.startsWith("windows")) {
            isWindows = true;
        } else if (os.startsWith("sunos") || os.startsWith("solaris")) {
            isSolaris = true;
            suffix = "_sol";
        }
        String arch = System.getProperty("os.arch");
        is64Bit = arch.contains("64") || arch.contains("s390x");
        logger = LoggerFactory.getLogger(Native.class);
        String library = "native" + suffix;
        if (Native.is64Bit()) {
            library = library + "64";
        }
        if (debug) {
            library = library + "_g";
        }
        boolean loaded = false;
        CodeSource cs = Native.class.getProtectionDomain().getCodeSource();
        URL jarURL = cs != null ? cs.getLocation() : null;
        try {
            String libDir;
            if (jarURL != null) {
                libDir = new File(URLDecoder.decode(jarURL.getFile(), "UTF-8")).getParentFile().getCanonicalPath();
            } else {
                String productHome = System.getenv("SNAPPY_HOME");
                if (productHome == null) {
                    productHome = System.getenv("SPARK_HOME");
                }
                if (productHome == null) {
                    throw new IllegalStateException("Unable to locate jar location");
                }
                libDir = new File(productHome, "jars").getCanonicalPath();
            }
            File libraryPath = new File(libDir, System.mapLibraryName(library));
            if (libraryPath.exists()) {
                System.load(libraryPath.getPath());
                logger.info("library " + library + " loaded from " + libraryPath);
            } else {
                System.loadLibrary(library);
                logger.info("library " + library + " loaded from system path");
            }
            loaded = true;
        }
        catch (IOException ioe) {
            logger.info("library " + library + " could not be loaded due to " + ioe);
        }
        catch (UnsatisfiedLinkError ule) {
            logger.info("library " + library + " could not be loaded");
        }
        nativeLoaded = loaded;
    }
}

