/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.types;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CalendarInterval
implements Serializable {
    public static final long MICROS_PER_MILLI = 1000L;
    public static final long MICROS_PER_SECOND = 1000000L;
    public static final long MICROS_PER_MINUTE = 60000000L;
    public static final long MICROS_PER_HOUR = 3600000000L;
    public static final long MICROS_PER_DAY = 86400000000L;
    public static final long MICROS_PER_WEEK = 604800000000L;
    private static Pattern p = Pattern.compile("interval" + CalendarInterval.unitRegex("year") + CalendarInterval.unitRegex("month") + CalendarInterval.unitRegex("week") + CalendarInterval.unitRegex("day") + CalendarInterval.unitRegex("hour") + CalendarInterval.unitRegex("minute") + CalendarInterval.unitRegex("second") + CalendarInterval.unitRegex("millisecond") + CalendarInterval.unitRegex("microsecond"));
    private static Pattern yearMonthPattern = Pattern.compile("^(?:['|\"])?([+|-])?(\\d+)-(\\d+)(?:['|\"])?$");
    private static Pattern dayTimePattern = Pattern.compile("^(?:['|\"])?([+|-])?(\\d+) (\\d+):(\\d+):(\\d+)(\\.(\\d+))?(?:['|\"])?$");
    private static Pattern quoteTrimPattern = Pattern.compile("^(?:['|\"])?(.*?)(?:['|\"])?$");
    public final int months;
    public final long microseconds;

    private static String unitRegex(String unit) {
        return "(?:\\s+(-?\\d+)\\s+" + unit + "s?)?";
    }

    private static long toLong(String s) {
        if (s == null) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public static CalendarInterval fromString(String s) {
        if (s == null) {
            return null;
        }
        Matcher m = p.matcher(s = s.trim());
        if (!m.matches() || s.equals("interval")) {
            return null;
        }
        long months = CalendarInterval.toLong(m.group(1)) * 12L + CalendarInterval.toLong(m.group(2));
        long microseconds = CalendarInterval.toLong(m.group(3)) * 604800000000L;
        microseconds += CalendarInterval.toLong(m.group(4)) * 86400000000L;
        microseconds += CalendarInterval.toLong(m.group(5)) * 3600000000L;
        microseconds += CalendarInterval.toLong(m.group(6)) * 60000000L;
        microseconds += CalendarInterval.toLong(m.group(7)) * 1000000L;
        microseconds += CalendarInterval.toLong(m.group(8)) * 1000L;
        return new CalendarInterval((int)months, microseconds += CalendarInterval.toLong(m.group(9)));
    }

    public static long toLongWithRange(String fieldName, String s, long minValue, long maxValue) throws IllegalArgumentException {
        long result = 0L;
        if (s != null && ((result = Long.parseLong(s)) < minValue || result > maxValue)) {
            throw new IllegalArgumentException(String.format("%s %d outside range [%d, %d]", fieldName, result, minValue, maxValue));
        }
        return result;
    }

    public static CalendarInterval fromYearMonthString(String s) throws IllegalArgumentException {
        CalendarInterval result = null;
        if (s == null) {
            throw new IllegalArgumentException("Interval year-month string was null");
        }
        Matcher m = yearMonthPattern.matcher(s = s.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("Interval string does not match year-month format of 'y-m': " + s);
        }
        try {
            int sign = m.group(1) != null && m.group(1).equals("-") ? -1 : 1;
            int years = (int)CalendarInterval.toLongWithRange("year", m.group(2), 0L, Integer.MAX_VALUE);
            int months = (int)CalendarInterval.toLongWithRange("month", m.group(3), 0L, 11L);
            result = new CalendarInterval(sign * (years * 12 + months), 0L);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing interval year-month string: " + e.getMessage(), e);
        }
        return result;
    }

    public static CalendarInterval fromDayTimeString(String s) throws IllegalArgumentException {
        CalendarInterval result = null;
        if (s == null) {
            throw new IllegalArgumentException("Interval day-time string was null");
        }
        Matcher m = dayTimePattern.matcher(s = s.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("Interval string does not match day-time format of 'd h:m:s.n': " + s);
        }
        try {
            int sign = m.group(1) != null && m.group(1).equals("-") ? -1 : 1;
            long days = CalendarInterval.toLongWithRange("day", m.group(2), 0L, Integer.MAX_VALUE);
            long hours = CalendarInterval.toLongWithRange("hour", m.group(3), 0L, 23L);
            long minutes = CalendarInterval.toLongWithRange("minute", m.group(4), 0L, 59L);
            long seconds = CalendarInterval.toLongWithRange("second", m.group(5), 0L, 59L);
            long nanos = CalendarInterval.toLongWithRange("nanosecond", m.group(7), 0L, 999999999L);
            result = new CalendarInterval(0, (long)sign * (days * 86400000000L + hours * 3600000000L + minutes * 60000000L + seconds * 1000000L + nanos / 1000L));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing interval day-time string: " + e.getMessage(), e);
        }
        return result;
    }

    public static CalendarInterval fromSingleUnitString(String unit, String s) throws IllegalArgumentException {
        CalendarInterval result = null;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Interval %s string was null", unit));
        }
        Matcher m = quoteTrimPattern.matcher(s = s.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("Interval string does not match day-time format of 'd h:m:s.n': " + s);
        }
        try {
            if (unit.equals("year")) {
                int year = (int)CalendarInterval.toLongWithRange("year", m.group(1), -178956970L, 0xAAAAAAAL);
                result = new CalendarInterval(year * 12, 0L);
            } else if (unit.equals("month")) {
                int month = (int)CalendarInterval.toLongWithRange("month", m.group(1), Integer.MIN_VALUE, Integer.MAX_VALUE);
                result = new CalendarInterval(month, 0L);
            } else if (unit.equals("week")) {
                long week = CalendarInterval.toLongWithRange("week", m.group(1), -15250284L, 15250284L);
                result = new CalendarInterval(0, week * 604800000000L);
            } else if (unit.equals("day")) {
                long day = CalendarInterval.toLongWithRange("day", m.group(1), -106751991L, 106751991L);
                result = new CalendarInterval(0, day * 86400000000L);
            } else if (unit.equals("hour")) {
                long hour = CalendarInterval.toLongWithRange("hour", m.group(1), -2562047788L, 2562047788L);
                result = new CalendarInterval(0, hour * 3600000000L);
            } else if (unit.equals("minute")) {
                long minute = CalendarInterval.toLongWithRange("minute", m.group(1), -153722867280L, 153722867280L);
                result = new CalendarInterval(0, minute * 60000000L);
            } else if (unit.equals("second")) {
                long micros = CalendarInterval.parseSecondNano(m.group(1));
                result = new CalendarInterval(0, micros);
            } else if (unit.equals("millisecond")) {
                long millisecond = CalendarInterval.toLongWithRange("millisecond", m.group(1), -9223372036854775L, 9223372036854775L);
                result = new CalendarInterval(0, millisecond * 1000L);
            } else if (unit.equals("microsecond")) {
                long micros = Long.parseLong(m.group(1));
                result = new CalendarInterval(0, micros);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing interval string: " + e.getMessage(), e);
        }
        return result;
    }

    public static long parseSecondNano(String secondNano) throws IllegalArgumentException {
        String[] parts = secondNano.split("\\.");
        if (parts.length == 1) {
            return CalendarInterval.toLongWithRange("second", parts[0], -9223372036854L, 9223372036854L) * 1000000L;
        }
        if (parts.length == 2) {
            long seconds = parts[0].equals("") ? 0L : CalendarInterval.toLongWithRange("second", parts[0], -9223372036854L, 9223372036854L);
            long nanos = CalendarInterval.toLongWithRange("nanosecond", parts[1], 0L, 999999999L);
            return seconds * 1000000L + nanos / 1000L;
        }
        throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
    }

    public CalendarInterval(int months, long microseconds) {
        this.months = months;
        this.microseconds = microseconds;
    }

    public CalendarInterval add(CalendarInterval that) {
        int months = this.months + that.months;
        long microseconds = this.microseconds + that.microseconds;
        return new CalendarInterval(months, microseconds);
    }

    public CalendarInterval subtract(CalendarInterval that) {
        int months = this.months - that.months;
        long microseconds = this.microseconds - that.microseconds;
        return new CalendarInterval(months, microseconds);
    }

    public CalendarInterval negate() {
        return new CalendarInterval(-this.months, -this.microseconds);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof CalendarInterval)) {
            return false;
        }
        CalendarInterval o = (CalendarInterval)other;
        return this.months == o.months && this.microseconds == o.microseconds;
    }

    public int hashCode() {
        return 31 * this.months + (int)this.microseconds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("interval");
        if (this.months != 0) {
            this.appendUnit(sb, this.months / 12, "year");
            this.appendUnit(sb, this.months % 12, "month");
        }
        if (this.microseconds != 0L) {
            long rest = this.microseconds;
            this.appendUnit(sb, rest / 604800000000L, "week");
            this.appendUnit(sb, (rest %= 604800000000L) / 86400000000L, "day");
            this.appendUnit(sb, (rest %= 86400000000L) / 3600000000L, "hour");
            this.appendUnit(sb, (rest %= 3600000000L) / 60000000L, "minute");
            this.appendUnit(sb, (rest %= 60000000L) / 1000000L, "second");
            this.appendUnit(sb, (rest %= 1000000L) / 1000L, "millisecond");
            this.appendUnit(sb, rest %= 1000L, "microsecond");
        }
        return sb.toString();
    }

    private void appendUnit(StringBuilder sb, long value, String unit) {
        if (value != 0L) {
            sb.append(' ').append(value).append(' ').append(unit).append('s');
        }
    }
}

