/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.array;

import org.apache.spark.unsafe.Platform;

public class ByteArrayMethods {
    private ByteArrayMethods() {
    }

    public static long nextPowerOf2(long num) {
        long highBit = Long.highestOneBit(num);
        return highBit == num ? num : highBit << 1;
    }

    public static int roundNumberOfBytesToNearestWord(int numBytes) {
        int remainder = numBytes & 7;
        if (remainder == 0) {
            return numBytes;
        }
        return numBytes + (8 - remainder);
    }

    public static boolean arrayEquals(Object leftBase, long leftOffset, Object rightBase, long rightOffset, long length) {
        long endOffset = leftOffset + length - 8L;
        while (leftOffset <= endOffset) {
            if (Platform.getLong(leftBase, leftOffset) != Platform.getLong(rightBase, rightOffset)) {
                return false;
            }
            leftOffset += 8L;
            rightOffset += 8L;
        }
        endOffset += 4L;
        while (leftOffset <= endOffset) {
            if (Platform.getInt(leftBase, leftOffset) != Platform.getInt(rightBase, rightOffset)) {
                return false;
            }
            leftOffset += 4L;
            rightOffset += 4L;
        }
        endOffset += 4L;
        while (leftOffset < endOffset) {
            if (Platform.getByte(leftBase, leftOffset) != Platform.getByte(rightBase, rightOffset)) {
                return false;
            }
            ++leftOffset;
            ++rightOffset;
        }
        return true;
    }
}

