/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.tools;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.shuffle.ShuffleWriterGroup;
import org.apache.spark.shuffle.hash.HashShuffleManager;
import org.apache.spark.storage.DiskBlockObjectWriter;
import org.apache.spark.tools.StoragePerfTester$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.sys.package$;

public final class StoragePerfTester$ {
    public static final StoragePerfTester$ MODULE$;

    static {
        new StoragePerfTester$();
    }

    public void main(String[] args) {
        int dataSizeMb = Utils$.MODULE$.memoryStringToMb((String)package$.MODULE$.env().getOrElse((Object)"OUTPUT_DATA", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "1g";
            }
        }));
        int numMaps = BoxesRunTime.unboxToInt((Object)package$.MODULE$.env().get((Object)"NUM_MAPS").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 8;
            }
        }));
        int numOutputSplits = BoxesRunTime.unboxToInt((Object)package$.MODULE$.env().get((Object)"NUM_REDUCERS").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 500;
            }
        }));
        int recordLength = 1000;
        int totalRecords = dataSizeMb * 1000;
        int recordsPerMap = totalRecords / numMaps;
        String writeKey = new StringOps(Predef$.MODULE$.augmentString("1")).$times(recordLength / 2);
        String writeValue = new StringOps(Predef$.MODULE$.augmentString("1")).$times(recordLength / 2);
        ExecutorService executor = Executors.newFixedThreadPool(numMaps);
        SparkConf conf = new SparkConf().set("spark.shuffle.compress", "false").set("spark.shuffle.sync", "true").set("spark.shuffle.manager", "org.apache.spark.shuffle.hash.HashShuffleManager");
        SparkContext sc = new SparkContext("local[4]", "Write Tester", conf);
        HashShuffleManager hashShuffleManager = (HashShuffleManager)sc.env().shuffleManager();
        long start = System.currentTimeMillis();
        CountDownLatch latch = new CountDownLatch(numMaps);
        AtomicLong totalBytes = new AtomicLong();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numMaps).foreach((Function1)new Serializable(numOutputSplits, recordsPerMap, writeKey, writeValue, executor, sc, hashShuffleManager, latch, totalBytes){
            public static final long serialVersionUID = 0L;
            public final int numOutputSplits$1;
            public final int recordsPerMap$1;
            public final String writeKey$1;
            public final String writeValue$1;
            private final ExecutorService executor$1;
            public final SparkContext sc$1;
            public final HashShuffleManager hashShuffleManager$1;
            public final CountDownLatch latch$1;
            public final AtomicLong totalBytes$1;

            public final Future<?> apply(int task) {
                return this.executor$1.submit(new Runnable(this, task){
                    private final /* synthetic */ anonfun.main.1 $outer;
                    private final int task$1;

                    public void run() {
                        try {
                            StoragePerfTester$.MODULE$.org$apache$spark$tools$StoragePerfTester$$writeOutputBytes$1(this.task$1, this.$outer.totalBytes$1, this.$outer.numOutputSplits$1, this.$outer.recordsPerMap$1, this.$outer.writeKey$1, this.$outer.writeValue$1, this.$outer.sc$1, this.$outer.hashShuffleManager$1);
                            this.$outer.latch$1.countDown();
                        }
                        catch (Exception exception) {
                            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Exception in child thread: ").append((Object)exception).append((Object)" ").append((Object)exception.getMessage()).toString());
                            System.exit(1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.task$1 = task$1;
                    }
                });
            }
            {
                this.numOutputSplits$1 = numOutputSplits$1;
                this.recordsPerMap$1 = recordsPerMap$1;
                this.writeKey$1 = writeKey$1;
                this.writeValue$1 = writeValue$1;
                this.executor$1 = executor$1;
                this.sc$1 = sc$1;
                this.hashShuffleManager$1 = hashShuffleManager$1;
                this.latch$1 = latch$1;
                this.totalBytes$1 = totalBytes$1;
            }
        });
        latch.await();
        long end = System.currentTimeMillis();
        double time = (double)(end - start) / 1000.0;
        double bytesPerSecond = (double)totalBytes.get() / time;
        long bytesPerFile = (long)((double)totalBytes.get() / ((double)numOutputSplits * (double)numMaps));
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("files_total\t\t%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numMaps * numOutputSplits))})));
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("bytes_per_file\t\t%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(bytesPerFile)})));
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("agg_throughput\t\t%s/s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString((long)bytesPerSecond)})));
        executor.shutdown();
        sc.stop();
    }

    public final void org$apache$spark$tools$StoragePerfTester$$writeOutputBytes$1(int mapId, AtomicLong total, int numOutputSplits$1, int recordsPerMap$1, String writeKey$1, String writeValue$1, SparkContext sc$1, HashShuffleManager hashShuffleManager$1) {
        ShuffleWriterGroup shuffle = hashShuffleManager$1.shuffleBlockResolver().forMapTask(1, mapId, numOutputSplits$1, (Serializer)new KryoSerializer(sc$1.conf()), new ShuffleWriteMetrics());
        DiskBlockObjectWriter[] writers = shuffle.writers();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), recordsPerMap$1).foreach$mVc$sp((Function1)new Serializable(numOutputSplits$1, writeKey$1, writeValue$1, writers){
            public static final long serialVersionUID = 0L;
            private final int numOutputSplits$1;
            private final String writeKey$1;
            private final String writeValue$1;
            private final DiskBlockObjectWriter[] writers$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.writers$1[i % this.numOutputSplits$1].write((Object)this.writeKey$1, (Object)this.writeValue$1);
            }
            {
                this.numOutputSplits$1 = numOutputSplits$1;
                this.writeKey$1 = writeKey$1;
                this.writeValue$1 = writeValue$1;
                this.writers$1 = writers$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])writers).map((Function1)new Serializable(total){
            public static final long serialVersionUID = 0L;
            private final AtomicLong total$1;

            public final long apply(DiskBlockObjectWriter w) {
                w.commitAndClose();
                return this.total$1.addAndGet(w.fileSegment().length());
            }
            {
                this.total$1 = total$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        shuffle.releaseWriters(true);
    }

    private StoragePerfTester$() {
        MODULE$ = this;
    }
}

