/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]3Q!\u0001\u0002\u0001\t1\u0011\u0001#\u00138qkRLeNZ8Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001eD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0004gN\u001c7\u0001\u0001\t\u0003;yi\u0011\u0001B\u0005\u0003?\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u001bA\u0001\u0007A\u0004C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002+\t\fGo\u00195US6,Gk\\%oaV$\u0018J\u001c4pgV\t\u0011\u0006\u0005\u0003+_E\"T\"A\u0016\u000b\u00051j\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003]=\t!bY8mY\u0016\u001cG/[8o\u0013\t\u00014FA\u0004ICNDW*\u00199\u0011\u0005u\u0011\u0014BA\u001a\u0005\u0005\u0011!\u0016.\\3\u0011\t)zS\u0007\u000f\t\u0003\u001dYJ!aN\b\u0003\u0007%sG\u000f\u0005\u0002%s%\u0011!H\u0001\u0002\u0010'R\u0014X-Y7J]B,H/\u00138g_\"1A\b\u0001Q\u0001\n%\naCY1uG\"$\u0016.\\3U_&s\u0007/\u001e;J]\u001a|7\u000f\t\u0005\u0006}\u0001!\taP\u0001\u000be\u0016\u0004xN\u001d;J]\u001a|Gc\u0001!D\u000bB\u0011a\"Q\u0005\u0003\u0005>\u0011A!\u00168ji\")A)\u0010a\u0001c\u0005I!-\u0019;dQRKW.\u001a\u0005\u0006\rv\u0002\r\u0001O\u0001\nS:\u0004X\u000f^%oM>DQ\u0001\u0013\u0001\u0005\u0002%\u000bqaZ3u\u0013:4w\u000e\u0006\u0002K#B!1JT\u001b9\u001d\tqA*\u0003\u0002N\u001f\u00051\u0001K]3eK\u001aL!a\u0014)\u0003\u00075\u000b\u0007O\u0003\u0002N\u001f!)Ai\u0012a\u0001c!)1\u000b\u0001C\u0001)\u000691\r\\3b]V\u0004HC\u0001!V\u0011\u00151&\u000b1\u00012\u0003=\u0011\u0017\r^2i)\"\u0014Xm\u001d5US6,\u0007")
public class InputInfoTracker
implements Logging {
    private final HashMap<Time, HashMap<Object, StreamInputInfo>> batchTimeToInputInfos;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private HashMap<Time, HashMap<Object, StreamInputInfo>> batchTimeToInputInfos() {
        return this.batchTimeToInputInfos;
    }

    public void reportInfo(Time batchTime, StreamInputInfo inputInfo) {
        InputInfoTracker inputInfoTracker = this;
        synchronized (inputInfoTracker) {
            HashMap inputInfos = (HashMap)this.batchTimeToInputInfos().getOrElseUpdate((Object)batchTime, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final HashMap<Object, StreamInputInfo> apply() {
                    return new HashMap();
                }
            });
            if (inputInfos.contains((Object)BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId()))) {
                throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input stream ", " for batch"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is already added into InputInfoTracker, this is an illegal state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batchTime}))).toString());
            }
            inputInfos.$plus$eq(new Tuple2((Object)BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId()), (Object)inputInfo));
            return;
        }
    }

    public synchronized Map<Object, StreamInputInfo> getInfo(Time batchTime) {
        Option inputInfos = this.batchTimeToInputInfos().get((Object)batchTime);
        return (Map)inputInfos.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Object, StreamInputInfo> apply(HashMap<Object, StreamInputInfo> x$2) {
                return x$2.toMap(Predef$.MODULE$.$conforms());
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Object, StreamInputInfo> apply() {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            }
        });
    }

    public void cleanup(Time batchThreshTime) {
        InputInfoTracker inputInfoTracker = this;
        synchronized (inputInfoTracker) {
            Iterable timesToCleanup = (Iterable)this.batchTimeToInputInfos().keys().filter((Function1)new Serializable(this, batchThreshTime){
                public static final long serialVersionUID = 0L;
                private final Time batchThreshTime$1;

                public final boolean apply(Time x$3) {
                    return x$3.$less(this.batchThreshTime$1);
                }
                {
                    this.batchThreshTime$1 = batchThreshTime$1;
                }
            });
            this.logInfo((Function0<String>)new Serializable(this, timesToCleanup){
                public static final long serialVersionUID = 0L;
                private final Iterable timesToCleanup$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"remove old batch metadata: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timesToCleanup$1.mkString(" ")}));
                }
                {
                    this.timesToCleanup$1 = timesToCleanup$1;
                }
            });
            this.batchTimeToInputInfos().$minus$minus$eq((TraversableOnce)timesToCleanup);
            return;
        }
    }

    public InputInfoTracker(StreamingContext ssc) {
        Logging.class.$init$((Logging)this);
        this.batchTimeToInputInfos = new HashMap();
    }
}

