/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tmc!B\u0001\u0003\u0005\tQ!\u0001\u0004#TiJ,\u0017-\\$sCBD'BA\u0002\u0005\u0003%\u0019HO]3b[&twM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\u0011\u00011\"\u0005\u000b\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g!\ta!#\u0003\u0002\u0014\u001b\ta1+\u001a:jC2L'0\u00192mKB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\tS:$XM\u001d8bY&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011\u0015Y\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000f\u0005\u0002!\u0019!C\u0005E\u0005a\u0011N\u001c9viN#(/Z1ngV\t1\u0005E\u0002%S-j\u0011!\n\u0006\u0003M\u001d\nq!\\;uC\ndWM\u0003\u0002)\u001b\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005)*#aC!se\u0006L()\u001e4gKJ\u0004$\u0001\f\u001b\u0011\u00075\u0002$'D\u0001/\u0015\ty#!A\u0004egR\u0014X-Y7\n\u0005Er#\u0001D%oaV$Hi\u0015;sK\u0006l\u0007CA\u001a5\u0019\u0001!\u0011\"\u000e\u001c\u0002\u0002\u0003\u0005)\u0011\u0001\u001d\u0003\u0007}#\u0013\u0007\u0003\u00048\u0001\u0001\u0006IaI\u0001\u000eS:\u0004X\u000f^*ue\u0016\fWn\u001d\u0011\u0012\u0005eb\u0004C\u0001\u0007;\u0013\tYTBA\u0004O_RD\u0017N\\4\u0011\u00051i\u0014B\u0001 \u000e\u0005\r\te.\u001f\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u00035yW\u000f\u001e9viN#(/Z1ngV\t!\tE\u0002%S\r\u0003$\u0001\u0012%\u0011\u00075*u)\u0003\u0002G]\t9Ai\u0015;sK\u0006l\u0007CA\u001aI\t%I%*!A\u0001\u0002\u000b\u0005\u0001HA\u0002`IIBaa\u0013\u0001!\u0002\u0013\u0011\u0015AD8viB,Ho\u0015;sK\u0006l7\u000f\t\u0005\b\u001b\u0002\u0001\r\u0011\"\u0001O\u0003A\u0011X-\\3nE\u0016\u0014H)\u001e:bi&|g.F\u0001P!\ty\u0002+\u0003\u0002R\u0005\tAA)\u001e:bi&|g\u000eC\u0004T\u0001\u0001\u0007I\u0011\u0001+\u0002)I,W.Z7cKJ$UO]1uS>tw\fJ3r)\t)\u0006\f\u0005\u0002\r-&\u0011q+\u0004\u0002\u0005+:LG\u000fC\u0004Z%\u0006\u0005\t\u0019A(\u0002\u0007a$\u0013\u0007\u0003\u0004\\\u0001\u0001\u0006KaT\u0001\u0012e\u0016lW-\u001c2fe\u0012+(/\u0019;j_:\u0004\u0003bB/\u0001\u0001\u0004%\tAX\u0001\u0015G\",7m\u001b9pS:$\u0018J\u001c)s_\u001e\u0014Xm]:\u0016\u0003}\u0003\"\u0001\u00041\n\u0005\u0005l!a\u0002\"p_2,\u0017M\u001c\u0005\bG\u0002\u0001\r\u0011\"\u0001e\u0003a\u0019\u0007.Z2la>Lg\u000e^%o!J|wM]3tg~#S-\u001d\u000b\u0003+\u0016Dq!\u00172\u0002\u0002\u0003\u0007q\f\u0003\u0004h\u0001\u0001\u0006KaX\u0001\u0016G\",7m\u001b9pS:$\u0018J\u001c)s_\u001e\u0014Xm]:!\u0011\u001dI\u0007\u00011A\u0005\u0002)\f\u0001B_3s_RKW.Z\u000b\u0002WB\u0011q\u0004\\\u0005\u0003[\n\u0011A\u0001V5nK\"9q\u000e\u0001a\u0001\n\u0003\u0001\u0018\u0001\u0004>fe>$\u0016.\\3`I\u0015\fHCA+r\u0011\u001dIf.!AA\u0002-Daa\u001d\u0001!B\u0013Y\u0017!\u0003>fe>$\u0016.\\3!\u0011\u001d)\b\u00011A\u0005\u0002)\f\u0011b\u001d;beR$\u0016.\\3\t\u000f]\u0004\u0001\u0019!C\u0001q\u0006i1\u000f^1siRKW.Z0%KF$\"!V=\t\u000fe3\u0018\u0011!a\u0001W\"11\u0010\u0001Q!\n-\f!b\u001d;beR$\u0016.\\3!\u0011\u001di\b\u00011A\u0005\u00029\u000bQBY1uG\"$UO]1uS>t\u0007\u0002C@\u0001\u0001\u0004%\t!!\u0001\u0002#\t\fGo\u00195EkJ\fG/[8o?\u0012*\u0017\u000fF\u0002V\u0003\u0007Aq!\u0017@\u0002\u0002\u0003\u0007q\nC\u0004\u0002\b\u0001\u0001\u000b\u0015B(\u0002\u001d\t\fGo\u00195EkJ\fG/[8oA!9\u00111\u0002\u0001\u0005\u0002\u00055\u0011!B:uCJ$HcA+\u0002\u0010!9\u0011\u0011CA\u0005\u0001\u0004Y\u0017\u0001\u0002;j[\u0016Dq!!\u0006\u0001\t\u0003\t9\"A\u0004sKN$\u0018M\u001d;\u0015\u0007U\u000bI\u0002C\u0004\u0002\u0012\u0005M\u0001\u0019A6\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 \u0005!1\u000f^8q)\u0005)\u0006bBA\u0012\u0001\u0011\u0005\u0011QE\u0001\u000bg\u0016$8i\u001c8uKb$HcA+\u0002(!A\u0011\u0011FA\u0011\u0001\u0004\tY#A\u0002tg\u000e\u00042aHA\u0017\u0013\r\tyC\u0001\u0002\u0011'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqRDq!a\r\u0001\t\u0003\t)$\u0001\ttKR\u0014\u0015\r^2i\tV\u0014\u0018\r^5p]R\u0019Q+a\u000e\t\u000f\u0005e\u0012\u0011\u0007a\u0001\u001f\u0006AA-\u001e:bi&|g\u000eC\u0004\u0002>\u0001!\t!a\u0010\u0002\u0011I,W.Z7cKJ$2!VA!\u0011\u001d\tI$a\u000fA\u0002=Cq!!\u0012\u0001\t\u0003\t9%\u0001\bbI\u0012Le\u000e];u'R\u0014X-Y7\u0015\u0007U\u000bI\u0005\u0003\u0005\u0002L\u0005\r\u0003\u0019AA'\u0003-Ig\u000e];u'R\u0014X-Y71\t\u0005=\u00131\u000b\t\u0005[A\n\t\u0006E\u00024\u0003'\"1\"!\u0016\u0002J\u0005\u0005\t\u0011!B\u0001q\t\u0019q\fJ\u001a\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\\u0005y\u0011\r\u001a3PkR\u0004X\u000f^*ue\u0016\fW\u000eF\u0002V\u0003;B\u0001\"a\u0018\u0002X\u0001\u0007\u0011\u0011M\u0001\r_V$\b/\u001e;TiJ,\u0017-\u001c\u0019\u0005\u0003G\n9\u0007\u0005\u0003.\u000b\u0006\u0015\u0004cA\u001a\u0002h\u0011Y\u0011\u0011NA/\u0003\u0003\u0005\tQ!\u00019\u0005\ryF\u0005\u000e\u0005\b\u0003[\u0002A\u0011AA8\u0003=9W\r^%oaV$8\u000b\u001e:fC6\u001cHCAA9!\u0015a\u00111OA<\u0013\r\t)(\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0019\u0005\u0003s\ni\b\u0005\u0003.a\u0005m\u0004cA\u001a\u0002~\u0011Y\u0011qPA6\u0003\u0003\u0005\tQ!\u00019\u0005\ryF%\u000e\u0005\b\u0003\u0007\u0003A\u0011AAC\u0003A9W\r^(viB,Ho\u0015;sK\u0006l7\u000f\u0006\u0002\u0002\bB)A\"a\u001d\u0002\nB\"\u00111RAH!\u0011iS)!$\u0011\u0007M\ny\tB\u0006\u0002\u0012\u0006\u0005\u0015\u0011!A\u0001\u0006\u0003A$aA0%m!9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0015aF4fiJ+7-Z5wKJLe\u000e];u'R\u0014X-Y7t)\t\tI\nE\u0003\r\u0003g\nY\n\r\u0003\u0002\u001e\u0006\u0015\u0006#B\u0017\u0002 \u0006\r\u0016bAAQ]\t!\"+Z2fSZ,'/\u00138qkR$5\u000b\u001e:fC6\u00042aMAS\t-\t9+a%\u0002\u0002\u0003\u0005)\u0011\u0001\u001d\u0003\u0007}#s\u0007C\u0004\u0002,\u0002!\t!!,\u0002%\u001d,G/\u00138qkR\u001cFO]3b[:\u000bW.\u001a\u000b\u0005\u0003_\u000b\u0019\rE\u0003\r\u0003c\u000b),C\u0002\u000246\u0011aa\u00149uS>t\u0007\u0003BA\\\u0003{s1\u0001DA]\u0013\r\tY,D\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0016\u0011\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mV\u0002\u0003\u0005\u0002F\u0006%\u0006\u0019AAd\u0003!\u0019HO]3b[&#\u0007c\u0001\u0007\u0002J&\u0019\u00111Z\u0007\u0003\u0007%sG\u000fC\u0004\u0002P\u0002!\t!!5\u0002\u0019\u001d,g.\u001a:bi\u0016TuNY:\u0015\t\u0005M\u0017q\u001f\t\u0007\u0003+\f)/a;\u000f\t\u0005]\u0017\u0011\u001d\b\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\u001c\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0011bAAr\u001b\u00059\u0001/Y2lC\u001e,\u0017\u0002BAt\u0003S\u00141aU3r\u0015\r\t\u0019/\u0004\t\u0005\u0003[\f\u00190\u0004\u0002\u0002p*\u0019\u0011\u0011\u001f\u0002\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018\u0002BA{\u0003_\u00141AS8c\u0011\u001d\t\t\"!4A\u0002-Dq!a?\u0001\t\u0003\ti0A\u0007dY\u0016\f'/T3uC\u0012\fG/\u0019\u000b\u0004+\u0006}\bbBA\t\u0003s\u0004\ra\u001b\u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0003\u0003Q)\b\u000fZ1uK\u000eCWmY6q_&tG\u000fR1uCR\u0019QKa\u0002\t\u000f\u0005E!\u0011\u0001a\u0001W\"9!1\u0002\u0001\u0005\u0002\t5\u0011aE2mK\u0006\u00148\t[3dWB|\u0017N\u001c;ECR\fGcA+\u0003\u0010!9\u0011\u0011\u0003B\u0005\u0001\u0004Y\u0007b\u0002B\n\u0001\u0011\u0005\u0011qD\u0001\u0016e\u0016\u001cHo\u001c:f\u0007\",7m\u001b9pS:$H)\u0019;b\u0011\u001d\u00119\u0002\u0001C\u0001\u0003?\t\u0001B^1mS\u0012\fG/\u001a\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0003\u0005:W\r^'bq&s\u0007/\u001e;TiJ,\u0017-\u001c*f[\u0016l'-\u001a:EkJ\fG/[8o)\u0005y\u0005b\u0002B\u0011\u0001\u0011%!1E\u0001\foJLG/Z(cU\u0016\u001cG\u000fF\u0002V\u0005KA\u0001Ba\n\u0003 \u0001\u0007!\u0011F\u0001\u0004_>\u001c\b\u0003\u0002B\u0016\u0005ki!A!\f\u000b\t\t=\"\u0011G\u0001\u0003S>T!Aa\r\u0002\t)\fg/Y\u0005\u0005\u0005o\u0011iC\u0001\nPE*,7\r^(viB,Ho\u0015;sK\u0006l\u0007F\u0002B\u0010\u0005w\u00119\u0005E\u0003\r\u0005{\u0011\t%C\u0002\u0003@5\u0011a\u0001\u001e5s_^\u001c\b\u0003\u0002B\u0016\u0005\u0007JAA!\u0012\u0003.\tY\u0011jT#yG\u0016\u0004H/[8oG\t\u0011\t\u0005C\u0004\u0003L\u0001!IA!\u0014\u0002\u0015I,\u0017\rZ(cU\u0016\u001cG\u000fF\u0002V\u0005\u001fB\u0001B!\u0015\u0003J\u0001\u0007!1K\u0001\u0004_&\u001c\b\u0003\u0002B\u0016\u0005+JAAa\u0016\u0003.\t\trJ\u00196fGRLe\u000e];u'R\u0014X-Y7)\r\t%#1\bB$\u0001")
public final class DStreamGraph
implements Serializable,
Logging {
    private final ArrayBuffer<InputDStream<?>> inputStreams;
    private final ArrayBuffer<DStream<?>> outputStreams;
    private Duration rememberDuration;
    private boolean checkpointInProgress;
    private Time zeroTime;
    private Time startTime;
    private Duration batchDuration;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ArrayBuffer<InputDStream<?>> inputStreams() {
        return this.inputStreams;
    }

    private ArrayBuffer<DStream<?>> outputStreams() {
        return this.outputStreams;
    }

    public Duration rememberDuration() {
        return this.rememberDuration;
    }

    public void rememberDuration_$eq(Duration x$1) {
        this.rememberDuration = x$1;
    }

    public boolean checkpointInProgress() {
        return this.checkpointInProgress;
    }

    public void checkpointInProgress_$eq(boolean x$1) {
        this.checkpointInProgress = x$1;
    }

    public Time zeroTime() {
        return this.zeroTime;
    }

    public void zeroTime_$eq(Time x$1) {
        this.zeroTime = x$1;
    }

    public Time startTime() {
        return this.startTime;
    }

    public void startTime_$eq(Time x$1) {
        this.startTime = x$1;
    }

    public Duration batchDuration() {
        return this.batchDuration;
    }

    public void batchDuration_$eq(Duration x$1) {
        this.batchDuration = x$1;
    }

    public synchronized void start(Time time) {
        Predef$.MODULE$.require(this.zeroTime() == null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DStream graph computation already started";
            }
        });
        this.zeroTime_$eq(time);
        this.startTime_$eq(time);
        this.outputStreams().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;

            public final void apply(DStream<?> x$1) {
                x$1.initialize(this.$outer.zeroTime());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.outputStreams().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;

            public final void apply(DStream<?> x$2) {
                x$2.remember(this.$outer.rememberDuration());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.outputStreams().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DStream<?> x$3) {
                x$3.validateAtStart();
            }
        });
        this.inputStreams().par().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(InputDStream<?> x$4) {
                x$4.start();
            }
        });
    }

    public synchronized void restart(Time time) {
        this.startTime_$eq(time);
    }

    public synchronized void stop() {
        this.inputStreams().par().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(InputDStream<?> x$5) {
                x$5.stop();
            }
        });
    }

    public synchronized void setContext(StreamingContext ssc) {
        this.outputStreams().foreach((Function1)new Serializable(this, ssc){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$1;

            public final void apply(DStream<?> x$6) {
                x$6.setContext(this.ssc$1);
            }
            {
                this.ssc$1 = ssc$1;
            }
        });
    }

    public synchronized void setBatchDuration(Duration duration2) {
        Predef$.MODULE$.require(this.batchDuration() == null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Batch duration already set as ", ". Cannot set it again."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.batchDuration()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.batchDuration_$eq(duration2);
    }

    public synchronized void remember(Duration duration2) {
        Predef$.MODULE$.require(this.rememberDuration() == null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Remember duration already set as ", ". Cannot set it again."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.rememberDuration()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.rememberDuration_$eq(duration2);
    }

    public void addInputStream(InputDStream<?> inputStream) {
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            inputStream.setGraph(this);
            this.inputStreams().$plus$eq(inputStream);
            return;
        }
    }

    public void addOutputStream(DStream<?> outputStream) {
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            outputStream.setGraph(this);
            this.outputStreams().$plus$eq(outputStream);
            return;
        }
    }

    public synchronized InputDStream<?>[] getInputStreams() {
        return (InputDStream[])this.inputStreams().toArray(ClassTag$.MODULE$.apply(InputDStream.class));
    }

    public synchronized DStream<?>[] getOutputStreams() {
        return (DStream[])this.outputStreams().toArray(ClassTag$.MODULE$.apply(DStream.class));
    }

    public synchronized ReceiverInputDStream<?>[] getReceiverInputStreams() {
        return (ReceiverInputDStream[])((TraversableOnce)((TraversableLike)this.inputStreams().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InputDStream<?> x$7) {
                return x$7 instanceof ReceiverInputDStream;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReceiverInputDStream<?> apply(InputDStream<?> x$8) {
                return (ReceiverInputDStream)x$8;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ReceiverInputDStream.class));
    }

    public synchronized Option<String> getInputStreamName(int streamId) {
        return this.inputStreams().find((Function1)new Serializable(this, streamId){
            public static final long serialVersionUID = 0L;
            private final int streamId$1;

            public final boolean apply(InputDStream<?> x$9) {
                return x$9.id() == this.streamId$1;
            }
            {
                this.streamId$1 = streamId$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(InputDStream<?> x$10) {
                return x$10.name();
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Seq<Job> generateJobs(Time time) {
        void var2_4;
        Object object;
        this.logDebug((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Generating jobs for time ").append((Object)this.time$1).toString();
            }
            {
                this.time$1 = time$1;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            object = this.outputStreams().flatMap((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$1;

                public final Iterable<Job> apply(DStream<?> outputStream) {
                    Option<Job> jobOption = outputStream.generateJob(this.time$1);
                    jobOption.foreach((Function1)new Serializable(this, outputStream){
                        public static final long serialVersionUID = 0L;
                        private final DStream outputStream$1;

                        public final void apply(Job x$11) {
                            x$11.setCallSite(this.outputStream$1.creationSite());
                        }
                        {
                            this.outputStream$1 = outputStream$1;
                        }
                    });
                    return Option$.MODULE$.option2Iterable(jobOption);
                }
                {
                    this.time$1 = time$1;
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom());
        }
        ArrayBuffer jobs = (ArrayBuffer)object;
        this.logDebug((Function0<String>)new Serializable(this, time, jobs){
            public static final long serialVersionUID = 0L;
            private final Time time$1;
            private final ArrayBuffer jobs$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Generated ").append((Object)BoxesRunTime.boxToInteger((int)this.jobs$1.length())).append((Object)" jobs for time ").append((Object)this.time$1).toString();
            }
            {
                this.time$1 = time$1;
                this.jobs$1 = jobs$1;
            }
        });
        return var2_4;
    }

    public void clearMetadata(Time time) {
        this.logDebug((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Clearing metadata for time ").append((Object)this.time$2).toString();
            }
            {
                this.time$2 = time$2;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$2;

                public final void apply(DStream<?> x$12) {
                    x$12.clearMetadata(this.time$2);
                }
                {
                    this.time$2 = time$2;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.logDebug((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Cleared old metadata for time ").append((Object)this.time$2).toString();
                }
                {
                    this.time$2 = time$2;
                }
            });
            return;
        }
    }

    public void updateCheckpointData(Time time) {
        this.logInfo((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$3;

            public final String apply() {
                return new StringBuilder().append((Object)"Updating checkpoint data for time ").append((Object)this.time$3).toString();
            }
            {
                this.time$3 = time$3;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$3;

                public final void apply(DStream<?> x$13) {
                    x$13.updateCheckpointData(this.time$3);
                }
                {
                    this.time$3 = time$3;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$3;

                public final String apply() {
                    return new StringBuilder().append((Object)"Updated checkpoint data for time ").append((Object)this.time$3).toString();
                }
                {
                    this.time$3 = time$3;
                }
            });
            return;
        }
    }

    public void clearCheckpointData(Time time) {
        this.logInfo((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$4;

            public final String apply() {
                return new StringBuilder().append((Object)"Clearing checkpoint data for time ").append((Object)this.time$4).toString();
            }
            {
                this.time$4 = time$4;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$4;

                public final void apply(DStream<?> x$14) {
                    x$14.clearCheckpointData(this.time$4);
                }
                {
                    this.time$4 = time$4;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$4;

                public final String apply() {
                    return new StringBuilder().append((Object)"Cleared checkpoint data for time ").append((Object)this.time$4).toString();
                }
                {
                    this.time$4 = time$4;
                }
            });
            return;
        }
    }

    public void restoreCheckpointData() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Restoring checkpoint data";
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(DStream<?> x$15) {
                    x$15.restoreCheckpointData();
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Restored checkpoint data";
                }
            });
            return;
        }
    }

    public synchronized void validate() {
        Predef$.MODULE$.require(this.batchDuration() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Batch duration has not been set";
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])this.getOutputStreams()).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "No output operations registered, so nothing to execute";
            }
        });
    }

    public Duration getMaxInputStreamRememberDuration() {
        return (Duration)((TraversableOnce)((TraversableLike)this.inputStreams().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Duration apply(InputDStream<?> x$16) {
                return x$16.rememberDuration();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Duration x$17) {
                return x$17 != null;
            }
        })).maxBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Duration x$18) {
                return x$18.milliseconds();
            }
        }, (Ordering)Ordering.Long$.MODULE$);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)new Serializable(this, oos){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;
            private final ObjectOutputStream oos$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "DStreamGraph.writeObject used";
                    }
                });
                DStreamGraph dStreamGraph = this.$outer;
                synchronized (dStreamGraph) {
                    this.$outer.checkpointInProgress_$eq(true);
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Enabled checkpoint mode";
                        }
                    });
                    this.oos$1.defaultWriteObject();
                    this.$outer.checkpointInProgress_$eq(false);
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Disabled checkpoint mode";
                        }
                    });
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.oos$1 = oos$1;
            }
        });
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)new Serializable(this, ois){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;
            private final ObjectInputStream ois$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "DStreamGraph.readObject used";
                    }
                });
                DStreamGraph dStreamGraph = this.$outer;
                synchronized (dStreamGraph) {
                    this.$outer.checkpointInProgress_$eq(true);
                    this.ois$1.defaultReadObject();
                    this.$outer.checkpointInProgress_$eq(false);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ois$1 = ois$1;
            }
        });
    }

    public DStreamGraph() {
        Logging.class.$init$((Logging)this);
        this.inputStreams = new ArrayBuffer();
        this.outputStreams = new ArrayBuffer();
        this.rememberDuration = null;
        this.checkpointInProgress = false;
        this.zeroTime = null;
        this.startTime = null;
        this.batchDuration = null;
    }
}

