/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.util.RecurringTimer$;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb!B\u0001\u0003\u0001\u0011a!A\u0004*fGV\u0014(/\u001b8h)&lWM\u001d\u0006\u0003\u0007\u0011\tA!\u001e;jY*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0019+\t9Aj\\4hS:<\u0007\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000b\rdwnY6\u0004\u0001A\u0011QdH\u0007\u0002=)\u00111AB\u0005\u0003Ay\u0011Qa\u00117pG.D\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\u0007a\u0016\u0014\u0018n\u001c3\u0011\u00059!\u0013BA\u0013\u0010\u0005\u0011auN\\4\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\n\u0001bY1mY\n\f7m\u001b\t\u0005\u001d%\u001a3&\u0003\u0002+\u001f\tIa)\u001e8di&|g.\r\t\u0003\u001d1J!!L\b\u0003\tUs\u0017\u000e\u001e\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005!a.Y7f!\t\tDG\u0004\u0002\u000fe%\u00111gD\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u00024\u001f!)\u0001\b\u0001C\u0001s\u00051A(\u001b8jiz\"RA\u000f\u001f>}}\u0002\"a\u000f\u0001\u000e\u0003\tAQAG\u001cA\u0002qAQAI\u001cA\u0002\rBQaJ\u001cA\u0002!BQaL\u001cA\u0002ABq!\u0011\u0001C\u0002\u0013%!)\u0001\u0004uQJ,\u0017\rZ\u000b\u0002\u0007B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0005Y\u0006twMC\u0001I\u0003\u0011Q\u0017M^1\n\u0005)+%A\u0002+ie\u0016\fG\r\u0003\u0004M\u0001\u0001\u0006IaQ\u0001\bi\"\u0014X-\u00193!\u0011\u001dq\u0005\u00011A\u0005\n=\u000b\u0001\u0002\u001d:fmRKW.Z\u000b\u0002G!9\u0011\u000b\u0001a\u0001\n\u0013\u0011\u0016\u0001\u00049sKZ$\u0016.\\3`I\u0015\fHCA\u0016T\u0011\u001d!\u0006+!AA\u0002\r\n1\u0001\u001f\u00132\u0011\u00191\u0006\u0001)Q\u0005G\u0005I\u0001O]3w)&lW\r\t\u0015\u0003+b\u0003\"AD-\n\u0005i{!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000fq\u0003\u0001\u0019!C\u0005\u001f\u0006Aa.\u001a=u)&lW\rC\u0004_\u0001\u0001\u0007I\u0011B0\u0002\u00199,\u0007\u0010\u001e+j[\u0016|F%Z9\u0015\u0005-\u0002\u0007b\u0002+^\u0003\u0003\u0005\ra\t\u0005\u0007E\u0002\u0001\u000b\u0015B\u0012\u0002\u00139,\u0007\u0010\u001e+j[\u0016\u0004\u0003FA1Y\u0011\u001d)\u0007\u00011A\u0005\n\u0019\fqa\u001d;paB,G-F\u0001h!\tq\u0001.\u0003\u0002j\u001f\t9!i\\8mK\u0006t\u0007bB6\u0001\u0001\u0004%I\u0001\\\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000f\u0006\u0002,[\"9AK[A\u0001\u0002\u00049\u0007BB8\u0001A\u0003&q-\u0001\u0005ti>\u0004\b/\u001a3!Q\tq\u0007\fC\u0003s\u0001\u0011\u00051/\u0001\u0007hKR\u001cF/\u0019:u)&lW\rF\u0001$\u0011\u0015)\b\u0001\"\u0001w\u000399W\r\u001e*fgR\f'\u000f\u001e+j[\u0016$\"aI<\t\u000ba$\b\u0019A\u0012\u0002#=\u0014\u0018nZ5oC2\u001cF/\u0019:u)&lW\rC\u0003{\u0001\u0011\u000510A\u0003ti\u0006\u0014H\u000f\u0006\u0002$y\")Q0\u001fa\u0001G\u0005I1\u000f^1siRKW.\u001a\u0005\u0006u\u0002!\ta\u001d\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0003\u0011\u0019Ho\u001c9\u0015\u0007\r\n)\u0001\u0003\u0004\u0002\b}\u0004\raZ\u0001\u000fS:$XM\u001d:vaR$\u0016.\\3s\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001b\tA\u0004\u001e:jO\u001e,'/Q2uS>tgi\u001c:OKb$\u0018J\u001c;feZ\fG\u000eF\u0001,\u0011\u001d\t\t\u0002\u0001C\u0005\u0003\u001b\tA\u0001\\8pa\u001eA\u0011Q\u0003\u0002\t\u0002\u0011\t9\"\u0001\bSK\u000e,(O]5oORKW.\u001a:\u0011\u0007m\nIBB\u0004\u0002\u0005!\u0005A!a\u0007\u0014\t\u0005eQb\u0005\u0005\bq\u0005eA\u0011AA\u0010)\t\t9\u0002\u0003\u0005\u0002$\u0005eA\u0011AA\u0013\u0003\u0011i\u0017-\u001b8\u0015\u0007-\n9\u0003\u0003\u0005\u0002*\u0005\u0005\u0002\u0019AA\u0016\u0003\u0011\t'oZ:\u0011\t9\ti\u0003M\u0005\u0004\u0003_y!!B!se\u0006L\b")
public class RecurringTimer
implements Logging {
    private final Clock clock;
    private final long period;
    private final Function1<Object, BoxedUnit> callback;
    public final String org$apache$spark$streaming$util$RecurringTimer$$name;
    private final Thread thread;
    private volatile long org$apache$spark$streaming$util$RecurringTimer$$prevTime;
    private volatile long org$apache$spark$streaming$util$RecurringTimer$$nextTime;
    private volatile boolean stopped;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] stringArray) {
        RecurringTimer$.MODULE$.main(stringArray);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private Thread thread() {
        return this.thread;
    }

    public long org$apache$spark$streaming$util$RecurringTimer$$prevTime() {
        return this.org$apache$spark$streaming$util$RecurringTimer$$prevTime;
    }

    private void org$apache$spark$streaming$util$RecurringTimer$$prevTime_$eq(long x$1) {
        this.org$apache$spark$streaming$util$RecurringTimer$$prevTime = x$1;
    }

    public long org$apache$spark$streaming$util$RecurringTimer$$nextTime() {
        return this.org$apache$spark$streaming$util$RecurringTimer$$nextTime;
    }

    private void org$apache$spark$streaming$util$RecurringTimer$$nextTime_$eq(long x$1) {
        this.org$apache$spark$streaming$util$RecurringTimer$$nextTime = x$1;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public long getStartTime() {
        return (long)(package$.MODULE$.floor((double)this.clock.getTimeMillis() / (double)this.period) + 1.0) * this.period;
    }

    public long getRestartTime(long originalStartTime) {
        long gap = this.clock.getTimeMillis() - originalStartTime;
        return ((long)package$.MODULE$.floor((double)gap / (double)this.period) + 1L) * this.period + originalStartTime;
    }

    public synchronized long start(long startTime) {
        this.org$apache$spark$streaming$util$RecurringTimer$$nextTime_$eq(startTime);
        this.thread().start();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecurringTimer $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started timer for ").append((Object)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$name).append((Object)" at time ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$nextTime())).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.org$apache$spark$streaming$util$RecurringTimer$$nextTime();
    }

    public long start() {
        return this.start(this.getStartTime());
    }

    public synchronized long stop(boolean interruptTimer) {
        if (!this.stopped()) {
            this.stopped_$eq(true);
            if (interruptTimer) {
                this.thread().interrupt();
            }
            this.thread().join();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RecurringTimer $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Stopped timer for ").append((Object)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$name).append((Object)" after time ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$prevTime())).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        return this.org$apache$spark$streaming$util$RecurringTimer$$prevTime();
    }

    private void triggerActionForNextInterval() {
        this.clock.waitTillTime(this.org$apache$spark$streaming$util$RecurringTimer$$nextTime());
        this.callback.apply$mcVJ$sp(this.org$apache$spark$streaming$util$RecurringTimer$$nextTime());
        this.org$apache$spark$streaming$util$RecurringTimer$$prevTime_$eq(this.org$apache$spark$streaming$util$RecurringTimer$$nextTime());
        this.org$apache$spark$streaming$util$RecurringTimer$$nextTime_$eq(this.org$apache$spark$streaming$util$RecurringTimer$$nextTime() + this.period);
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecurringTimer $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Callback for ").append((Object)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$name).append((Object)" called at time ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$util$RecurringTimer$$prevTime())).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void org$apache$spark$streaming$util$RecurringTimer$$loop() {
        try {
            while (true) {
                if (this.stopped()) {
                    this.triggerActionForNextInterval();
                    break;
                }
                this.triggerActionForNextInterval();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public RecurringTimer(Clock clock, long period, Function1<Object, BoxedUnit> callback, String name) {
        this.clock = clock;
        this.period = period;
        this.callback = callback;
        this.org$apache$spark$streaming$util$RecurringTimer$$name = name;
        Logging.class.$init$((Logging)this);
        this.thread = new Thread(this){
            private final /* synthetic */ RecurringTimer $outer;

            public void run() {
                this.$outer.org$apache$spark$streaming$util$RecurringTimer$$loop();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringBuilder().append((Object)"RecurringTimer - ").append((Object)$outer.org$apache$spark$streaming$util$RecurringTimer$$name).toString());
                this.setDaemon(true);
            }
        };
        this.org$apache$spark$streaming$util$RecurringTimer$$prevTime = -1L;
        this.org$apache$spark$streaming$util$RecurringTimer$$nextTime = -1L;
        this.stopped = false;
    }
}

