/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Interval;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M4Q!\u0001\u0002\u0001\t1\u0011qbV5oI><X\r\u001a#TiJ,\u0017-\u001c\u0006\u0003\u0007\u0011\tq\u0001Z:ue\u0016\fWN\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sOV\u0011Q\u0002F\n\u0003\u00019\u00012a\u0004\t\u0013\u001b\u0005\u0011\u0011BA\t\u0003\u0005\u001d!5\u000b\u001e:fC6\u0004\"a\u0005\u000b\r\u0001\u0011)Q\u0003\u0001b\u0001/\t\tAk\u0001\u0001\u0012\u0005aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"a\u0002(pi\"Lgn\u001a\t\u00033}I!\u0001\t\u000e\u0003\u0007\u0005s\u0017\u0010\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u000f\u0003\u0019\u0001\u0018M]3oi\"AA\u0005\u0001B\u0001B\u0003%Q%A\b`o&tGm\\<EkJ\fG/[8o!\t1s%D\u0001\u0005\u0013\tACA\u0001\u0005EkJ\fG/[8o\u0011!Q\u0003A!A!\u0002\u0013)\u0013AD0tY&$W\rR;sCRLwN\u001c\u0005\tY\u0001\u0011\u0019\u0011)A\u0006[\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u00079\n$#D\u00010\u0015\t\u0001$$A\u0004sK\u001adWm\u0019;\n\u0005Iz#\u0001C\"mCN\u001cH+Y4\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\u00111\u0014HO\u001e\u0015\u0005]B\u0004cA\b\u0001%!)Af\ra\u0002[!)!e\ra\u0001\u001d!)Ae\ra\u0001K!)!f\ra\u0001K!)Q\b\u0001C\u0001}\u0005qq/\u001b8e_^$UO]1uS>tW#A\u0013\t\u000b\u0001\u0003A\u0011I!\u0002\u0019\u0011,\u0007/\u001a8eK:\u001c\u0017.Z:\u0016\u0003\t\u00032aQ&O\u001d\t!\u0015J\u0004\u0002F\u00116\taI\u0003\u0002H-\u00051AH]8pizJ\u0011aG\u0005\u0003\u0015j\tq\u0001]1dW\u0006<W-\u0003\u0002M\u001b\n!A*[:u\u0015\tQ%\u0004\r\u0002P#B\u0019q\u0002\u0005)\u0011\u0005M\tF!\u0003*@\u0003\u0003\u0005\tQ!\u0001\u0018\u0005\ryF%\r\u0005\u0006)\u0002!\tEP\u0001\u000eg2LG-\u001a#ve\u0006$\u0018n\u001c8\t\u000bY\u0003A\u0011\t \u0002-A\f'/\u001a8u%\u0016lW-\u001c2fe\u0012+(/\u0019;j_:DQ\u0001\u0017\u0001\u0005Be\u000bq\u0001]3sg&\u001cH\u000f\u0006\u0002\u000f5\")1l\u0016a\u00019\u0006)A.\u001a<fYB\u0011Q\fY\u0007\u0002=*\u0011qLB\u0001\bgR|'/Y4f\u0013\t\tgL\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000eC\u0003d\u0001\u0011\u0005C-A\u0004d_6\u0004X\u000f^3\u0015\u0005\u0015t\u0007cA\rgQ&\u0011qM\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007%d'#D\u0001k\u0015\tYg!A\u0002sI\u0012L!!\u001c6\u0003\u0007I#E\tC\u0003pE\u0002\u0007\u0001/A\u0005wC2LG\rV5nKB\u0011a%]\u0005\u0003e\u0012\u0011A\u0001V5nK\u0002")
public class WindowedDStream<T>
extends DStream<T> {
    private final DStream<T> parent;
    private final Duration _windowDuration;
    private final Duration _slideDuration;
    private final ClassTag<T> evidence$1;

    public Duration windowDuration() {
        return this._windowDuration;
    }

    @Override
    public List<DStream<?>> dependencies() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DStream[]{this.parent}));
    }

    @Override
    public Duration slideDuration() {
        return this._slideDuration;
    }

    @Override
    public Duration parentRememberDuration() {
        return this.rememberDuration().$plus(this.windowDuration());
    }

    @Override
    public DStream<T> persist(StorageLevel level) {
        this.parent.persist(level);
        return this;
    }

    @Override
    public Option<RDD<T>> compute(Time validTime) {
        Interval currentWindow = new Interval(validTime.$minus(this.windowDuration()).$plus(this.parent.slideDuration()), validTime);
        Seq<RDD<T>> rddsInWindow = this.parent.slice(currentWindow);
        return new Some((Object)this.ssc().sc().union(rddsInWindow, this.evidence$1));
    }

    public WindowedDStream(DStream<T> parent, Duration _windowDuration, Duration _slideDuration, ClassTag<T> evidence$1) {
        this.parent = parent;
        this._windowDuration = _windowDuration;
        this._slideDuration = _slideDuration;
        this.evidence$1 = evidence$1;
        super(parent.ssc(), evidence$1);
        if (_windowDuration.isMultipleOf(parent.slideDuration())) {
            if (_slideDuration.isMultipleOf(parent.slideDuration())) {
                parent.persist(StorageLevel$.MODULE$.MEMORY_ONLY_SER());
                return;
            }
            throw new Exception(new StringBuilder().append((Object)"The slide duration of windowed DStream (").append((Object)_slideDuration).append((Object)") ").append((Object)"must be a multiple of the slide duration of parent DStream (").append((Object)parent.slideDuration()).append((Object)")").toString());
        }
        throw new Exception(new StringBuilder().append((Object)"The window duration of windowed DStream (").append((Object)_windowDuration).append((Object)") ").append((Object)"must be a multiple of the slide duration of parent DStream (").append((Object)parent.slideDuration()).append((Object)")").toString());
    }
}

